/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.inventory;

import cc.lechun.framework.common.utils.http.HttpComponentUtil;
import cc.lechun.framework.common.utils.http.HttpRequest;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.sign.InterfaceSign;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.sales.MallProductMapper;
import cc.lechun.mall.entity.deliver.DeliverVo;
import cc.lechun.mall.entity.trade.MallMainOrderVo;
import cc.lechun.mall.entity.trade.MallOrderEntity;
import cc.lechun.mall.entity.trade.MallOrderGroupProductEntity;
import cc.lechun.mall.entity.trade.MallOrderVo;
import cc.lechun.mall.iservice.deliver.MallAreaInterface;
import cc.lechun.mall.iservice.inventory.InventoryInterface;
import cc.lechun.mall.iservice.sales.MallGroupInterface;
import cc.lechun.mall.iservice.sales.MallProductSalesInterface;
import cc.lechun.mall.iservice.sales.MallPromotionProductInterface;
import cc.lechun.mall.iservice.trade.MallOrderGroupProductInterface;
import cc.lechun.mall.iservice.trade.MallOrderInterface;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import cc.lechun.mall.iservice.trade.MallTradeCommonInterface;
import cc.lechun.mall.service.trade.MallOrderGroupProductService;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class InventoryService
extends BaseService
implements InventoryInterface {
    @Value(value="${lechun.oldapi.domain:}")
    private String apiHost;
    @Autowired
    private MallGroupInterface groupInterface;
    @Autowired
    private MallPromotionProductInterface promotionProductInterface;
    @Autowired
    private MallTradeCommonInterface tradeCommonInterface;
    @Autowired
    private MallOrderInterface orderService;
    @Autowired
    private MallOrderGroupProductInterface groupProductService;
    @Autowired
    private MallProductSalesInterface salesService;
    @Autowired
    private MallAreaInterface areaInterface;
    @Autowired
    private MallProductMapper mallProductMapper;
    @Autowired
    private MallOrderMainInterface mallOrderMainInterface;
    @Autowired
    private MallOrderGroupProductService mallOrderGroupProductService;
    @Value(value="${erp.reduceInventory.url}")
    private String reduceInventory;

    @Override
    public BaseJsonVo lockProductInventory(MallMainOrderVo mainOrderVo) {
        try {
            int channelId = this.tradeCommonInterface.platformConvertChannel(mainOrderVo.getPlatFormId());
            if (channelId == 0) {
                return BaseJsonVo.error((String)"\u6e20\u9053\u6ca1\u6709\u5b9a\u4e49");
            }
            for (MallOrderVo orderVo : mainOrderVo.getMallOrderVos()) {
                if (!"\u7f8e\u56e2\u914d\u9001".equals(orderVo.getDeliverVo().getDeliverName())) continue;
                DeliverVo deliverVo = orderVo.getDeliverVo();
                if (deliverVo == null) {
                    return BaseJsonVo.error((String)"\u6ca1\u6709\u914d\u9001\u4fe1\u606f");
                }
                String orderDcNo = deliverVo.getDcId();
                String date = deliverVo.getPickDate();
                List<MallOrderGroupProductEntity> mallOrderGroupProductEntityList = this.mallOrderGroupProductService.getOrderGroupProductListByOrderNo(orderVo.getOrderNo());
                if (mallOrderGroupProductEntityList == null || mallOrderGroupProductEntityList.size() <= 0) continue;
                for (MallOrderGroupProductEntity mallOrderGroupProductEntity : mallOrderGroupProductEntityList) {
                    String url = this.apiHost + "mallcommon/lockProductInventory";
                    String param = String.format("productId=%s&date=%s&quantity=%s&orderMainNo=%s&orderNo=%s&dcId=%s&channelId=%d", mallOrderGroupProductEntity.getProductId(), date, mallOrderGroupProductEntity.getQuantity(), mainOrderVo.getMainOrderNo(), orderVo.getOrderNo(), orderDcNo, channelId);
                    String sign = InterfaceSign.getSign((String)param);
                    this.logger.info("\u6263\u51cf\u5e93\u5b58\u63a5\u53e3\uff1a" + url + "?" + param + "&sign=" + sign);
                    HashMap<String, String> param1 = new HashMap<String, String>();
                    param1.put("productId", mallOrderGroupProductEntity.getProductId());
                    param1.put("date", date);
                    param1.put("quantity", String.valueOf(mallOrderGroupProductEntity.getQuantity()));
                    param1.put("orderMainNo", mainOrderVo.getMainOrderNo());
                    param1.put("orderNo", orderVo.getOrderNo());
                    param1.put("dcId", orderDcNo);
                    param1.put("channelId", String.valueOf(channelId));
                    param1.put("sign", sign);
                    String result1 = HttpComponentUtil.execute((HttpRequest)new HttpRequest(url, param1));
                    this.logger.info("================lockProductInventory.result1===============result1={}", (Object)result1);
                    Map result = (Map)JsonUtils.fromJson((String)result1, Map.class);
                    if (result.containsKey("status")) {
                        if (!"0".equals(result.get("status"))) continue;
                        this.unLockProductInventory(mainOrderVo);
                        return BaseJsonVo.error((String)String.format("\u963f\u5076\uff0c%s\u5df2\u88ab\u62a2\u8d2d\u4e00\u7a7a", mallOrderGroupProductEntity.getProductName()));
                    }
                    this.unLockProductInventory(mainOrderVo);
                    return BaseJsonVo.error((String)String.format("\u963f\u5076\uff0c%s\u9501\u5b9a\u5e93\u5b58\u5931\u8d25", mallOrderGroupProductEntity.getProductName()));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error(e.toString());
            throw new RuntimeException();
        }
        this.logger.info("\u9501\u5b9a\u5e93\u5b58\u6210\u529f,mainOrderNo:" + mainOrderVo.getMainOrderNo());
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo unLockProductInventory(String mainOrderNo, int platFormId) {
        List<MallOrderEntity> orders = this.orderService.findOrders(mainOrderNo);
        this.logger.info("==========unLockProductInventory===============orders={}", (Object)JSON.toJSONString(orders));
        BaseJsonVo baseJsonVo = this.unLockProductInventoryByErpTwo(mainOrderNo, platFormId);
        if (baseJsonVo.isSuccess()) {
            baseJsonVo = this.unLockProductInventoryByErpThr(orders);
        }
        return baseJsonVo;
    }

    @Override
    public BaseJsonVo unLockProductInventory(MallMainOrderVo mainOrderVo) {
        return this.unLockProductInventory(mainOrderVo.getMainOrderNo(), mainOrderVo.getPlatFormId());
    }

    private BaseJsonVo unLockProductInventoryByErpTwo(String mainOrderNo, int platFormId) {
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo unLockProductInventoryByErpThr(List<MallOrderEntity> orders) {
        if (orders != null && orders.size() > 0) {
            ArrayList orderNoList = new ArrayList();
            orders.forEach(order -> {
                if ("0".equals(order.getSpeedUp())) {
                    orderNoList.add(order.getOrderNo());
                }
            });
            if (orderNoList != null) {
                String result = "";
                result = HttpRequest.httpsPostByDeliver((String)this.reduceInventory, (String)JsonUtils.toJson(orderNoList, (boolean)false));
                this.logger.info("*************************unLockProductInventoryByErpThr********************\u8c03\u7528ERP3.0\u589e\u52a0\u5e93\u5b58\u8bf7\u6c42\u548c\u8fd4\u56de\u7684\u6570\u636e*************orderNoList={},result={}", (Object)JSON.toJSONString(orderNoList), (Object)JSON.toJSONString((Object)result));
            }
        }
        return BaseJsonVo.success((Object)"");
    }
}

