/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.jms;

import cc.lechun.common.cache.MallRedisLock;
import cc.lechun.common.vo.weixin.ScanMessageVo;
import cc.lechun.framework.common.jms.MessageQueueInterface;
import cc.lechun.framework.common.utils.object.ObjectConvert;
import cc.lechun.mall.iservice.weixin.WeiXinScanInterface;
import com.aliyun.openservices.ons.api.ConsumeContext;
import com.aliyun.openservices.ons.api.Message;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="scanCode")
public class ScanQrcodeListener
implements MessageQueueInterface {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private WeiXinScanInterface scanReceiveMessageService;
    @Autowired
    private MallRedisLock mallRedisLock;

    public boolean receive(Message message, ConsumeContext consumeContext) {
        this.log.info("\u63a5\u53d7\u626b\u7801\u6d88\u606f...");
        try {
            Map messageBody = (Map)ObjectConvert.toObject((byte[])message.getBody());
            ScanMessageVo scanMessageVo = new ScanMessageVo();
            scanMessageVo.setPlatformId(Integer.parseInt(messageBody.get("platformId").toString()));
            scanMessageVo.setUserId(messageBody.get("userId").toString());
            scanMessageVo.setDtFrom(messageBody.get("dtFrom").toString());
            scanMessageVo.setBindCode(messageBody.get("bindcode").toString());
            scanMessageVo.setOpenId(messageBody.get("openId").toString());
            if (this.mallRedisLock.lock("SCAN:" + messageBody.get("bindcode").toString(), messageBody.get("userId").toString(), 60L, TimeUnit.SECONDS)) {
                this.scanReceiveMessageService.scanCode(scanMessageVo).isSuccess();
            }
            return true;
        }
        catch (Exception e) {
            this.log.error("\u626b\u7801\u6d88\u606f{}\u5904\u7406\u5931\u8d25{}", (Object)message.getMsgID(), (Object)e);
            return false;
        }
    }
}

