/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.sales;

import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.sales.MallFullcutDetailMapper;
import cc.lechun.mall.entity.sales.MallFullcutDetailEntity;
import cc.lechun.mall.iservice.sales.MallFullcutDetailInterface;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MallFullcutDetailService
extends BaseService
implements MallFullcutDetailInterface {
    @Autowired
    private MallFullcutDetailMapper fullcutDetailMapper;

    @Override
    public List<MallFullcutDetailEntity> getFullcutDetails(String fullcutId) {
        MallFullcutDetailEntity fullcutDetailEntity = new MallFullcutDetailEntity();
        fullcutDetailEntity.setFullCutId(fullcutId);
        List fullcutDetailEntities = this.fullcutDetailMapper.getList(fullcutDetailEntity);
        return fullcutDetailEntities;
    }

    @Override
    public PageInfo getFullCutDetailList(int pageNum, int pageSize, String fullcutId) {
        Page page = PageHelper.startPage((int)pageNum, (int)pageSize);
        this.fullcutDetailMapper.getFullCutList(fullcutId);
        PageInfo pg = page.toPageInfo();
        return pg;
    }

    @Override
    public BaseJsonVo saveMallFullcutDetail(MallFullcutDetailEntity mallFullcutDetailEntity) {
        MallFullcutDetailEntity query = new MallFullcutDetailEntity();
        if (mallFullcutDetailEntity.getGroupType() == 2) {
            if (StringUtils.isEmpty((String)mallFullcutDetailEntity.getGroupId())) {
                return BaseJsonVo.paramError((String)"\u8bf7\u9009\u62e9\u7ec4\u5408");
            }
            query.setFullCutId(mallFullcutDetailEntity.getFullCutId());
            query.setGroupId(mallFullcutDetailEntity.getGroupId());
            if (this.fullcutDetailMapper.getList(query).size() > 0) {
                return BaseJsonVo.paramError((String)"\u5df2\u5b58\u5728");
            }
        } else if (mallFullcutDetailEntity.getGroupType() == 4) {
            if (StringUtils.isEmpty((String)mallFullcutDetailEntity.getProductId())) {
                return BaseJsonVo.paramError((String)"\u8bf7\u9009\u62e9\u5355\u54c1");
            }
            query.setFullCutId(mallFullcutDetailEntity.getFullCutId());
            query.setProductId(mallFullcutDetailEntity.getProductId());
            if (this.fullcutDetailMapper.getList(query).size() > 0) {
                return BaseJsonVo.paramError((String)"\u5df2\u5b58\u5728");
            }
        } else {
            return BaseJsonVo.paramError((String)"\u4fdd\u5b58\u9519\u8bef");
        }
        mallFullcutDetailEntity.setFullCutDetailId(IDGenerate.getUniqueID() + "");
        this.fullcutDetailMapper.insertSelective(mallFullcutDetailEntity);
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo deleteMallFullcutDetail(String fullCutDetailId) {
        this.fullcutDetailMapper.deleteByPrimaryKey((Serializable)((Object)fullCutDetailId));
        return BaseJsonVo.success((Object)"");
    }
}

