/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.sales;

import cc.lechun.common.cache.MallRedisLock;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.dao.sales.MallProductSalesMapper;
import cc.lechun.mall.dao.sales.WarehouseAreaMapper;
import cc.lechun.mall.entity.sales.MallProductEntity;
import cc.lechun.mall.entity.sales.MallProductSalesEntity;
import cc.lechun.mall.entity.sales.MallProductSalesEntityVo;
import cc.lechun.mall.entity.sales.MallProductVO;
import cc.lechun.mall.entity.sales.WarehouseAreaEntity;
import cc.lechun.mall.entity.trade.MallOrderGroupProductEntity;
import cc.lechun.mall.entity.user.MallUserEntity;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.iservice.sales.MallProductSalesInterface;
import com.alibaba.fastjson.JSON;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MallProductSalesService
implements MallProductSalesInterface {
    private static final Logger logger = LoggerFactory.getLogger(MallProductSalesService.class);
    @Autowired
    private MallProductSalesMapper mallProductSalesMapper;
    @Autowired
    private WarehouseAreaMapper warehouseAreaMapper;
    @Autowired
    private MallProductInterface mallProductInterface;
    @Autowired
    private MallRedisLock mallRedisLock;

    @Override
    public List<MallProductSalesEntityVo> getProductSalesList(MallProductSalesEntityVo mallProductSalesEntityVo) {
        List<MallProductSalesEntityVo> mallProductSalesEntityList = this.mallProductSalesMapper.getProductSalesList(mallProductSalesEntityVo);
        return mallProductSalesEntityList;
    }

    @Override
    public PageInfo getProductSalesListByPage(int currentPage, int pageSize, MallProductSalesEntityVo mallProductSalesEntityVo) {
        Page page = PageHelper.startPage((int)currentPage, (int)pageSize);
        this.getProductSalesList(mallProductSalesEntityVo);
        return page.toPageInfo();
    }

    @Override
    public void addProduct(String productId) {
        ArrayList<MallProductSalesEntity> mallProductSalesEntityList = new ArrayList<MallProductSalesEntity>();
        MallProductSalesEntity mallProductSalesEntity1 = new MallProductSalesEntity();
        mallProductSalesEntity1.setId(IDGenerate.getUniqueIdStr());
        mallProductSalesEntity1.setProId(productId);
        mallProductSalesEntity1.setWarehouseId("1037595826996514816");
        mallProductSalesEntity1.setWarehouseCode("00004");
        mallProductSalesEntity1.setWarehouseName("\u5317\u4eac\u4ed3");
        mallProductSalesEntity1.setSalesNum(0);
        mallProductSalesEntity1.setDelFlag("0");
        mallProductSalesEntityList.add(mallProductSalesEntity1);
        MallProductSalesEntity mallProductSalesEntity2 = new MallProductSalesEntity();
        mallProductSalesEntity2.setId(IDGenerate.getUniqueIdStr());
        mallProductSalesEntity2.setProId(productId);
        mallProductSalesEntity2.setWarehouseId("1069807551659380736");
        mallProductSalesEntity2.setWarehouseCode("00007");
        mallProductSalesEntity2.setWarehouseName("\u4e0a\u6d77\u4ed3");
        mallProductSalesEntity2.setSalesNum(0);
        mallProductSalesEntity2.setDelFlag("0");
        mallProductSalesEntityList.add(mallProductSalesEntity2);
        logger.info("*********************MallProductSalesService.addProduct \u589e\u52a0\u4ea7\u54c1\u4fe1\u606f======================mallProductSalesEntityList={}", (Object)JSON.toJSONString(mallProductSalesEntityList));
        this.mallProductSalesMapper.saveBatchProduct(mallProductSalesEntityList);
    }

    @Override
    @Transactional
    public int saveProductInfo(MallProductSalesEntity mallProductSalesEntity, MallUserEntity user) {
        logger.info("=======MallProductSalesService.saveProductInfo=========mallProductSalesEntity={}", (Object)JSON.toJSONString((Object)mallProductSalesEntity));
        int salesNum = 0;
        int result = 0;
        if (StringUtils.isEmpty((String)mallProductSalesEntity.getId())) {
            mallProductSalesEntity.setUpdateBy(user.getUserName());
            mallProductSalesEntity.setUpdateTime(new Date());
            salesNum = this.mallProductSalesMapper.getProductSalesNumByProId(mallProductSalesEntity);
            salesNum = mallProductSalesEntity.getSalesNum() + salesNum;
            mallProductSalesEntity.setSalesNum(salesNum);
            result = this.mallProductSalesMapper.insertSelective(mallProductSalesEntity);
        } else {
            mallProductSalesEntity.setId(IDGenerate.getUniqueIdStr());
            mallProductSalesEntity.setCreateTime(new Date());
            mallProductSalesEntity.setCreateBy(user.getUserName());
            salesNum = mallProductSalesEntity.getSalesNum() + salesNum;
            mallProductSalesEntity.setSalesNum(salesNum);
            result = this.mallProductSalesMapper.updateProductSalesNumByProId(mallProductSalesEntity.getSalesNum(), mallProductSalesEntity.getProId(), mallProductSalesEntity.getWarehouseId());
        }
        return result;
    }

    @Override
    public int getProductSalesNumByProId(MallProductSalesEntity mallProductSalesEntity) {
        return 0;
    }

    @Override
    public void deleteProductSalesByProId(MallProductSalesEntity mallProductSalesEntity) {
        this.mallProductSalesMapper.deleteProductSalesByProId(mallProductSalesEntity);
    }

    @Override
    public BaseJsonVo checkSalesNum(Map<String, Integer> prodIdSalesNumMap, Integer cityId) {
        logger.info("=======\u6821\u9a8c\u63a5\u53e3checkSalesNum\u4f20\u5165\u53c2\u6570===========prodIdSalesNumMap={},cityId={}", (Object)JSON.toJSONString(prodIdSalesNumMap), (Object)cityId);
        Set<String> proIdList = prodIdSalesNumMap.keySet();
        for (String proId : proIdList) {
            MallProductEntity mallProductEntity = this.mallProductInterface.getProduct(proId);
            if (mallProductEntity != null) {
                Integer salesNumMath;
                int salesNumInt;
                WarehouseAreaEntity warehouseAreaEntity = this.warehouseAreaMapper.getWareHouseByCityId(cityId, mallProductEntity.getTransportType());
                logger.info("=======\u6821\u9a8c\u63a5\u53e3checkSalesNum\u83b7\u53d6\u57ce\u5e02\u5bf9\u5e94\u4ed3\u5e93==========warehouseAreaEntity={}", (Object)JSON.toJSONString((Object)warehouseAreaEntity));
                if (warehouseAreaEntity == null) {
                    logger.info("=======\u6821\u9a8c\u63a5\u53e3checkSalesNum\u83b7\u53d6\u57ce\u5e02\u5bf9\u5e94\u4ed3\u5e93\u4e3a\u7a7anull\u4e3a\u7a7anull\u4e3a\u7a7anull==========warehouseAreaEntity={}", (Object)JSON.toJSONString((Object)warehouseAreaEntity));
                    return BaseJsonVo.error((String)"\u5e93\u5b58\u4e0d\u8db3");
                }
                Integer salesNum = Integer.valueOf(prodIdSalesNumMap.get(proId).toString());
                MallProductSalesEntityVo mallProductSalesEntityVo = this.mallProductSalesMapper.getProductSalesNum(proId, warehouseAreaEntity.getWarehouseId());
                if (mallProductSalesEntityVo == null) continue;
                int n = salesNumInt = mallProductSalesEntityVo.getSalesNum() == null ? 0 : mallProductSalesEntityVo.getSalesNum();
                if (salesNum >= 0 || (salesNumMath = Integer.valueOf(Math.abs(salesNum))).compareTo(salesNumInt) <= 0) continue;
                logger.info("============\u6821\u9a8c\u5931\u8d25\u5e93\u5b58\u4e0d\u8db3===========proId={},proName={}", (Object)proId, (Object)mallProductSalesEntityVo.getProName());
                return BaseJsonVo.error((String)(mallProductSalesEntityVo.getProName() + "\u5e93\u5b58\u4e0d\u8db3"));
            }
            logger.info("============\u6821\u9a8c\u5931\u8d25\u4ea7\u54c1\u4e0d\u5b58\u5728==========");
            return BaseJsonVo.error((String)"\u65e0\u4ea7\u54c1\u4fe1\u606f");
        }
        return BaseJsonVo.success((Object)"\u6821\u9a8c\u901a\u8fc7");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public BaseJsonVo updateProductSalesNumByProId(Map<String, Integer> prodIdSalesNumMap, Integer cityId) {
        logger.info("=======\u66f4\u65b0\u5e93\u5b58\u63a5\u53e3updateProductSalesNumByProId\u4f20\u5165\u53c2\u6570===========prodIdSalesNumMap={},cityId={}", (Object)JSON.toJSONString(prodIdSalesNumMap), (Object)cityId);
        BaseJsonVo baseJsonVo = this.checkSalesNum(prodIdSalesNumMap, cityId);
        if (baseJsonVo.getStatus() == 200) {
            Set<String> proIdList = prodIdSalesNumMap.keySet();
            for (String proId : proIdList) {
                MallProductEntity mallProductEntity = this.mallProductInterface.getProduct(proId);
                if (mallProductEntity != null) {
                    WarehouseAreaEntity warehouseAreaEntity = this.warehouseAreaMapper.getWareHouseByCityId(cityId, mallProductEntity.getTransportType());
                    logger.info("=======\u6821\u9a8c\u63a5\u53e3checkSalesNum\u83b7\u53d6\u57ce\u5e02\u5bf9\u5e94\u4ed3\u5e93==========warehouseAreaEntity={}", (Object)JSON.toJSONString((Object)warehouseAreaEntity));
                    if (warehouseAreaEntity == null) {
                        logger.info("=======\u6821\u9a8c\u63a5\u53e3checkSalesNum\u83b7\u53d6\u57ce\u5e02\u5bf9\u5e94\u4ed3\u5e93\u4e3a\u7a7anull\u4e3a\u7a7anull\u4e3a\u7a7anull==========warehouseAreaEntity={}", (Object)JSON.toJSONString((Object)warehouseAreaEntity));
                        return BaseJsonVo.error((String)"\u5e93\u5b58\u4e0d\u8db3");
                    }
                    Integer salesNum = Integer.valueOf(prodIdSalesNumMap.get(proId).toString());
                    StringBuilder redisKey = new StringBuilder("mall_product_id").append(proId);
                    boolean tryLock = this.mallRedisLock.tryLock(redisKey.toString(), 20000L);
                    try {
                        logger.info("=========\u66f4\u65b0\u53ef\u552e\u5356\u91cf=========salesNum={},proId={},redisKey={}", new Object[]{salesNum, proId, redisKey.toString()});
                        if (!tryLock) continue;
                        int result = 0;
                        MallProductSalesEntityVo mallProductSalesEntityVo = this.mallProductSalesMapper.getProductSalesNum(proId, warehouseAreaEntity.getWarehouseId());
                        if (mallProductSalesEntityVo != null) {
                            int salesNumInt;
                            int n = salesNumInt = mallProductSalesEntityVo.getSalesNum() == null ? 0 : mallProductSalesEntityVo.getSalesNum();
                            if (salesNum < 0) {
                                Integer salesNumMath = Math.abs(salesNum);
                                if (salesNumMath.compareTo(salesNumInt) > 0) {
                                    BaseJsonVo baseJsonVo2 = BaseJsonVo.error((String)(mallProductSalesEntityVo.getProName() + "\u5e93\u5b58\u4e0d\u8db3"));
                                    return baseJsonVo2;
                                }
                                salesNum = salesNumInt + salesNum;
                                result = this.mallProductSalesMapper.updateProductSalesNumByProId(salesNum, proId, warehouseAreaEntity.getWarehouseId());
                            } else {
                                salesNum = salesNumInt + salesNum;
                                result = this.mallProductSalesMapper.updateProductSalesNumByProId(salesNum, proId, warehouseAreaEntity.getWarehouseId());
                            }
                        }
                        if (result == 0) {
                            BaseJsonVo baseJsonVo3 = BaseJsonVo.success((Object)"\u66f4\u65b0\u5e93\u5b58\u5931\u8d25");
                            return baseJsonVo3;
                        }
                        BaseJsonVo baseJsonVo4 = BaseJsonVo.success((Object)"\u66f4\u65b0\u5e93\u5b58\u6210\u529f");
                        return baseJsonVo4;
                    }
                    finally {
                        logger.info("============\u66f4\u65b0\u53ef\u552e\u5356\u91cf\u7ed3\u675f===redisLock.unlock============redisKey={}", (Object)redisKey.toString());
                        this.mallRedisLock.unlock(redisKey.toString());
                        continue;
                    }
                }
                logger.info("============\u6821\u9a8c\u5931\u8d25\u4ea7\u54c1\u4e0d\u5b58\u5728==========");
                return BaseJsonVo.error((String)"\u65e0\u4ea7\u54c1\u4fe1\u606f");
            }
        }
        return baseJsonVo;
    }

    @Override
    public BaseJsonVo updateProductSalesNumByProId(List<MallProductVO> productsPool, Boolean isDeduction, Integer cityId) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        if (productsPool != null && productsPool.size() > 0) {
            for (MallProductVO product : productsPool) {
                if (map.containsKey(product.getProId())) {
                    map.put(product.getProId(), (Integer)map.get(product.getProId()) + (isDeduction != false ? 0 - product.getCount() : product.getCount()));
                    continue;
                }
                map.put(product.getProId(), isDeduction != false ? 0 - product.getCount() : product.getCount());
            }
        }
        return this.updateProductSalesNumByProId(map, cityId);
    }

    @Override
    public BaseJsonVo updateProductSalesNumByOrderGroupProducts(List<MallOrderGroupProductEntity> productsPool, Boolean isDeduction, Integer cityId) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        if (productsPool != null && productsPool.size() > 0) {
            for (MallOrderGroupProductEntity product : productsPool) {
                if (map.containsKey(product.getProductId())) {
                    map.put(product.getProductId(), (Integer)map.get(product.getProductId()) + (isDeduction != false ? 0 - product.getQuantity() : product.getQuantity()));
                    continue;
                }
                map.put(product.getProductId(), isDeduction != false ? 0 - product.getQuantity() : product.getQuantity());
            }
        }
        return this.updateProductSalesNumByProId(map, cityId);
    }
}

