/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.shoppingcart;

import cc.lechun.common.enums.customer.VipRightTypeEnum;
import cc.lechun.common.enums.sales.TransportTypeEnum;
import cc.lechun.common.enums.trade.OrderSourceEnum;
import cc.lechun.common.enums.trade.SalesTypeEnum;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.math.PriceUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.entity.sales.MallFreeVO;
import cc.lechun.mall.entity.sales.MallFullCutNumberVo;
import cc.lechun.mall.entity.sales.MallFullcutDetailEntity;
import cc.lechun.mall.entity.sales.MallFullcutVo;
import cc.lechun.mall.entity.sales.MallGroupProductEntity;
import cc.lechun.mall.entity.sales.MallGroupVO;
import cc.lechun.mall.entity.sales.MallPriceVO;
import cc.lechun.mall.entity.sales.MallProductEntity;
import cc.lechun.mall.entity.sales.MallProductGroupEntity;
import cc.lechun.mall.entity.sales.MallProductVO;
import cc.lechun.mall.entity.sales.MallPromotionEntity;
import cc.lechun.mall.entity.sales.MallPromotionProductEntity;
import cc.lechun.mall.entity.sales.MallPromotionVO;
import cc.lechun.mall.entity.sales.MallRegularEntity;
import cc.lechun.mall.entity.shoppingcart.MallShoppingcartVO;
import cc.lechun.mall.entity.trade.MallMainOrderVo;
import cc.lechun.mall.entity.trade.MallOrderVo;
import cc.lechun.mall.entity.vip.MallVipRightsEntity;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.platform.PlatFormInterface;
import cc.lechun.mall.iservice.sales.MallFullcutDetailInterface;
import cc.lechun.mall.iservice.sales.MallFullcutInterface;
import cc.lechun.mall.iservice.sales.MallGroupInterface;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.iservice.sales.MallPromotionInterface;
import cc.lechun.mall.iservice.sales.MallPromotionProductInterface;
import cc.lechun.mall.iservice.sales.MallRegularInterface;
import cc.lechun.mall.iservice.shoppingcart.MallPriceCalcInterface;
import cc.lechun.mall.iservice.shoppingcart.MallShoppingcartInterface;
import cc.lechun.mall.iservice.vip.MallVipInterface;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MallPriceCalcService
extends BaseService
implements MallPriceCalcInterface {
    @Autowired
    private CustomerInterface customerService;
    @Autowired
    private MallGroupInterface groupService;
    @Autowired
    private MallFullcutInterface fullcutService;
    @Autowired
    private MallFullcutDetailInterface fullcutDetailService;
    @Autowired
    private MallProductInterface productService;
    @Autowired
    private MallRegularInterface regularService;
    @Autowired
    private PlatFormInterface platformService;
    @Autowired
    private MallVipInterface vipService;
    @Autowired
    private MallPromotionInterface promotionService;
    @Autowired
    private MallPromotionProductInterface promotionProductService;
    @Autowired
    private MallShoppingcartInterface shoppingcartInterface;

    @Override
    public void calcShoppingcartVO(List<MallShoppingcartVO> mallShoppingcartVOS) {
        Integer orderSource = mallShoppingcartVOS.get(0).getOrderSource();
        for (MallShoppingcartVO cartVO : mallShoppingcartVOS) {
            this.calcProduct(cartVO, mallShoppingcartVOS.size() == 1 ? mallShoppingcartVOS.get(0).getDeliverCount().intValue() : mallShoppingcartVOS.size());
            this.calcGroup(cartVO);
            this.calcPromotion(cartVO);
            this.totalCartVo(cartVO);
            if (OrderSourceEnum.CART.getValue() != orderSource.intValue() || !StringUtils.isNotEmpty((String)cartVO.getBindCode())) continue;
            ArrayList<MallShoppingcartVO> fullCart = new ArrayList<MallShoppingcartVO>();
            fullCart.add(cartVO);
            this.calcFullCut(fullCart);
        }
        if (OrderSourceEnum.FULLCUT.getValue() == orderSource.intValue()) {
            this.calcFullCut(mallShoppingcartVOS);
        }
    }

    private void calcProduct(MallShoppingcartVO cartVO, int deliverCount) {
        if (cartVO == null || cartVO.getProducts() == null || cartVO.getProducts().size() == 0) {
            return;
        }
        List<MallProductVO> productList = cartVO.getProducts();
        BigDecimal factPrice = cartVO.getFactPrice() == null ? new BigDecimal(0) : cartVO.getFactPrice();
        BigDecimal price = cartVO.getPrice() == null ? new BigDecimal(0) : cartVO.getPrice();
        for (MallProductVO vo : productList) {
            MallPriceVO priceVO;
            if (OrderSourceEnum.CART.getValue() == cartVO.getOrderSource()) {
                priceVO = this.getPrice(OrderSourceEnum.CART, SalesTypeEnum.SALES_PRODUCT, vo.getProId(), cartVO.getCustomerId(), 0);
                if (priceVO != null && priceVO.getOriginPrice() != null) {
                    vo.setProPrice(String.valueOf(priceVO.getOriginPrice()));
                }
                if (priceVO != null && priceVO.getFactPrice() != null) {
                    vo.setFactPrice(priceVO.getFactPrice());
                }
                if (priceVO != null && priceVO.getVipPrice() != null) {
                    vo.setVipPrice(priceVO.getVipPrice());
                }
                if (priceVO != null && priceVO.getVipDiff() != null) {
                    vo.setVipDiff(priceVO.getVipDiff());
                }
            } else if (OrderSourceEnum.LONGPERIOD_BUY.getValue() == cartVO.getOrderSource()) {
                priceVO = this.getPrice(OrderSourceEnum.LONGPERIOD_BUY, SalesTypeEnum.SALES_PRODUCT, vo.getProId(), cartVO.getCustomerId(), deliverCount);
                if (priceVO != null && priceVO.getOriginPrice() != null) {
                    vo.setProPrice(String.valueOf(priceVO.getOriginPrice()));
                }
                if (priceVO != null && priceVO.getFactPrice() != null) {
                    vo.setFactPrice(priceVO.getFactPrice());
                }
            }
            if (StringUtils.isNotEmpty((String)vo.getGroupId())) {
                List<MallGroupProductEntity> groupProducts = this.groupService.getGroupProducts(vo.getGroupId());
                vo.setFactPrice(groupProducts.stream().filter(pro -> pro.getProId().equals(vo.getProId())).findFirst().get().getProPrice());
            }
            vo.setShareAmount(PriceUtils.multiply((BigDecimal)vo.getFactPrice(), (Integer)vo.getCount()));
            vo.setShareCount(vo.getCount());
        }
    }

    private void calcGroup(MallShoppingcartVO cartVO) {
        if (cartVO == null || cartVO.getGroups() == null || cartVO.getGroups().size() == 0) {
            return;
        }
        List<MallGroupVO> groupList = cartVO.getGroups();
        for (MallGroupVO vo : groupList) {
            vo.setFactPrice(PriceUtils.format((BigDecimal)vo.getSalePrice()));
            vo.setShareAmount(PriceUtils.multiply((BigDecimal)vo.getFactPrice(), (Integer)vo.getCount()));
            this.setGroupProductPrice(vo);
        }
    }

    private void setGroupProductPrice(MallGroupVO vo) {
        Integer splitPriceMode = vo.getSplitPriceMode();
        if (splitPriceMode == 0) {
            Object originPrice = new BigDecimal("0.00");
            for (MallProductVO productVO : vo.getProductList()) {
                originPrice = PriceUtils.add((BigDecimal)originPrice, (BigDecimal)PriceUtils.multiply((BigDecimal)new BigDecimal(productVO.getProPrice()), (Integer)productVO.getCount()));
            }
            BigDecimal discount = BigDecimal.ONE;
            if (((BigDecimal)originPrice).intValue() != 0) {
                discount = PriceUtils.divide((BigDecimal)vo.getFactPrice(), (BigDecimal)originPrice);
            }
            for (MallProductVO productVO : vo.getProductList()) {
                productVO.setFactPrice(PriceUtils.multiply((BigDecimal)new BigDecimal(productVO.getProPrice()), (BigDecimal)discount));
            }
        } else if (splitPriceMode != 0) {
            for (MallProductVO productVO : vo.getProductList()) {
                productVO.setFactPrice(new BigDecimal(productVO.getProPrice()));
            }
        }
        double rate = vo.getProductList().stream().mapToDouble(c -> PriceUtils.multiply((BigDecimal)c.getFactPrice(), (Integer)c.getCount()).doubleValue()).sum() / vo.getShareAmount().divide(BigDecimal.valueOf(vo.getCount().intValue())).doubleValue();
        for (MallProductVO productVO : vo.getProductList()) {
            productVO.setFactPrice(PriceUtils.multiply((BigDecimal)productVO.getFactPrice(), (BigDecimal)new BigDecimal(rate)));
            productVO.setShareAmount(PriceUtils.multiply((BigDecimal)PriceUtils.multiply((BigDecimal)productVO.getFactPrice(), (Integer)productVO.getCount()).multiply(BigDecimal.valueOf(vo.getCount().intValue())), (BigDecimal)new BigDecimal(rate)));
            productVO.setShareCount(vo.getCount() * productVO.getCount());
        }
    }

    private void calcPromotion(MallShoppingcartVO cartVO) {
        if (cartVO == null || cartVO.getPromotions() == null || cartVO.getPromotions().size() == 0) {
            return;
        }
        List<MallPromotionVO> promotionList = cartVO.getPromotions();
        for (MallPromotionVO vo : promotionList) {
            MallPriceVO priceVO = this.getPrice(OrderSourceEnum.CART, SalesTypeEnum.SALES_PROMOTION, vo.getPromotionId(), cartVO.getCustomerId(), 0);
            if (priceVO != null && priceVO.getOriginPrice() != null) {
                vo.setOriginPrice(priceVO.getOriginPrice());
            }
            if (priceVO != null && priceVO.getFactPrice() != null) {
                vo.setFactPrice(priceVO.getFactPrice());
            }
            if (priceVO != null && priceVO.getVipDiff() != null) {
                vo.setVipDiff(priceVO.getVipDiff());
            }
            if (priceVO != null && priceVO.getPromotionDiff() != null) {
                vo.setPromotionDiff(priceVO.getPromotionDiff());
            }
            if (SalesTypeEnum.SALES_PRODUCT.getValue() == Integer.valueOf(vo.getProductType()).intValue() && vo.getProduct() != null) {
                vo.getProduct().setFactPrice(vo.getFactPrice());
                vo.getProduct().setShareAmount(PriceUtils.multiply((BigDecimal)vo.getFactPrice(), (Integer)vo.getCount()));
                vo.getProduct().setShareCount(vo.getCount());
                continue;
            }
            if (SalesTypeEnum.SALES_GROUP.getValue() != Integer.valueOf(vo.getProductType()).intValue() || vo.getGroup() == null) continue;
            vo.getGroup().setFactPrice(vo.getFactPrice());
            vo.getGroup().setShareAmount(PriceUtils.multiply((BigDecimal)vo.getFactPrice(), (Integer)vo.getCount()));
            this.setGroupProductPrice(vo.getGroup());
        }
    }

    private void calcFullCut(List<MallShoppingcartVO> shoppingcartVOS) {
        Boolean isGlobalFullcut = false;
        BaseJsonVo jsonVo = this.fullcutService.getEnableFullcut(shoppingcartVOS);
        if (jsonVo.isSuccess()) {
            MallFullcutVo fullcutVo = (MallFullcutVo)jsonVo.getValue();
            isGlobalFullcut = fullcutVo.getFullClass() == 1;
            if (fullcutVo != null) {
                List<MallFullcutDetailEntity> fullcutDetailEntities = this.fullcutDetailService.getFullcutDetails(fullcutVo.getFullCutId());
                if (fullcutDetailEntities == null || fullcutDetailEntities.size() == 0) {
                    return;
                }
                if (!this.fullcutService.checkFullcut(fullcutVo, fullcutDetailEntities, shoppingcartVOS)) {
                    return;
                }
                int quantity = 0;
                BigDecimal amount = new BigDecimal(0);
                ArrayList fullProductVos = new ArrayList();
                ArrayList fullGroupVos = new ArrayList();
                for (MallShoppingcartVO cartVO : shoppingcartVOS) {
                    if (fullcutVo.getDoubleFreeGift() == 0) {
                        cartVO.setFrees(new ArrayList<MallFreeVO>());
                    }
                    if (fullcutVo.getDoublePromotion() == 0 && !isGlobalFullcut.booleanValue()) {
                        cartVO.setPromotionDiffPrice(BigDecimal.valueOf(0L));
                        cartVO.setPromotions(new ArrayList<MallPromotionVO>());
                        cartVO.getProductsPool().removeAll(cartVO.getProductsPool().stream().filter(c -> StringUtils.isNotEmpty((String)c.getPromotionId())).collect(Collectors.toList()));
                    }
                    if (cartVO.getIsfullCutFree() != 0) continue;
                    if (isGlobalFullcut.booleanValue()) {
                        for (MallProductVO productVO : cartVO.getProductsPool()) {
                            productVO.setFullcutAmount(BigDecimal.ZERO);
                            productVO.setFullcutCount(0);
                        }
                        if (fullcutVo.getDoublePromotion() == 0) {
                            fullProductVos.addAll(cartVO.getProductsPool().stream().filter(c -> c.getFullCutId() != null && StringUtils.isEmpty((String)c.getPromotionId())).collect(Collectors.toList()));
                        } else {
                            fullProductVos.addAll(cartVO.getProductsPool().stream().filter(c -> c.getFullCutId() != null).collect(Collectors.toList()));
                        }
                    } else {
                        for (MallProductVO productVO : cartVO.getProducts()) {
                            productVO.setFullcutAmount(BigDecimal.ZERO);
                            productVO.setFullcutCount(0);
                        }
                        fullProductVos.addAll(cartVO.getProducts().stream().filter(c -> c.getFullCutId() != null).collect(Collectors.toList()));
                    }
                    for (MallGroupVO groupVO : cartVO.getGroups()) {
                        groupVO.setFullcutAmount(BigDecimal.ZERO);
                        groupVO.setFullcutCount(0);
                    }
                    fullGroupVos.addAll(cartVO.getGroups().stream().filter(c -> c.getFullCutId() != null).collect(Collectors.toList()));
                    cartVO.setFullcutName(fullcutVo.getFullCutName());
                    cartVO.setFullcutRuleName(fullcutVo.getCutRuleName());
                }
                if (fullProductVos != null) {
                    quantity = fullProductVos.stream().mapToInt(c -> c.getCount()).sum();
                    amount = BigDecimal.valueOf(fullProductVos.stream().mapToDouble(c -> c.getShareAmount().doubleValue()).sum());
                }
                if (fullGroupVos != null && !isGlobalFullcut.booleanValue()) {
                    quantity += fullGroupVos.stream().mapToInt(c -> c.getCount()).sum();
                    amount = BigDecimal.valueOf(fullGroupVos.stream().mapToDouble(c -> c.getShareAmount().doubleValue()).sum()).add(amount);
                }
                BigDecimal num = new BigDecimal(0);
                MallFullCutNumberVo numberVo = this.fullcutService.calculateFullCutAmount(fullcutVo, amount, quantity);
                num = BigDecimal.valueOf(numberVo.getCutNumber().intValue());
                if (num.doubleValue() > 0.0) {
                    if (fullcutVo.getCutRule() == 1) {
                        Comparator comparator = (h1, h2) -> h1.getFactPrice().compareTo(h2.getFactPrice());
                        fullProductVos.sort(comparator.reversed());
                        String[] comparator1 = (h1, h2) -> h1.getFactPrice().compareTo(h2.getFactPrice());
                        fullGroupVos.sort(comparator1.reversed());
                    }
                    if (fullcutVo.getCutRule() == 2) {
                        fullProductVos.sort((v1, v2) -> v1.getFactPrice().compareTo(v2.getFactPrice()));
                        fullGroupVos.sort((v1, v2) -> v1.getFactPrice().compareTo(v2.getFactPrice()));
                    }
                    if (fullcutVo.getCutRule() == 3) {
                        Collections.shuffle(fullProductVos);
                        Collections.shuffle(fullGroupVos);
                    }
                    if (fullcutVo.getCutRule() == 4 && fullcutVo.getType() == 1) {
                        String[] productIds = fullcutVo.getProductIds().split(",");
                        for (String p : productIds) {
                            List list = fullProductVos.stream().filter(c -> c.getProId().equals(p)).collect(Collectors.toList());
                            MallProductVO productVO = new MallProductVO();
                            if (list != null && list.size() > 0) {
                                productVO = (MallProductVO)list.get(0);
                                if (fullcutVo.getProductRule() == 1) {
                                    this.logger.info("+1\u4e4b\u524d\uff1a" + String.valueOf(productVO.getCount()));
                                    productVO.setCount(productVO.getCount() + num.intValue());
                                    productVO.setFullCutId(fullcutVo.getFullCutId());
                                    productVO.setFullcutCount(productVO.getFullcutCount() == null ? num.intValue() : productVO.getFullcutCount() + num.intValue());
                                    productVO.setFullcutAmount(productVO.getFactPrice().multiply(BigDecimal.valueOf(productVO.getFullcutCount().intValue())));
                                }
                                if (fullcutVo.getProductRule() != 2) continue;
                                if (productVO.getFullcutCount() == productVO.getCount()) break;
                                productVO.setFullCutId(fullcutVo.getFullCutId());
                                productVO.setFullcutCount(productVO.getFullcutCount() == null ? 0 : productVO.getFullcutCount() + 1);
                                productVO.setFullcutAmount(productVO.getFactPrice().multiply(BigDecimal.valueOf(productVO.getFullcutCount().intValue())));
                                continue;
                            }
                            BaseJsonVo result = this.productService.buildProductVO(p, num.intValue(), "", "", fullcutVo.getFullCutId(), "", false, true, productVO.getSpeedUp(), null);
                            if (!result.isSuccess()) continue;
                            productVO = (MallProductVO)result.getValue();
                            MallShoppingcartVO shoppingcartVO = this.productService.getTransportType(shoppingcartVOS, TransportTypeEnum.getTransportTypeEnum(productVO.getTransportType()));
                            if (fullcutVo.getProductRule() != 1) continue;
                            productVO.setFullcutCount(productVO.getFullcutCount() == null ? num.intValue() : productVO.getFullcutCount() + num.intValue());
                            productVO.setFullcutAmount(productVO.getFactPrice().multiply(BigDecimal.valueOf(productVO.getFullcutCount().intValue())));
                            if (shoppingcartVO != null) {
                                shoppingcartVO.getProducts().add(productVO);
                                shoppingcartVO.setIsfullCutFree(1);
                                continue;
                            }
                            shoppingcartVO = new MallOrderVo();
                            shoppingcartVO.setPromotionDiffPrice(BigDecimal.ZERO);
                            shoppingcartVO.setPromotions(new ArrayList<MallPromotionVO>());
                            shoppingcartVO.setFrees(new ArrayList<MallFreeVO>());
                            shoppingcartVO.setOrderSource(shoppingcartVOS.get(0).getOrderSource());
                            shoppingcartVO.setPlatFormGroupId(shoppingcartVOS.get(0).getPlatFormGroupId());
                            shoppingcartVO.setPlatFormId(shoppingcartVOS.get(0).getPlatFormId());
                            shoppingcartVO.setCustomerId(shoppingcartVOS.get(0).getCustomerId());
                            shoppingcartVO.setGroups(new ArrayList<MallGroupVO>());
                            ArrayList<MallProductVO> productVOS = new ArrayList<MallProductVO>();
                            productVOS.add(productVO);
                            shoppingcartVO.setProducts(productVOS);
                            shoppingcartVO.setSelfMadeType(shoppingcartVOS.get(0).getSelfMadeType());
                            shoppingcartVO.setDeliverCount(shoppingcartVOS.get(0).getDeliverCount());
                            shoppingcartVO.setFactPrice(productVO.getFactPrice());
                            shoppingcartVO.setFullcutName(shoppingcartVOS.get(0).getFullcutName());
                            shoppingcartVO.setFullcutRuleName(shoppingcartVOS.get(0).getFullcutRuleName());
                            shoppingcartVO.setPrice(new BigDecimal(productVO.getProPrice()));
                            shoppingcartVO.setProductsPool(productVOS);
                            shoppingcartVO.setSpeedUp(shoppingcartVOS.get(0).getSpeedUp());
                            shoppingcartVO.setVipDiffPrice(BigDecimal.ZERO);
                            shoppingcartVO.setBindCode(shoppingcartVOS.get(0).getBindCode());
                            shoppingcartVO.setRule(shoppingcartVOS.get(0).getRule());
                            shoppingcartVO.setIsfullCutFree(1);
                            shoppingcartVOS.add(shoppingcartVO);
                        }
                        for (MallShoppingcartVO s : shoppingcartVOS) {
                            s.setIsfullCutFree(1);
                        }
                    } else if (fullcutVo.getType() == 1) {
                        int tempNum = num.intValue();
                        for (int i = 1; i <= tempNum; ++i) {
                            MallProductVO productVO = null;
                            MallGroupVO groupVO = null;
                            if (fullGroupVos.size() > 0) {
                                groupVO = (MallGroupVO)fullGroupVos.get(0);
                            }
                            if (fullProductVos.size() > 0) {
                                productVO = (MallProductVO)fullProductVos.get(0);
                            }
                            if (num.doubleValue() > 0.0) {
                                if (productVO != null && (productVO.getFactPrice().compareTo(groupVO == null ? BigDecimal.ZERO : groupVO.getFactPrice()) >= 0 && fullcutVo.getCutRule() == 1 || productVO.getFactPrice().compareTo(groupVO == null ? BigDecimal.valueOf(100000000L) : groupVO.getFactPrice()) <= 0 && fullcutVo.getCutRule() == 2 || fullcutVo.getCutRule() == 3)) {
                                    if ((double)productVO.getCount().intValue() >= num.doubleValue()) {
                                        productVO.setFullCutId(fullcutVo.getFullCutId());
                                        productVO.setFullcutCount(num.intValue());
                                        productVO.setFullcutAmount(PriceUtils.multiply((BigDecimal)productVO.getFactPrice(), (Integer)num.intValue()));
                                        num = new BigDecimal(0);
                                    } else {
                                        productVO.setFullCutId(fullcutVo.getFullCutId());
                                        productVO.setFullcutCount(productVO.getCount());
                                        productVO.setFullcutAmount(PriceUtils.multiply((BigDecimal)productVO.getFactPrice(), (Integer)productVO.getCount()));
                                        num = PriceUtils.subtract((BigDecimal)num, (BigDecimal)new BigDecimal(productVO.getCount()));
                                    }
                                    fullProductVos.remove(productVO);
                                }
                                if (groupVO != null && (groupVO.getFactPrice().compareTo(productVO == null ? BigDecimal.ZERO : productVO.getFactPrice()) > 0 && fullcutVo.getCutRule() == 1 || groupVO.getFactPrice().compareTo(productVO == null ? BigDecimal.valueOf(100000000L) : productVO.getFactPrice()) < 0 && fullcutVo.getCutRule() == 2 || fullcutVo.getCutRule() == 3)) {
                                    if ((double)groupVO.getCount().intValue() >= num.doubleValue()) {
                                        groupVO.setFullCutId(fullcutVo.getFullCutId());
                                        groupVO.setFullcutCount(num.intValue());
                                        groupVO.setFullcutAmount(PriceUtils.multiply((BigDecimal)groupVO.getFactPrice(), (Integer)num.intValue()));
                                        num = new BigDecimal(0);
                                    } else {
                                        groupVO.setFullCutId(fullcutVo.getFullCutId());
                                        groupVO.setFullcutCount(groupVO.getCount());
                                        groupVO.setFullcutAmount(PriceUtils.multiply((BigDecimal)groupVO.getFactPrice(), (Integer)groupVO.getCount()));
                                        num = PriceUtils.subtract((BigDecimal)num, (BigDecimal)new BigDecimal(groupVO.getCount()));
                                    }
                                    fullGroupVos.remove(groupVO);
                                }
                            }
                            if (num.intValue() != 0) {
                                continue;
                            }
                            break;
                        }
                    } else {
                        for (MallProductVO productVO : fullProductVos) {
                            if (fullcutVo.getType() != 2 || !(num.doubleValue() > 0.0)) continue;
                            if (PriceUtils.multiply((BigDecimal)productVO.getFactPrice(), (Integer)productVO.getShareCount()).compareTo(num) >= 0) {
                                productVO.setFullCutId(fullcutVo.getFullCutId());
                                productVO.setFullcutCount(0);
                                productVO.setFullcutAmount(num);
                                num = new BigDecimal(0);
                                continue;
                            }
                            productVO.setFullCutId(fullcutVo.getFullCutId());
                            productVO.setFullcutCount(0);
                            productVO.setFullcutAmount(PriceUtils.multiply((BigDecimal)productVO.getFactPrice(), (Integer)productVO.getShareCount()));
                            num = PriceUtils.subtract((BigDecimal)num, (BigDecimal)PriceUtils.multiply((BigDecimal)productVO.getFactPrice(), (Integer)productVO.getShareCount()));
                        }
                        if (!isGlobalFullcut.booleanValue()) {
                            for (MallGroupVO groupVO : fullGroupVos) {
                                if (fullcutVo.getType() != 2 || !(num.doubleValue() > 0.0)) continue;
                                if (PriceUtils.multiply((BigDecimal)groupVO.getFactPrice(), (Integer)groupVO.getCount()).compareTo(num) >= 0) {
                                    groupVO.setFullCutId(fullcutVo.getFullCutId());
                                    groupVO.setFullcutCount(0);
                                    groupVO.setFullcutAmount(num);
                                    num = new BigDecimal(0);
                                    continue;
                                }
                                groupVO.setFullCutId(fullcutVo.getFullCutId());
                                groupVO.setFullcutCount(0);
                                groupVO.setFullcutAmount(PriceUtils.multiply((BigDecimal)groupVO.getFactPrice(), (Integer)groupVO.getCount()));
                                num = PriceUtils.subtract((BigDecimal)num, (BigDecimal)PriceUtils.multiply((BigDecimal)groupVO.getFactPrice(), (Integer)groupVO.getCount()));
                            }
                        }
                    }
                }
                if (isGlobalFullcut.booleanValue()) {
                    if (fullGroupVos.size() > 0) {
                        for (MallGroupVO groupVO : fullGroupVos) {
                            double fullAmount = fullProductVos.stream().filter(c -> groupVO.getGroupId().equals(c.getGroupId())).mapToDouble(c -> c.getFullcutAmount().doubleValue()).sum();
                            if (!(fullAmount > 0.0)) continue;
                            groupVO.setFullcutAmount(BigDecimal.valueOf(fullAmount));
                        }
                    }
                    for (MallShoppingcartVO cart : shoppingcartVOS) {
                        if (cart.getPromotions() == null || cart.getPromotions().size() <= 0) continue;
                        for (MallPromotionVO promotionVO : cart.getPromotions()) {
                            double fullAmount = fullProductVos.stream().filter(c -> promotionVO.getPromotionId().equals(c.getPromotionId())).mapToDouble(c -> c.getFullcutAmount().doubleValue()).sum();
                            if (!(fullAmount > 0.0)) continue;
                            promotionVO.setFullcutAmount(BigDecimal.valueOf(fullAmount));
                            if (promotionVO.getGroup() == null) continue;
                            promotionVO.getGroup().setFullcutAmount(BigDecimal.valueOf(fullAmount));
                            promotionVO.getGroup().setFullCutId(fullcutVo.getFullCutId());
                        }
                    }
                }
            }
        }
    }

    @Override
    public void totalCartVo(MallShoppingcartVO shoppingcartVO) {
        BigDecimal[] factPrice = new BigDecimal[]{new BigDecimal(0)};
        BigDecimal[] price = new BigDecimal[]{new BigDecimal(0)};
        BigDecimal[] vipDiffPrice = new BigDecimal[]{new BigDecimal(0)};
        BigDecimal[] promotionDiffPrice = new BigDecimal[]{new BigDecimal(0)};
        BigDecimal[] fullCutAmount = new BigDecimal[]{new BigDecimal(0)};
        if (shoppingcartVO.getProducts().size() > 0) {
            shoppingcartVO.getProducts().forEach(c -> {
                if (c.getValid().booleanValue() && c.getShoppingcartCheck().booleanValue() && c.getValid().booleanValue()) {
                    factPrice[0] = PriceUtils.add((BigDecimal)factPrice[0], (BigDecimal)PriceUtils.multiply((BigDecimal)c.getFactPrice(), (Integer)c.getCount()));
                    price[0] = PriceUtils.add((BigDecimal)price[0], (BigDecimal)PriceUtils.multiply((BigDecimal)new BigDecimal(c.getProPrice()), (Integer)c.getCount()));
                    vipDiffPrice[0] = PriceUtils.add((BigDecimal)vipDiffPrice[0], (BigDecimal)PriceUtils.multiply((BigDecimal)(c.getVipDiff() == null ? new BigDecimal(0) : c.getVipDiff()), (BigDecimal)new BigDecimal(c.getCount())));
                    fullCutAmount[0] = PriceUtils.add((BigDecimal)fullCutAmount[0], (BigDecimal)(c.getFullcutAmount() == null ? new BigDecimal(0) : c.getFullcutAmount()));
                }
            });
        }
        if (shoppingcartVO.getGroups().size() > 0) {
            shoppingcartVO.getGroups().forEach(c -> {
                if (c.getValid().booleanValue() && c.getShoppingcartCheck().booleanValue() && c.getValid().booleanValue()) {
                    factPrice[0] = PriceUtils.add((BigDecimal)factPrice[0], (BigDecimal)PriceUtils.multiply((BigDecimal)c.getFactPrice(), (Integer)c.getCount()));
                    price[0] = PriceUtils.add((BigDecimal)price[0], (BigDecimal)PriceUtils.multiply((BigDecimal)c.getSalePrice(), (Integer)c.getCount()));
                    fullCutAmount[0] = PriceUtils.add((BigDecimal)fullCutAmount[0], (BigDecimal)(c.getFullcutAmount() == null ? new BigDecimal(0) : c.getFullcutAmount()));
                }
            });
        }
        if (shoppingcartVO.getPromotions().size() > 0) {
            shoppingcartVO.getPromotions().forEach(c -> {
                if (c.getValid().booleanValue() && c.getShoppingcartCheck().booleanValue() && c.getValid().booleanValue()) {
                    factPrice[0] = PriceUtils.add((BigDecimal)factPrice[0], (BigDecimal)PriceUtils.multiply((BigDecimal)c.getFactPrice(), (Integer)c.getCount()));
                    price[0] = PriceUtils.add((BigDecimal)price[0], (BigDecimal)PriceUtils.multiply((BigDecimal)c.getOriginPrice(), (Integer)c.getCount()));
                    vipDiffPrice[0] = PriceUtils.add((BigDecimal)vipDiffPrice[0], (BigDecimal)PriceUtils.multiply((BigDecimal)(c.getVipDiff() == null ? new BigDecimal(0) : c.getVipDiff()), (BigDecimal)new BigDecimal(c.getCount())));
                    promotionDiffPrice[0] = PriceUtils.add((BigDecimal)promotionDiffPrice[0], (BigDecimal)PriceUtils.multiply((BigDecimal)(c.getPromotionDiff() == null ? new BigDecimal(0) : c.getPromotionDiff()), (BigDecimal)new BigDecimal(c.getCount())));
                    fullCutAmount[0] = PriceUtils.add((BigDecimal)fullCutAmount[0], (BigDecimal)(c.getFullcutAmount() == null ? new BigDecimal(0) : c.getFullcutAmount()));
                }
            });
        }
        shoppingcartVO.setFactPrice(factPrice[0]);
        shoppingcartVO.setPrice(price[0]);
        shoppingcartVO.setVipDiffPrice(vipDiffPrice[0]);
        shoppingcartVO.setPromotionDiffPrice(promotionDiffPrice[0]);
    }

    @Override
    public void totalOrderPrice(List<MallOrderVo> orderVos) {
        ArrayList<MallShoppingcartVO> shoppingcartVOS = new ArrayList<MallShoppingcartVO>();
        shoppingcartVOS.addAll(orderVos);
        this.calcShoppingcartVO(shoppingcartVOS);
        if (shoppingcartVOS.size() > orderVos.size()) {
            orderVos.add((MallOrderVo)shoppingcartVOS.get(shoppingcartVOS.size() - 1));
        }
        for (MallOrderVo orderVo : orderVos) {
            BigDecimal[] fullCutAmount = new BigDecimal[]{new BigDecimal(0)};
            BigDecimal[] freight = new BigDecimal[]{new BigDecimal(0)};
            BigDecimal couponAmount = orderVo.getCouponAmount();
            BigDecimal orderAmount = orderVo.getFactPrice();
            if (orderVo.getProducts().size() > 0) {
                for (MallProductVO mallProductVO : orderVo.getProducts()) {
                    fullCutAmount[0] = PriceUtils.add((BigDecimal)fullCutAmount[0], (BigDecimal)(mallProductVO.getFullcutAmount() == null ? new BigDecimal(0) : mallProductVO.getFullcutAmount()));
                }
            }
            if (orderVo.getGroups().size() > 0) {
                for (MallGroupVO mallGroupVO : orderVo.getGroups()) {
                    fullCutAmount[0] = PriceUtils.add((BigDecimal)fullCutAmount[0], (BigDecimal)(mallGroupVO.getFullcutAmount() == null ? new BigDecimal(0) : mallGroupVO.getFullcutAmount()));
                }
            }
            if (orderVo.getPromotions().size() > 0) {
                for (MallPromotionVO mallPromotionVO : orderVo.getPromotions()) {
                    fullCutAmount[0] = PriceUtils.add((BigDecimal)fullCutAmount[0], (BigDecimal)(mallPromotionVO.getFullcutAmount() == null ? new BigDecimal(0) : mallPromotionVO.getFullcutAmount()));
                }
            }
            orderAmount = PriceUtils.subtract((BigDecimal)orderAmount, (BigDecimal)fullCutAmount[0]);
            BigDecimal toatalAmount = PriceUtils.add((BigDecimal)orderAmount, (BigDecimal)(orderVo.getFreight() == null ? new BigDecimal(0) : orderVo.getFreight()));
            BigDecimal payAmount = PriceUtils.subtractToSix((BigDecimal)toatalAmount, (BigDecimal)orderVo.getBalanceAmount());
            payAmount = PriceUtils.subtractToSix((BigDecimal)payAmount, (BigDecimal)couponAmount);
            orderVo.setTotalAmount(toatalAmount);
            orderVo.setOrderAmount(orderAmount);
            orderVo.setCouponAmount(couponAmount);
            orderVo.setPayAmount(payAmount);
            orderVo.setFullcutAmount(fullCutAmount[0]);
        }
    }

    @Override
    public void totalMainOrderPrice(MallMainOrderVo mainOrderVo) {
        BigDecimal toatalAmount;
        BigDecimal[] orderAmount = new BigDecimal[]{new BigDecimal(0)};
        BigDecimal[] freight = new BigDecimal[]{new BigDecimal(0)};
        BigDecimal[] couponAmount = new BigDecimal[]{new BigDecimal(0)};
        BigDecimal[] balanceAmount = new BigDecimal[]{new BigDecimal(0)};
        BigDecimal[] vipDiffAmount = new BigDecimal[]{new BigDecimal(0)};
        BigDecimal[] promotionDiffAmount = new BigDecimal[]{new BigDecimal(0)};
        BigDecimal[] fullcutAmount = new BigDecimal[]{new BigDecimal(0)};
        mainOrderVo.getMallOrderVos().forEach(c -> {
            orderAmount[0] = PriceUtils.addNoUp((BigDecimal)orderAmount[0], (BigDecimal)c.getOrderAmount());
            freight[0] = PriceUtils.addNoUp((BigDecimal)freight[0], (BigDecimal)c.getFreight());
            balanceAmount[0] = PriceUtils.addNoUp((BigDecimal)balanceAmount[0], (BigDecimal)c.getBalanceAmount());
            couponAmount[0] = PriceUtils.addNoUp((BigDecimal)couponAmount[0], (BigDecimal)c.getCouponAmount());
            fullcutAmount[0] = PriceUtils.addNoUp((BigDecimal)fullcutAmount[0], (BigDecimal)c.getFullcutAmount());
            vipDiffAmount[0] = PriceUtils.addNoUp((BigDecimal)vipDiffAmount[0], (BigDecimal)c.getVipDiffPrice());
            promotionDiffAmount[0] = PriceUtils.addNoUp((BigDecimal)promotionDiffAmount[0], (BigDecimal)c.getPromotionDiffPrice());
            mainOrderVo.setFullcutName(c.getFullcutName());
            mainOrderVo.setFullcutRuleName(c.getFullcutRuleName());
        });
        BigDecimal payAmount = toatalAmount = PriceUtils.addNoUp((BigDecimal)orderAmount[0], (BigDecimal)freight[0]);
        payAmount = PriceUtils.subtractToSix((BigDecimal)payAmount, (BigDecimal)balanceAmount[0]);
        payAmount = PriceUtils.subtractToSix((BigDecimal)payAmount, (BigDecimal)couponAmount[0]);
        mainOrderVo.setTotalAmount(toatalAmount);
        mainOrderVo.setOrderAmount(orderAmount[0]);
        mainOrderVo.setCouponAmount(couponAmount[0]);
        mainOrderVo.setBalanceAmount(balanceAmount[0]);
        mainOrderVo.setFreight(freight[0]);
        mainOrderVo.setPayAmount(payAmount);
        mainOrderVo.setFullcutAmount(fullcutAmount[0]);
        mainOrderVo.setVipDiffPrice(vipDiffAmount[0]);
        mainOrderVo.setPromotionDiffPrice(promotionDiffAmount[0]);
        mainOrderVo.setTotalAmountANdVipDiff(toatalAmount.add(vipDiffAmount[0]).add(promotionDiffAmount[0]));
        this.calcOrderFavorable(mainOrderVo);
    }

    private void calcOrderFavorable(MallMainOrderVo mainOrderVo) {
        if (mainOrderVo != null && mainOrderVo.getOrderFavorStrategies() != null && mainOrderVo.getOrderFavorStrategies().size() > 0) {
            BigDecimal[] orderSaved = new BigDecimal[]{new BigDecimal(0)};
            mainOrderVo.getOrderFavorStrategies().forEach(favorStrategy -> {
                HashMap<String, Object> param = new HashMap<String, Object>();
                String inviteId = mainOrderVo.getMallOrderVos().get(0).getDefineField();
                try {
                    inviteId = JsonUtils.stringToMap((String)URLDecoder.decode(inviteId, "utf-8")).get("inviteId").toString();
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException("\u672a\u83b7\u53d6\u5230inviteId,\u7c7b\u578b\u8f6c\u5316\u9519\u8bef");
                }
                param.put("inviteId", inviteId);
                BigDecimal moneySaved = favorStrategy.favorCalc(param);
                orderSaved[0] = PriceUtils.add((BigDecimal)orderSaved[0], (BigDecimal)moneySaved);
            });
            this.logger.info("\u62fc\u5355\u8282\u7701\uff1a" + orderSaved[0].doubleValue());
            mainOrderVo.setTotalAmount(PriceUtils.subtract((BigDecimal)mainOrderVo.getTotalAmount(), (BigDecimal)orderSaved[0]));
            mainOrderVo.setOrderAmount(PriceUtils.subtract((BigDecimal)mainOrderVo.getOrderAmount(), (BigDecimal)orderSaved[0]));
            mainOrderVo.setPayAmount(PriceUtils.subtract((BigDecimal)mainOrderVo.getPayAmount(), (BigDecimal)orderSaved[0]));
            mainOrderVo.getMallOrderVos().get(0).setTotalAmount(PriceUtils.subtract((BigDecimal)mainOrderVo.getMallOrderVos().get(0).getTotalAmount(), (BigDecimal)orderSaved[0]));
            mainOrderVo.getMallOrderVos().get(0).setOrderAmount(PriceUtils.subtract((BigDecimal)mainOrderVo.getMallOrderVos().get(0).getOrderAmount(), (BigDecimal)orderSaved[0]));
            mainOrderVo.getMallOrderVos().get(0).setPayAmount(PriceUtils.subtract((BigDecimal)mainOrderVo.getMallOrderVos().get(0).getPayAmount(), (BigDecimal)orderSaved[0]));
        }
    }

    @Override
    public MallPriceVO getPrice(OrderSourceEnum orderSourceEnum, SalesTypeEnum salesTypeEnum, String saleId, String customerId, int longPeriodTimes) {
        MallPriceVO priceVO = new MallPriceVO();
        priceVO.setBuyable(true);
        Boolean isVipDay = this.vipService.isVipDayNow();
        Boolean isVip = this.vipService.isVip(customerId);
        block0 : switch (orderSourceEnum) {
            case CART: {
                switch (salesTypeEnum) {
                    case SALES_PRODUCT: {
                        MallProductEntity productEntity = this.productService.getProduct(saleId);
                        priceVO.setOriginPrice(PriceUtils.format((String)productEntity.getProPrice()));
                        if (isVip.booleanValue() && StringUtils.isNotEmpty((String)customerId)) {
                            MallVipRightsEntity right = this.vipService.checkCustomerRight(customerId, "3263699494671905110");
                            if (right == null && isVipDay.booleanValue()) {
                                right = this.vipService.checkCustomerRight(customerId, "3164601824691353085");
                            }
                            if (right != null && Integer.valueOf(right.getRightData()) > 0 && Integer.valueOf(right.getRightData()) < 100) {
                                priceVO.setVipPrice(PriceUtils.divide((BigDecimal)PriceUtils.multiply((BigDecimal)priceVO.getOriginPrice(), (Integer)Integer.valueOf(right.getRightData())), (BigDecimal)PriceUtils.format((BigDecimal)new BigDecimal(100))));
                                priceVO.setVipDiff(PriceUtils.subtract((BigDecimal)priceVO.getOriginPrice(), (BigDecimal)priceVO.getVipPrice()));
                                priceVO.setFactPrice(priceVO.getVipPrice());
                                return priceVO;
                            }
                        }
                        priceVO.setFactPrice(priceVO.getOriginPrice());
                        break block0;
                    }
                    case SALES_GROUP: {
                        MallProductGroupEntity groupEntity = this.groupService.getGroup(saleId);
                        priceVO.setOriginPrice(groupEntity.getPrice());
                        priceVO.setFactPrice(groupEntity.getSalePrice());
                        return priceVO;
                    }
                    case SALES_PROMOTION: {
                        MallPromotionEntity promotionEntity = this.promotionService.getPromotion(saleId);
                        if (promotionEntity == null) {
                            return null;
                        }
                        MallPromotionProductEntity promotionProductEntity = this.promotionProductService.getPromotionProductEntity(saleId);
                        if ("1".equals(String.valueOf(promotionProductEntity.getIsvip())) && StringUtils.isNotEmpty((String)customerId)) {
                            MallVipRightsEntity right = this.vipService.checkCustomerRightByType(customerId, promotionProductEntity.getVipRightType(), isVipDay);
                            if (right != null && "1".equals(right.getHasRight()) && "1".equals(right.getStatus())) {
                                priceVO.setOriginPrice(promotionProductEntity.getOriginPrice());
                                if (String.valueOf(VipRightTypeEnum.RIGHT_XINPINCHANGXIAN.getValue()).equals(right.getRightType())) {
                                    priceVO.setFactPrice(PriceUtils.divide((BigDecimal)PriceUtils.multiply((BigDecimal)priceVO.getOriginPrice(), (BigDecimal)PriceUtils.format((String)right.getRightData())), (BigDecimal)PriceUtils.format((BigDecimal)new BigDecimal(100))));
                                    priceVO.setVipPrice(priceVO.getFactPrice());
                                    priceVO.setVipDiff(PriceUtils.subtract((BigDecimal)priceVO.getOriginPrice(), (BigDecimal)priceVO.getVipPrice()));
                                } else if (String.valueOf(VipRightTypeEnum.RIGHT_TAOZHUANG_ZHEKOU.getValue()).equals(right.getRightType())) {
                                    priceVO.setFactPrice(PriceUtils.divide((BigDecimal)PriceUtils.multiply((BigDecimal)priceVO.getOriginPrice(), (BigDecimal)PriceUtils.format((String)right.getRightData())), (BigDecimal)PriceUtils.format((BigDecimal)new BigDecimal(100))));
                                    priceVO.setVipPrice(priceVO.getFactPrice());
                                    priceVO.setVipDiff(PriceUtils.subtract((BigDecimal)priceVO.getOriginPrice(), (BigDecimal)priceVO.getVipPrice()));
                                } else if (String.valueOf(VipRightTypeEnum.RIGHT_MIAOSHA.getValue()).equals(right.getRightType())) {
                                    priceVO.setFactPrice(promotionProductEntity.getPromotionPrice());
                                    priceVO.setVipPrice(priceVO.getFactPrice());
                                    priceVO.setVipDiff(PriceUtils.subtract((BigDecimal)priceVO.getOriginPrice(), (BigDecimal)priceVO.getVipPrice()));
                                }
                            } else {
                                priceVO.setOriginPrice(promotionProductEntity.getOriginPrice());
                                priceVO.setFactPrice(promotionProductEntity.getPromotionPrice());
                                priceVO.setPromotionPrice(promotionProductEntity.getPromotionPrice());
                                priceVO.setPromotionDiff(PriceUtils.subtract((BigDecimal)priceVO.getOriginPrice(), (BigDecimal)priceVO.getPromotionPrice()));
                                if (StringUtils.isNotEmpty((String)promotionProductEntity.getVipRightType()) && String.valueOf(VipRightTypeEnum.RIGHT_XINPINCHANGXIAN.getValue()).equals(promotionProductEntity.getVipRightType())) {
                                    priceVO.setBuyable(false);
                                } else if ((!StringUtils.isNotEmpty((String)promotionProductEntity.getVipRightType()) || !String.valueOf(VipRightTypeEnum.RIGHT_TAOZHUANG_ZHEKOU.getValue()).equals(promotionProductEntity.getVipRightType())) && StringUtils.isNotEmpty((String)promotionProductEntity.getVipRightType()) && String.valueOf(VipRightTypeEnum.RIGHT_MIAOSHA.getValue()).equals(promotionProductEntity.getVipRightType())) {
                                    priceVO.setBuyable(false);
                                }
                            }
                        } else {
                            priceVO.setOriginPrice(promotionProductEntity.getOriginPrice());
                            priceVO.setFactPrice(promotionProductEntity.getPromotionPrice());
                            priceVO.setPromotionPrice(promotionProductEntity.getPromotionPrice());
                            priceVO.setPromotionDiff(PriceUtils.subtract((BigDecimal)priceVO.getOriginPrice(), (BigDecimal)priceVO.getPromotionPrice()));
                        }
                        return priceVO;
                    }
                }
                break;
            }
            case LONGPERIOD_BUY: {
                MallProductEntity productEntity = this.productService.getProduct(saleId);
                MallRegularEntity regular = this.regularService.getRegular4GroupDCount(productEntity.getPlatformGroupId(), longPeriodTimes);
                if (regular != null) {
                    if (regular.getPriceMode() != 2) break;
                    priceVO.setOriginPrice(PriceUtils.format((String)productEntity.getProPrice()));
                    priceVO.setFactPrice(PriceUtils.multiply((BigDecimal)priceVO.getOriginPrice(), (BigDecimal)PriceUtils.format((Float)regular.getDiscount())));
                    priceVO.setOtherDiff(PriceUtils.subtract((BigDecimal)priceVO.getOriginPrice(), (BigDecimal)priceVO.getFactPrice()));
                    return priceVO;
                }
                priceVO.setOriginPrice(PriceUtils.format((String)productEntity.getProPrice()));
                priceVO.setFactPrice(priceVO.getOriginPrice());
                break;
            }
            case PLEASE_MILK: 
            case GIFTCARD_PROMOTION: 
            case LIMIT_BUY: {
                break;
            }
        }
        return null;
    }
}

