/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.trade.cache;

import cc.lechun.common.enums.pay.PayTypeEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.trade.MallRefundDetailMapper;
import cc.lechun.mall.dao.trade.MallRefundMapper;
import cc.lechun.mall.dao.trade.MallRefundPayDetailMapper;
import cc.lechun.mall.dao.trade.MallRefundRecordMapper;
import cc.lechun.mall.entity.pay.PayInputEntity;
import cc.lechun.mall.entity.trade.MallOrderEntity;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.entity.trade.MallPayTypeEntity;
import cc.lechun.mall.entity.trade.MallRefundDetailEntity;
import cc.lechun.mall.entity.trade.MallRefundEntity;
import cc.lechun.mall.entity.trade.MallRefundPayDetailEntity;
import cc.lechun.mall.entity.trade.MallRefundRecordEntity;
import cc.lechun.mall.entity.trade.OrderRefundApplyVo;
import cc.lechun.mall.iservice.trade.MallPayTypeInterface;
import cc.lechun.mall.iservice.trade.MallRefundInterface;
import com.alibaba.fastjson.JSON;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MallRefundService
extends BaseService
implements MallRefundInterface {
    @Autowired
    private MallRefundMapper refundMapper;
    @Autowired
    private MallRefundDetailMapper refundDetailMapper;
    @Autowired
    private MallRefundPayDetailMapper refundPayDetailMapper;
    @Autowired
    private MallRefundRecordMapper refundRecordMapper;
    @Autowired
    private MallPayTypeInterface payTypeInterface;

    @Override
    public MallRefundEntity selectByPrimaryKey(String billNo) {
        return (MallRefundEntity)this.refundMapper.selectByPrimaryKey((Serializable)((Object)billNo));
    }

    @Override
    public MallRefundEntity findRefund(MallOrderMainEntity orderMain, MallOrderEntity order, List<PayInputEntity> payInputEntities, int refundOrderType) {
        MallRefundEntity refundEntity = new MallRefundEntity();
        refundEntity.setOrderMainNo(orderMain.getOrderMainNo());
        List refundEntityList = this.refundMapper.getList(refundEntity);
        if (refundEntityList != null && refundEntityList.size() > 0) {
            refundEntity = (MallRefundEntity)refundEntityList.get(refundEntityList.size() - 1);
            return refundEntity;
        }
        return null;
    }

    @Override
    public MallRefundEntity createRefund(MallOrderMainEntity orderMain, MallOrderEntity order, List<PayInputEntity> payInputEntities, int refundOrderType) {
        return this.createRefund(orderMain, order, payInputEntities, refundOrderType, "EDB\u7cfb\u7edf\u9000\u6b3e");
    }

    @Override
    public MallRefundEntity createRefund(MallOrderMainEntity orderMain, MallOrderEntity order, List<PayInputEntity> payInputEntities, int refundOrderType, String reason) {
        MallRefundEntity refundEntity = new MallRefundEntity();
        refundEntity.setRefundId(IDGenerate.getUniqueIdStr());
        refundEntity.setOrderMainNo(orderMain.getOrderMainNo());
        refundEntity.setOrderNo(order.getOrderNo());
        refundEntity.setCreateSource(3);
        refundEntity.setCreateTime(DateUtils.now());
        refundEntity.setRefundType(2);
        refundEntity.setStatus(1);
        refundEntity.setReason(reason);
        refundEntity.setTotalAmount(orderMain.getTotalAmount());
        refundEntity.setReturnAmount(new BigDecimal(0));
        refundEntity.setFactReturnAmount(new BigDecimal(0));
        refundEntity.setHandingCost(new BigDecimal(0));
        refundEntity.setDebit(new BigDecimal(0));
        refundEntity.setOperaterId("3254864471995961944");
        refundEntity.setOperaterTime(DateUtils.now());
        refundEntity.setRefundClass(0);
        refundEntity.setOrderStatus(orderMain.getStatus());
        refundEntity.setRemark("");
        refundEntity.setOtherTkOrderNo("");
        refundEntity.setRefundOrderType(refundOrderType);
        refundEntity.setCustomerId(orderMain.getCustomerId());
        this.refundMapper.insert(refundEntity);
        MallRefundDetailEntity refundDetailEntity = new MallRefundDetailEntity();
        refundDetailEntity.setRefundDetailId(IDGenerate.getUniqueIdStr());
        refundDetailEntity.setRefundId(refundEntity.getRefundId());
        refundDetailEntity.setOrderMainNo(orderMain.getOrderMainNo());
        refundDetailEntity.setOrderNo(order.getOrderNo());
        refundDetailEntity.setCustomerId(orderMain.getCustomerId());
        refundDetailEntity.setCreateTime(refundEntity.getCreateTime());
        refundDetailEntity.setOperaterId("3254864471995961944");
        refundDetailEntity.setStatus(refundEntity.getStatus());
        refundDetailEntity.setReason(refundEntity.getReason());
        this.refundDetailMapper.insert(refundDetailEntity);
        for (PayInputEntity payInputEntity : payInputEntities) {
            MallRefundPayDetailEntity refundPayDetailEntity = new MallRefundPayDetailEntity();
            refundPayDetailEntity.setRefundPayId(IDGenerate.getUniqueIdStr());
            refundPayDetailEntity.setRefundId(refundEntity.getRefundId());
            refundPayDetailEntity.setOrderMainNo(orderMain.getOrderMainNo());
            refundPayDetailEntity.setOrderNo(order.getOrderNo());
            refundPayDetailEntity.setPaytypeId(payInputEntity.getPayType());
            refundPayDetailEntity.setPaytypeName(PayTypeEnum.getPayTypeName((int)payInputEntity.getPayType()));
            refundPayDetailEntity.setRefundStatus(1);
            if (payInputEntity.getPayAmount().compareTo(BigDecimal.ZERO) > 0) {
                refundPayDetailEntity.setReturnAmount(payInputEntity.getPayAmount());
            } else {
                refundPayDetailEntity.setReturnAmount(new BigDecimal(0));
            }
            refundPayDetailEntity.setReallyReturnAmount(new BigDecimal(0));
            this.refundPayDetailMapper.insert(refundPayDetailEntity);
        }
        return refundEntity;
    }

    @Override
    @Transactional
    public MallRefundEntity findOrCreateRefund(MallOrderMainEntity orderMain, MallOrderEntity order, List<PayInputEntity> payInputEntities, int refundOrderType) {
        MallRefundEntity refund = this.findRefund(orderMain, order, payInputEntities, refundOrderType);
        if (refund == null) {
            refund = this.createRefund(orderMain, order, payInputEntities, refundOrderType);
        }
        return refund;
    }

    @Override
    public void updateRefundAmount(String refundId, BigDecimal wechatAmount, BigDecimal alipayAmount, BigDecimal balanceAmount, BigDecimal couponAmount) {
        this.logger.info("++++++++++++mallRefundService.updateRefundAmount params+++++++++refundId={},wechatAmount={},alipayAmount={},balanceAmount={},couponAmount={}", new Object[]{refundId, wechatAmount, alipayAmount, balanceAmount, couponAmount});
        MallRefundEntity refund = (MallRefundEntity)this.refundMapper.selectByPrimaryKey((Serializable)((Object)refundId));
        if (refund != null) {
            refund.setReturnAmount(wechatAmount.add(alipayAmount).add(balanceAmount));
            refund.setFactReturnAmount(refund.getReturnAmount());
            refund.setRefundClass(1);
            this.refundMapper.updateByPrimaryKey(refund);
        }
        this.logger.info("++++++++++++mallRefundService.updateRefundAmount params+++++++++refund1={}", (Object)JSON.toJSONString((Object)refund));
        MallRefundPayDetailEntity entity = new MallRefundPayDetailEntity();
        if (wechatAmount.compareTo(BigDecimal.ZERO) > 0 && entity != null) {
            MallPayTypeEntity mallPayTypeEntity = this.payTypeInterface.getDefaultPayType();
            if (mallPayTypeEntity != null) {
                entity.setPaytypeId(mallPayTypeEntity.getpPaytypeId());
            }
            entity.setRefundId(refundId);
            entity = (MallRefundPayDetailEntity)this.refundPayDetailMapper.getSingle(entity);
            if (entity != null) {
                entity.setConfirmTime(DateUtils.date());
                entity.setReallyReturnAmount(wechatAmount);
                this.refundPayDetailMapper.updateByPrimaryKey(entity);
            }
        }
        if (alipayAmount.compareTo(BigDecimal.ZERO) > 0 && entity != null) {
            entity.setPaytypeId(PayTypeEnum.ALIPAY_PAY.getValue());
            entity.setRefundId(refundId);
            entity = (MallRefundPayDetailEntity)this.refundPayDetailMapper.getSingle(entity);
            if (entity != null) {
                entity.setConfirmTime(DateUtils.date());
                entity.setReallyReturnAmount(alipayAmount);
                this.refundPayDetailMapper.updateByPrimaryKey(entity);
            }
        }
        if (balanceAmount.compareTo(BigDecimal.ZERO) > 0 && entity != null) {
            entity.setPaytypeId(PayTypeEnum.BALANCE_PAY.getValue());
            entity.setRefundId(refundId);
            entity = (MallRefundPayDetailEntity)this.refundPayDetailMapper.getSingle(entity);
            if (entity != null) {
                entity.setConfirmTime(DateUtils.date());
                entity.setReallyReturnAmount(balanceAmount);
                this.refundPayDetailMapper.updateByPrimaryKey(entity);
            }
        }
        if (couponAmount.compareTo(BigDecimal.ZERO) > 0 && entity != null) {
            entity.setPaytypeId(PayTypeEnum.COUPON_PAY.getValue());
            entity.setRefundId(refundId);
            entity = (MallRefundPayDetailEntity)this.refundPayDetailMapper.getSingle(entity);
            if (entity != null) {
                entity.setConfirmTime(DateUtils.date());
                entity.setReallyReturnAmount(couponAmount);
                this.refundPayDetailMapper.updateByPrimaryKey(entity);
            }
        }
        MallRefundRecordEntity refundRecord = new MallRefundRecordEntity();
    }

    @Override
    public void updateRefund(MallRefundEntity refund) {
        this.refundMapper.updateByPrimaryKey(refund);
    }

    @Override
    public void PassOrderRefund(String refundId, BigDecimal factRefundAmount, String checker) {
        MallRefundEntity refund = new MallRefundEntity();
        refund.setRefundId(refundId);
        refund.setStatus(2);
        refund.setChecker(checker);
        refund.setCheckTime(new Date());
        if (factRefundAmount != null) {
            refund.setFactReturnAmount(factRefundAmount);
        }
        this.refundMapper.updateByPrimaryKeySelective(refund);
    }

    @Override
    public void FailOrderRefund(String refundId, String reason) {
        MallRefundEntity refund = new MallRefundEntity();
        refund.setRefundId(refundId);
        refund.setStatus(4);
        refund.setRemark(reason);
        this.refundMapper.updateByPrimaryKeySelective(refund);
    }

    @Override
    public void CancelOrderRefund(String refundId, String reason) {
        MallRefundEntity refund = new MallRefundEntity();
        refund.setRefundId(refundId);
        refund.setStatus(5);
        refund.setRemark(reason);
        this.refundMapper.updateByPrimaryKeySelective(refund);
    }

    @Override
    public void SuccessOrderRefund(String refundId) {
        MallRefundEntity refund = new MallRefundEntity();
        refund.setRefundId(refundId);
        refund.setStatus(3);
        this.refundMapper.updateByPrimaryKeySelective(refund);
    }

    @Override
    public List<MallRefundEntity> queryRefundInfoByStatusCheckTime(int status, Date refundDate) {
        return this.refundMapper.queryRefundInfoByStatusCheckTime(status, refundDate);
    }

    @Override
    public List<MallRefundEntity> getRefundListByOrderMainNo(String orderMainNo) {
        MallRefundEntity refundEntity = new MallRefundEntity();
        refundEntity.setOrderMainNo(orderMainNo);
        return this.refundMapper.getList(refundEntity);
    }

    @Override
    public List<MallRefundEntity> getRefundListByOrderNo(String orderNo) {
        MallRefundEntity refundEntity = new MallRefundEntity();
        refundEntity.setOrderNo(orderNo);
        return this.refundMapper.getList(refundEntity);
    }

    @Override
    public MallRefundEntity createRefund(OrderRefundApplyVo refundApplyVo) throws Exception {
        MallRefundEntity refundEntity = new MallRefundEntity();
        refundEntity.setRefundId(IDGenerate.getUniqueIdStr());
        refundEntity.setOrderMainNo(refundApplyVo.getOrderMainNo());
        refundEntity.setOrderNo(refundApplyVo.getOrderNo());
        refundEntity.setCreateSource(refundApplyVo.getSourceEnum().getValue());
        refundEntity.setCreateTime(DateUtils.now());
        refundEntity.setRefundType(2);
        refundEntity.setStatus(1);
        refundEntity.setReason(refundApplyVo.getReason());
        refundEntity.setTotalAmount(refundApplyVo.getOrderTotalAmount());
        refundEntity.setReturnAmount(refundApplyVo.getReturnAmount());
        refundEntity.setFactReturnAmount(refundApplyVo.getReturnAmount());
        refundEntity.setHandingCost(new BigDecimal(0));
        refundEntity.setDebit(new BigDecimal(0));
        refundEntity.setOperaterId(refundApplyVo.getOperator());
        refundEntity.setOperaterTime(DateUtils.now());
        refundEntity.setRefundClass(this.getRefundClass(refundApplyVo.getOrderStatus()));
        refundEntity.setOrderStatus(refundApplyVo.getOrderStatus());
        refundEntity.setRemark("");
        refundEntity.setOtherTkOrderNo("");
        refundEntity.setRefundOrderType(refundApplyVo.getRefundOrderType());
        refundEntity.setCustomerId(refundApplyVo.getCustomerId());
        if (this.refundMapper.insert(refundEntity) <= 0) {
            throw new Exception("\u65e0\u6cd5\u521b\u5efa\u9000\u6b3e\u5355");
        }
        return refundEntity;
    }

    private int getRefundClass(int orderStatus) {
        if (orderStatus >= 2 && orderStatus <= 3) {
            return 1;
        }
        if (orderStatus > 3 && orderStatus < 9) {
            return 2;
        }
        if (orderStatus >= 9 && orderStatus <= 10) {
            return 3;
        }
        if (orderStatus >= 15) {
            return 4;
        }
        return 0;
    }
}

