/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.trade.orderHandle;

import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.customer.CustomerAddressVo;
import cc.lechun.mall.entity.trade.MallMainOrderVo;
import cc.lechun.mall.iservice.customer.CustomerAddressInterface;
import cc.lechun.mall.iservice.trade.MallTradeCommonInterface;
import cc.lechun.mall.service.trade.orderHandle.OrderHandleInterface;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="20_address")
public class AddressHandle
implements OrderHandleInterface {
    @Autowired
    private CustomerAddressInterface addressInterface;
    @Autowired
    private MallTradeCommonInterface tradeCommonInterface;

    @Override
    public BaseJsonVo orderHandle(MallMainOrderVo mallMainOrderVo) throws Exception {
        if (this.tradeCommonInterface.isNoDeliverOrder(mallMainOrderVo)) {
            return BaseJsonVo.success((Object)"");
        }
        int[] transportType = new int[]{-1, -1};
        mallMainOrderVo.getMallOrderVos().forEach(c -> {
            if (c.getTransportType() == 1) {
                transportType[0] = 1;
            }
            if (c.getTransportType() == 2) {
                transportType[1] = 2;
            }
        });
        CustomerAddressVo addressVo = null;
        addressVo = StringUtils.isNotEmpty((String)mallMainOrderVo.getOrderCacheVo().getAddressId()) ? this.addressInterface.getCustomerAddressVO(mallMainOrderVo.getOrderCacheVo().getAddressId(), transportType) : this.addressInterface.getCustomerDefaultAddress(mallMainOrderVo.getCustomerId(), "", "", "", transportType);
        if (addressVo != null && StringUtils.isNotEmpty((String)addressVo.getAddrId())) {
            mallMainOrderVo.setAddressVo(addressVo);
            mallMainOrderVo.getOrderCacheVo().setAddressId(addressVo.getAddrId());
        } else if (mallMainOrderVo.getOrderCacheVo().getCacheType() == 2) {
            BaseJsonVo.error((String)"\u6ca1\u6709\u586b\u5199\u6536\u8d27\u5730\u5740");
        }
        return BaseJsonVo.success((Object)"");
    }
}

