/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.version;

import cc.lechun.active.iservice.active.ActiveInterface;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.version.VersionDetailMapper;
import cc.lechun.mall.entity.version.VersionDetailEntity;
import cc.lechun.mall.iservice.version.VersionDetailInterface;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VersionDetailServcie
extends BaseService
implements VersionDetailInterface {
    @Autowired
    private ActiveInterface activeService;
    @Autowired
    private VersionDetailMapper versionDetailMapper;

    @Override
    @ReadThroughSingleCache(namespace="VersionDetailServcie.getCookieVersionDetailId", expiration=300)
    public VersionDetailEntity getCookieVersionDetailId(@ParameterValueKeyProvider(order=0) String bindCode, @ParameterValueKeyProvider(order=1) String customerId) {
        try {
            List<VersionDetailEntity> list;
            String activeNo = this.activeService.getActiveNoByBindCode(bindCode);
            if (StringUtils.isNotEmpty((String)activeNo) && (list = this.versionDetailMapper.getCookieVersionList(activeNo)) != null && list.size() >= 1) {
                Integer nums = ((VersionDetailEntity)list.stream().reduce((sum, item) -> {
                    sum.setRate(sum.getRate() + item.getRate());
                    return sum;
                }).get()).getRate();
                if (nums == 0 || nums == 1) {
                    return list.get(0);
                }
                int num = Math.abs((customerId + activeNo).hashCode()) % nums;
                int rateStart = 0;
                int rateEnd = 0;
                for (VersionDetailEntity r : list) {
                    if (num >= rateStart && num < (rateEnd += r.getRate() == null ? 0 : r.getRate())) {
                        return r;
                    }
                    rateStart += r.getRate() == null ? 0 : r.getRate();
                }
                return list.get(0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    @ReadThroughSingleCache(namespace="VersionDetailServcie.getVersionDetailByDetailsId", expiration=300)
    public VersionDetailEntity getVersionDetailByDetailsId(@ParameterValueKeyProvider String versionDetailId) {
        return (VersionDetailEntity)this.versionDetailMapper.selectByPrimaryKey((Serializable)((Object)versionDetailId));
    }
}

