/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.weixin;

import cc.lechun.common.cache.RedisService;
import cc.lechun.framework.common.enums.jms.MessageQueueTagEnum;
import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.object.ObjectConvert;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.common.vo.jms.MessageParam;
import cc.lechun.framework.common.vo.jms.MessageResult;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.framework.core.jms.MessageQueueService;
import cc.lechun.mall.dao.weixin.MallMessageConfigMapper;
import cc.lechun.mall.entity.weixin.MallMessageConfigEntity;
import cc.lechun.mall.entity.weixin.MallMessageConfigVo;
import cc.lechun.mall.entity.weixin.TemplateMessageEntity;
import cc.lechun.mall.entity.weixin.WeiXinKeywordEntity;
import cc.lechun.mall.iservice.weixin.MallMessageConfigInterface;
import cc.lechun.mall.iservice.weixin.MessageInterface;
import cc.lechun.mall.iservice.weixin.TemplateMessageInterface;
import cc.lechun.mall.iservice.weixin.WeiXinKeywordInterface;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class MallMessageConfigService
extends BaseService
implements MallMessageConfigInterface {
    @Autowired
    private MallMessageConfigMapper messageConfigMapper;
    @Autowired
    private WeiXinKeywordInterface keywordInterface;
    @Autowired
    private TemplateMessageInterface templateMessageInterface;
    @Autowired
    private MemcachedService memcachedService;
    @Autowired
    private MessageQueueService messageQueueService;
    @Autowired
    private RedisService redisService;
    @Autowired
    @Lazy
    private MessageInterface messageService;

    @Override
    @ReadThroughSingleCache(namespace="MallMessageConfigService.getMessageConfigEntity", expiration=600)
    public MallMessageConfigEntity getMessageConfigEntity(@ParameterValueKeyProvider(order=0) Integer platformId, @ParameterValueKeyProvider(order=1) String action) {
        MallMessageConfigEntity messageConfigEntity = new MallMessageConfigEntity();
        messageConfigEntity.setActionId(action);
        messageConfigEntity.setPlatformId(platformId);
        messageConfigEntity = (MallMessageConfigEntity)this.messageConfigMapper.getSingle(messageConfigEntity);
        return messageConfigEntity;
    }

    @Override
    @ReadThroughSingleCache(namespace="MallMessageConfigService.getMessageConfigEntity", expiration=600)
    public MallMessageConfigEntity getMessageConfigEntity(@ParameterValueKeyProvider(order=0) String activeNo, @ParameterValueKeyProvider(order=1) Integer actionType) {
        MallMessageConfigEntity messageConfigEntity = new MallMessageConfigEntity();
        messageConfigEntity.setActionType(actionType);
        messageConfigEntity.setActiveNo(activeNo);
        messageConfigEntity = (MallMessageConfigEntity)this.messageConfigMapper.getSingle(messageConfigEntity);
        return messageConfigEntity;
    }

    @Override
    public BaseJsonVo save(MallMessageConfigEntity messageConfigEntity) {
        boolean b = false;
        MallMessageConfigEntity messageConfigEntitySearch = new MallMessageConfigEntity();
        messageConfigEntitySearch.setActionId(messageConfigEntity.getActionId());
        messageConfigEntitySearch.setPlatformId(messageConfigEntity.getPlatformId());
        messageConfigEntitySearch = (MallMessageConfigEntity)this.messageConfigMapper.getSingle(messageConfigEntitySearch);
        if (messageConfigEntity.getMessageConfigId() == null || messageConfigEntity.getMessageConfigId() == 0) {
            if (messageConfigEntitySearch != null) {
                return BaseJsonVo.error((String)("\u52a8\u4f5cId\u5df2\u5b58\u5728" + messageConfigEntity.getActionId()));
            }
            messageConfigEntity.setCreateTime(DateUtils.now());
            b = this.messageConfigMapper.insertSelective(messageConfigEntity) > 0;
        } else {
            if (messageConfigEntitySearch != null && messageConfigEntitySearch.getMessageConfigId().intValue() != messageConfigEntitySearch.getMessageConfigId().intValue()) {
                return BaseJsonVo.error((String)("\u52a8\u4f5cId\u5df2\u5b58\u5728" + messageConfigEntity.getActionId()));
            }
            b = this.messageConfigMapper.updateByPrimaryKeySelective(messageConfigEntity) > 0;
        }
        this.removeCache(messageConfigEntity.getMessageConfigId(), messageConfigEntity.getPlatformId(), messageConfigEntity.getActionId(), messageConfigEntity.getActiveNo(), messageConfigEntity.getActionType());
        if (b) {
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
    }

    @Override
    @ReadThroughSingleCache(namespace="MallMessageConfigService.select", expiration=600)
    public MallMessageConfigEntity select(@ParameterValueKeyProvider int messageConfigId) {
        return (MallMessageConfigEntity)this.messageConfigMapper.selectByPrimaryKey(Integer.valueOf(messageConfigId));
    }

    @Override
    public List<MallMessageConfigVo> getMessageConfigList(MallMessageConfigEntity messageConfigEntity) {
        List configEntities;
        ArrayList<MallMessageConfigVo> configVos = new ArrayList<MallMessageConfigVo>();
        if (messageConfigEntity != null && (configEntities = this.messageConfigMapper.getList(messageConfigEntity)) != null) {
            for (MallMessageConfigEntity configEntity : configEntities) {
                String messageName = "";
                if (configEntity != null) {
                    TemplateMessageEntity templateMessageEntity;
                    WeiXinKeywordEntity keywordEntity;
                    if (configEntity.getMessageType() == 1 && (keywordEntity = this.keywordInterface.getWeiXinKeywordById(configEntity.getMessageId())) != null) {
                        messageName = keywordEntity.getKeyword();
                    }
                    if (configEntity.getMessageType() == 2 && (templateMessageEntity = this.templateMessageInterface.getTemplateMessageById(configEntity.getMessageId())) != null) {
                        messageName = templateMessageEntity.getMessageName();
                    }
                }
                MallMessageConfigVo configVo = new MallMessageConfigVo();
                try {
                    ObjectConvert.fatherConvertToChild((Object)configEntity, (Object)configVo);
                    configVo.setMessageName(messageName);
                    configVos.add(configVo);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return configVos;
    }

    @Override
    public boolean delete(Integer messageConfigId) {
        MallMessageConfigEntity configEntity = this.select(messageConfigId);
        this.removeCache(configEntity.getMessageConfigId(), configEntity.getPlatformId(), configEntity.getActionId(), configEntity.getActiveNo(), configEntity.getActionType());
        return this.messageConfigMapper.deleteByPrimaryKey(messageConfigId) > 0;
    }

    @Override
    public BaseJsonVo getMessageConfig(Integer messageConfigId, Map<String, String> variable) {
        BaseJsonVo baseJsonVo;
        MallMessageConfigEntity configEntity = this.select(messageConfigId);
        HashMap<Integer, Object> map = new HashMap<Integer, Object>();
        if (configEntity.getMessageType() == 1) {
            baseJsonVo = this.keywordInterface.getKeywordContent(configEntity.getMessageId(), variable);
            if (!baseJsonVo.isSuccess()) {
                return baseJsonVo;
            }
            map.put(configEntity.getMessageType(), baseJsonVo.getValue());
        }
        if (configEntity.getMessageType() == 2) {
            baseJsonVo = this.templateMessageInterface.getTemplateMessageContent(configEntity.getMessageId(), variable);
            if (!baseJsonVo.isSuccess()) {
                return baseJsonVo;
            }
            map.put(configEntity.getMessageType(), baseJsonVo.getValue());
        }
        return BaseJsonVo.success(map);
    }

    @Override
    public Boolean pushNoticeMQ(List<String> customerTypeList, String action, Date sendTime, Integer platformId) {
        customerTypeList.forEach(t -> this.pushNoticeMQ((String)t, action, sendTime, (Integer)0, platformId));
        return true;
    }

    @Override
    public BaseJsonVo pushCustomerNum(String customerType, String action) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("total", this.redisService.increment("TEMPLETE_ACTIVE_SEND_OPENID_TOTAL_NUM" + customerType + action, 0L));
        map.put("succ", this.redisService.increment("TEMPLETE_ACTIVE_SEND_OPENID_SUCC_NUM" + customerType + action, 0L));
        map.put("receivNum", this.redisService.increment("RedisConstantstempleteActiveSendOpenIdSendNum:" + customerType + ":" + action, 0L));
        return BaseJsonVo.success(map);
    }

    @Override
    @Async
    public void pushNoticeMQ(String customerType, String action, Date sendTime, Integer status, Integer platformId) {
        this.logger.info("\u63a5\u6536\u53c2\u6570:customerType={},action={},sendTime={}", new Object[]{customerType, action, sendTime});
        int pageNum = 0;
        int pageSize = 1000;
        int nameSize = 0;
        try {
            List<Map<String, Object>> nameList = this.getCustomerList(customerType, pageNum, pageSize, platformId);
            this.logger.info("\u63a8\u9001\u6d88\u606f\u961f\u5217\u540d\u5355\u662f\u5426\u4e3a\u7a7a\uff1a" + (nameList == null));
            if (nameList == null) {
                return;
            }
            nameSize = nameList.size();
            this.logger.info("\u5c06\u8981\u63a8\u9001\u7528\u6237\u8bb0\u5f55\u6570:{}", (Object)nameSize);
            ArrayList<Map<String, Object>> tempNameList = new ArrayList<Map<String, Object>>();
            for (int i = 0; i < nameSize; ++i) {
                tempNameList.add(nameList.get(i));
                if (i <= 0 || i % pageSize != 0) continue;
                this.pushNoticeMQ(customerType, action, tempNameList, pageNum, platformId);
                ++pageNum;
                tempNameList = new ArrayList();
            }
            if (tempNameList.size() >= 1) {
                this.pushNoticeMQ(customerType, action, tempNameList, pageNum, platformId);
                ++pageNum;
            }
            this.logger.info("\u6d88\u606f\u961f\u5217\u63a8\u9001\u6b21\u6570:{}", (Object)pageNum);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void clearMessageCache(String customerType, String action) {
        boolean temp = this.redisService.delete("TEMPLETE_ACTIVE_SEND_OPENID_LIST2" + customerType + action);
        this.logger.info("\u63a8\u9001\u6210\u529f\u8bb0\u5f55\u7f13\u5b58\u6e05\u9664:customerType={},{},action=", new Object[]{temp, customerType, action});
        this.redisService.delete("TEMPLETE_ACTIVE_SEND_OPENID_TOTAL_NUM" + customerType + action);
        this.redisService.delete("TEMPLETE_ACTIVE_SEND_OPENID_SUCC_NUM" + customerType + action);
        this.redisService.delete("RedisConstantstempleteActiveSendOpenIdSendNum:" + customerType + ":" + action);
        this.logger.info("\u63a8\u9001\u6210\u529f\u4eba\u5a04\u8bb0\u5f55\u7f13\u5b58\u6e05\u9664:customerType={}{},action=", new Object[]{temp, customerType, action});
    }

    private void pushNoticeMQ(String customerType, String action, List<Map<String, Object>> tempNameList, int pageNum, Integer platformId) {
        HashMap<String, Object> messageMap = new HashMap<String, Object>();
        messageMap.put("customerType", customerType);
        messageMap.put("action", action);
        messageMap.put("list", tempNameList);
        messageMap.put("platformId", platformId);
        MessageResult mr = this.messageQueueService.sendBaseMessage(MessageQueueTagEnum.templeteMessageSend, new MessageParam(String.valueOf(pageNum), messageMap));
        this.logger.info("\u63a8\u9001\u6d88\u606f\u961f\u5217\u7ed3\u679c\uff1a" + mr.isStatus() + "  " + mr.getMsg().toString());
    }

    @Override
    public List<Map<String, Object>> getCustomerList(String customerType, int pageNum, int pageSize, Integer platformId) {
        if ("all".equals(customerType)) {
            return this.messageConfigMapper.getCustomerList(platformId);
        }
        if ("test".equals(customerType)) {
            return this.messageConfigMapper.getCustomerList4Test(platformId);
        }
        if ("fresh".equals(customerType)) {
            return this.messageConfigMapper.getCustomerList4FreshCity(platformId);
        }
        return this.messageConfigMapper.getCustomerList4customer(customerType);
    }

    @Override
    public Boolean sendNotice(Map<String, Object> param) {
        List paramList = (List)param.get("list");
        String customerType = param.get("customerType").toString();
        String action = param.get("action").toString();
        Integer platformId = (Integer)param.get("platformId");
        this.logger.info("\u63a5\u6536\u6d88\u606f\u6b21\u6570:" + this.redisService.increment("RedisConstantstempleteActiveSendOpenIdSendNum:" + customerType + ":" + action, 1L));
        for (Map customer : paramList) {
            boolean setResult = this.redisService.sadd("TEMPLETE_ACTIVE_SEND_OPENID_LIST2" + customerType + action, customer.get("OPEN_ID"));
            if (!setResult) {
                this.logger.info("\u5f53\u524d\u7528\u6237\u5df2\u53d1\u9001,openId={}", customer.get("OPEN_ID"));
                continue;
            }
            Long ll = this.redisService.increment("TEMPLETE_ACTIVE_SEND_OPENID_TOTAL_NUM" + customerType + action, 1L);
            this.logger.info("\u6a21\u677f\u6d88\u606f\u53d1\u9001\u4eba\u6570\uff1a{}", (Object)ll);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("nickName", String.valueOf(customer.get("NICK_NAME")));
            BaseJsonVo jsonVo = this.messageService.sendWechatMessage((int)platformId, action, String.valueOf(customer.get("OPEN_ID")), map);
            this.logger.info(JsonUtils.toJson((Object)jsonVo, (boolean)false));
        }
        return true;
    }

    @Override
    public Integer getPushCustomizedNoticeMQNum(String action, Integer platformId, String connector, Integer lastCreateTimeBegin, Integer lastCreateTimeEnd, Integer totalOrderNumBegin, Integer totalOrderNumEnd, Integer perOrderCostBegin, Integer perOrderCostEnd) {
        List<Map<String, Object>> customers = this.getCustomizedList(platformId, connector, lastCreateTimeBegin, lastCreateTimeEnd, totalOrderNumBegin, totalOrderNumEnd, perOrderCostBegin, perOrderCostEnd);
        return customers.size();
    }

    @Override
    public void pushCustomizedNoticeMQ(String action, Integer platformId, String connector, Integer lastCreateTimeBegin, Integer lastCreateTimeEnd, Integer totalOrderNumBegin, Integer totalOrderNumEnd, Integer perOrderCostBegin, Integer perOrderCostEnd) {
        List<Map<String, Object>> customers = this.getCustomizedList(platformId, connector, lastCreateTimeBegin, lastCreateTimeEnd, totalOrderNumBegin, totalOrderNumEnd, perOrderCostBegin, perOrderCostEnd);
        int pageNum = 0;
        int pageSize = 1000;
        String customerType = IDGenerate.getUniqueIdStr();
        try {
            if (customers == null) {
                return;
            }
            this.logger.info("\u5c06\u8981\u63a8\u9001\u7528\u6237\u8bb0\u5f55\u6570:{}", (Object)customers.size());
            ArrayList<Map<String, Object>> tempNameList = new ArrayList<Map<String, Object>>();
            for (int i = 0; i < customers.size(); ++i) {
                tempNameList.add(customers.get(i));
                if (i <= 0 || i % pageSize != 0) continue;
                this.pushNoticeMQ(customerType, action, tempNameList, pageNum, platformId);
                ++pageNum;
                tempNameList = new ArrayList();
            }
            if (tempNameList.size() >= 1) {
                this.pushNoticeMQ(customerType, action, tempNameList, pageNum, platformId);
                ++pageNum;
            }
            this.logger.info("\u6d88\u606f\u961f\u5217\u63a8\u9001\u6b21\u6570:{}", (Object)pageNum);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private List<Map<String, Object>> getCustomizedList(Integer platformId, String connector, Integer lastCreateTimeBegin, Integer lastCreateTimeEnd, Integer totalOrderNumBegin, Integer totalOrderNumEnd, Integer perOrderCostBegin, Integer perOrderCostEnd) {
        this.logger.info("platformid : " + platformId);
        this.logger.info("connector : " + connector);
        this.logger.info("lastCreateTimeBegin : " + lastCreateTimeBegin);
        this.logger.info("lastCreateTimeEnd : " + lastCreateTimeEnd);
        this.logger.info("totalOrderNumBegin : " + totalOrderNumBegin);
        this.logger.info("totalOrderNumEnd : " + totalOrderNumEnd);
        this.logger.info("perOrderCostBegin : " + perOrderCostBegin);
        this.logger.info("perOrderCostEnd : " + perOrderCostEnd);
        String lastCreateTimeBeginStr = DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)DateUtils.now(), (int)(0 - lastCreateTimeBegin)), (String)"yyyy-MM-dd");
        String lastCreateTimeEndStr = DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)DateUtils.now(), (int)(1 - lastCreateTimeEnd)), (String)"yyyy-MM-dd");
        if ("1".equals(connector)) {
            return this.messageConfigMapper.getCustomizedListAND(platformId, lastCreateTimeBeginStr, lastCreateTimeEndStr, totalOrderNumBegin, totalOrderNumEnd, perOrderCostBegin, perOrderCostEnd);
        }
        return this.messageConfigMapper.getCustomizedListOR(platformId, lastCreateTimeBeginStr, lastCreateTimeEndStr, totalOrderNumBegin, totalOrderNumEnd, perOrderCostBegin, perOrderCostEnd);
    }

    private void removeCache(Integer messageConfigId, Integer platformId, String actionId, String activeNo, Integer actionType) {
        this.memcachedService.delete("MallMessageConfigService.getMessageConfigEntity", new String[]{String.valueOf(platformId), actionId});
        this.memcachedService.delete("MallMessageConfigService.getMessageConfigEntity", new String[]{activeNo, String.valueOf(actionType)});
        this.memcachedService.delete("MallMessageConfigService.select", String.valueOf(messageConfigId));
        this.memcachedService.delete("MallMessageConfigService.getMessageConfig", String.valueOf(messageConfigId));
    }
}

