/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.weixin.reply;

import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.entity.customer.CustomerEntity;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.service.weixin.WeiXinMessage;
import cc.lechun.mall.service.weixin.reply.ReplyMessageHandle;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import weixin.popular.bean.message.EventMessage;
import weixin.popular.bean.xmlmessage.XMLMessage;

@Component(value="locationMessage")
public class LocationHandle
extends WeiXinMessage
implements ReplyMessageHandle {
    @Autowired
    private CustomerInterface customerService;

    @Override
    public XMLMessage receiveMessage(EventMessage eventMessage, int platformId) {
        String openId = eventMessage.getFromUserName();
        CustomerDetailVo customerDetailVo = this.customerService.getCustomerDetailByOpenid(eventMessage.getFromUserName(), platformId);
        if (customerDetailVo == null) {
            this.logger.error("\u7528\u6237\u4e0d\u5b58\u5728,oppenId={}", (Object)eventMessage.getFromUserName());
            return null;
        }
        String customerId = customerDetailVo.getCustomerId();
        CustomerEntity customerEntity = this.customerService.getCustomer(customerId);
        if (!openId.isEmpty()) {
            customerEntity.setPositionX(eventMessage.getLatitude());
            customerEntity.setPositionY(eventMessage.getLongitude());
            customerEntity.setScale(eventMessage.getScale());
            this.customerService.updateCustomerEntitySelective(customerEntity);
        }
        return null;
    }
}

