/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.weixin.reply;

import cc.lechun.active.iservice.active.CustomerQrcodeInterface;
import cc.lechun.active.service.tempqrcode.TempQrcodeContext;
import cc.lechun.framework.common.enums.jms.MessageQueueTagEnum;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.jms.MessageParam;
import cc.lechun.framework.core.jms.MessageQueueService;
import cc.lechun.mall.entity.customer.CustomerEntity;
import cc.lechun.mall.entity.customer.SubscribeVo;
import cc.lechun.mall.entity.weixin.WeiXinKeywordEntity;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.weixin.WeiXinKeywordInterface;
import cc.lechun.mall.service.weixin.WeiXinMessage;
import cc.lechun.mall.service.weixin.reply.ReplyMessageHandle;
import cc.lechun.mall.service.weixin.reply.ScanInfoMessage;
import java.io.IOException;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import weixin.popular.bean.message.EventMessage;
import weixin.popular.bean.xmlmessage.XMLMessage;

@Component(value="subscribeMessage")
public class SubscribeMessageHandle
extends WeiXinMessage
implements ReplyMessageHandle {
    @Autowired
    private CustomerInterface customerInterface;
    @Autowired
    private MessageQueueService messageQueueService;
    @Autowired
    private WeiXinKeywordInterface weiXinKeywordService;
    @Autowired
    private CustomerQrcodeInterface customerQrcodeService;
    @Autowired
    private TempQrcodeContext tempQrcodeContext;
    @Autowired
    private ScanInfoMessage scanMessage;

    @Override
    public XMLMessage receiveMessage(EventMessage eventMessage, int platformId) {
        String bindCode = StringUtils.isEmpty((String)eventMessage.getEventKey()) ? "" : eventMessage.getEventKey().replace("qrscene_", "");
        try {
            SubscribeVo vo = new SubscribeVo();
            vo.setPlatformId(platformId);
            vo.setOpenId(eventMessage.getFromUserName());
            vo.setBindCode(bindCode);
            vo.setVersionDetailId("");
            CustomerEntity customerEntity = (CustomerEntity)this.customerInterface.subscribe(vo).getValue();
            if (customerEntity == null) {
                return null;
            }
            HashMap<String, String> messageBody = new HashMap<String, String>();
            messageBody.put("userId", customerEntity.getCustomerId());
            messageBody.put("dtFrom", StringUtils.isEmpty((String)bindCode) ? "\u76f4\u63a5\u5173\u6ce8" : bindCode);
            this.messageQueueService.sendBaseMessage(MessageQueueTagEnum.attentionNumber, MessageParam.messageParam((String)customerEntity.getCustomerId(), messageBody));
            if (StringUtils.isEmpty((String)bindCode)) {
                WeiXinKeywordEntity weiXinKeywordEntity = this.weiXinKeywordService.getWeiXinKeywordById(2055);
                return this.pushMessage(eventMessage, weiXinKeywordEntity, platformId);
            }
            eventMessage.setMoney(Integer.valueOf(1));
            eventMessage.setEventKey("scan");
            return this.scanMessage.receiveMessage(eventMessage, platformId);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

