/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.pro.service.impl;

import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.pro.dao.MaterialProdMapper;
import cc.lechun.pro.entity.MaterialProdEntity;
import cc.lechun.pro.service.MaterialProdService;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RefreshScope
@Service
public class MaterialProdServiceImpl
implements MaterialProdService {
    @Autowired
    private MaterialProdMapper materialProdMapper;
    @Autowired
    private PlatformTransactionManager transactionManager;

    @RequestMapping(value={"/mpsi/saveOrUpdateList"})
    public BaseJsonVo<List<MaterialProdEntity>> saveOrUpdateMaterialProd(@RequestBody List<MaterialProdEntity> materialProds) {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        TransactionStatus status = this.transactionManager.getTransaction((TransactionDefinition)def);
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        try {
            ArrayList<MaterialProdEntity> listAdd = new ArrayList<MaterialProdEntity>();
            ArrayList<MaterialProdEntity> listUpdate = new ArrayList<MaterialProdEntity>();
            if (null != materialProds && materialProds.size() > 0) {
                for (MaterialProdEntity materialProd : materialProds) {
                    if (StringUtils.isNotBlank((String)materialProd.getBmpid())) {
                        listUpdate.add(materialProd);
                        continue;
                    }
                    materialProd.setMatid(materialProd.getCguid());
                    materialProd.setBmpid(IDGenerate.getUniqueIdStr());
                    listAdd.add(materialProd);
                }
            }
            if (listAdd.size() > 0) {
                this.materialProdMapper.addRecordsBatch(listAdd);
            }
            if (listUpdate.size() > 0) {
                for (MaterialProdEntity materialProd : listUpdate) {
                    this.materialProdMapper.updateByParam(materialProd);
                }
            }
            this.transactionManager.commit(status);
        }
        catch (Exception e) {
            System.out.println(e);
            baseJsonVo.setStatus(500);
            baseJsonVo.setError_msg(e.getMessage());
            this.transactionManager.rollback(status);
        }
        return baseJsonVo;
    }

    @RequestMapping(value={"/mpsi/findPage"})
    public BaseJsonVo<List<MaterialProdEntity>> findPage(@RequestHeader(value="pageNo") Integer pageNo, @RequestHeader(value="pageSize") Integer pageSize, @RequestBody Map<String, Object> map) {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        if (pageNo == null) {
            pageNo = 0;
        }
        if (pageSize == null) {
            pageSize = 0;
        }
        try {
            if (pageNo > 0 && pageSize > 0) {
                PageHelper.startPage((int)pageNo, (int)pageSize);
            }
            baseJsonVo.setValue((Object)this.materialProdMapper.loadList(map));
        }
        catch (Exception e) {
            baseJsonVo.setStatus(500);
            baseJsonVo.setError_msg(e.getMessage());
        }
        return baseJsonVo;
    }
}

