/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.pro.service.impl;

import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.pro.dao.ProAllocationSumMapper;
import cc.lechun.pro.dao.ProPredictSumMapper;
import cc.lechun.pro.dao.ProTransportCalendarMapper;
import cc.lechun.pro.dao.ProductAllocationMapper;
import cc.lechun.pro.entity.ProAllocationSumEntity;
import cc.lechun.pro.entity.ProPredictSumEntity;
import cc.lechun.pro.entity.ProTransportCalendarEntity;
import cc.lechun.pro.entity.ProductAllocationEntity;
import cc.lechun.pro.service.ProAllocationSumService;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RefreshScope
@Service
public class ProAllocationSumServiceImpl
implements ProAllocationSumService {
    @Autowired
    private ProAllocationSumMapper proAllocationSumMapper;
    @Autowired
    private ProTransportCalendarMapper proTransportCalendarMapper;
    @Autowired
    private ProductAllocationMapper productAllocationMapper;
    @Autowired
    private ProPredictSumMapper proPredictSumMapper;
    @Autowired
    private PlatformTransactionManager transactionManager;

    @RequestMapping(value={"/passi/saveOrUpdateList"})
    public BaseJsonVo saveOrUpdateList(@RequestBody List<ProAllocationSumEntity> proAllocationSumEntitys, List<String> deleteids) {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        TransactionStatus status = this.transactionManager.getTransaction((TransactionDefinition)def);
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        try {
            ArrayList<ProAllocationSumEntity> listAdd = new ArrayList<ProAllocationSumEntity>();
            ArrayList<ProAllocationSumEntity> listUpdate = new ArrayList<ProAllocationSumEntity>();
            if (null != proAllocationSumEntitys && proAllocationSumEntitys.size() > 0) {
                for (ProAllocationSumEntity proAllocationSum : proAllocationSumEntitys) {
                    if (StringUtils.isNotBlank((String)proAllocationSum.getId())) {
                        listUpdate.add(proAllocationSum);
                        continue;
                    }
                    proAllocationSum.setId(IDGenerate.getUniqueIdStr());
                    listAdd.add(proAllocationSum);
                }
            }
            if (listAdd.size() > 0) {
                this.proAllocationSumMapper.addRecordsBatch(listAdd);
            }
            if (listUpdate.size() > 0) {
                this.proAllocationSumMapper.updateBatch(listUpdate);
            }
            if (deleteids != null && deleteids.size() > 0) {
                this.proAllocationSumMapper.deleteByIds(deleteids);
            }
            this.transactionManager.commit(status);
        }
        catch (Exception e) {
            baseJsonVo.setStatus(500);
            baseJsonVo.setMessage(e.getMessage());
            this.transactionManager.rollback(status);
        }
        return baseJsonVo;
    }

    @RequestMapping(value={"/passi/findList"})
    public BaseJsonVo<List<ProAllocationSumEntity>> findList(@RequestHeader(value="pageNo") Integer pageNo, @RequestHeader(value="pageSize") Integer pageSize, @RequestBody Map<String, Object> param) {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        try {
            if (pageNo == null) {
                pageNo = 0;
            }
            if (pageSize == null) {
                pageSize = 0;
            }
            if (pageNo > 0 && pageSize > 0) {
                PageHelper.startPage((int)pageNo, (int)pageSize);
            }
            baseJsonVo.setValue((Object)this.proAllocationSumMapper.loadList(param));
        }
        catch (Exception e) {
            baseJsonVo.setStatus(500);
            baseJsonVo.setError_msg(e.getMessage());
        }
        return baseJsonVo;
    }

    @RequestMapping(value={"/passi/deleteByIds"})
    public BaseJsonVo deleteByIds(@RequestBody List<String> deleteIds) {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        try {
            if (deleteIds != null && deleteIds.size() > 0) {
                this.proAllocationSumMapper.deleteByIds(deleteIds);
            } else {
                baseJsonVo.setStatus(500);
                baseJsonVo.setError_msg("deleteIds is null");
            }
        }
        catch (Exception e) {
            baseJsonVo.setStatus(500);
            baseJsonVo.setError_msg(e.getMessage());
        }
        return baseJsonVo;
    }

    public BaseJsonVo countProMaterialAllocationPlan() {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        TransactionStatus status = this.transactionManager.getTransaction((TransactionDefinition)def);
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        try {
            String today = DateUtils.formatDate((Date)new Date(), (String)"yyyyMMdd");
            ArrayList<ProAllocationSumEntity> listAdd = new ArrayList<ProAllocationSumEntity>();
            ArrayList listUpdate = new ArrayList();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("today", today);
            List proTransportCalendars = this.proTransportCalendarMapper.loadList(map);
            List productAllocations = this.productAllocationMapper.getList(null);
            List proPredictSums = this.proPredictSumMapper.fhindGroupByStorePickupdateSkuSum();
            List proAllocationSumEntitysNew = this.proAllocationSumMapper.loadList(null);
            ArrayList deleteProAllocationSums = new ArrayList();
            if (proTransportCalendars != null && proTransportCalendars.size() > 0) {
                for (ProTransportCalendarEntity proTransportCalendar : proTransportCalendars) {
                    if (proAllocationSumEntitysNew != null && proAllocationSumEntitysNew.size() > 0) {
                        ArrayList<String> deleteProAllocationSumsNew = new ArrayList<String>();
                        boolean deleteFlag = true;
                        for (ProAllocationSumEntity pas : proAllocationSumEntitysNew) {
                            if (!pas.getStoreinId().equals(proTransportCalendar.getStoreinId()) || !pas.getStoreoutId().equals(proTransportCalendar.getStoreoutId()) || !pas.getLogisticsCpId().equals(proTransportCalendar.getLogisticsCpId()) || !pas.getPlanStartTime().equals(proTransportCalendar.getLogisticsDate())) continue;
                            deleteProAllocationSumsNew.add(pas.getId());
                            if (pas.getStatus().equals(1)) continue;
                            deleteFlag = false;
                        }
                        if (!deleteFlag) continue;
                        deleteProAllocationSums.addAll(deleteProAllocationSumsNew);
                    }
                    if (productAllocations == null || productAllocations.size() <= 0) continue;
                    for (ProductAllocationEntity productAllocation : productAllocations) {
                        if (!productAllocation.getStorein().equals(proTransportCalendar.getStoreinId()) || !productAllocation.getStoreout().equals(proTransportCalendar.getStoreoutId())) continue;
                        String planStartTime = proTransportCalendar.getLogisticsDate();
                        Integer days = 1;
                        if (proTransportCalendar.getHaulCycle() != null) {
                            days = (int)Math.ceil((double)proTransportCalendar.getHaulCycle().intValue() * 1.0 / 24.0);
                        }
                        String planEndTime = DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)DateUtils.getDateFromString((String)planStartTime, (String)"yyyyMMdd"), (int)days), (String)"yyyyMMdd");
                        int startTimeString = Integer.valueOf(DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)DateUtils.getDateFromString((String)planEndTime, (String)"yyyyMMdd"), (int)1), (String)"yyyyMMdd"));
                        int endTimeString = Integer.valueOf(DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)DateUtils.getDateFromString((String)planEndTime, (String)"yyyyMMdd"), (int)productAllocation.getPredictcoverdays()), (String)"yyyyMMdd"));
                        if (proPredictSums == null || proPredictSums.size() <= 0) continue;
                        for (ProPredictSumEntity proPredictSum : proPredictSums) {
                            int pickupdate;
                            if (!proPredictSum.getStoreid().equals(productAllocation.getStorein()) || !proPredictSum.getMatid().equals(productAllocation.getCmatid()) || !StringUtils.isNotBlank((String)proPredictSum.getPickupdate()) || startTimeString > (pickupdate = Integer.valueOf(proPredictSum.getPickupdate()).intValue()) || pickupdate > endTimeString) continue;
                            ProAllocationSumEntity proAllocationSumEntity = new ProAllocationSumEntity();
                            proAllocationSumEntity.setId(IDGenerate.getUniqueIdStr());
                            proAllocationSumEntity.setStoreoutId(proTransportCalendar.getStoreoutId());
                            proAllocationSumEntity.setStoreinId(proTransportCalendar.getStoreinId());
                            proAllocationSumEntity.setLogisticsCpId(proTransportCalendar.getLogisticsCpId());
                            proAllocationSumEntity.setMatId(productAllocation.getCmatid());
                            proAllocationSumEntity.setPlanStartTime(planStartTime);
                            proAllocationSumEntity.setPlanEndTime(planEndTime);
                            proAllocationSumEntity.setNeedDate(proPredictSum.getPickupdate());
                            proAllocationSumEntity.setNeedSum(proPredictSum.getPredictsum());
                            proAllocationSumEntity.setAllocationSum(proPredictSum.getPredictsum());
                            proAllocationSumEntity.setStatus(Integer.valueOf(1));
                            listAdd.add(proAllocationSumEntity);
                        }
                    }
                }
            }
            if (deleteProAllocationSums.size() > 0) {
                this.proAllocationSumMapper.deleteByIds(deleteProAllocationSums);
            }
            if (listAdd.size() > 0) {
                this.proAllocationSumMapper.addRecordsBatch(listAdd);
            }
            this.transactionManager.commit(status);
        }
        catch (Exception e) {
            baseJsonVo.setStatus(500);
            baseJsonVo.setMessage(e.getMessage());
            this.transactionManager.rollback(status);
        }
        return baseJsonVo;
    }

    public BaseJsonVo completeProAllocation() {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        try {
            String today = DateUtils.formatDate((Date)new Date(), (String)"yyyyMMdd");
            Integer status = 2;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("today", today);
            map.put("status", status);
            this.proAllocationSumMapper.updateByTodayAndStauts(map);
        }
        catch (Exception e) {
            baseJsonVo.setStatus(500);
            baseJsonVo.setMessage(e.getMessage());
        }
        return baseJsonVo;
    }
}

