/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.pro.service.impl;

import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.serviceresult.Message;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.common.vo.BaseUser;
import cc.lechun.pro.apiinvoke.CodingSchemeServiceClient;
import cc.lechun.pro.apiinvoke.WmsServiceClient;
import cc.lechun.pro.dao.ProMaterialPlanMapper;
import cc.lechun.pro.entity.ProMaterialPlanEntity;
import cc.lechun.pro.entity.ProStoreMaterialEntity;
import cc.lechun.pro.service.ProMaterialPlanService;
import cc.lechun.wms.entity.OutPutDetailEntity;
import cc.lechun.wms.entity.OutPutEntity;
import cc.lechun.wms.entity.vo.OutPutVO;
import com.github.pagehelper.PageHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RefreshScope
@Service
public class ProMaterialPlanServiceImpl
implements ProMaterialPlanService {
    @Autowired
    private ProMaterialPlanMapper proMaterialPlanMapper;
    @Autowired
    private WmsServiceClient wmsServiceClient;
    @Autowired
    private CodingSchemeServiceClient codingSchemeServiceClient;
    @Autowired
    private PlatformTransactionManager transactionManager;

    @RequestMapping(value={"/pmps/findList"})
    public BaseJsonVo findList(@RequestHeader(value="pageNo") Integer pageNo, @RequestHeader(value="pageSize") Integer pageSize, @RequestBody Map<String, Object> param) {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        try {
            if (pageNo == null) {
                pageNo = 0;
            }
            if (pageSize == null) {
                pageSize = 0;
            }
            if (pageNo > 0 && pageSize > 0) {
                PageHelper.startPage((int)pageNo, (int)pageSize);
            }
            List loadList = this.proMaterialPlanMapper.loadList(param);
            if (param != null && param.get("panstatusNo") != null && param.get("panstatusNo").equals("1") && loadList != null && loadList.size() > 0) {
                for (ProMaterialPlanEntity proMaterialPlanEntity : loadList) {
                    if (proMaterialPlanEntity.getActuallyfinishnum() != null) continue;
                    proMaterialPlanEntity.setActuallyfinishnum(proMaterialPlanEntity.getPlannum());
                }
            }
            baseJsonVo.setValue((Object)loadList);
        }
        catch (Exception e) {
            baseJsonVo.setStatus(500);
            baseJsonVo.setError_msg(e.getMessage());
        }
        return baseJsonVo;
    }

    @RequestMapping(value={"/pmps/saveOrUpdate"})
    public BaseJsonVo saveOrUpdate(BaseUser user, @RequestBody List<ProMaterialPlanEntity> proMaterialPlanEntitys, List<String> ids) {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        try {
            if (proMaterialPlanEntitys != null && proMaterialPlanEntitys.size() > 0) {
                ArrayList<ProMaterialPlanEntity> adlist = new ArrayList<ProMaterialPlanEntity>();
                ArrayList<ProMaterialPlanEntity> updates = new ArrayList<ProMaterialPlanEntity>();
                for (ProMaterialPlanEntity proMaterialPlanEntity : proMaterialPlanEntitys) {
                    proMaterialPlanEntity.setPanstatus(Integer.valueOf(1));
                    proMaterialPlanEntity.setCreattime(new Date());
                    if (StringUtils.isNotBlank((String)proMaterialPlanEntity.getPlanid())) {
                        updates.add(proMaterialPlanEntity);
                        continue;
                    }
                    proMaterialPlanEntity.setPlanid(IDGenerate.getUniqueIdStr());
                    adlist.add(proMaterialPlanEntity);
                }
                if (updates.size() > 0) {
                    this.proMaterialPlanMapper.updateBatch(updates);
                }
                if (adlist.size() > 0) {
                    this.proMaterialPlanMapper.addRecordsBatch(adlist);
                }
            }
            if (ids != null && ids.size() > 0) {
                this.proMaterialPlanMapper.deleteListByIds(ids);
            }
        }
        catch (Exception e) {
            baseJsonVo.setStatus(500);
            baseJsonVo.setError_msg(e.getMessage());
        }
        return baseJsonVo;
    }

    @RequestMapping(value={"/pmps/issuedUpdateList"})
    public BaseJsonVo issuedUpdateList(BaseUser user) {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        try {
            String dateAddOneDay = DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)new Date(), (int)1), (String)"yyyyMMdd");
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (user != null) {
                map.put("plantime", dateAddOneDay);
                map.put("userName", user.getUserName());
                map.put("date", new Date());
                this.proMaterialPlanMapper.issuedUpdate(map);
            } else {
                map.put("plantime", dateAddOneDay);
                map.put("userName", null);
                map.put("date", new Date());
                this.proMaterialPlanMapper.issuedUpdate(map);
            }
        }
        catch (Exception e) {
            baseJsonVo.setStatus(500);
            baseJsonVo.setError_msg(e.getMessage());
        }
        return baseJsonVo;
    }

    @RequestMapping(value={"/pmps/finishInToStoreUpdateList"})
    public BaseJsonVo finishInToStoreUpdateList(BaseUser user, @RequestBody List<ProMaterialPlanEntity> proMaterialPlanEntitys) {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        TransactionStatus status = this.transactionManager.getTransaction((TransactionDefinition)def);
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        try {
            for (ProMaterialPlanEntity proMaterialPlanEntity : proMaterialPlanEntitys) {
                Date date = new Date();
                proMaterialPlanEntity.setVerifytime(date);
                proMaterialPlanEntity.setActuallyfinishtime(date);
                proMaterialPlanEntity.setPanstatus(Integer.valueOf(3));
            }
            this.proMaterialPlanMapper.updateBatch(proMaterialPlanEntitys);
            OutPutVO outPutVO = this.toOutPutVO(user, proMaterialPlanEntitys);
            Message message = this.wmsServiceClient.saveOrUpdate(outPutVO);
            this.codingSchemeServiceClient.updategenerateCode("013", "300846");
            if (!message.getSuccess()) {
                this.transactionManager.rollback(status);
            }
            this.transactionManager.commit(status);
        }
        catch (Exception e) {
            baseJsonVo.setStatus(500);
            baseJsonVo.setError_msg(e.getMessage());
            this.transactionManager.rollback(status);
        }
        return baseJsonVo;
    }

    private OutPutVO toOutPutVO(BaseUser user, List<ProMaterialPlanEntity> proMaterialPlanEntitys) {
        OutPutVO outPutVO = new OutPutVO();
        ArrayList<OutPutDetailEntity> add = new ArrayList<OutPutDetailEntity>();
        for (ProMaterialPlanEntity proMaterialPlanEntity : proMaterialPlanEntitys) {
            OutPutDetailEntity outPutDetailEntity = new OutPutDetailEntity();
            outPutDetailEntity.setcTenantId(user.getCtenantid());
            outPutDetailEntity.setMat_id(proMaterialPlanEntity.getMatid());
            outPutDetailEntity.setStore_id(null);
            if (proMaterialPlanEntity.getActuallyfinishnum() != null) {
                outPutDetailEntity.setiQty(new BigDecimal(proMaterialPlanEntity.getActuallyfinishnum()));
            } else {
                outPutDetailEntity.setiQty(new BigDecimal(0));
            }
            outPutDetailEntity.setUnit_id(null);
            add.add(outPutDetailEntity);
        }
        outPutVO.setAdd(add);
        OutPutEntity outPut = new OutPutEntity();
        outPut.setcBillCode(this.codingSchemeServiceClient.generateCode("013", "300846"));
        outPut.setdDate(DateUtils.currentDate());
        outPut.setiType(Integer.valueOf(3));
        outPut.setOsType(Integer.valueOf(1));
        outPut.setEmp_id(null);
        outPut.setcRemark("\u9ed8\u8ba4\u5355\u4f4d\u4e3a\u76d2  -- \u56e0\u4e3a\u63a8\u9001\u6570\u636e\u9ed8\u8ba4\u4e3a\u76d2,\u65e0\u5355\u4f4dID,\u9700\u8981\u624b\u52a8\u4fee\u6539\u5355\u4f4d\u4e3a\u76d2");
        outPutVO.setOutPut(outPut);
        return outPutVO;
    }

    @RequestMapping(value={"/pmps/checkPlanSum"})
    public BaseJsonVo<List<ProStoreMaterialEntity>> checkPlanSum() {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        try {
            String dateAddOneDay = DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)new Date(), (int)1), (String)"yyyyMMdd");
            List list = this.proMaterialPlanMapper.checkPlanSum(dateAddOneDay);
            if (list != null && list.size() > 0) {
                baseJsonVo.setStatus(500);
                baseJsonVo.setMessage("\u5f53\u65e5\u6392\u4ea7\u6570\u636e\u5df2\u7ecf\u751f\u6210\u4e0b\u8fbe\u6570\u636e,\u6545\u65e0\u6cd5\u518d\u6b21\u8ba1\u7b97");
            }
        }
        catch (Exception e) {
            baseJsonVo.setStatus(500);
            baseJsonVo.setError_msg(e.getMessage());
        }
        return baseJsonVo;
    }
}

