/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.pro.service.impl;

import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.pro.api.ProPredictMatService;
import cc.lechun.pro.dao.MatFreshnessMapper;
import cc.lechun.pro.dao.ProPredictDetailMapper;
import cc.lechun.pro.dao.ProPredictSumMapper;
import cc.lechun.pro.entity.MatFreshnessEntity;
import cc.lechun.pro.entity.ProPredictDetailEntity;
import cc.lechun.pro.entity.ProPredictSumEntity;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RefreshScope
@Service
public class ProPredictMatServiceImpl
implements ProPredictMatService {
    @Autowired
    private ProPredictDetailMapper proPredictDetailMapper;
    @Autowired
    private ProPredictSumMapper proPredictSumMapper;
    @Autowired
    private MatFreshnessMapper matFreshnessMapper;
    @Autowired
    private PlatformTransactionManager transactionManager;

    @RequestMapping(value={"/ppms/saveOrUpdateList"})
    @Transactional
    public BaseJsonVo saveOrUpdateList(@RequestBody List<ProPredictDetailEntity> proPredictDetailEntitys) {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        TransactionStatus status = this.transactionManager.getTransaction((TransactionDefinition)def);
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        String nowDate = DateUtils.formatDate((Date)new Date(), (String)"yyyyMMdd");
        try {
            ArrayList<ProPredictDetailEntity> ListAdd = new ArrayList<ProPredictDetailEntity>();
            ArrayList ListUpdate = new ArrayList();
            List proPredictDetailEntitysNew = this.proPredictDetailMapper.fhindList(null);
            if (proPredictDetailEntitys != null && proPredictDetailEntitys.size() > 0) {
                HashSet<String> getPreordercodes = new HashSet<String>();
                if (proPredictDetailEntitysNew != null && proPredictDetailEntitysNew.size() > 0) {
                    for (ProPredictDetailEntity proPredictDetailEntity : proPredictDetailEntitysNew) {
                        getPreordercodes.add(proPredictDetailEntity.getPreordercode());
                    }
                }
                HashSet<String> noExistentPreordercodes = new HashSet<String>();
                for (ProPredictDetailEntity proPredictDetailEntity : proPredictDetailEntitys) {
                    proPredictDetailEntity.setGuid(IDGenerate.getUniqueIdStr());
                    proPredictDetailEntity.setSumdatetime(nowDate);
                    proPredictDetailEntity.setPreordercode("PDE-" + (proPredictDetailEntity.getBctid() + proPredictDetailEntity.getMatid() + proPredictDetailEntity.getStoreid() + proPredictDetailEntity.getPickupdate()).hashCode());
                    if (!getPreordercodes.contains(proPredictDetailEntity.getPreordercode())) {
                        ListAdd.add(proPredictDetailEntity);
                        noExistentPreordercodes.add(proPredictDetailEntity.getPreordercode());
                    }
                    if (ListAdd.size() <= 0) continue;
                    List matFreshnessEntitys = this.matFreshnessMapper.fhindList(null);
                    if (matFreshnessEntitys != null && matFreshnessEntitys.size() > 0) {
                        block8: for (ProPredictDetailEntity p : ListAdd) {
                            for (MatFreshnessEntity f : matFreshnessEntitys) {
                                if (!p.getBctid().equals(f.getBctid()) || !p.getMatid().equals(f.getMatid())) continue;
                                p.setFreshnessId(f.getGuid());
                                p.setFreshness(f.getFreshness());
                                continue block8;
                            }
                        }
                    }
                    this.proPredictDetailMapper.addRecordsBatch(ListAdd);
                    HashMap<String, HashSet<String>> param = new HashMap<String, HashSet<String>>();
                    if (noExistentPreordercodes != null && noExistentPreordercodes.size() > 0) {
                        param.put("preordercodes", noExistentPreordercodes);
                    }
                    List listsum = this.proPredictDetailMapper.sum(param);
                    for (ProPredictSumEntity proPredictSumEntity : listsum) {
                        proPredictSumEntity.setGuid(IDGenerate.getUniqueIdStr());
                        proPredictSumEntity.setSumdatetime(nowDate);
                        proPredictSumEntity.setSumstatus(Integer.valueOf(1));
                    }
                    this.proPredictSumMapper.addRecordsBatch(listsum);
                }
            }
            this.transactionManager.commit(status);
        }
        catch (Exception e) {
            System.out.println(e);
            baseJsonVo.setStatus(500);
            baseJsonVo.setError_msg(e.getMessage());
            try {
                this.transactionManager.rollback(status);
            }
            catch (Exception e1) {
                System.out.println(e1);
                baseJsonVo.setStatus(500);
                baseJsonVo.setError_msg(e1.getMessage());
                try {
                    this.transactionManager.rollback(status);
                }
                catch (Exception e12) {
                    baseJsonVo.setError_msg(e12.getMessage());
                }
            }
        }
        return baseJsonVo;
    }

    @RequestMapping(value={"/ppms/saveOrUpdate"})
    public BaseJsonVo saveOrUpdate(@RequestBody ProPredictDetailEntity mtFreshnessEntity) {
        ArrayList<ProPredictDetailEntity> List2 = new ArrayList<ProPredictDetailEntity>();
        List2.add(mtFreshnessEntity);
        return this.saveOrUpdateList(List2);
    }

    @RequestMapping(value={"/ppms/save"})
    public BaseJsonVo save(@RequestBody ProPredictDetailEntity mtFreshnessEntity) {
        ArrayList<ProPredictDetailEntity> List2 = new ArrayList<ProPredictDetailEntity>();
        List2.add(mtFreshnessEntity);
        return this.saveOrUpdateList(List2);
    }

    @RequestMapping(value={"/ppms/update"})
    public BaseJsonVo update(@RequestBody ProPredictDetailEntity mtFreshnessEntity) {
        ArrayList<ProPredictDetailEntity> List2 = new ArrayList<ProPredictDetailEntity>();
        List2.add(mtFreshnessEntity);
        return this.saveOrUpdateList(List2);
    }

    @RequestMapping(value={"/ppms/findList"})
    public BaseJsonVo<List<ProPredictDetailEntity>> findList(Integer pageNo, Integer pageSize, @RequestBody Map<String, Object> param) {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        if (pageNo == null) {
            pageNo = 0;
        }
        if (pageSize == null) {
            pageSize = 0;
        }
        try {
            if (pageNo > 0 && pageSize > 0) {
                PageHelper.startPage((int)pageNo, (int)pageSize);
            }
            baseJsonVo.setValue((Object)this.proPredictDetailMapper.fhindList(param));
        }
        catch (Exception e) {
            baseJsonVo.setStatus(500);
            baseJsonVo.setError_msg(e.getMessage());
        }
        return baseJsonVo;
    }

    @RequestMapping(value={"/ppms/findById"})
    public BaseJsonVo<ProPredictDetailEntity> findById(String guid) {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("guid", guid);
        BaseJsonVo result = this.findList(null, null, param);
        if (result.getStatus() == 200) {
            List list = (List)result.getValue();
            if (list != null && list.size() > 0) {
                baseJsonVo.setValue(list.get(0));
            }
        } else {
            baseJsonVo.setStatus(result.getStatus());
            baseJsonVo.setMessage(result.getMessage());
        }
        return baseJsonVo;
    }

    @RequestMapping(value={"/ppms/findByIds"})
    public BaseJsonVo<List<ProPredictDetailEntity>> findByIds(@RequestBody List<String> guids) {
        HashMap<String, List<String>> param = new HashMap<String, List<String>>();
        param.put("guids", guids);
        return this.findList(null, null, param);
    }

    @RequestMapping(value={"/ppms/delete"})
    public BaseJsonVo delete(@RequestBody Map<String, Object> pacam) {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        try {
            this.proPredictDetailMapper.deleteByParam(pacam);
        }
        catch (Exception e) {
            baseJsonVo.setStatus(500);
            baseJsonVo.setError_msg(e.getMessage());
        }
        return baseJsonVo;
    }

    @RequestMapping(value={"/ppms/deleteById"})
    public BaseJsonVo deleteById(String guid) {
        ArrayList<String> list = new ArrayList<String>(1);
        list.add(guid);
        return this.deleteByIds(list);
    }

    @RequestMapping(value={"/ppms/deleteByIds"})
    public BaseJsonVo deleteByIds(@RequestBody List<String> guids) {
        HashMap<String, List<String>> pacam = new HashMap<String, List<String>>();
        pacam.put("guids", guids);
        return this.delete(pacam);
    }

    @RequestMapping(value={"/ppms/details"})
    public BaseJsonVo details(Integer pageNo, Integer pageSize, @RequestBody Map<String, Object> param) {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        try {
            if (pageNo == null) {
                pageNo = 0;
            }
            if (pageSize == null) {
                pageSize = 0;
            }
            if (pageNo > 0 && pageSize > 0) {
                PageHelper.startPage((int)pageNo, (int)pageSize);
            }
            baseJsonVo.setValue((Object)this.proPredictDetailMapper.fhindList(param));
        }
        catch (Exception e) {
            baseJsonVo.setStatus(500);
            baseJsonVo.setError_msg(e.getMessage());
        }
        return baseJsonVo;
    }

    @RequestMapping(value={"/ppms/sum"})
    public BaseJsonVo sum(Integer pageNo, Integer pageSize, @RequestBody Map<String, Object> param) {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        try {
            if (pageNo == null) {
                pageNo = 0;
            }
            if (pageSize == null) {
                pageSize = 0;
            }
            if (pageNo > 0 && pageSize > 0) {
                PageHelper.startPage((int)pageNo, (int)pageSize);
            }
            baseJsonVo.setValue((Object)this.proPredictDetailMapper.sum(param));
        }
        catch (Exception e) {
            baseJsonVo.setStatus(500);
            baseJsonVo.setError_msg(e.getMessage());
        }
        return baseJsonVo;
    }

    @RequestMapping(value={"/ppms/sumDetails"})
    public BaseJsonVo sumDetails(Integer pageNo, Integer pageSize, @RequestBody Map<String, Object> param) {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        try {
            if (pageNo == null) {
                pageNo = 0;
            }
            if (pageSize == null) {
                pageSize = 0;
            }
            if (pageNo > 0 && pageSize > 0) {
                PageHelper.startPage((int)pageNo, (int)pageSize);
            }
            baseJsonVo.setValue((Object)this.proPredictDetailMapper.fhindListdetail(param));
        }
        catch (Exception e) {
            baseJsonVo.setStatus(500);
            baseJsonVo.setError_msg(e.getMessage());
        }
        return baseJsonVo;
    }

    @RequestMapping(value={"/ppms/deleteByPreordercode"})
    public BaseJsonVo deleteByPreordercode(List<String> preordercodes) {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        HashMap<String, List<String>> paramMap = new HashMap<String, List<String>>();
        paramMap.put("preordercodes", preordercodes);
        try {
            this.proPredictDetailMapper.deleteByParam(paramMap);
            this.proPredictSumMapper.deleteByParam(paramMap);
            baseJsonVo.setStatus(200);
        }
        catch (Exception e) {
            baseJsonVo.setStatus(500);
            baseJsonVo.setError_msg(e.getMessage());
        }
        return baseJsonVo;
    }
}

