/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.pro.service.impl;

import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.pro.dao.ProTransportCalendarMapper;
import cc.lechun.pro.entity.ProTransportCalendarEntity;
import cc.lechun.pro.service.ProTransportCalendarService;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RefreshScope
@Service
public class ProTransportCalendarServiceImpl
implements ProTransportCalendarService {
    @Autowired
    private ProTransportCalendarMapper proTransportCalendarMapper;
    @Autowired
    private PlatformTransactionManager transactionManager;

    @RequestMapping(value={"/ptcsi/saveOrUpdateList"})
    public BaseJsonVo saveOrUpdateList(@RequestBody List<ProTransportCalendarEntity> proTransportCalendarEntitys, List<String> deleteids) {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        TransactionStatus status = this.transactionManager.getTransaction((TransactionDefinition)def);
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        try {
            ArrayList<ProTransportCalendarEntity> listAdd = new ArrayList<ProTransportCalendarEntity>();
            ArrayList<ProTransportCalendarEntity> listUpdate = new ArrayList<ProTransportCalendarEntity>();
            if (null != proTransportCalendarEntitys && proTransportCalendarEntitys.size() > 0) {
                for (ProTransportCalendarEntity proTransportCalendar : proTransportCalendarEntitys) {
                    if (StringUtils.isNotBlank((String)proTransportCalendar.getId())) {
                        proTransportCalendar.setModifytime(new Date());
                        listUpdate.add(proTransportCalendar);
                        continue;
                    }
                    proTransportCalendar.setModifytime(new Date());
                    proTransportCalendar.setId(IDGenerate.getUniqueIdStr());
                    listAdd.add(proTransportCalendar);
                }
            }
            if (listAdd.size() > 0) {
                this.proTransportCalendarMapper.addRecordsBatch(listAdd);
            }
            if (listUpdate.size() > 0) {
                this.proTransportCalendarMapper.updateBatch(listUpdate);
            }
            if (deleteids != null && deleteids.size() > 0) {
                this.proTransportCalendarMapper.deleteByIds(deleteids);
            }
            this.transactionManager.commit(status);
        }
        catch (Exception e) {
            baseJsonVo.setStatus(500);
            baseJsonVo.setMessage(e.getMessage());
            this.transactionManager.rollback(status);
        }
        return baseJsonVo;
    }

    @RequestMapping(value={"/ptcsi/findList"})
    public BaseJsonVo<List<ProTransportCalendarEntity>> findList(@RequestHeader(value="pageNo") Integer pageNo, @RequestHeader(value="pageSize") Integer pageSize, @RequestBody Map<String, Object> param) {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        try {
            if (pageNo == null) {
                pageNo = 0;
            }
            if (pageSize == null) {
                pageSize = 0;
            }
            if (pageNo > 0 && pageSize > 0) {
                PageHelper.startPage((int)pageNo, (int)pageSize);
            }
            baseJsonVo.setValue((Object)this.proTransportCalendarMapper.loadList(param));
        }
        catch (Exception e) {
            baseJsonVo.setStatus(500);
            baseJsonVo.setError_msg(e.getMessage());
        }
        return baseJsonVo;
    }

    @RequestMapping(value={"/ptcsi/deleteByIds"})
    public BaseJsonVo deleteByIds(@RequestBody List<String> deleteIds) {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        try {
            if (deleteIds != null && deleteIds.size() > 0) {
                this.proTransportCalendarMapper.deleteByIds(deleteIds);
            } else {
                baseJsonVo.setStatus(500);
                baseJsonVo.setError_msg("deleteIds is null");
            }
        }
        catch (Exception e) {
            baseJsonVo.setStatus(500);
            baseJsonVo.setError_msg(e.getMessage());
        }
        return baseJsonVo;
    }
}

