/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.pro.control;

import cc.lechun.framework.common.utils.jqgridData.JqGridData;
import cc.lechun.framework.common.utils.serviceresult.Message;
import cc.lechun.framework.common.vo.BaseUser;
import cc.lechun.framework.common.vo.JedisUtils;
import cc.lechun.pro.entity.ProductAllocationEntity;
import cc.lechun.pro.entity.bo.ProductAllocationEntityBO;
import cc.lechun.pro.entity.vo.ProductAllocationVO;
import cc.lechun.pro.service.ProductAllocationService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RefreshScope
public class ProductAllocationControl {
    @Autowired
    private ProductAllocationService productAllocationService;

    @RequestMapping(value={"/productallocation/selectProductAllocation"})
    public JqGridData<ProductAllocationEntityBO> selectSalesPrice(HttpServletRequest request, HttpServletResponse response, String cheadId) {
        BaseUser user = null;
        try {
            user = JedisUtils.getBaseUser((HttpServletRequest)request);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String page = request.getParameter("page");
        String rows = request.getParameter("rows");
        int pageNo = 0;
        int pageSize = 0;
        if (StringUtils.isNotBlank((CharSequence)page) && StringUtils.isNotBlank((CharSequence)rows)) {
            pageNo = Integer.valueOf(page);
            pageSize = Integer.valueOf(rows);
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ctenantid", user.getCtenantid());
        params.put("ccustomerid", request.getParameter("ccustomerid"));
        List salesPriceList = this.productAllocationService.findByParams(Integer.valueOf(pageNo), Integer.valueOf(pageSize), params);
        JqGridData gridData = new JqGridData(page, salesPriceList);
        return gridData;
    }

    @RequestMapping(value={"/productallocation/saveOrUpdate"})
    public Message saveOrUpdate(HttpServletRequest request, HttpServletResponse response, @RequestBody ProductAllocationVO productAllocationVO) {
        BaseUser user = null;
        try {
            user = JedisUtils.getBaseUser((HttpServletRequest)request);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Message message = new Message();
        List addList = productAllocationVO.getAdd();
        List modifyList = productAllocationVO.getModify();
        List delList = productAllocationVO.getDel();
        ArrayList sumList = new ArrayList();
        if (addList.size() > 0) {
            sumList.addAll(addList);
        }
        if (modifyList.size() > 0) {
            sumList.addAll(modifyList);
        }
        Boolean flag = this.productAllocationService.checkData(sumList);
        for (int i = 0; i < sumList.size() - 1; ++i) {
            for (int j = i + 1; j < sumList.size(); ++j) {
                if (!((ProductAllocationEntity)sumList.get(i)).getCmatid().equals(((ProductAllocationEntity)sumList.get(j)).getCmatid()) || !((ProductAllocationEntity)sumList.get(i)).getStorein().equals(((ProductAllocationEntity)sumList.get(j)).getStorein()) || !((ProductAllocationEntity)sumList.get(i)).getStoreout().equals(((ProductAllocationEntity)sumList.get(j)).getStoreout())) continue;
                flag = false;
            }
        }
        if (flag.booleanValue()) {
            this.productAllocationService.saveOrUpdateProductAllocation(user, addList, modifyList, delList);
            message.setSuccess(true);
            message.setMsg("\u4fdd\u5b58\u6210\u529f");
            return message;
        }
        message.setSuccess(false);
        message.setMsg("\u4f60\u4fdd\u5b58\u7684\u6570\u636e\u6709\u51b2\u7a81");
        return message;
    }
}

