/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.pro.service.impl;

import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.pro.api.ImatFreshnessService;
import cc.lechun.pro.dao.MatFreshnessMapper;
import cc.lechun.pro.entity.MatFreshnessEntity;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RefreshScope
@Service
public class ImatFreshnessServiceImpl
implements ImatFreshnessService {
    @Autowired
    private MatFreshnessMapper matFreshnessMapper;
    @Autowired
    private PlatformTransactionManager transactionManager;

    @RequestMapping(value={"/ifsa/saveOrUpdateList"})
    public BaseJsonVo saveOrUpdateList(@RequestBody List<MatFreshnessEntity> mtFreshnessEntitys) {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        try {
            ArrayList<MatFreshnessEntity> ListAdd = new ArrayList<MatFreshnessEntity>();
            ArrayList<MatFreshnessEntity> ListUpdate = new ArrayList<MatFreshnessEntity>();
            if (mtFreshnessEntitys != null && mtFreshnessEntitys.size() > 0) {
                for (MatFreshnessEntity matFreshnessEntity : mtFreshnessEntitys) {
                    matFreshnessEntity.setModifytime(new Date());
                    if (StringUtils.isNotBlank((CharSequence)matFreshnessEntity.getGuid())) {
                        ListUpdate.add(matFreshnessEntity);
                        continue;
                    }
                    matFreshnessEntity.setGuid(IDGenerate.getUniqueIdStr());
                    ListAdd.add(matFreshnessEntity);
                }
                if (ListAdd.size() > 0) {
                    this.matFreshnessMapper.addRecordsBatch(ListAdd);
                }
                if (ListUpdate.size() > 0) {
                    this.matFreshnessMapper.updateBatch(ListUpdate);
                }
            }
        }
        catch (Exception e) {
            System.out.println(e);
            baseJsonVo.setStatus(500);
            baseJsonVo.setError_msg(e.getMessage());
            throw e;
        }
        return baseJsonVo;
    }

    @RequestMapping(value={"/ifsa/saveOrUpdate"})
    public BaseJsonVo saveOrUpdate(@RequestBody MatFreshnessEntity mtFreshnessEntity) {
        ArrayList<MatFreshnessEntity> List2 = new ArrayList<MatFreshnessEntity>();
        List2.add(mtFreshnessEntity);
        return this.saveOrUpdateList(List2);
    }

    @RequestMapping(value={"/ifsa/saveIFSA"})
    public BaseJsonVo save(@RequestBody MatFreshnessEntity mtFreshnessEntity) {
        ArrayList<MatFreshnessEntity> List2 = new ArrayList<MatFreshnessEntity>();
        List2.add(mtFreshnessEntity);
        return this.saveOrUpdateList(List2);
    }

    @RequestMapping(value={"/ifsa/update"})
    public BaseJsonVo update(@RequestBody MatFreshnessEntity mtFreshnessEntity) {
        ArrayList<MatFreshnessEntity> List2 = new ArrayList<MatFreshnessEntity>();
        List2.add(mtFreshnessEntity);
        return this.saveOrUpdateList(List2);
    }

    @RequestMapping(value={"/ifsa/findList"})
    public BaseJsonVo<List<MatFreshnessEntity>> findList(Integer pageNo, Integer pageSize, @RequestBody Map<String, Object> param) {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        try {
            if (pageNo == null) {
                pageNo = 0;
            }
            if (pageSize == null) {
                pageSize = 0;
            }
            if (pageNo > 0 && pageSize > 0) {
                PageHelper.startPage((int)pageNo, (int)pageSize);
            }
            baseJsonVo.setValue((Object)this.matFreshnessMapper.fhindList(param));
        }
        catch (Exception e) {
            baseJsonVo.setStatus(500);
            baseJsonVo.setError_msg(e.getMessage());
        }
        return baseJsonVo;
    }

    @RequestMapping(value={"/ifsa/findById"})
    public BaseJsonVo<MatFreshnessEntity> findById(String guid) {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("guid", guid);
        BaseJsonVo result = this.findList(null, null, param);
        if (result.getStatus() == 200) {
            List list = (List)result.getValue();
            if (list != null && list.size() > 0) {
                baseJsonVo.setValue(list.get(0));
            }
        } else {
            baseJsonVo.setStatus(result.getStatus());
            baseJsonVo.setMessage(result.getMessage());
        }
        return baseJsonVo;
    }

    @RequestMapping(value={"/ifsa/findByIds"})
    public BaseJsonVo<List<MatFreshnessEntity>> findByIds(@RequestBody List<String> guids) {
        HashMap<String, List<String>> param = new HashMap<String, List<String>>();
        param.put("guids", guids);
        return this.findList(null, null, param);
    }

    @RequestMapping(value={"/ifsa/delete"})
    public BaseJsonVo delete(@RequestBody Map<String, Object> pacam) {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        try {
            this.matFreshnessMapper.deleteByParam(pacam);
        }
        catch (Exception e) {
            baseJsonVo.setStatus(500);
            baseJsonVo.setError_msg(e.getMessage());
        }
        return baseJsonVo;
    }

    @RequestMapping(value={"/ifsa/deleteById"})
    public BaseJsonVo deleteById(String guid) {
        ArrayList<String> list = new ArrayList<String>(1);
        list.add(guid);
        return this.deleteByIds(list);
    }

    @RequestMapping(value={"/ifsa/deleteByIds"})
    public BaseJsonVo deleteByIds(@RequestBody List<String> guids) {
        HashMap<String, List<String>> pacam = new HashMap<String, List<String>>();
        pacam.put("guids", guids);
        return this.delete(pacam);
    }
}

