/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.pro.service.impl;

import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.pro.dao.ProFactoryCalendarMapper;
import cc.lechun.pro.entity.ProFactoryCalendarEntity;
import cc.lechun.pro.service.ProFactoryCalendarService;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RefreshScope
@Service
public class ProFactoryCalendarServiceImpl
implements ProFactoryCalendarService {
    @Autowired
    private ProFactoryCalendarMapper proFactoryCalendarMapper;
    @Autowired
    private PlatformTransactionManager transactionManager;

    public BaseJsonVo saveOrUpDate(List<ProFactoryCalendarEntity> proFactoryCalendarEntitys, List<String> deleteIds) {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        TransactionStatus status = this.transactionManager.getTransaction((TransactionDefinition)def);
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        try {
            ArrayList<ProFactoryCalendarEntity> listAdd = new ArrayList<ProFactoryCalendarEntity>();
            ArrayList<ProFactoryCalendarEntity> listUpdate = new ArrayList<ProFactoryCalendarEntity>();
            if (proFactoryCalendarEntitys != null) {
                for (ProFactoryCalendarEntity proFactoryCalendar : proFactoryCalendarEntitys) {
                    if (StringUtils.isNotBlank((String)proFactoryCalendar.getId())) {
                        listUpdate.add(proFactoryCalendar);
                        continue;
                    }
                    proFactoryCalendar.setId(IDGenerate.getUniqueIdStr());
                    listAdd.add(proFactoryCalendar);
                }
                if (deleteIds != null && deleteIds.size() > 0) {
                    this.proFactoryCalendarMapper.deleteByIds(deleteIds);
                }
                if (listAdd.size() > 0) {
                    this.proFactoryCalendarMapper.addRecordsBatch(listAdd);
                }
                if (listUpdate.size() > 0) {
                    this.proFactoryCalendarMapper.updateBatch(listUpdate);
                }
            }
            this.transactionManager.commit(status);
        }
        catch (Exception e) {
            baseJsonVo.setStatus(500);
            baseJsonVo.setError_msg(e.getMessage());
            this.transactionManager.rollback(status);
        }
        return baseJsonVo;
    }

    public BaseJsonVo<List<ProFactoryCalendarEntity>> findPage(Integer pageNo, Integer pageSize, Map<String, Object> param) {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        try {
            pageNo = pageNo == null ? 0 : pageNo;
            pageSize = pageSize == null ? 0 : pageSize;
            if (pageNo > 0 && pageSize > 0) {
                PageHelper.startPage((int)pageNo, (int)pageSize);
            }
            baseJsonVo.setValue((Object)this.proFactoryCalendarMapper.loadList(param));
        }
        catch (Exception e) {
            baseJsonVo.setStatus(500);
            baseJsonVo.setError_msg(e.getMessage());
        }
        return baseJsonVo;
    }

    public BaseJsonVo<List<ProFactoryCalendarEntity>> createProTime(String days) {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        if (StringUtils.isNotBlank((String)days)) {
            try {
                Integer days2 = Integer.valueOf(days);
                ArrayList<ProFactoryCalendarEntity> list = new ArrayList<ProFactoryCalendarEntity>();
                for (int i = 1; i < days2 + 1; ++i) {
                    String dateAddOneDay = DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)new Date(), (int)i), (String)"yyyyMMdd");
                    ProFactoryCalendarEntity proFactoryCalendar = new ProFactoryCalendarEntity();
                    proFactoryCalendar.setId(IDGenerate.getUniqueIdStr());
                    proFactoryCalendar.setProDay(dateAddOneDay);
                    list.add(proFactoryCalendar);
                }
                this.proFactoryCalendarMapper.addRecordsBatch(list);
            }
            catch (Exception e) {
                baseJsonVo.setStatus(500);
                baseJsonVo.setMessage(e.getMessage());
            }
        } else {
            baseJsonVo.setStatus(500);
            baseJsonVo.setMessage("\u53c2\u6570: \u751f\u6210\u51e0\u5929\u7684\u6392\u4ea7\u5929\u6570\u672a\u6b63\u786e\u8d4b\u503c");
        }
        return baseJsonVo;
    }
}

