/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.pro.service.impl;

import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.common.vo.BaseUser;
import cc.lechun.pro.apiinvoke.CodingSchemeServiceClient;
import cc.lechun.pro.dao.MaterialProdMapper;
import cc.lechun.pro.dao.ProFactoryCalendarMapper;
import cc.lechun.pro.dao.ProMaterialPlanMapper;
import cc.lechun.pro.dao.ProPredictSumMapper;
import cc.lechun.pro.dao.ProStoreMaterialMapper;
import cc.lechun.pro.dao.ProStoreOccupyRelationMapper;
import cc.lechun.pro.dao.ProStorePredictRangeMapper;
import cc.lechun.pro.entity.MaterialProdEntity;
import cc.lechun.pro.entity.ProFactoryCalendarEntity;
import cc.lechun.pro.entity.ProMaterialPlanEntity;
import cc.lechun.pro.entity.ProPredictSumEntity;
import cc.lechun.pro.entity.ProStoreMaterialEntity;
import cc.lechun.pro.entity.ProStoreOccupyRelationEntity;
import cc.lechun.pro.entity.ProStorePredictRangeEntity;
import cc.lechun.pro.service.ProStoreMaterialService;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RefreshScope
@Service
public class ProStoreMaterialServiceImpl
implements ProStoreMaterialService {
    @Autowired
    private MaterialProdMapper materialProdMapper;
    @Autowired
    private ProStoreMaterialMapper proStoreMaterialMapper;
    @Autowired
    private ProMaterialPlanMapper proMaterialPlanMapper;
    @Autowired
    private ProStoreOccupyRelationMapper proStoreOccupyRelationMapper;
    @Autowired
    private ProPredictSumMapper proPredictSumMapper;
    @Autowired
    private ProStorePredictRangeMapper proStorePredictRangeMapper;
    @Autowired
    private ProFactoryCalendarMapper proFactoryCalendarMapper;
    @Autowired
    private CodingSchemeServiceClient codingSchemeServiceClient;
    @Autowired
    private PlatformTransactionManager transactionManager;

    @RequestMapping(value={"/psm/addRecords"})
    public BaseJsonVo addRecords(@RequestBody List<ProStoreMaterialEntity> proStoreMaterialEntitys) {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        TransactionStatus status = this.transactionManager.getTransaction((TransactionDefinition)def);
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        try {
            ArrayList<ProStoreMaterialEntity> listAdd = new ArrayList<ProStoreMaterialEntity>();
            if (null != proStoreMaterialEntitys && proStoreMaterialEntitys.size() > 0) {
                for (ProStoreMaterialEntity proStoreMaterialEntity : proStoreMaterialEntitys) {
                    proStoreMaterialEntity.setTpsmid(IDGenerate.getUniqueIdStr());
                    proStoreMaterialEntity.setSurplusnum(proStoreMaterialEntity.getInitialnum());
                    listAdd.add(proStoreMaterialEntity);
                }
            }
            if (listAdd.size() > 0) {
                this.proStoreMaterialMapper.deleteAll();
                this.proStoreMaterialMapper.addRecordsBatch(listAdd);
            }
            this.proPredictSumToproStoreMaterial(null);
            this.transactionManager.commit(status);
        }
        catch (Exception e) {
            baseJsonVo.setStatus(500);
            baseJsonVo.setError_msg(e.getMessage());
            this.transactionManager.rollback(status);
        }
        return baseJsonVo;
    }

    public List<ProStoreOccupyRelationEntity> findStoreOccupyNum(Map<String, Object> map) {
        List list = this.proStoreOccupyRelationMapper.findAll(map);
        List proMaterialPlanEntitysA = this.proStoreOccupyRelationMapper.sumPlan();
        block0: for (ProStoreOccupyRelationEntity proStoreOccupyRelationEntity : list) {
            for (ProMaterialPlanEntity proMaterialPlanEntity : proMaterialPlanEntitysA) {
                if (!proStoreOccupyRelationEntity.getProdatetime().equals(proMaterialPlanEntity.getPantime()) || !proStoreOccupyRelationEntity.getStoreid().equals(proMaterialPlanEntity.getStoreid()) || !proStoreOccupyRelationEntity.getMatid().equals(proMaterialPlanEntity.getMatid())) continue;
                proStoreOccupyRelationEntity.setSurplusneedsumAll(proMaterialPlanEntity.getNetrequirement());
                continue block0;
            }
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    public List<ProStoreOccupyRelationEntity> proPredictSumToproStoreMaterial(BaseUser user) {
        ArrayList<ProStoreOccupyRelationEntity> storePredictMaterialOccupyDetails = new ArrayList<ProStoreOccupyRelationEntity>();
        try {
            void var10_18;
            List proPredictSumEntitys = this.proPredictSumMapper.fhindListToMaterial();
            List proPredictSumEntitysA = this.proPredictSumMapper.fhindListToMaterialPlan();
            List proStorePredictRangeEntitys = this.proStorePredictRangeMapper.loadList(null);
            LinkedList storePredictMaterialTimes = new LinkedList();
            for (Object proPredictSumEntity : proPredictSumEntitys) {
                this.getProPredictSumToproStoreMaterial((ProPredictSumEntity)proPredictSumEntity, proStorePredictRangeEntitys, storePredictMaterialTimes, proPredictSumEntitysA);
            }
            LinkedList<ProStoreOccupyRelationEntity> storePredictMaterialOccupyDetailsOld = new LinkedList<ProStoreOccupyRelationEntity>();
            for (Object storePredictMaterial : storePredictMaterialTimes) {
                Integer n = storePredictMaterial.getFreshness();
                String coverDateTime = storePredictMaterial.getCoverdatetime();
                if (n != null) {
                    for (int i = n.intValue(); i > 0; --i) {
                        String proSchedDate = DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)DateUtils.getDateFromString((String)coverDateTime, (String)"yyyyMMdd"), (int)(-i)), (String)"yyyyMMdd");
                        ProStoreOccupyRelationEntity storePredictMaterialOccupyDetail = new ProStoreOccupyRelationEntity();
                        storePredictMaterialOccupyDetail.copy((ProStoreOccupyRelationEntity)storePredictMaterial);
                        storePredictMaterialOccupyDetail.setCbatchname(proSchedDate);
                        storePredictMaterialOccupyDetailsOld.add(storePredictMaterialOccupyDetail);
                    }
                    continue;
                }
                ProStoreOccupyRelationEntity storePredictMaterialOccupyDetail = new ProStoreOccupyRelationEntity();
                storePredictMaterialOccupyDetail.copy((ProStoreOccupyRelationEntity)storePredictMaterial);
                storePredictMaterialOccupyDetailsOld.add(storePredictMaterialOccupyDetail);
            }
            List proFactoryCalendarEntitys = this.proFactoryCalendarMapper.loadList(null);
            for (ProStoreOccupyRelationEntity proStoreOccupyRelationEntity : storePredictMaterialOccupyDetailsOld) {
                if (!this.toGetProFactoryCalendarMaterial(proFactoryCalendarEntitys, proStoreOccupyRelationEntity)) continue;
                storePredictMaterialOccupyDetails.add(proStoreOccupyRelationEntity);
            }
            for (ProStoreOccupyRelationEntity proStoreOccupyRelationEntity : storePredictMaterialOccupyDetails) {
                proStoreOccupyRelationEntity.setSorid(IDGenerate.getUniqueIdStr());
                proStoreOccupyRelationEntity.setSurplusneedsum(proStoreOccupyRelationEntity.getNeedsum());
            }
            Collections.sort(storePredictMaterialOccupyDetails, new /* Unavailable Anonymous Inner Class!! */);
            List proStoreMaterialEntitys = this.proStoreMaterialMapper.findAll();
            for (ProStoreMaterialEntity proStoreMaterial : proStoreMaterialEntitys) {
                proStoreMaterial.setSurplusnum(proStoreMaterial.getInitialnum());
            }
            this.proStoreMaterialMapper.updateBatch(proStoreMaterialEntitys);
            boolean bl = false;
            while (var10_18 < storePredictMaterialOccupyDetails.size()) {
                ProStoreOccupyRelationEntity storePredictMaterialOccupyDetailA = (ProStoreOccupyRelationEntity)storePredictMaterialOccupyDetails.get((int)var10_18);
                this.getProOccupyRelationEntity(storePredictMaterialOccupyDetails, storePredictMaterialOccupyDetailA, proStoreMaterialEntitys);
                ++var10_18;
            }
            Collections.sort(storePredictMaterialOccupyDetails, new /* Unavailable Anonymous Inner Class!! */);
            this.proStoreOccupyRelationMapper.deleteAll();
            if (storePredictMaterialOccupyDetails.size() > 0) {
                this.proStoreOccupyRelationMapper.addRecordsBatch(storePredictMaterialOccupyDetails);
            }
            this.proStoreMaterialMapper.updateBatch(proStoreMaterialEntitys);
            LinkedList linkedList = new LinkedList();
            this.getProMaterialPlanEntitys(linkedList);
            Date date = new Date();
            if (linkedList.size() > 0) {
                this.proMaterialPlanMapper.deleteByPanstatus(Integer.valueOf(1));
                List findList = this.proMaterialPlanMapper.loadList(null);
                if (findList != null) {
                    List addList = this.checkCanAddProMaterialPlans(findList, linkedList);
                    if (addList.size() > 0) {
                        for (ProMaterialPlanEntity proMaterial : addList) {
                            proMaterial.setCreattime(date);
                            proMaterial.setSource("system");
                            if (user == null) continue;
                            proMaterial.setCreator(user.getUserName());
                        }
                        this.proMaterialPlanMapper.addRecordsBatch(addList);
                    }
                } else {
                    if (user != null) {
                        for (ProMaterialPlanEntity proMaterialPlan : linkedList) {
                            proMaterialPlan.setCreattime(date);
                            if (user == null) continue;
                            proMaterialPlan.setCreator(user.getUserName());
                        }
                    }
                    this.proMaterialPlanMapper.addRecordsBatch(linkedList);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return storePredictMaterialOccupyDetails;
    }

    private List<String> checkCanDeleteProMaterialPlanIds(List<ProMaterialPlanEntity> findList, List<ProMaterialPlanEntity> proMaterialPlanEntitys) {
        ArrayList<String> list = new ArrayList<String>();
        block0: for (ProMaterialPlanEntity proMaterialPlan : findList) {
            for (ProMaterialPlanEntity proMaterialPlanEntity : proMaterialPlanEntitys) {
                if (!proMaterialPlan.equals((Object)proMaterialPlanEntity) || !proMaterialPlan.getPanstatus().equals(1)) continue;
                list.add(proMaterialPlan.getPlanid());
                continue block0;
            }
        }
        return list;
    }

    private List<ProMaterialPlanEntity> checkCanAddProMaterialPlans(List<ProMaterialPlanEntity> findList, List<ProMaterialPlanEntity> proMaterialPlanEntitys) {
        ArrayList<ProMaterialPlanEntity> list = new ArrayList<ProMaterialPlanEntity>();
        for (ProMaterialPlanEntity proMaterialPlanEntity : proMaterialPlanEntitys) {
            boolean flag = true;
            for (ProMaterialPlanEntity proMaterialPlan : findList) {
                if (!proMaterialPlan.equals((Object)proMaterialPlanEntity) || proMaterialPlan.getPanstatus().equals(1)) continue;
                flag = false;
                break;
            }
            if (!flag) continue;
            proMaterialPlanEntity.setSource("system");
            list.add(proMaterialPlanEntity);
        }
        return list;
    }

    public BaseJsonVo<List<ProStoreMaterialEntity>> findList(Integer pageNo, Integer pageSize, Map<String, Object> param) {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        try {
            if (pageNo == null) {
                pageNo = 0;
            }
            if (pageSize == null) {
                pageSize = 0;
            }
            if (pageNo > 0 && pageSize > 0) {
                PageHelper.startPage((int)pageNo, (int)pageSize);
            }
            baseJsonVo.setValue((Object)this.proStoreMaterialMapper.findList(param));
        }
        catch (Exception e) {
            baseJsonVo.setStatus(500);
            baseJsonVo.setError_msg(e.getMessage());
        }
        return baseJsonVo;
    }

    private boolean toGetProFactoryCalendarMaterial(List<ProFactoryCalendarEntity> proFactoryCalendarEntitys, ProStoreOccupyRelationEntity proStoreOccupyRelationEntity) {
        List materialProdEntitys = this.materialProdMapper.loadList(null);
        boolean flag = false;
        if (proFactoryCalendarEntitys != null && proFactoryCalendarEntitys.size() > 0) {
            for (ProFactoryCalendarEntity proFactoryCalendarEntity : proFactoryCalendarEntitys) {
                if (!proStoreOccupyRelationEntity.getProdatetime().equals(proFactoryCalendarEntity.getProDay())) continue;
                String podMatClassId = this.getMatpodclassId(materialProdEntitys, proStoreOccupyRelationEntity);
                if (StringUtils.isBlank((String)podMatClassId)) {
                    flag = true;
                } else {
                    if (!StringUtils.isNotBlank((String)podMatClassId) || !proFactoryCalendarEntity.getPodMatClassId().equals(podMatClassId)) continue;
                    flag = true;
                }
                break;
            }
        } else {
            flag = true;
        }
        return flag;
    }

    private String getMatpodclassId(List<MaterialProdEntity> materialProdEntitys, ProStoreOccupyRelationEntity proStoreOccupyRelationEntity) {
        String matpodclassId = "";
        for (MaterialProdEntity materialProdEntity : materialProdEntitys) {
            if (!materialProdEntity.getCguid().equals(proStoreOccupyRelationEntity.getMatid())) continue;
            matpodclassId = materialProdEntity.getMatpodclassid();
            break;
        }
        return matpodclassId;
    }

    private void getProMaterialPlanEntitys(List<ProMaterialPlanEntity> proMaterialPlanEntitys) {
        String code = this.codingSchemeServiceClient.generateCode("016", "300846");
        Date date = new Date();
        List proMaterialPlanEntitysA = this.proStoreOccupyRelationMapper.sumPlan();
        List materialProdEntitys = this.materialProdMapper.loadList(null);
        if (proMaterialPlanEntitysA != null) {
            for (ProMaterialPlanEntity proMaterialPlanEntity : proMaterialPlanEntitysA) {
                proMaterialPlanEntity.setPlanid(IDGenerate.getUniqueIdStr());
                proMaterialPlanEntity.setPlancode(code);
                proMaterialPlanEntity.setCreattime(date);
                proMaterialPlanEntity.setPanstatus(Integer.valueOf(1));
                proMaterialPlanEntity.setSafetystock(this.toGetSafetystock(proMaterialPlanEntity, materialProdEntitys));
                proMaterialPlanEntity.setPlannum(this.toGetPlannum(proMaterialPlanEntity));
                proMaterialPlanEntity.setSource("system");
                proMaterialPlanEntitys.add(proMaterialPlanEntity);
            }
        }
        this.codingSchemeServiceClient.updategenerateCode("016", "300846");
    }

    private Integer toGetSafetystock(ProMaterialPlanEntity proMaterialPlanEntity, List<MaterialProdEntity> materialProdEntitys) {
        int num = 0;
        if (materialProdEntitys == null) {
            System.out.println("materialProdEntitys = " + materialProdEntitys);
        }
        if (materialProdEntitys != null && materialProdEntitys.size() == 0) {
            System.out.println("materialProdEntitys.size() = " + materialProdEntitys.size());
        }
        if (proMaterialPlanEntity == null) {
            System.out.println("proMaterialPlanEntity = " + proMaterialPlanEntity);
        }
        if (proMaterialPlanEntity != null && proMaterialPlanEntity.getMatid() == null) {
            System.out.println("proMaterialPlanEntity( proMaterialPlanEntity.getMatid())) = " + proMaterialPlanEntity.getMatid());
        }
        if (materialProdEntitys != null && materialProdEntitys.size() > 0 && proMaterialPlanEntity != null) {
            for (MaterialProdEntity materialProdEntity : materialProdEntitys) {
                if (materialProdEntity.getCguid() != null) {
                    if (proMaterialPlanEntity.getMatid() == null || !materialProdEntity.getCguid().equals(proMaterialPlanEntity.getMatid())) continue;
                    if (materialProdEntity.getIsafetystock() == null) break;
                    num = materialProdEntity.getIsafetystock();
                    break;
                }
                System.out.println("materialProdEntity(materialProdEntity.getCguid()) = " + materialProdEntity.getCguid());
            }
        }
        return num;
    }

    private Integer toGetPlannum(ProMaterialPlanEntity proMaterialPlanEntity) {
        int num = 0;
        if (proMaterialPlanEntity != null) {
            if (proMaterialPlanEntity.getNetrequirement() != null && proMaterialPlanEntity.getSafetystock() != null) {
                num = proMaterialPlanEntity.getNetrequirement() + proMaterialPlanEntity.getSafetystock();
            } else if (proMaterialPlanEntity.getNetrequirement() == null && proMaterialPlanEntity.getSafetystock() != null) {
                num = proMaterialPlanEntity.getSafetystock();
            } else if (proMaterialPlanEntity.getNetrequirement() != null && proMaterialPlanEntity.getSafetystock() == null) {
                num = proMaterialPlanEntity.getNetrequirement();
            }
        }
        return num;
    }

    private void getProOccupyRelationEntity(List<ProStoreOccupyRelationEntity> storePredictMaterialOccupyDetails, ProStoreOccupyRelationEntity storePredictMaterialOccupyDetailA, List<ProStoreMaterialEntity> proStoreMaterialEntitys) {
        for (ProStoreMaterialEntity proStoreMaterialEntity : proStoreMaterialEntitys) {
            if (!proStoreMaterialEntity.getMatid().equals(storePredictMaterialOccupyDetailA.getMatid()) || !proStoreMaterialEntity.getStoreid().equals(storePredictMaterialOccupyDetailA.getStoreid()) || !proStoreMaterialEntity.getCbatchname().equals(storePredictMaterialOccupyDetailA.getCbatchname())) continue;
            if (proStoreMaterialEntity.getSurplusnum() - storePredictMaterialOccupyDetailA.getSurplusneedsum() >= 0) {
                Integer agetSurplusneedsum = storePredictMaterialOccupyDetailA.getSurplusneedsum();
                storePredictMaterialOccupyDetailA.setOccupynum(agetSurplusneedsum);
                Integer surplusnum = proStoreMaterialEntity.getSurplusnum();
                storePredictMaterialOccupyDetailA.setSurplusnum(Integer.valueOf(surplusnum - agetSurplusneedsum));
                storePredictMaterialOccupyDetailA.setSurplusneedsum(Integer.valueOf(agetSurplusneedsum - storePredictMaterialOccupyDetailA.getOccupynum()));
                proStoreMaterialEntity.setSurplusnum(Integer.valueOf(surplusnum - storePredictMaterialOccupyDetailA.getOccupynum()));
                if (storePredictMaterialOccupyDetailA.getOccupynum() < 0) {
                    System.out.println(storePredictMaterialOccupyDetailA.getOccupynum());
                }
                if (proStoreMaterialEntity.getSurplusnum() < 0) {
                    System.out.println(proStoreMaterialEntity.getSurplusnum());
                }
            } else {
                Integer surplusnum = proStoreMaterialEntity.getSurplusnum();
                storePredictMaterialOccupyDetailA.setOccupynum(surplusnum);
                storePredictMaterialOccupyDetailA.setSurplusnum(Integer.valueOf(0));
                proStoreMaterialEntity.setSurplusnum(Integer.valueOf(0));
                storePredictMaterialOccupyDetailA.setSurplusneedsum(Integer.valueOf(storePredictMaterialOccupyDetailA.getSurplusneedsum() - storePredictMaterialOccupyDetailA.getOccupynum()));
            }
            this.tochangeStorePredictMaterialOccupyDetails(storePredictMaterialOccupyDetails, storePredictMaterialOccupyDetailA);
            break;
        }
    }

    private void tochangeStorePredictMaterialOccupyDetails(List<ProStoreOccupyRelationEntity> storePredictMaterialOccupyDetails, ProStoreOccupyRelationEntity storePredictMaterialOccupyDetailA) {
        for (ProStoreOccupyRelationEntity storePredictMaterialOccupy : storePredictMaterialOccupyDetails) {
            if (!storePredictMaterialOccupyDetailA.getProdatetime().equals(storePredictMaterialOccupy.getProdatetime()) || !storePredictMaterialOccupyDetailA.getMatid().equals(storePredictMaterialOccupy.getMatid()) || !storePredictMaterialOccupyDetailA.getStoreid().equals(storePredictMaterialOccupy.getStoreid()) || !storePredictMaterialOccupyDetailA.getCoverdatetime().equals(storePredictMaterialOccupy.getCoverdatetime()) || !storePredictMaterialOccupyDetailA.getFreshness().equals(storePredictMaterialOccupy.getFreshness()) || !storePredictMaterialOccupyDetailA.getNeedsum().equals(storePredictMaterialOccupy.getNeedsum())) continue;
            storePredictMaterialOccupy.setSurplusneedsum(storePredictMaterialOccupyDetailA.getSurplusneedsum());
        }
    }

    private void getProPredictSumToproStoreMaterial(ProPredictSumEntity proPredictSumEntity, List<ProStorePredictRangeEntity> proStorePredictRangeEntitys, List<ProStoreOccupyRelationEntity> storePredictMaterialTimes, List<ProPredictSumEntity> proPredictSumEntitysA) {
        Date date = new Date();
        for (ProStorePredictRangeEntity proStorePredictRangeEntity : proStorePredictRangeEntitys) {
            if (!proStorePredictRangeEntity.getStoreid().equals(proPredictSumEntity.getStoreid())) continue;
            String intervalNumDate = DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)date, (int)proStorePredictRangeEntity.getIntervalnum()), (String)"yyyyMMdd");
            LinkedList proSchedulingDates = new LinkedList();
            for (int i = 0; i < proStorePredictRangeEntity.getProscheduling(); ++i) {
                String proSchedDate = DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)DateUtils.getDateFromString((String)intervalNumDate, (String)"yyyyMMdd"), (int)i), (String)"yyyyMMdd");
                LinkedList<String> predictCoverDays = new LinkedList<String>();
                for (int b = 1; b < proStorePredictRangeEntity.getPredictcoverdays() + 1; ++b) {
                    predictCoverDays.add(DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)DateUtils.getDateFromString((String)proSchedDate, (String)"yyyyMMdd"), (int)b), (String)"yyyyMMdd"));
                }
                for (String predCoverDay : predictCoverDays) {
                    boolean flag = true;
                    for (ProPredictSumEntity proPredictSumEntityA : proPredictSumEntitysA) {
                        if (!proPredictSumEntity.getStoreid().equals(proPredictSumEntityA.getStoreid()) || !proPredictSumEntity.getMatid().equals(proPredictSumEntityA.getMatid()) || !proPredictSumEntityA.getPickupdate().equals(predCoverDay)) continue;
                        flag = false;
                        ProStoreOccupyRelationEntity storePredictMaterial = new ProStoreOccupyRelationEntity();
                        storePredictMaterial.setMatid(proPredictSumEntity.getMatid());
                        storePredictMaterial.setMatcode(proPredictSumEntity.getMatcode());
                        storePredictMaterial.setMatname(proPredictSumEntity.getMatname());
                        storePredictMaterial.setStoreid(proPredictSumEntity.getStoreid());
                        storePredictMaterial.setStorecode(proPredictSumEntity.getStorecode());
                        storePredictMaterial.setStorename(proPredictSumEntity.getStorename());
                        storePredictMaterial.setCoverdatetime(predCoverDay);
                        storePredictMaterial.setNeedsum(proPredictSumEntityA.getNeedsum());
                        storePredictMaterial.setFreshness(proPredictSumEntityA.getFreshness());
                        storePredictMaterial.setProdatetime(proSchedDate);
                        storePredictMaterialTimes.add(storePredictMaterial);
                    }
                    if (!flag) continue;
                    ProStoreOccupyRelationEntity storePredictMaterial = new ProStoreOccupyRelationEntity();
                    storePredictMaterial.setMatid(proPredictSumEntity.getMatid());
                    storePredictMaterial.setMatcode(proPredictSumEntity.getMatcode());
                    storePredictMaterial.setMatname(proPredictSumEntity.getMatname());
                    storePredictMaterial.setStoreid(proPredictSumEntity.getStoreid());
                    storePredictMaterial.setStorecode(proPredictSumEntity.getStorecode());
                    storePredictMaterial.setStorename(proPredictSumEntity.getStorename());
                    storePredictMaterial.setCoverdatetime(predCoverDay);
                    storePredictMaterial.setProdatetime(proSchedDate);
                    storePredictMaterialTimes.add(storePredictMaterial);
                }
            }
        }
    }
}

