/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.pro.service.impl;

import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.pro.dao.ProStorePredictRangeMapper;
import cc.lechun.pro.entity.ProStorePredictRangeEntity;
import cc.lechun.pro.service.ProStorePredictRangeService;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RefreshScope
@Service
public class ProStorePredictRangeServiceImpl
implements ProStorePredictRangeService {
    @Autowired
    private ProStorePredictRangeMapper proStorePredictRangeMapper;
    @Autowired
    private PlatformTransactionManager transactionManager;

    @RequestMapping(value={"/pspr/saveOrUpdateList"})
    public BaseJsonVo saveOrUpdateList(@RequestBody List<ProStorePredictRangeEntity> proStorePredictRangeEntitys) {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        TransactionStatus status = this.transactionManager.getTransaction((TransactionDefinition)def);
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        try {
            ArrayList<ProStorePredictRangeEntity> listAdd = new ArrayList<ProStorePredictRangeEntity>();
            ArrayList<ProStorePredictRangeEntity> listUpdate = new ArrayList<ProStorePredictRangeEntity>();
            if (null != proStorePredictRangeEntitys && proStorePredictRangeEntitys.size() > 0) {
                for (ProStorePredictRangeEntity proStorePredictRangeEntity : proStorePredictRangeEntitys) {
                    if (StringUtils.isNotBlank((String)proStorePredictRangeEntity.getTsprid())) {
                        proStorePredictRangeEntity.setModifytime(new Date());
                        listUpdate.add(proStorePredictRangeEntity);
                        continue;
                    }
                    proStorePredictRangeEntity.setModifytime(new Date());
                    proStorePredictRangeEntity.setTsprid(IDGenerate.getUniqueIdStr());
                    listAdd.add(proStorePredictRangeEntity);
                }
            }
            if (listAdd.size() > 0) {
                this.proStorePredictRangeMapper.addRecordsBatch(listAdd);
            }
            if (listUpdate.size() > 0) {
                this.proStorePredictRangeMapper.updateBatch(listUpdate);
            }
            this.transactionManager.commit(status);
        }
        catch (Exception e) {
            baseJsonVo.setStatus(500);
            baseJsonVo.setMessage(e.getMessage());
            this.transactionManager.rollback(status);
        }
        return baseJsonVo;
    }

    @RequestMapping(value={"/pspr/findList"})
    public BaseJsonVo<List<ProStorePredictRangeEntity>> findList(@RequestHeader(value="pageNo") Integer pageNo, @RequestHeader(value="pageSize") Integer pageSize, @RequestBody Map<String, Object> param) {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        try {
            if (pageNo == null) {
                pageNo = 0;
            }
            if (pageSize == null) {
                pageSize = 0;
            }
            if (pageNo > 0 && pageSize > 0) {
                PageHelper.startPage((int)pageNo, (int)pageSize);
            }
            baseJsonVo.setValue((Object)this.proStorePredictRangeMapper.loadList(param));
        }
        catch (Exception e) {
            baseJsonVo.setStatus(500);
            baseJsonVo.setError_msg(e.getMessage());
        }
        return baseJsonVo;
    }

    @RequestMapping(value={"/pspr/deleteByIds"})
    public BaseJsonVo deleteByIds(@RequestBody List<String> tsprid) {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        try {
            HashMap<String, List<String>> param = new HashMap<String, List<String>>();
            param.put("ids", tsprid);
            this.proStorePredictRangeMapper.deleteByParam(param);
        }
        catch (Exception e) {
            baseJsonVo.setStatus(500);
            baseJsonVo.setError_msg(e.getMessage());
        }
        return baseJsonVo;
    }
}

