/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.pro.service.impl;

import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.vo.BaseUser;
import cc.lechun.pro.dao.ProductAllocationMapper;
import cc.lechun.pro.entity.ProductAllocationEntity;
import cc.lechun.pro.entity.bo.ProductAllocationEntityBO;
import cc.lechun.pro.service.ProductAllocationService;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProductAllocationServiceImpl
implements ProductAllocationService {
    @Autowired
    private ProductAllocationMapper productAllocationMapper;

    public List<ProductAllocationEntityBO> findByParams(Integer pageNo, Integer pageSize, Map<String, Object> params) {
        if (pageNo > 0 && pageSize > 0) {
            PageHelper.startPage((int)pageNo, (int)pageSize);
        }
        return this.productAllocationMapper.getProductAllocationByParam(params);
    }

    public Boolean checkData(List<ProductAllocationEntity> addList) {
        boolean flag = true;
        for (ProductAllocationEntity item : addList) {
            List m = this.productAllocationMapper.checkData(item);
            if (m.size() <= 0) continue;
            flag = false;
        }
        return flag;
    }

    @Transactional
    public int saveOrUpdateProductAllocation(BaseUser user, List<ProductAllocationEntity> addList, List<ProductAllocationEntity> modifyList, List<String> delIds) {
        if (addList != null && addList.size() > 0) {
            ArrayList adds = new ArrayList();
            for (ProductAllocationEntity item : addList) {
                if (!StringUtils.isNotBlank((CharSequence)item.getCmatid())) continue;
                item.setCguid(IDGenerate.getUniqueIdStr());
                if (user != null) {
                    item.setTenantid(user.getCtenantid());
                    item.setMaintainer(user.getId());
                }
                item.setDdate(new Date());
                adds.add(item);
            }
            if (adds.size() > 0) {
                this.productAllocationMapper.saveProductAllocationBatch((List)adds);
            }
        }
        if (modifyList != null && modifyList.size() > 0) {
            for (ProductAllocationEntity item : modifyList) {
                if (!StringUtils.isNotBlank((CharSequence)item.getCmatid())) continue;
                if (user != null) {
                    item.setTenantid(user.getCtenantid());
                    item.setMaintainer(user.getId());
                }
                item.setDdate(new Date());
                this.productAllocationMapper.updateByPrimaryKeySelective((Object)item);
            }
        }
        if (delIds != null && delIds.size() > 0) {
            HashMap<String, List<String>> params = new HashMap<String, List<String>>();
            params.put("ids", delIds);
            this.productAllocationMapper.deleteProductAllocationByParam(params);
        }
        return 1;
    }
}

