/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.sa.entity.order.vo;

import cc.lechun.bd.entity.Warehouse;
import cc.lechun.bd.entity.base.BaseCustomerFreshnessEntity;
import cc.lechun.bd.entity.base.vo.BaseCustomerVO;
import cc.lechun.bd.entity.bo.MaterialEntityBO;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.vo.BaseUser;
import cc.lechun.sa.entity.order.SaleOrderDetailEntity;
import cc.lechun.sa.entity.order.vo.SaleOrderVO;
import cc.lechun.sa.entity.price.SalePriceEntity;
import cc.lechun.sys.entity.SystemDicDataEntity;
import cn.afterturn.easypoi.excel.annotation.Excel;
import cn.afterturn.easypoi.excel.annotation.ExcelTarget;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ExcelTarget(value="ExceImportOrderTobVO")
public class ExceImportOrderTobVO
implements Serializable {
    @Excel(name="\u5916\u90e8\u8ba2\u5355\u53f7(\u5fc5\u586b)")
    private String outerorderno;
    @Excel(name="\u5ba2\u6237\u540d\u79f0(\u5fc5\u586b)")
    private String custName;
    @Excel(name="\u7701(\u5fc5\u586b)")
    private String provincename;
    @Excel(name="\u5e02\u533a(\u5fc5\u586b)")
    private String cityname;
    @Excel(name="\u533a(\u5fc5\u586b)")
    private String areaname;
    @Excel(name="\u6536\u8d27\u5730\u5740(\u5fc5\u586b)")
    private String cdeliveryaddresses;
    @Excel(name="\u8054\u7cfb\u4eba(\u5fc5\u586b)")
    private String ccontacts;
    @Excel(name="\u8054\u7cfb\u4eba\u7535\u8bdd(\u5fc5\u586b)")
    private String ccontactnumber;
    @Excel(name="\u63d0\u8d27\u65e5\u671f(2019-03-12)(\u5fc5\u586b)")
    private Date pickupdate;
    @Excel(name="\u4ed3\u5e93\u540d\u79f0(\u5fc5\u586b)")
    private String storeName;
    @Excel(name="\u5907\u6ce8")
    private String cremark;
    @Excel(name="\u4e70\u5bb6\u7559\u8a00")
    private String buyermessage;
    @Excel(name="\u7269\u54c1\u7f16\u7801(\u5fc5\u586b)")
    private String productCode;
    @Excel(name="\u7269\u54c1\u540d\u79f0")
    private String productName;
    @Excel(name="\u65b0\u9c9c\u5ea6(\u6574\u6570)(\u5fc5\u586b)")
    private Integer freshness;
    @Excel(name="\u6570\u91cf(\u6574\u6570)(\u5fc5\u586b)")
    private BigDecimal iqty;
    private BigDecimal unitPrice;
    @Excel(name="\u603b\u4ef7(\u542b\u7a0e\u6570\u5b57)")
    private BigDecimal itaxAmont;
    @Excel(name="\u9500\u552e\u7c7b\u578b(\u5fc5\u586b)")
    private String salestype;
    @Excel(name="\u8d60\u54c1(\u5fc5\u586b)")
    private String ifGifts;

    public String getOuterorderno() {
        return this.outerorderno;
    }

    public void setOuterorderno(String outerorderno) {
        this.outerorderno = outerorderno == null ? null : outerorderno.trim();
    }

    public String getCustName() {
        return this.custName;
    }

    public void setCustName(String custName) {
        this.custName = custName == null ? null : custName.trim();
    }

    public String getProvincename() {
        return this.provincename;
    }

    public void setProvincename(String provincename) {
        this.provincename = provincename == null ? null : provincename.trim();
    }

    public String getCityname() {
        return this.cityname;
    }

    public void setCityname(String cityname) {
        this.cityname = cityname == null ? null : cityname.trim();
    }

    public String getAreaname() {
        return this.areaname;
    }

    public void setAreaname(String areaname) {
        this.areaname = areaname == null ? null : areaname.trim();
    }

    public String getCdeliveryaddresses() {
        return this.cdeliveryaddresses;
    }

    public void setCdeliveryaddresses(String cdeliveryaddresses) {
        this.cdeliveryaddresses = cdeliveryaddresses == null ? null : cdeliveryaddresses.trim();
    }

    public String getCcontacts() {
        return this.ccontacts;
    }

    public void setCcontacts(String ccontacts) {
        this.ccontacts = ccontacts == null ? null : ccontacts.trim();
    }

    public String getCcontactnumber() {
        return this.ccontactnumber;
    }

    public void setCcontactnumber(String ccontactnumber) {
        this.ccontactnumber = ccontactnumber == null ? null : ccontactnumber.trim();
    }

    public Date getPickupdate() {
        return this.pickupdate;
    }

    public void setPickupdate(Date pickupdate) {
        this.pickupdate = pickupdate;
    }

    public String getStoreName() {
        return this.storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName == null ? null : storeName.trim();
    }

    public String getCremark() {
        return this.cremark;
    }

    public void setCremark(String cremark) {
        this.cremark = cremark == null ? null : cremark.trim();
    }

    public String getBuyermessage() {
        return this.buyermessage;
    }

    public void setBuyermessage(String buyermessage) {
        this.buyermessage = buyermessage == null ? null : buyermessage.trim();
    }

    public String getProductCode() {
        return this.productCode;
    }

    public void setProductCode(String productCode) {
        this.productCode = productCode == null ? null : productCode.trim();
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName == null ? null : productName.trim();
    }

    public Integer getFreshness() {
        return this.freshness;
    }

    public void setFreshness(Integer freshness) {
        this.freshness = freshness;
    }

    public BigDecimal getIqty() {
        return this.iqty;
    }

    public void setIqty(BigDecimal iqty) {
        this.iqty = iqty;
    }

    public BigDecimal getUnitPrice() {
        return this.unitPrice;
    }

    public void setUnitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
    }

    public BigDecimal getItaxAmont() {
        return this.itaxAmont;
    }

    public void setItaxAmont(BigDecimal itaxAmont) {
        this.itaxAmont = itaxAmont;
    }

    public String getSalestype() {
        return this.salestype;
    }

    public void setSalestype(String salestype) {
        this.salestype = salestype == null ? null : salestype.trim();
    }

    public String getIfGifts() {
        return this.ifGifts;
    }

    public void setIfGifts(String ifGifts) {
        this.ifGifts = ifGifts;
    }

    public static SaleOrderVO buildOrder(String billCode, ExceImportOrderTobVO voExce, Map<String, BaseCustomerVO> customersMapByName, Map<String, Warehouse> warehousesMapByName, Map<String, SystemDicDataEntity> salesTypeMapByName, BaseUser user, Map<String, BaseCustomerFreshnessEntity> customerFreshnessMap) {
        SaleOrderVO vo = new SaleOrderVO();
        vo.setBillCode(billCode);
        vo.setExternalBillCode(voExce.getOuterorderno());
        BaseCustomerVO cust = customersMapByName.get(voExce.getCustName());
        vo.setCustomerId(cust.getCustomerId());
        vo.setDepartmentId(cust.getDepartmentId());
        vo.setEmployeeId(cust.getEmployeeId());
        SystemDicDataEntity systemDicDataEntity = salesTypeMapByName.get(voExce.getSalestype());
        vo.setSaleType(voExce.getSalestype());
        vo.setSaleTypeCode(systemDicDataEntity.getDicNo());
        Warehouse store = warehousesMapByName.get(voExce.getStoreName());
        vo.setStoreId(store.getCguid());
        vo.setRemark(voExce.getCremark());
        vo.setPickupDate(voExce.getPickupdate());
        String keyFreshness = cust.getCustomerId() + "|" + store.getCguid();
        vo.setArriveDate(DateUtils.getAddDateByDay((Date)vo.getPickupDate(), (int)customerFreshnessMap.get(keyFreshness).getDuration()));
        vo.setStatus(new Short("0"));
        vo.setCreator(user.getEmployeeName());
        vo.setCreateTime(new Date());
        vo.setConsigneeName(voExce.getCcontacts());
        vo.setConsigneeMobile(voExce.getCcontactnumber());
        vo.setConsigneeRemark(voExce.getBuyermessage());
        vo.setConsigneeProvince(voExce.getProvincename());
        vo.setConsigneeCity(voExce.getCityname());
        vo.setConsigneeArea(voExce.getAreaname());
        vo.setConsigneeAddress(voExce.getCdeliveryaddresses());
        vo.setType(new Short("0"));
        return vo;
    }

    public static SaleOrderDetailEntity buildOrderDetail(ExceImportOrderTobVO voExce, Map<String, MaterialEntityBO> matMapByCode, Map<String, SalePriceEntity> salePriceMap) {
        MaterialEntityBO mat = matMapByCode.get(voExce.getProductCode());
        SaleOrderDetailEntity deail = new SaleOrderDetailEntity();
        deail.setMaterialId(mat.getCguid());
        deail.setUnitId(mat.getCunitid());
        deail.setTaxRate(mat.getItaxrate());
        deail.setQuantity(voExce.getIqty());
        deail.setIsGift(voExce.getIfGifts());
        deail.setFreshness(voExce.getFreshness());
        if (deail.getIsGift().equals("\u5426")) {
            String keyA = voExce.getCustName() + "|" + voExce.getProductCode() + "|" + DateUtils.formatDate((Date)voExce.getPickupdate(), (String)"yyyyMMdd");
            SalePriceEntity salePrice = salePriceMap.get(keyA);
            deail.setRetailPrice(salePrice.getRetailPrice());
            deail.setContractPrice(salePrice.getContractPrice());
            deail.setActivityPrice(salePrice.getActivityPrice());
            BigDecimal total = (deail.getActivityPrice() == null || deail.getActivityPrice().doubleValue() == 0.0 ? deail.getContractPrice() : deail.getActivityPrice()).multiply(deail.getQuantity()).setScale(6, 1);
            deail.setTotalAmount(total);
            deail.setAmount(deail.getTotalAmount().divide(new BigDecimal(1).add(deail.getTaxRate().divide(new BigDecimal(100))), 6, 1));
            deail.setTaxAmount(deail.getTotalAmount().subtract(deail.getAmount()));
        }
        return deail;
    }
}

