/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.sys.entity.util.domain.print;

import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.layout.Document;

public abstract class PDFPrinter {
    private float width = 0.0f;
    private float height = 0.0f;
    private float topMargin = 0.0f;
    private float rightMargin = 0.0f;
    private float bottomMargin = 0.0f;
    private float leftMargin = 0.0f;

    public PDFPrinter() {
    }

    public PDFPrinter(float width, float height, float topMargin, float rightMargin, float bottomMargin, float leftMargin) {
        this.width = width;
        this.height = height;
        this.topMargin = topMargin;
        this.rightMargin = rightMargin;
        this.bottomMargin = bottomMargin;
        this.leftMargin = leftMargin;
    }

    public PDFPrinter setMargins(Document document, float topMargin, float rightMargin, float bottomMargin, float leftMargin) {
        this.setTopMargin(topMargin);
        this.setRightMargin(rightMargin);
        this.setBottomMargin(bottomMargin);
        this.setLeftMargin(leftMargin);
        if (document == null) {
            throw new NullPointerException("\u9700\u8981\u5148\u5b9e\u4f8b\u5316#com.itextpdf.layout.Document\u5bf9\u8c61");
        }
        document.setMargins(this.getTopMargin(), this.getRightMargin(), this.getBottomMargin(), this.getLeftMargin());
        return this;
    }

    public PDFPrinter setArea(Document document, float width, float height) {
        this.setWidth(width);
        this.setHeight(height);
        if (document == null) {
            throw new NullPointerException("\u9700\u8981\u5148\u5b9e\u4f8b\u5316#com.itextpdf.layout.Document\u5bf9\u8c61");
        }
        ((Document)document.setWidth(this.getWidth())).setHeight(this.getHeight());
        return this;
    }

    public PDFPrinter setFont(Document document, PdfFont font) {
        if (document == null) {
            throw new NullPointerException("\u9700\u8981\u5148\u5b9e\u4f8b\u5316#com.itextpdf.layout.Document\u5bf9\u8c61");
        }
        document.setFont(font);
        return this;
    }

    public float getWidth() {
        return this.width;
    }

    public PDFPrinter setWidth(float width) {
        this.width = width;
        return this;
    }

    public float getHeight() {
        return this.height;
    }

    public PDFPrinter setHeight(float height) {
        this.height = height;
        return this;
    }

    public float getTopMargin() {
        return this.topMargin;
    }

    public PDFPrinter setTopMargin(float topMargin) {
        this.topMargin = topMargin;
        return this;
    }

    public float getRightMargin() {
        return this.rightMargin;
    }

    public PDFPrinter setRightMargin(float rightMargin) {
        this.rightMargin = rightMargin;
        return this;
    }

    public float getBottomMargin() {
        return this.bottomMargin;
    }

    public PDFPrinter setBottomMargin(float bottomMargin) {
        this.bottomMargin = bottomMargin;
        return this;
    }

    public float getLeftMargin() {
        return this.leftMargin;
    }

    public PDFPrinter setLeftMargin(float leftMargin) {
        this.leftMargin = leftMargin;
        return this;
    }
}

