/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.sys.util;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import java.io.OutputStream;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyBigDataExport<T> {
    private Logger log = LoggerFactory.getLogger(MyBigDataExport.class);

    public void export(HttpServletRequest request, HttpServletResponse response, Class<T> pojoClass, MyExportMehtod<T> myExportMehtod, String filename) {
        try {
            Workbook workbook = null;
            filename = StringUtils.isBlank((CharSequence)filename) ? "export.xlsx" : filename + ".xlsx";
            response.setHeader("content-Type", "application/vnd.ms-excel");
            response.setHeader("Content-disposition", "attachment;filename=" + filename);
            ExportParams exportParams = new ExportParams();
            exportParams.setType(ExcelType.XSSF);
            boolean flag = true;
            int start = 0;
            int rows = 10000;
            while (flag) {
                List<T> list = myExportMehtod.getMyBigData(request, start * rows, rows);
                this.log.info("\u7b2c" + start + "\u9875\u6570\u636e \u6bcf\u9875\u6240" + rows + "\u6761,\u5b9e\u9645\u6bcf\u9875\u591a" + (list != null ? list.size() : 0) + "\u6761");
                if (list == null || list.size() == 0) {
                    flag = false;
                    break;
                }
                workbook = ExcelExportUtil.exportBigExcel((ExportParams)exportParams, pojoClass, list);
                list.clear();
                ++start;
            }
            workbook.write((OutputStream)response.getOutputStream());
            ExcelExportUtil.closeExportBigExcel();
        }
        catch (Exception e) {
            this.log.error("\u5bfc\u51fa\u5f02\u5e38\uff1a{}", (Throwable)e);
            ExcelExportUtil.closeExportBigExcel();
        }
    }

    public static interface MyExportMehtod<T> {
        public List<T> getMyBigData(HttpServletRequest var1, int var2, int var3);
    }
}

