/*
 * Decompiled with CFR 0.152.
 */
package weixin.popular.util;

import java.util.Arrays;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import weixin.popular.util.MapUtil;
import weixin.popular.util.StringUtils;

public class SignatureUtil {
    private static final Logger log = LoggerFactory.getLogger(SignatureUtil.class);

    public static String generateSign(Map<String, String> map, String paternerKey) {
        return SignatureUtil.generateSign(map, null, paternerKey);
    }

    public static String generateSign(Map<String, String> map, String sign_type, String paternerKey) {
        Map<String, String> tmap = MapUtil.order(map);
        if (tmap.containsKey("sign")) {
            tmap.remove("sign");
        }
        String str = MapUtil.mapJoin(tmap, false, false);
        if (sign_type == null) {
            sign_type = tmap.get("sign_type");
        }
        if ("HMAC-SHA256".equalsIgnoreCase(sign_type)) {
            try {
                Mac sha256_HMAC = Mac.getInstance("HmacSHA256");
                SecretKeySpec secret_key = new SecretKeySpec(paternerKey.getBytes("UTF-8"), "HmacSHA256");
                sha256_HMAC.init(secret_key);
                return Hex.encodeHexString((byte[])sha256_HMAC.doFinal((str + "&key=" + paternerKey).getBytes("UTF-8"))).toUpperCase();
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
                return null;
            }
        }
        return DigestUtils.md5Hex((String)(str + "&key=" + paternerKey)).toUpperCase();
    }

    public static String generateEventMessageSignature(String token, String timestamp, String nonce) {
        Object[] array = new String[]{token, timestamp, nonce};
        Arrays.sort(array);
        String s = StringUtils.arrayToDelimitedString(array, "");
        return DigestUtils.shaHex((String)s);
    }

    public static boolean validateSign(Map<String, String> map, String key) {
        return SignatureUtil.validateSign(map, null, key);
    }

    public static boolean validateSign(Map<String, String> map, String sign_type, String key) {
        if (map.get("sign") == null) {
            return false;
        }
        return map.get("sign").equals(SignatureUtil.generateSign(map, sign_type, key));
    }
}

