/*
 * Decompiled with CFR 0.152.
 */
package weixin.popular.api;

import com.alibaba.fastjson.JSON;
import com.wechat.pay.contrib.apache.httpclient.Credentials;
import com.wechat.pay.contrib.apache.httpclient.Validator;
import com.wechat.pay.contrib.apache.httpclient.WechatPayHttpClientBuilder;
import com.wechat.pay.contrib.apache.httpclient.auth.AutoUpdateCertificatesVerifier;
import com.wechat.pay.contrib.apache.httpclient.auth.PrivateKeySigner;
import com.wechat.pay.contrib.apache.httpclient.auth.Signer;
import com.wechat.pay.contrib.apache.httpclient.auth.Verifier;
import com.wechat.pay.contrib.apache.httpclient.auth.WechatPay2Credentials;
import com.wechat.pay.contrib.apache.httpclient.auth.WechatPay2Validator;
import com.wechat.pay.contrib.apache.httpclient.util.PemUtil;
import com.wechat.pay.contrib.apache.httpclient.util.RsaCryptoUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import weixin.popular.api.BaseAPI;
import weixin.popular.bean.BaseResult;
import weixin.popular.bean.payservice.StaffInfo;
import weixin.popular.bean.payservice.StaffResult;
import weixin.popular.client.LocalHttpClient;

public class PayServiceAPI
extends BaseAPI {
    private static String mchId = "10186975";
    private static String mchSerialNo = "580ADCCE4926323141B52216441B66C9572AA36F";
    private static String apiV3Key = "";
    private static String privateKey = "MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQC6/xE90KRsIJyzQgX7C2eIAntffSx2d9yzcBta5va9knDKaVeg4Zbin2Rb40uoRqDa44IINunqAZfDsOL54T9ZqE4PbInRv49Jm5kw34iO2fPckMzQy2x3r59XQJUsBEWwzrZzYnf/FKFk98pCy6ZBT69keSktGXXFR7seQCIfjVa5Uqt6AMHO2jsVSVk5iZc3FHrYR5yhOtB+X8POebwj5YAlxcpQ4XmPWamwAm18WGfbHXyoccmb57II72kz67CPUbCqW3j8Ef/G4xvJXu0eswr1o0MOkcCzTJDW2OaFBDpenR+wMkhayVh3qeseOPAPIif2DqhN6Y02Om+KywS/AgMBAAECggEBAKfD4QcRYgJ0O8IDcPQq5ia6+07PMY3TuZju8kvavPGVKUYfvnNjEQiesd5SjPUa8IOQ639NLQ05gpwZ3XkL4dchTW8/FGKutvH1/DlBwvVOix+OdYK5jsXONWmFUo/cAV5ABqZ8aGXcb3Pzb23/4VflEtlUbmG83tEwqqrYJQUiMpEtjgdr4k1qLZk++aGDP6vEC8Qr49pMpTAWC+aIjjMibW6Km+OmhK5lImHIAE4bHtLwzMla6o48D6Oy4TxDfNgtpy1B/HHG8oLCRowWoFMibCNxFgef6JfIJmWOy5G/7OpFnlDIsAGCECjc1ZuFcHcGUtHgvRQMJnWMfVjz58kCgYEA6TMrWQ0+Xc+Dzm31WyRhzoViWmaxjkR3Q+NWAkJpW49zWbslovsXXQ45JIB/TVxN0zaL56as8+ZVMsIhyC1OuCkKTeGzIxD2PInTis8kM6zNX7myxwEpkGk2sfYibFHUOocUx078yLnk4ErTe/2KvB2c+tuT4nJbyR8aR6TfOCMCgYEAzUd0vAsb6MiGASXnbmrJC5aep0swpvWRgukXMUNQ4wIwbcqJ9IyidVa1CPD2JM4h+YuyNR5vygo8m2m2B+M5sNW6vP1YGz7TIyUBjuu5v944cxldFD8WAs8qWvDemTuNvMFUVImrnAP2Vc9EQaUE3T/o71QaE23EgHYmrbThnLUCgYB3fbWver7DOOqz4tn+6qSHOweLhOVkHabzDVDr9XWg6d9UUjXVzk1JbFlRX9pbHHnwSRnlCB3FF/f9+0VuGfElIjpab9TnmfBiUsknbj6BkADoFPILUIgorBDPnWxEDqXtm3vFKK8Ud1RUrWKyPNdSzuW6ELs1JB3t71b68PtD+wKBgCpYViVAKWawjqwH9KCbWJOSY3HhGc0nFPgrOwSHfVUGq5TKVgDjTdPkqf2JL01SVEHU5lL8z1SfHfd1K/6eidUHkbjQje8423cBeDvSNoP0xDJCBihaByFXOMZ/r3tuhINuYgX6TDMnwhXbZpof/0vglh1gfOyLFSDmvn3QtUWNAoGBAKjnAkdHdqDhVEKpkPkVxG4kf9aVOJnTf32bvY1zJJEsMQfRy4yYlI2KlS0xAD+Vl9zsxyLdkdn7ySN8YkkbpuQ5Z75l//w43LevK1NRoQHExmGHLQBreQsOb78F6F8HTj9xOKxGpWyBEqO8x7fjwXA+HNJMsfXKfgYSipqukijm";
    private static CloseableHttpClient httpClient;
    private static AutoUpdateCertificatesVerifier verifier;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StaffResult register(String store_id, String corpid, String name, String mobile, String qr_code, String sub_mchid, String avatar, String userid, String certPath) throws Exception {
        logger.info("\u63a5\u6536\u53c2\u6570:store_id={},corpid={},name={},mobile={},qr_code={},sub_mchid={},avatar={},userid={},certPath={}", new Object[]{store_id, corpid, name, mobile, qr_code, sub_mchid, avatar, userid, certPath});
        PrivateKey merchantPrivateKey = PemUtil.loadPrivateKey((InputStream)new ByteArrayInputStream(privateKey.getBytes("utf-8")));
        verifier = new AutoUpdateCertificatesVerifier((Credentials)new WechatPay2Credentials(mchId, (Signer)new PrivateKeySigner(mchSerialNo, merchantPrivateKey)), apiV3Key.getBytes("utf-8"));
        httpClient = WechatPayHttpClientBuilder.create().withMerchant(mchId, mchSerialNo, merchantPrivateKey).withValidator((Validator)new WechatPay2Validator((Verifier)verifier)).build();
        X509Certificate wechatpayCertificate = verifier.getValidCertificate();
        try {
            name = RsaCryptoUtil.encryptOAEP((String)name, (X509Certificate)wechatpayCertificate);
            System.out.println("\u52a0\u5bc6\u540e\u7684name:" + name);
            mobile = RsaCryptoUtil.encryptOAEP((String)mobile, (X509Certificate)wechatpayCertificate);
            System.out.println("\u52a0\u5bc6\u540e\u7684mobile:" + mobile);
        }
        catch (IllegalBlockSizeException e) {
            e.printStackTrace();
        }
        logger.info("name={}", (Object)name);
        logger.info("mobile={}", (Object)mobile);
        verifier = new AutoUpdateCertificatesVerifier((Credentials)new WechatPay2Credentials(sub_mchid, (Signer)new PrivateKeySigner(mchSerialNo, merchantPrivateKey)), apiV3Key.getBytes("utf-8"));
        httpClient = WechatPayHttpClientBuilder.create().withMerchant(mchId, mchSerialNo, merchantPrivateKey).withValidator((Validator)new WechatPay2Validator((Verifier)verifier)).build();
        String url = "https://api.mch.weixin.qq.com/v3/smartguide/guides";
        HttpPost httpPost = new HttpPost(url);
        httpPost.addHeader("Accept", "application/json");
        httpPost.addHeader("Wechatpay-Serial", mchSerialNo);
        String data = "{\n  \"store_id\" : " + store_id + ",\n  \"corpid\" : \"" + corpid + "\",\n  \"name\" : \"" + name + "\",\n  \"mobile\" : \"" + mobile + "\",\n  \"qr_code\" : \"" + qr_code + "\",\n  \"sub_mchid\" : \"" + sub_mchid + "\",\n  \"avatar\" : \"" + avatar + "\",\n  \"userid\" : \"" + userid + "\"\n}";
        logger.info("\u53c2\u6570:{}", (Object)data);
        StringEntity reqEntity = new StringEntity(data, ContentType.create((String)"application/json", (String)"utf-8"));
        logger.info("\u7f16\u7801\u540e\u7684\u53c2\u6570:{}", (Object)data);
        httpPost.setEntity((HttpEntity)reqEntity);
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
        String result = "";
        StaffResult staffResult = new StaffResult();
        try {
            if (response.getStatusLine().getStatusCode() == 200) {
                result = EntityUtils.toString((HttpEntity)response.getEntity());
                staffResult.setGuide_id(result);
                logger.info("\u670d\u52a1\u4eba\u5458\u6ce8\u518c V3 url={} result={} ", (Object)url, (Object)result);
            } else {
                result = EntityUtils.toString((HttpEntity)response.getEntity());
                logger.info("\u5fae\u4fe1\u652f\u4ed8V3 url={} result={} response.getEntity()={}", new Object[]{url, result, JSON.toJSONString((Object)response.getEntity())});
            }
        }
        catch (Exception e) {
            logger.error("\u5fae\u4fe1\u652f\u4ed8V3 \u8bf7\u6c42url={} \u53c2\u6570={} \u5f02\u5e38 e={}", new Object[]{url, JSON.toJSONString((Object)data), e.getMessage()});
            e.printStackTrace();
        }
        finally {
            response.close();
        }
        return staffResult;
    }

    public static BaseResult assign(String guide_id, String sub_mchid, String out_trade_no) {
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.mch.weixin.qq.com" + "/v3/smartguide/guides/{guide_id}/assign".replace("{guide_id}", guide_id)).addParameter("sub_mchid", sub_mchid).addParameter("out_trade_no", out_trade_no).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, BaseResult.class);
    }

    public static StaffInfo getStaff(String access_token, String userId) {
        logger.info("\u67e5\u627e\u5458\u5de5\u4fe1\u606f:{}", (Object)("https://qyapi.weixin.qq.com/cgi-bin/user/get?access_token=" + access_token + "&userid=" + userId));
        HttpUriRequest httpUriRequest = RequestBuilder.get().setUri("https://qyapi.weixin.qq.com/cgi-bin/user/get?access_token=" + access_token + "&userid=" + userId).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, StaffInfo.class);
    }

    public static X509Certificate getX509Certificate(InputStream inputStream) {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X509");
            X509Certificate cert = (X509Certificate)cf.generateCertificate(inputStream);
            cert.checkValidity();
            logger.info("\u8f93\u51fa\u8bc1\u4e66\u4fe1\u606f:\n" + cert.toString());
            logger.info("\u8bc1\u4e66\u5e8f\u5217\u53f7:" + cert.getSerialNumber().toString(16));
            logger.info("\u7248\u672c\u53f7:" + cert.getVersion());
            logger.info("\u7b7e\u53d1\u8005\uff1a" + cert.getIssuerDN());
            logger.info("\u6709\u6548\u8d77\u59cb\u65e5\u671f\uff1a" + cert.getNotBefore());
            logger.info("\u6709\u6548\u7ec8\u6b62\u65e5\u671f\uff1a" + cert.getNotAfter());
            logger.info("\u4e3b\u4f53\u540d\uff1a" + cert.getSubjectDN());
            logger.info("\u7b7e\u540d\u7b97\u6cd5\uff1a" + cert.getSigAlgName());
            logger.info("\u7b7e\u540d\uff1a" + cert.getSignature().toString());
            return cert;
        }
        catch (CertificateExpiredException e) {
            e.printStackTrace();
            throw new RuntimeException("\u8bc1\u4e66\u5df2\u8fc7\u671f", e);
        }
        catch (CertificateNotYetValidException e) {
            e.printStackTrace();
            throw new RuntimeException("\u8bc1\u4e66\u5c1a\u672a\u751f\u6548", e);
        }
        catch (CertificateException e) {
            e.printStackTrace();
            throw new RuntimeException("\u65e0\u6548\u7684\u8bc1\u4e66", e);
        }
    }

    public static String rsaEncryptOAEP(String message, X509Certificate certificate) throws IllegalBlockSizeException, IOException {
        try {
            Cipher cipher = Cipher.getInstance("RSA/ECB/OAEPWithSHA-1AndMGF1Padding");
            cipher.init(1, certificate.getPublicKey());
            byte[] data = message.getBytes("utf-8");
            byte[] cipherdata = cipher.doFinal(data);
            return Base64.getEncoder().encodeToString(cipherdata);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new RuntimeException("\u5f53\u524dJava\u73af\u5883\u4e0d\u652f\u6301RSA v1.5/OAEP", e);
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException("\u65e0\u6548\u7684\u8bc1\u4e66", e);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new IllegalBlockSizeException("\u52a0\u5bc6\u539f\u4e32\u7684\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7214\u5b57\u8282");
        }
    }
}

