/*
 * Decompiled with CFR 0.152.
 */
package weixin.popular.api.qy;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.StringEntity;
import weixin.popular.api.API;
import weixin.popular.api.BaseAPI;
import weixin.popular.api.qy.WxApiConst;
import weixin.popular.bean.BaseResult;
import weixin.popular.bean.qy.tag.TagGroupResult;
import weixin.popular.bean.qy.tag.UserTagInfo;
import weixin.popular.bean.qy.tag.WxTag;
import weixin.popular.client.LocalHttpClient;
import weixin.popular.util.HttpClientUtil;
import weixin.popular.util.JsonUtil;

public class WxApiUtils
extends BaseAPI
implements WxApiConst {
    private static final String CONST_ACCESS_TOKEN_INVALID = "-1";
    private static Map<String, String> map = new HashMap<String, String>(0);

    public static String getAccessToken(String wxCorpId, String secret) {
        String accessTokenUrl = "https://qyapi.weixin.qq.com/cgi-bin/gettoken?corpid=" + wxCorpId + "&corpsecret=" + secret;
        String respJson = HttpClientUtil.doGet(accessTokenUrl);
        JSONObject jsonObject = JSON.parseObject((String)respJson);
        int errCode = jsonObject.getIntValue("errcode");
        if (errCode == 0) {
            return jsonObject.getString("access_token");
        }
        return null;
    }

    public static String requestDepartmentListApi(String access_token) {
        String key;
        String url = "https://qyapi.weixin.qq.com/cgi-bin/department/list?access_token=" + access_token;
        String respJson = WxApiUtils.doGetResult(url, key = "department");
        if (CONST_ACCESS_TOKEN_INVALID.equals(respJson)) {
            url = "https://qyapi.weixin.qq.com/cgi-bin/department/list?access_token=" + access_token;
            respJson = WxApiUtils.doGetResult(url, key);
        }
        return respJson;
    }

    public static String requestUserListApi(String access_token, int wxDepartmentId) {
        String key;
        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/list?access_token=" + access_token + "&department_id=" + wxDepartmentId + "&fetch_child=0";
        String respJson = WxApiUtils.doGetResult(url, key = "userlist");
        if (CONST_ACCESS_TOKEN_INVALID.equals(respJson)) {
            url = "https://qyapi.weixin.qq.com/cgi-bin/user/list?access_token=" + access_token + "&department_id=" + wxDepartmentId + "&fetch_child=0";
            respJson = WxApiUtils.doGetResult(url, key);
        }
        return respJson;
    }

    public static String requestWxUserIdApi(String access_token, int agentId, String code) {
        String key;
        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/getuserinfo?access_token=" + access_token + "&code=" + code;
        String respJson = WxApiUtils.doGetResult(url, key = "UserId");
        if (CONST_ACCESS_TOKEN_INVALID.equals(respJson)) {
            url = "https://qyapi.weixin.qq.com/cgi-bin/user/list?access_token=" + access_token + "&code=" + code;
            respJson = WxApiUtils.doGetResult(url, key);
        }
        return respJson;
    }

    public static String requestFollowUserListApi(String access_token) {
        String key;
        String url = "https://qyapi.weixin.qq.com/cgi-bin/externalcontact/get_follow_user_list?access_token=" + access_token;
        String respJson = WxApiUtils.doGetResult(url, key = "follow_user");
        if (CONST_ACCESS_TOKEN_INVALID.equals(respJson)) {
            url = "https://qyapi.weixin.qq.com/cgi-bin/externalcontact/get_follow_user_list?access_token=" + access_token;
            respJson = WxApiUtils.doGetResult(url, key);
        }
        return respJson;
    }

    public static String getUserBehaviorData(String access_token, String wxUserId) {
        String reqUrl = "https://qyapi.weixin.qq.com/cgi-bin/externalcontact/get_user_behavior_data?access_token=" + access_token;
        long endTime = System.currentTimeMillis();
        long startTime = endTime - 86400000L;
        JSONObject reqJson = new JSONObject();
        reqJson.put("userid", (Object)new String[]{wxUserId});
        reqJson.put("start_time", (Object)(startTime / 1000L));
        reqJson.put("end_time", (Object)(endTime / 1000L));
        String paramJson = reqJson.toJSONString();
        String key = "behavior_data";
        String respJson = WxApiUtils.doPostResult(reqUrl, key, paramJson);
        if (CONST_ACCESS_TOKEN_INVALID.equals(respJson)) {
            reqUrl = "https://qyapi.weixin.qq.com/cgi-bin/externalcontact/get_user_behavior_data?access_token=" + access_token;
            respJson = WxApiUtils.doPostResult(reqUrl, key, paramJson);
        }
        return respJson;
    }

    public static TagGroupResult requestGetAllTag(String access_token) {
        return WxApiUtils.requestGetTagDetail(access_token, null);
    }

    public static TagGroupResult requestGetTagDetail(String access_token, String wxTagId) {
        String reqUrl = "https://qyapi.weixin.qq.com/cgi-bin/externalcontact/get_corp_tag_list?access_token=" + access_token;
        String paramJson = "";
        if (wxTagId != null & wxTagId != "") {
            JSONObject reqJson = new JSONObject();
            reqJson.put("tag_id", (Object)new String[]{wxTagId});
            paramJson = reqJson.toJSONString();
        }
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://qyapi.weixin.qq.com/cgi-bin/externalcontact/get_corp_tag_list").addParameter("access_token", API.accessToken(access_token)).setEntity((HttpEntity)new StringEntity(JsonUtil.toJSONString(paramJson), Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, TagGroupResult.class);
    }

    public static void requestEditTag(String access_token, String wxTagId, String tagName) {
        String reqUrl = "https://qyapi.weixin.qq.com/cgi-bin/externalcontact/edit_corp_tag?access_token=" + access_token;
        JSONObject reqJson = new JSONObject();
        reqJson.put("id", (Object)wxTagId);
        reqJson.put("name", (Object)tagName);
        String paramJson = reqJson.toJSONString();
        String respJson = WxApiUtils.doPostResult(reqUrl, null, paramJson);
        if (CONST_ACCESS_TOKEN_INVALID.equals(respJson)) {
            reqUrl = "https://qyapi.weixin.qq.com/cgi-bin/externalcontact/edit_corp_tag?access_token=" + access_token;
            WxApiUtils.doPostResult(reqUrl, null, paramJson);
        }
    }

    public static void requestDelGroupTag(String access_token, String wxTagGroupId) {
        WxApiUtils.requestDelTag(access_token, wxTagGroupId, true);
    }

    public static void requestDelTag(String access_token, String wxTagGroupId) {
        WxApiUtils.requestDelTag(access_token, wxTagGroupId, false);
    }

    public static BaseResult requestDelTag(String access_token, String wxTagId, boolean isGroup) {
        String reqUrl = "https://qyapi.weixin.qq.com/cgi-bin/externalcontact/del_corp_tag?access_token=" + access_token;
        String key = isGroup ? "group_id" : "tag_id";
        JSONObject reqJson = new JSONObject();
        reqJson.put(key, (Object)new String[]{wxTagId});
        String paramJson = reqJson.toJSONString();
        String respJson = WxApiUtils.doPostResult(reqUrl, null, paramJson);
        BaseResult baseResult = (BaseResult)JSON.parseObject((String)respJson, BaseResult.class);
        if (baseResult.isSuccess()) {
            reqUrl = "https://qyapi.weixin.qq.com/cgi-bin/externalcontact/del_corp_tag?access_token=" + access_token;
            respJson = WxApiUtils.doPostResult(reqUrl, null, paramJson);
            baseResult = (BaseResult)JSON.parseObject((String)respJson, BaseResult.class);
            return baseResult;
        }
        return baseResult;
    }

    public static BaseResult requestDelTags(String access_token, List<String> tagIds) {
        JSONObject reqJson = new JSONObject();
        reqJson.put("tag_id", tagIds);
        String paramJson = reqJson.toJSONString();
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://qyapi.weixin.qq.com/cgi-bin/externalcontact/del_corp_tag").addParameter("access_token", API.accessToken(access_token)).setEntity((HttpEntity)new StringEntity(JsonUtil.toJSONString(paramJson), Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, BaseResult.class);
    }

    public static WxTag requestCreateGroupAndTag(String access_token, String tagGroupName, String tagName) {
        ArrayList<String> tagList = new ArrayList<String>(1);
        tagList.add(tagName);
        return WxApiUtils.requestCreateGroupAndTags(access_token, tagGroupName, tagList);
    }

    public static WxTag requestCreateTag(String access_token, String wxTagGroupId, String tagName) {
        ArrayList<String> tagList = new ArrayList<String>(1);
        tagList.add(tagName);
        return WxApiUtils.requestCreateTags(access_token, wxTagGroupId, tagList);
    }

    public static WxTag requestCreateGroupAndTags(String access_token, String tagGroupName, List<String> tagNameList) {
        String groupKey = "group_name";
        return WxApiUtils.requestCreateTags(access_token, groupKey, tagGroupName, tagNameList);
    }

    public static WxTag requestCreateTags(String access_token, String wxGroupId, List<String> tagNameList) {
        String groupKey = "group_id";
        return WxApiUtils.requestCreateTags(access_token, groupKey, wxGroupId, tagNameList);
    }

    public static WxTag requestCreateTags(String access_token, String groupKey, String groupValue, List<String> tagNameList) {
        ArrayList<JSONObject> tagList = new ArrayList<JSONObject>();
        for (String tagName : tagNameList) {
            JSONObject tagJson = new JSONObject();
            tagJson.put("name", (Object)tagName);
            tagList.add(tagJson);
        }
        JSONObject reqJson = new JSONObject();
        reqJson.put(groupKey, (Object)groupValue);
        reqJson.put("tag", tagList);
        String paramJson = reqJson.toJSONString();
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://qyapi.weixin.qq.com/cgi-bin/externalcontact/add_corp_tag").addParameter("access_token", API.accessToken(access_token)).setEntity((HttpEntity)new StringEntity(paramJson, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, WxTag.class);
    }

    public static BaseResult markTag(String accessToken, UserTagInfo userTagInfo) {
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://qyapi.weixin.qq.com/cgi-bin/externalcontact/mark_tag").addParameter("access_token", API.accessToken(accessToken)).setEntity((HttpEntity)new StringEntity(JsonUtil.toJSONString(userTagInfo), Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, BaseResult.class);
    }

    public static String requestCreateContactWay(String access_token, boolean skipVerify, String state, List<String> wxUserIdList) {
        String reqUrl = "https://qyapi.weixin.qq.com/cgi-bin/externalcontact/add_contact_way?access_token=" + access_token;
        JSONObject reqJson = new JSONObject();
        reqJson.put("type", (Object)"2");
        reqJson.put("scene", (Object)"2");
        reqJson.put("skip_verify", (Object)skipVerify);
        reqJson.put("state", (Object)state);
        reqJson.put("user", wxUserIdList);
        String paramJson = reqJson.toJSONString();
        String key = "";
        String respJson = WxApiUtils.doPostResult(reqUrl, key, paramJson);
        if (CONST_ACCESS_TOKEN_INVALID.equals(respJson)) {
            reqUrl = "https://qyapi.weixin.qq.com/cgi-bin/externalcontact/add_contact_way?access_token=" + access_token;
            respJson = WxApiUtils.doPostResult(reqUrl, key, paramJson);
        }
        return respJson;
    }

    public static String requestCreateContactWay(String access_token, int type, boolean skipVerify, String state, List<?> wxUserIdList, List<?> wxDepartmentIdList) {
        String reqUrl = "https://qyapi.weixin.qq.com/cgi-bin/externalcontact/add_contact_way?access_token=" + access_token;
        JSONObject reqJson = new JSONObject();
        reqJson.put("type", (Object)type);
        reqJson.put("scene", (Object)"2");
        reqJson.put("skip_verify", (Object)skipVerify);
        reqJson.put("state", (Object)state);
        reqJson.put("user", wxUserIdList);
        reqJson.put("party", wxDepartmentIdList);
        String paramJson = reqJson.toJSONString();
        String key = "";
        String respJson = WxApiUtils.doPostResult(reqUrl, key, paramJson);
        if (CONST_ACCESS_TOKEN_INVALID.equals(respJson)) {
            reqUrl = "https://qyapi.weixin.qq.com/cgi-bin/externalcontact/add_contact_way?access_token=" + access_token;
            respJson = WxApiUtils.doPostResult(reqUrl, key, paramJson);
        }
        return respJson;
    }

    public static void requestUpdateContactWay(String access_token, String wxConfigId, List<?> wxUserIdList) {
        WxApiUtils.requestUpdateContactWay(access_token, wxConfigId, wxUserIdList, Collections.emptyList());
    }

    public static void requestUpdateContactWay(String access_token, String wxConfigId, List<?> wxUserIdList, List<?> wxDepartmentIdList) {
        String reqUrl = "https://qyapi.weixin.qq.com/cgi-bin/externalcontact/update_contact_way?access_token=" + access_token;
        JSONObject reqJson = new JSONObject();
        reqJson.put("config_id", (Object)wxConfigId);
        reqJson.put("user", wxUserIdList);
        reqJson.put("party", wxDepartmentIdList);
        String paramJson = reqJson.toJSONString();
        String key = null;
        String respJson = WxApiUtils.doPostResult(reqUrl, key, paramJson);
        if (CONST_ACCESS_TOKEN_INVALID.equals(respJson)) {
            reqUrl = "https://qyapi.weixin.qq.com/cgi-bin/externalcontact/update_contact_way?access_token=" + access_token;
            WxApiUtils.doPostResult(reqUrl, key, paramJson);
        }
    }

    public static String getWorkRoomIndexData(String access_token, String ownerId) {
        String reqUrl = "https://qyapi.weixin.qq.com/cgi-bin/externalcontact/groupchat/list?access_token=" + access_token;
        ArrayList<JSONObject> workRoomList = new ArrayList<JSONObject>();
        JSONObject workRoomJson = new JSONObject();
        workRoomJson.put("userid_list", (Object)ownerId);
        workRoomJson.put("partyid_list", null);
        workRoomList.add(workRoomJson);
        JSONObject reqJson = new JSONObject();
        reqJson.put("status_filter", (Object)0);
        reqJson.put("limit", (Object)10);
        String key = "group_chat_list";
        String paramJson = reqJson.toJSONString();
        String respJson = WxApiUtils.doPostResult(reqUrl, key, paramJson);
        if (CONST_ACCESS_TOKEN_INVALID.equals(respJson)) {
            reqUrl = "https://qyapi.weixin.qq.com/cgi-bin/externalcontact/groupchat/list?access_token=" + access_token;
            respJson = WxApiUtils.doPostResult(reqUrl, key, paramJson);
        }
        return respJson;
    }

    public static String getWorkRoomInfoData(String access_token, String chatId) {
        String reqUrl = "https://qyapi.weixin.qq.com/cgi-bin/externalcontact/groupchat/get?access_token=" + access_token;
        ArrayList workRoomList = new ArrayList();
        JSONObject reqJson = new JSONObject();
        reqJson.put("chat_id", (Object)chatId);
        String key = "group_chat";
        String paramJson = reqJson.toJSONString();
        String respJson = WxApiUtils.doPostResult(reqUrl, key, paramJson);
        if (CONST_ACCESS_TOKEN_INVALID.equals(respJson)) {
            reqUrl = "https://qyapi.weixin.qq.com/cgi-bin/externalcontact/groupchat/get?access_token=" + access_token;
            respJson = WxApiUtils.doPostResult(reqUrl, key, paramJson);
        }
        return respJson;
    }

    public static String updateExternalContact(String access_token, Map<String, Object> map) {
        String reqUrl = "https://qyapi.weixin.qq.com/cgi-bin/externalcontact/remark?access_token=" + access_token;
        JSONObject reqJson = new JSONObject();
        reqJson.put("userid", map.get("userid"));
        reqJson.put("external_userid", map.get("external_userid"));
        reqJson.put("remark", map.get("remark"));
        reqJson.put("description", map.get("description"));
        String key = null;
        String paramJson = reqJson.toJSONString();
        String respJson = WxApiUtils.doPostResult(reqUrl, key, paramJson);
        if (CONST_ACCESS_TOKEN_INVALID.equals(respJson)) {
            reqUrl = "https://qyapi.weixin.qq.com/cgi-bin/externalcontact/groupchat/get?access_token=" + access_token;
            respJson = WxApiUtils.doPostResult(reqUrl, key, paramJson);
        }
        return respJson;
    }

    public static String getExternalContactList(String access_token, String userId) {
        String key;
        String reqUrl = "https://qyapi.weixin.qq.com/cgi-bin/externalcontact/list?access_token=" + access_token + "&userid=" + userId;
        String respJson = WxApiUtils.doGetResult(reqUrl, key = "");
        if (CONST_ACCESS_TOKEN_INVALID.equals(respJson)) {
            reqUrl = "https://qyapi.weixin.qq.com/cgi-bin/externalcontact/groupchat/get?access_token=" + access_token;
            respJson = WxApiUtils.doGetResult(reqUrl, key);
        }
        return respJson;
    }

    public static String getExternalContactInfo(String access_token, String externalUserid) {
        String key;
        String reqUrl = "https://qyapi.weixin.qq.com/cgi-bin/externalcontact/get?access_token=" + access_token + "&external_userid=" + externalUserid;
        String respJson = WxApiUtils.doGetResult(reqUrl, key = "");
        if (CONST_ACCESS_TOKEN_INVALID.equals(respJson)) {
            reqUrl = "https://qyapi.weixin.qq.com/cgi-bin/externalcontact/groupchat/get?access_token=" + access_token;
            respJson = WxApiUtils.doGetResult(reqUrl, key);
        }
        return respJson;
    }

    public static String sendWelcomeCode(String access_token, Map<String, Object> map) {
        JSONObject reqJson;
        String paramJson;
        String reqUrl = "https://qyapi.weixin.qq.com/cgi-binexternalcontact/send_welcome_msg?access_token=" + access_token;
        String respJson = WxApiUtils.doPostResult(reqUrl, null, paramJson = (reqJson = new JSONObject(map)).toJSONString());
        if (CONST_ACCESS_TOKEN_INVALID.equals(respJson)) {
            reqUrl = "https://qyapi.weixin.qq.com/cgi-bin/externalcontact/groupchat/get?access_token=" + access_token;
            respJson = WxApiUtils.doPostResult(reqUrl, null, paramJson);
        }
        return respJson;
    }

    public static String getAgentInfo(String wxCorpId, String wxAgentId, String wxAgentSecret) {
        String key;
        String accessToken = WxApiUtils.getAccessToken(wxCorpId, wxAgentSecret);
        String paramUrl = "?access_token=" + accessToken + "&agentid=" + wxAgentId;
        String url = "https://qyapi.weixin.qq.com/cgi-bin/agent/get" + paramUrl;
        String respJson = WxApiUtils.doGetResult(url, key = "");
        if (CONST_ACCESS_TOKEN_INVALID.equals(respJson)) {
            accessToken = WxApiUtils.getAccessToken(wxCorpId, wxAgentSecret);
            paramUrl = "?access_token=" + accessToken + "&agentid=" + wxAgentId;
            url = "https://qyapi.weixin.qq.com/cgi-bin/agent/get" + paramUrl;
            respJson = WxApiUtils.doGetResult(url, key);
        }
        return respJson;
    }

    public static String uploadImageToTemp(String access_token, File file) {
        return WxApiUtils.uploadFileToTemp(access_token, "image", file);
    }

    public static String uploadFileToTemp(String access_token, String type, File file) {
        System.out.println("=================\u4e0a\u4f20\u6587\u4ef6\u7d20\u6750========================");
        String url = "https://qyapi.weixin.qq.com/cgi-bin/media/upload?type=" + type + "&access_token=" + access_token;
        String key = "media_id";
        String respJson = WxApiUtils.doPostResult(url, key, file);
        if (CONST_ACCESS_TOKEN_INVALID.equals(respJson)) {
            url = "https://qyapi.weixin.qq.com/cgi-bin/media/upload?type=" + type + "&access_token=" + access_token;
            respJson = WxApiUtils.doPostResult(url, key, file);
        }
        return respJson;
    }

    public static String getNewJsapiTicketOfCorp(String access_token) {
        String key;
        String url = "https://qyapi.weixin.qq.com/cgi-bin/get_jsapi_ticket?access_token=" + access_token;
        String respJson = WxApiUtils.doGetResult(url, key = "ticket");
        if (CONST_ACCESS_TOKEN_INVALID.equals(respJson)) {
            url = "https://qyapi.weixin.qq.com/cgi-bin/get_jsapi_ticket?access_token=" + access_token;
            respJson = WxApiUtils.doGetResult(url, key);
        }
        return respJson;
    }

    public static String getNewJsapiTicketOfApp(String access_token, int agentId) {
        String key;
        String url = "https://qyapi.weixin.qq.com/cgi-bin/ticket/get?access_token=" + access_token + "&type=agent_config";
        String respJson = WxApiUtils.doGetResult(url, key = "ticket");
        if (CONST_ACCESS_TOKEN_INVALID.equals(respJson)) {
            url = "https://qyapi.weixin.qq.com/cgi-bin/ticket/get?access_token=" + access_token + "&type=agent_config";
            respJson = WxApiUtils.doGetResult(url, key);
        }
        return respJson;
    }

    private static String doGetResult(String url, String key) {
        String respJson = HttpClientUtil.doGet(url);
        return WxApiUtils.getResultData(respJson, key);
    }

    private static String doPostResult(String url, String key, String requestBody) {
        String respJson = HttpClientUtil.doPost(url, requestBody);
        return WxApiUtils.getResultData(respJson, key);
    }

    private static String doPostResult(String url, String key, File requestBody) {
        String respJson = HttpClientUtil.doPost(url, requestBody);
        return WxApiUtils.getResultData(respJson, key);
    }

    private static String getResultData(String result, String key) {
        JSONObject jsonObject = JSON.parseObject((String)result);
        int errCode = jsonObject.getIntValue("errcode");
        if (errCode == 42001) {
            return CONST_ACCESS_TOKEN_INVALID;
        }
        if (errCode == 0) {
            if (key == null) {
                return "";
            }
            if (key.isEmpty()) {
                return result;
            }
            return jsonObject.getString(key);
        }
        return null;
    }

    public static void clear() {
        map.clear();
    }
}

