/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.payment.wechat.v3;

import cn.felord.payment.wechat.WechatPayProperties;
import cn.felord.payment.wechat.enumeration.WeChatServer;
import cn.felord.payment.wechat.enumeration.WechatPayV3Type;
import cn.felord.payment.wechat.v3.AbstractApi;
import cn.felord.payment.wechat.v3.SignatureProvider;
import cn.felord.payment.wechat.v3.WechatPayClient;
import cn.felord.payment.wechat.v3.WechatResponseEntity;
import cn.felord.payment.wechat.v3.X509WechatCertificateInfo;
import cn.felord.payment.wechat.v3.model.profitsharing.PartnerAddReceiversParams;
import cn.felord.payment.wechat.v3.model.profitsharing.PartnerDelReceiversParams;
import cn.felord.payment.wechat.v3.model.profitsharing.PartnerProfitSharingOrder;
import cn.felord.payment.wechat.v3.model.profitsharing.PartnerQueryOrderParams;
import cn.felord.payment.wechat.v3.model.profitsharing.PartnerQueryReturnOrderParams;
import cn.felord.payment.wechat.v3.model.profitsharing.PartnerReturnOrdersParams;
import cn.felord.payment.wechat.v3.model.profitsharing.PartnerUnfreezeParams;
import cn.felord.payment.wechat.v3.model.profitsharing.Receiver;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.net.URI;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.http.HttpHeaders;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;

public class WechatPartnerProfitsharingApi
extends AbstractApi {
    public WechatPartnerProfitsharingApi(WechatPayClient wechatPayClient, String tenantId) {
        super(wechatPayClient, tenantId);
    }

    public WechatResponseEntity<ObjectNode> profitsharingOrders(PartnerProfitSharingOrder profitSharingOrder) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.PROFITSHARING_ORDERS, profitSharingOrder).function((wechatPayV3Type, params) -> {
            WechatPayProperties.V3 v3 = this.wechatMetaBean().getV3();
            SignatureProvider signatureProvider = this.client().signatureProvider();
            X509WechatCertificateInfo certificate = signatureProvider.getCertificate();
            X509Certificate x509Certificate = certificate.getX509Certificate();
            params.setAppid(v3.getAppId());
            List<Receiver> receivers = params.getReceivers();
            if (!CollectionUtils.isEmpty(receivers)) {
                List<Receiver> encrypted = receivers.stream().peek(receiversItem -> {
                    String name = receiversItem.getName();
                    if (StringUtils.hasText((String)name)) {
                        String encryptedName = signatureProvider.encryptRequestMessage(name, x509Certificate);
                        receiversItem.setName(encryptedName);
                    }
                }).collect(Collectors.toList());
                params.setReceivers(encrypted);
            }
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).build().toUri();
            HttpHeaders httpHeaders = new HttpHeaders();
            httpHeaders.add("Wechatpay-Serial", certificate.getWechatPaySerial());
            return this.Post(uri, params, httpHeaders);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> queryProfitsharingOrder(PartnerQueryOrderParams queryOrderParams) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.PROFITSHARING_ORDERS_RESULT, queryOrderParams).function((wechatPayV3Type, params) -> {
            LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
            queryParams.add((Object)"transaction_id", (Object)params.getTransactionId());
            Optional.ofNullable(params.getSubMchid()).ifPresent(arg_0 -> WechatPartnerProfitsharingApi.lambda$null$2((MultiValueMap)queryParams, params, arg_0));
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).queryParams((MultiValueMap)queryParams).build().expand(new Object[]{params.getOutOrderNo()}).toUri();
            return this.Get(uri);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> returnOrders(PartnerReturnOrdersParams returnOrdersParams) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.PROFITSHARING_RETURN_ORDERS, returnOrdersParams).function((wechatPayV3Type, params) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).build().toUri();
            return this.Post(uri, params);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> queryReturnOrders(PartnerQueryReturnOrderParams queryReturnOrderParams) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.PROFITSHARING_RETURN_ORDERS_RESULT, queryReturnOrderParams).function((wechatPayV3Type, params) -> {
            LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
            queryParams.add((Object)"out_order_no", (Object)params.getOutOrderNo());
            Optional.ofNullable(params.getSubMchid()).ifPresent(arg_0 -> WechatPartnerProfitsharingApi.lambda$null$5((MultiValueMap)queryParams, params, arg_0));
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).queryParams((MultiValueMap)queryParams).build().expand(new Object[]{params.getOutReturnNo()}).toUri();
            return this.Get(uri);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> unfreeze(PartnerUnfreezeParams unfreezeParams) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.PROFITSHARING_ORDERS_UNFREEZE, unfreezeParams).function((wechatPayV3Type, params) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).build().toUri();
            return this.Post(uri, params);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> queryAmounts(String transactionId) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.PROFITSHARING_AMOUNTS, transactionId).function((wechatPayV3Type, id) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).build().expand(new Object[]{id}).toUri();
            return this.Get(uri);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> queryMchConfigs(String subMchid) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.PROFITSHARING_MCH_CONFIG, subMchid).function((wechatPayV3Type, id) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).build().expand(new Object[]{id}).toUri();
            return this.Get(uri);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> addReceivers(PartnerAddReceiversParams addReceiversParams) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.PROFITSHARING_RECEIVERS_ADD, addReceiversParams).function((wechatPayV3Type, params) -> {
            WechatPayProperties.V3 v3 = this.wechatMetaBean().getV3();
            SignatureProvider signatureProvider = this.client().signatureProvider();
            X509WechatCertificateInfo certificate = signatureProvider.getCertificate();
            X509Certificate x509Certificate = certificate.getX509Certificate();
            params.setAppid(v3.getAppId());
            String name = params.getName();
            if (StringUtils.hasText((String)name)) {
                String encryptedName = signatureProvider.encryptRequestMessage(name, x509Certificate);
                params.setName(encryptedName);
            }
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).build().toUri();
            HttpHeaders httpHeaders = new HttpHeaders();
            httpHeaders.add("Wechatpay-Serial", certificate.getWechatPaySerial());
            return this.Post(uri, params, httpHeaders);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> deleteReceivers(PartnerDelReceiversParams delReceiversParams) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.PROFITSHARING_RECEIVERS_DELETE, delReceiversParams).function((wechatPayV3Type, params) -> {
            WechatPayProperties.V3 v3 = this.wechatMetaBean().getV3();
            params.setAppid(v3.getAppId());
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).build().toUri();
            return this.Post(uri, params);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    private static /* synthetic */ void lambda$null$5(MultiValueMap queryParams, PartnerQueryReturnOrderParams params, String mchId) {
        queryParams.add((Object)"sub_mchid", (Object)params.getSubMchid());
    }

    private static /* synthetic */ void lambda$null$2(MultiValueMap queryParams, PartnerQueryOrderParams params, String mchId) {
        queryParams.add((Object)"sub_mchid", (Object)params.getSubMchid());
    }
}

