/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.file.local;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.system.SystemUtil;
import cn.stylefeng.roses.kernel.auth.api.context.LoginContext;
import cn.stylefeng.roses.kernel.file.api.FileOperatorApi;
import cn.stylefeng.roses.kernel.file.api.enums.BucketAuthEnum;
import cn.stylefeng.roses.kernel.file.api.enums.FileLocationEnum;
import cn.stylefeng.roses.kernel.file.api.exception.FileException;
import cn.stylefeng.roses.kernel.file.api.exception.enums.FileExceptionEnum;
import cn.stylefeng.roses.kernel.file.api.expander.FileConfigExpander;
import cn.stylefeng.roses.kernel.file.api.pojo.props.LocalFileProperties;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.rule.util.HttpServletUtil;
import java.io.File;
import java.io.InputStream;

public class LocalFileOperator
implements FileOperatorApi {
    private final LocalFileProperties localFileProperties;
    private String currentSavePath = "";

    public LocalFileOperator(LocalFileProperties localFileProperties) {
        this.localFileProperties = localFileProperties;
        this.initClient();
    }

    public void initClient() {
        if (SystemUtil.getOsInfo().isWindows()) {
            String savePathWindows = this.localFileProperties.getLocalFileSavePathWin();
            if (!FileUtil.exist((String)savePathWindows)) {
                FileUtil.mkdir((String)savePathWindows);
            }
            this.currentSavePath = savePathWindows;
        } else {
            String savePathLinux = this.localFileProperties.getLocalFileSavePathLinux();
            if (!FileUtil.exist((String)savePathLinux)) {
                FileUtil.mkdir((String)savePathLinux);
            }
            this.currentSavePath = savePathLinux;
        }
    }

    public void destroyClient() {
    }

    public Object getClient() {
        return null;
    }

    public boolean doesBucketExist(String bucketName) {
        String absolutePath = this.currentSavePath + File.separator + bucketName;
        return FileUtil.exist((String)absolutePath);
    }

    public void setBucketAcl(String bucketName, BucketAuthEnum bucketAuthEnum) {
    }

    public boolean isExistingFile(String bucketName, String key) {
        String absoluteFile = this.currentSavePath + File.separator + bucketName + File.separator + key;
        return FileUtil.exist((String)absoluteFile);
    }

    public void storageFile(String bucketName, String key, byte[] bytes) {
        String bucketPath = this.currentSavePath + File.separator + bucketName;
        if (!FileUtil.exist((String)bucketPath)) {
            FileUtil.mkdir((String)bucketPath);
        }
        String absoluteFile = this.currentSavePath + File.separator + bucketName + File.separator + key;
        FileUtil.writeBytes((byte[])bytes, (String)absoluteFile);
    }

    public void storageFile(String bucketName, String key, InputStream inputStream) {
        String bucketPath = this.currentSavePath + File.separator + bucketName;
        if (!FileUtil.exist((String)bucketPath)) {
            FileUtil.mkdir((String)bucketPath);
        }
        String absoluteFile = this.currentSavePath + File.separator + bucketName + File.separator + key;
        FileUtil.writeFromStream((InputStream)inputStream, (String)absoluteFile);
    }

    public byte[] getFileBytes(String bucketName, String key) {
        String absoluteFile = this.currentSavePath + File.separator + bucketName + File.separator + key;
        if (!FileUtil.exist((String)absoluteFile)) {
            String errorMessage = StrUtil.format((CharSequence)"bucket={},key={}", (Object[])new Object[]{bucketName, key});
            throw new FileException((AbstractExceptionEnum)FileExceptionEnum.FILE_NOT_FOUND, new Object[]{errorMessage});
        }
        return FileUtil.readBytes((String)absoluteFile);
    }

    public void setFileAcl(String bucketName, String key, BucketAuthEnum bucketAuthEnum) {
    }

    public void copyFile(String originBucketName, String originFileKey, String newBucketName, String newFileKey) {
        String originFile = this.currentSavePath + File.separator + originBucketName + File.separator + originFileKey;
        if (!FileUtil.exist((String)originFile)) {
            String errorMessage = StrUtil.format((CharSequence)"bucket={},key={}", (Object[])new Object[]{originBucketName, originFileKey});
            throw new FileException((AbstractExceptionEnum)FileExceptionEnum.FILE_NOT_FOUND, new Object[]{errorMessage});
        }
        String destFile = this.currentSavePath + File.separator + newBucketName + File.separator + newFileKey;
        FileUtil.copy((String)originFile, (String)destFile, (boolean)true);
    }

    public String getFileAuthUrl(String bucketName, String key, Long timeoutMillis) {
        String token = LoginContext.me().getToken();
        String contextPath = HttpServletUtil.getRequest().getContextPath();
        return FileConfigExpander.getServerDeployHost() + contextPath + "/sysFileInfo/previewByObjectName" + "?fileBucket=" + bucketName + "&fileObjectName=" + key + "&token=" + token;
    }

    public String getFileUnAuthUrl(String bucketName, String key) {
        String contextPath = HttpServletUtil.getRequest().getContextPath();
        return FileConfigExpander.getServerDeployHost() + contextPath + "/sysFileInfo/previewByObjectName" + "?fileBucket=" + bucketName + "&fileObjectName=" + key;
    }

    public void deleteFile(String bucketName, String key) {
        String file = this.currentSavePath + File.separator + bucketName + File.separator + key;
        if (!FileUtil.exist((String)file)) {
            return;
        }
        FileUtil.del((String)file);
    }

    public FileLocationEnum getFileLocationEnum() {
        return FileLocationEnum.LOCAL;
    }
}

