/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.get_calendars.Calendar;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class GetCalendarsResponse
implements JsonpSerializable {
    private final List<Calendar> calendars;
    private final long count;
    public static final JsonpDeserializer<GetCalendarsResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetCalendarsResponse::setupGetCalendarsResponseDeserializer);

    private GetCalendarsResponse(Builder builder) {
        this.calendars = ApiTypeHelper.unmodifiableRequired(builder.calendars, (Object)this, "calendars");
        this.count = ApiTypeHelper.requireNonNull(builder.count, this, "count");
    }

    public static GetCalendarsResponse of(Function<Builder, ObjectBuilder<GetCalendarsResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<Calendar> calendars() {
        return this.calendars;
    }

    public final long count() {
        return this.count;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.calendars)) {
            generator.writeKey("calendars");
            generator.writeStartArray();
            for (Calendar item0 : this.calendars) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("count");
        generator.write(this.count);
    }

    protected static void setupGetCalendarsResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::calendars, JsonpDeserializer.arrayDeserializer(Calendar._DESERIALIZER), "calendars");
        op.add(Builder::count, JsonpDeserializer.longDeserializer(), "count");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<GetCalendarsResponse> {
        private List<Calendar> calendars;
        private Long count;

        public final Builder calendars(List<Calendar> list) {
            this.calendars = Builder._listAddAll(this.calendars, list);
            return this;
        }

        public final Builder calendars(Calendar value, Calendar ... values) {
            this.calendars = Builder._listAdd(this.calendars, value, values);
            return this;
        }

        public final Builder calendars(Function<Calendar.Builder, ObjectBuilder<Calendar>> fn) {
            return this.calendars(fn.apply(new Calendar.Builder()).build(), new Calendar[0]);
        }

        public final Builder count(long value) {
            this.count = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GetCalendarsResponse build() {
            this._checkSingleUse();
            return new GetCalendarsResponse(this);
        }
    }
}

