/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.odps.visitor;

import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLHint;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLCaseExpr;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableRenameColumn;
import com.alibaba.druid.sql.ast.statement.SQLAssignItem;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableElement;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsAddStatisticStatement;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsAnalyzeTableStatement;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsCreateTableStatement;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsGrantStmt;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsInsert;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsInsertStatement;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsLateralViewTableSource;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsListStmt;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsReadStatement;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsRemoveStatisticStatement;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsSelectQueryBlock;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsSetLabelStatement;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsShowGrantsStmt;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsShowPartitionsStmt;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsShowStatisticStmt;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsStatisticClause;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsUDTFSQLSelectItem;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsValuesTableSource;
import com.alibaba.druid.sql.dialect.odps.visitor.OdpsASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTOutputVisitor;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class OdpsOutputVisitor
extends SQLASTOutputVisitor
implements OdpsASTVisitor {
    private Set<String> builtInFunctions = new HashSet<String>();

    public OdpsOutputVisitor(Appendable appender) {
        super(appender, "odps");
        this.builtInFunctions.add("IF");
        this.builtInFunctions.add("COALESCE");
        this.builtInFunctions.add("TO_DATE");
        this.builtInFunctions.add("SUBSTR");
        this.builtInFunctions.add("INSTR");
        this.builtInFunctions.add("LENGTH");
        this.builtInFunctions.add("SPLIT");
        this.builtInFunctions.add("TOLOWER");
        this.builtInFunctions.add("TOUPPER");
        this.builtInFunctions.add("EXPLODE");
        this.builtInFunctions.add("LEAST");
        this.builtInFunctions.add("GREATEST");
        this.groupItemSingleLine = true;
    }

    @Override
    public boolean visit(OdpsCreateTableStatement x) {
        int partitionSize;
        int size;
        if (x.isIfNotExiists()) {
            this.print0(this.ucase ? "CREATE TABLE IF NOT EXISTS " : "create table if not exists ");
        } else {
            this.print0(this.ucase ? "CREATE TABLE " : "create table ");
        }
        x.getName().accept(this);
        if (x.getLike() != null) {
            this.print0(this.ucase ? " LIKE " : " like ");
            x.getLike().accept(this);
        }
        if ((size = x.getTableElementList().size()) > 0) {
            this.print0(" (");
            if (this.isPrettyFormat() && x.hasBodyBeforeComment()) {
                this.print(' ');
                this.printComment(x.getBodyBeforeCommentsDirect(), "");
            }
            this.incrementIndent();
            this.println();
            for (int i = 0; i < size; ++i) {
                SQLTableElement element = x.getTableElementList().get(i);
                element.accept(this);
                if (i != size - 1) {
                    this.print(',');
                }
                if (this.isPrettyFormat() && element.hasAfterComment()) {
                    this.print(' ');
                    this.printComment(element.getAfterCommentsDirect(), "\n");
                }
                if (i == size - 1) continue;
                this.println();
            }
            this.decrementIndent();
            this.println();
            this.print(')');
        }
        if (x.getComment() != null) {
            this.println();
            this.print0(this.ucase ? "COMMENT " : "comment ");
            x.getComment().accept(this);
        }
        if ((partitionSize = x.getPartitionColumns().size()) > 0) {
            this.println();
            this.print0(this.ucase ? "PARTITIONED BY (" : "partitioned by (");
            this.incrementIndent();
            this.println();
            for (int i = 0; i < partitionSize; ++i) {
                SQLColumnDefinition column = x.getPartitionColumns().get(i);
                column.accept(this);
                if (i != partitionSize - 1) {
                    this.print(',');
                }
                if (this.isPrettyFormat() && column.hasAfterComment()) {
                    this.print(' ');
                    this.printComment(column.getAfterCommentsDirect(), "\n");
                }
                if (i == partitionSize - 1) continue;
                this.println();
            }
            this.decrementIndent();
            this.println();
            this.print(')');
        }
        if (x.getLifecycle() != null) {
            this.println();
            this.print0(this.ucase ? "LIFECYCLE " : "lifecycle ");
            x.getLifecycle().accept(this);
        }
        if (x.getSelect() != null) {
            this.println();
            this.print0(this.ucase ? "AS" : "as");
            this.println();
            x.getSelect().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(OdpsCreateTableStatement x) {
        super.endVisit(x);
    }

    public SQLStatement parseInsert() {
        OdpsInsertStatement stmt = new OdpsInsertStatement();
        return stmt;
    }

    @Override
    public void endVisit(OdpsInsertStatement x) {
    }

    @Override
    public boolean visit(OdpsInsertStatement x) {
        SQLTableSource from = x.getFrom();
        if (x.getFrom() != null) {
            if (from instanceof SQLSubqueryTableSource) {
                SQLSelect select = ((SQLSubqueryTableSource)from).getSelect();
                this.print0(this.ucase ? "FROM (" : "from (");
                this.incrementIndent();
                this.println();
                select.accept(this);
                this.decrementIndent();
                this.println();
                this.print0(") ");
                this.print0(x.getFrom().getAlias());
            } else {
                this.print0(this.ucase ? "FROM " : "from ");
                from.accept(this);
            }
            this.println();
        }
        for (int i = 0; i < x.getItems().size(); ++i) {
            OdpsInsert insert = x.getItems().get(i);
            if (i != 0) {
                this.println();
            }
            insert.accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(OdpsInsert x) {
    }

    @Override
    public boolean visit(OdpsInsert x) {
        if (x.hasBeforeComment()) {
            this.printComment(x.getBeforeCommentsDirect(), "\n");
            this.println();
        }
        if (x.isOverwrite()) {
            this.print0(this.ucase ? "INSERT OVERWRITE TABLE " : "insert overwrite table ");
        } else {
            this.print0(this.ucase ? "INSERT INTO TABLE " : "insert into table ");
        }
        x.getTableSource().accept(this);
        int partitions = x.getPartitions().size();
        if (partitions > 0) {
            this.print0(this.ucase ? " PARTITION (" : " partition (");
            for (int i = 0; i < partitions; ++i) {
                if (i != 0) {
                    this.print0(", ");
                }
                SQLAssignItem assign = x.getPartitions().get(i);
                assign.getTarget().accept(this);
                if (assign.getValue() == null) continue;
                this.print('=');
                assign.getValue().accept(this);
            }
            this.print(')');
        }
        this.println();
        x.getQuery().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLCaseExpr x) {
        this.incrementIndent();
        this.print0(this.ucase ? "CASE " : "case ");
        if (x.getValueExpr() != null) {
            x.getValueExpr().accept(this);
            this.println();
        }
        int size = x.getItems().size();
        for (int i = 0; i < size; ++i) {
            this.println();
            x.getItems().get(i).accept(this);
        }
        if (x.getElseExpr() != null) {
            this.println();
            this.print0(this.ucase ? "ELSE " : "else ");
            x.getElseExpr().accept(this);
        }
        this.decrementIndent();
        this.println();
        this.print0(this.ucase ? "END" : "end");
        return false;
    }

    @Override
    protected void printSelectList(List<SQLSelectItem> selectList) {
        this.incrementIndent();
        int size = selectList.size();
        for (int i = 0; i < size; ++i) {
            SQLSelectItem selectItem = selectList.get(i);
            if (i != 0) {
                SQLSelectItem preSelectItem = selectList.get(i - 1);
                if (preSelectItem.hasAfterComment()) {
                    this.print(' ');
                    this.printComment(preSelectItem.getAfterCommentsDirect(), "\n");
                }
                this.println();
                this.print0(", ");
            }
            selectItem.accept(this);
            if (i != selectList.size() - 1 || !selectItem.hasAfterComment()) continue;
            this.print(' ');
            this.printComment(selectItem.getAfterCommentsDirect(), "\n");
        }
        this.decrementIndent();
    }

    @Override
    public boolean visit(SQLSubqueryTableSource x) {
        this.print('(');
        this.incrementIndent();
        this.println();
        x.getSelect().accept(this);
        this.decrementIndent();
        this.println();
        this.print(')');
        if (x.getAlias() != null) {
            this.print(' ');
            this.print0(x.getAlias());
        }
        return false;
    }

    @Override
    public boolean visit(SQLJoinTableSource x) {
        x.getLeft().accept(this);
        if (x.getJoinType() == SQLJoinTableSource.JoinType.COMMA) {
            this.print(',');
        } else {
            this.println();
            this.printJoinType(x.getJoinType());
        }
        this.print(' ');
        x.getRight().accept(this);
        if (x.getCondition() != null) {
            this.println();
            this.print0(this.ucase ? "ON " : "on ");
            this.incrementIndent();
            x.getCondition().accept(this);
            this.decrementIndent();
        }
        if (x.getUsing().size() > 0) {
            this.print0(this.ucase ? " USING (" : " using (");
            this.printAndAccept(x.getUsing(), ", ");
            this.print(')');
        }
        if (x.getAlias() != null) {
            this.print0(this.ucase ? " AS " : " as ");
            this.print0(x.getAlias());
        }
        return false;
    }

    @Override
    public void endVisit(OdpsUDTFSQLSelectItem x) {
    }

    @Override
    public boolean visit(OdpsUDTFSQLSelectItem x) {
        x.getExpr().accept(this);
        this.println();
        this.print0(this.ucase ? "AS (" : "as (");
        int aliasSize = x.getAliasList().size();
        if (aliasSize > 5) {
            this.incrementIndent();
            this.println();
        }
        for (int i = 0; i < aliasSize; ++i) {
            if (i != 0) {
                if (aliasSize > 5) {
                    this.println(",");
                } else {
                    this.print0(", ");
                }
            }
            this.print0(x.getAliasList().get(i));
        }
        if (aliasSize > 5) {
            this.decrementIndent();
            this.println();
        }
        this.print(')');
        return false;
    }

    @Override
    public void endVisit(OdpsShowPartitionsStmt x) {
    }

    @Override
    public boolean visit(OdpsShowPartitionsStmt x) {
        this.print0(this.ucase ? "SHOW PARTITIONS " : "show partitions ");
        x.getTableSource().accept(this);
        return false;
    }

    @Override
    public void endVisit(OdpsShowStatisticStmt x) {
    }

    @Override
    public boolean visit(OdpsShowStatisticStmt x) {
        this.print0(this.ucase ? "SHOW STATISTIC " : "show statistic ");
        x.getTableSource().accept(this);
        return false;
    }

    @Override
    public void endVisit(OdpsSetLabelStatement x) {
    }

    @Override
    public boolean visit(OdpsSetLabelStatement x) {
        this.print0(this.ucase ? "SET LABEL " : "set label ");
        this.print0(x.getLabel());
        this.print0(this.ucase ? " TO " : " to ");
        if (x.getUser() != null) {
            this.print0(this.ucase ? "USER " : "user ");
            x.getUser().accept(this);
        } else if (x.getTable() != null) {
            this.print0(this.ucase ? "TABLE " : "table ");
            x.getTable().accept(this);
            if (x.getColumns().size() > 0) {
                this.print('(');
                this.printAndAccept(x.getColumns(), ", ");
                this.print(')');
            }
        }
        return false;
    }

    @Override
    public void endVisit(OdpsSelectQueryBlock x) {
    }

    @Override
    public boolean visit(OdpsSelectQueryBlock x) {
        if (this.isPrettyFormat() && x.hasBeforeComment()) {
            this.printComment(x.getBeforeCommentsDirect(), "\n");
            this.println();
        }
        this.print0(this.ucase ? "SELECT " : "select ");
        List<SQLHint> hints = x.getHintsDirect();
        if (hints != null) {
            this.printAndAccept(hints, " ");
            this.print(' ');
        }
        if (1 == x.getDistionOption()) {
            this.print0(this.ucase ? "ALL " : "all ");
        } else if (2 == x.getDistionOption()) {
            this.print0(this.ucase ? "DISTINCT " : "distinct ");
        } else if (3 == x.getDistionOption()) {
            this.print0(this.ucase ? "UNIQUE " : "unique ");
        }
        this.printSelectList(x.getSelectList());
        if (x.getFrom() != null) {
            this.println();
            this.print0(this.ucase ? "FROM " : "from ");
            x.getFrom().accept(this);
        }
        if (x.getWhere() != null) {
            this.println();
            this.print0(this.ucase ? "WHERE " : "where ");
            if (x.getWhere().hasBeforeComment() && this.isPrettyFormat()) {
                this.printlnComments(x.getWhere().getBeforeCommentsDirect());
            }
            x.getWhere().setParent(x);
            x.getWhere().accept(this);
            if (x.getWhere().hasAfterComment() && this.isPrettyFormat()) {
                this.print(' ');
                this.printComment(x.getWhere().getAfterCommentsDirect(), "\n");
            }
        }
        if (x.getGroupBy() != null) {
            this.println();
            x.getGroupBy().accept(this);
        }
        if (x.getOrderBy() != null) {
            this.println();
            x.getOrderBy().accept(this);
        }
        if (x.getDistributeBy().size() > 0) {
            this.println();
            this.print0(this.ucase ? "DISTRIBUTE BY " : "distribute by ");
            this.printAndAccept(x.getDistributeBy(), ", ");
            if (!x.getSortBy().isEmpty()) {
                this.print0(this.ucase ? " SORT BY " : " sort by ");
                this.printAndAccept(x.getSortBy(), ", ");
            }
        }
        if (x.getLimit() != null) {
            this.println();
            x.getLimit().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLOrderBy x) {
        int itemSize = x.getItems().size();
        if (itemSize > 0) {
            this.print0(this.ucase ? "ORDER BY " : "order by ");
            this.incrementIndent();
            for (int i = 0; i < itemSize; ++i) {
                if (i != 0) {
                    this.println(", ");
                }
                x.getItems().get(i).accept(this);
            }
            this.decrementIndent();
        }
        return false;
    }

    @Override
    public void endVisit(OdpsAnalyzeTableStatement x) {
    }

    @Override
    public boolean visit(OdpsAnalyzeTableStatement x) {
        this.print0(this.ucase ? "ANALYZE TABLE " : "analyze table ");
        x.getTable().accept(this);
        if (x.getPartition().size() > 0) {
            this.print0(this.ucase ? " PARTITION (" : " partition (");
            this.printAndAccept(x.getPartition(), ", ");
            this.print(')');
        }
        this.print0(this.ucase ? " COMPUTE STATISTICS" : " compute statistics");
        return false;
    }

    @Override
    public void endVisit(OdpsAddStatisticStatement x) {
    }

    @Override
    public boolean visit(OdpsAddStatisticStatement x) {
        this.print0(this.ucase ? "ADD STATISTIC " : "add statistic ");
        x.getTable().accept(this);
        this.print(' ');
        x.getStatisticClause().accept(this);
        return false;
    }

    @Override
    public void endVisit(OdpsRemoveStatisticStatement x) {
    }

    @Override
    public boolean visit(OdpsRemoveStatisticStatement x) {
        this.print0(this.ucase ? "REMOVE STATISTIC " : "remove statistic ");
        x.getTable().accept(this);
        this.print(' ');
        x.getStatisticClause().accept(this);
        return false;
    }

    @Override
    public void endVisit(OdpsStatisticClause.TableCount x) {
    }

    @Override
    public boolean visit(OdpsStatisticClause.TableCount x) {
        this.print0(this.ucase ? "TABLE_COUNT" : "table_count");
        return false;
    }

    @Override
    public void endVisit(OdpsStatisticClause.ExpressionCondition x) {
    }

    @Override
    public boolean visit(OdpsStatisticClause.ExpressionCondition x) {
        this.print0(this.ucase ? "EXPRESSION_CONDITION " : "expression_condition ");
        x.getExpr().accept(this);
        return false;
    }

    @Override
    public void endVisit(OdpsStatisticClause.NullValue x) {
    }

    @Override
    public boolean visit(OdpsStatisticClause.NullValue x) {
        this.print0(this.ucase ? "NULL_VALUE " : "null_value ");
        x.getColumn().accept(this);
        return false;
    }

    @Override
    public void endVisit(OdpsStatisticClause.ColumnSum x) {
    }

    @Override
    public boolean visit(OdpsStatisticClause.ColumnSum x) {
        this.print0(this.ucase ? "COLUMN_SUM " : "column_sum ");
        x.getColumn().accept(this);
        return false;
    }

    @Override
    public void endVisit(OdpsStatisticClause.ColumnMax x) {
    }

    @Override
    public boolean visit(OdpsStatisticClause.ColumnMax x) {
        this.print0(this.ucase ? "COLUMN_MAX " : "column_max ");
        x.getColumn().accept(this);
        return false;
    }

    @Override
    public void endVisit(OdpsStatisticClause.ColumnMin x) {
    }

    @Override
    public boolean visit(OdpsStatisticClause.ColumnMin x) {
        this.print0(this.ucase ? "COLUMN_MIN " : "column_min ");
        x.getColumn().accept(this);
        return false;
    }

    @Override
    public void endVisit(OdpsReadStatement x) {
    }

    @Override
    public boolean visit(OdpsReadStatement x) {
        this.print0(this.ucase ? "READ " : "read ");
        x.getTable().accept(this);
        if (x.getColumns().size() > 0) {
            this.print0(" (");
            this.printAndAccept(x.getColumns(), ", ");
            this.print(')');
        }
        if (x.getPartition().size() > 0) {
            this.print0(this.ucase ? " PARTITION (" : " partition (");
            this.printAndAccept(x.getPartition(), ", ");
            this.print(')');
        }
        if (x.getRowCount() != null) {
            this.print(' ');
            x.getRowCount().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLMethodInvokeExpr x) {
        if (x.getOwner() != null) {
            x.getOwner().accept(this);
            this.print(':');
        }
        this.printFunctionName(x.getMethodName());
        this.print('(');
        this.printAndAccept(x.getParameters(), ", ");
        this.print(')');
        return false;
    }

    @Override
    protected void printJoinType(SQLJoinTableSource.JoinType joinType) {
        if (joinType.equals((Object)SQLJoinTableSource.JoinType.LEFT_OUTER_JOIN)) {
            this.print0(this.ucase ? "LEFT OUTER JOIN" : "left outer join");
        } else if (joinType.equals((Object)SQLJoinTableSource.JoinType.RIGHT_OUTER_JOIN)) {
            this.print0(this.ucase ? "RIGHT OUTER JOIN" : "right outer join");
        } else if (joinType.equals((Object)SQLJoinTableSource.JoinType.FULL_OUTER_JOIN)) {
            this.print0(this.ucase ? "FULL OUTER JOIN" : "full outer join");
        } else {
            this.print0(this.ucase ? joinType.name : joinType.name_lcase);
        }
    }

    @Override
    public boolean visit(SQLDataType x) {
        String dataTypeName = x.getName();
        this.print0(this.ucase ? dataTypeName.toUpperCase() : dataTypeName.toLowerCase());
        if (x.getArguments().size() > 0) {
            this.print('(');
            this.printAndAccept(x.getArguments(), ", ");
            this.print(')');
        }
        return false;
    }

    @Override
    protected void printFunctionName(String name) {
        String upperName = name.toUpperCase();
        if (this.builtInFunctions.contains(upperName)) {
            this.print0(this.ucase ? upperName : name);
        } else {
            this.print0(name);
        }
    }

    @Override
    public void endVisit(OdpsShowGrantsStmt x) {
    }

    @Override
    public boolean visit(OdpsShowGrantsStmt x) {
        this.print0(this.ucase ? "SHOW GRANTS" : "show grants");
        if (x.getUser() != null) {
            this.print0(this.ucase ? " FOR " : " for ");
            x.getUser().accept(this);
        }
        if (x.getObjectType() != null) {
            this.print0(this.ucase ? " ON TYPE " : " on type ");
            x.getObjectType().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(OdpsListStmt x) {
    }

    @Override
    public boolean visit(OdpsListStmt x) {
        this.print0(this.ucase ? "LIST " : "list ");
        if (x.getObject() != null) {
            x.getObject().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(OdpsGrantStmt x) {
    }

    @Override
    public boolean visit(OdpsGrantStmt x) {
        this.print0(this.ucase ? "GRANT " : "grant ");
        if (x.isSuper()) {
            this.print0(this.ucase ? "SUPER " : "super ");
        }
        if (x.isLabel()) {
            this.print0(this.ucase ? "LABEL " : "label ");
            x.getLabel().accept(this);
        } else {
            this.printAndAccept(x.getPrivileges(), ", ");
        }
        if (x.getOn() != null) {
            this.print0(this.ucase ? " ON " : " on ");
            if (x.getObjectType() != null) {
                this.print0(this.ucase ? x.getObjectType().name() : x.getObjectType().name().toLowerCase());
                this.print(' ');
            }
            x.getOn().accept(this);
            if (x.getColumns().size() > 0) {
                this.print('(');
                this.printAndAccept(x.getColumns(), ", ");
                this.print(')');
            }
        }
        if (x.getTo() != null) {
            this.print0(this.ucase ? " TO " : " to ");
            if (x.getSubjectType() != null) {
                this.print0(x.getSubjectType().name());
                this.print(' ');
            }
            x.getTo().accept(this);
        }
        if (x.getExpire() != null) {
            this.print0(this.ucase ? " WITH EXP " : " with exp ");
            x.getExpire().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(OdpsLateralViewTableSource x) {
    }

    @Override
    public boolean visit(OdpsLateralViewTableSource x) {
        x.getTableSource().accept(this);
        this.incrementIndent();
        this.println();
        this.print0(this.ucase ? "LATERAL VIEW " : "lateral view ");
        x.getMethod().accept(this);
        this.print(' ');
        this.print0(x.getAlias());
        this.print0(this.ucase ? " AS " : " as ");
        this.printAndAccept(x.getColumns(), ", ");
        this.decrementIndent();
        return false;
    }

    @Override
    public boolean visit(SQLCharExpr x) {
        String text = x.getText();
        if (text == null) {
            this.print0(this.ucase ? "NULL" : "null");
        } else {
            StringBuilder buf = new StringBuilder(text.length() + 2);
            buf.append('\'');
            block6: for (int i = 0; i < text.length(); ++i) {
                char ch = text.charAt(i);
                switch (ch) {
                    case '\\': {
                        buf.append("\\\\");
                        continue block6;
                    }
                    case '\'': {
                        buf.append("\\'");
                        continue block6;
                    }
                    case '\u0000': {
                        buf.append("\\0");
                        continue block6;
                    }
                    case '\n': {
                        buf.append("\\n");
                        continue block6;
                    }
                    default: {
                        buf.append(ch);
                    }
                }
            }
            buf.append('\'');
            this.print0(buf.toString());
        }
        return false;
    }

    @Override
    public void endVisit(OdpsValuesTableSource x) {
    }

    @Override
    public boolean visit(OdpsValuesTableSource x) {
        this.print0(this.ucase ? "VALUES " : "values ");
        this.printAndAccept(x.getValues(), ", ");
        this.print(' ');
        this.print0(x.getAlias());
        this.print0(" (");
        this.printAndAccept(x.getColumns(), ", ");
        this.print(')');
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableRenameColumn x) {
        this.print0(this.ucase ? "CHANGE COLUMN " : "change column ");
        x.getColumn().accept(this);
        this.print0(this.ucase ? " RENAME TO " : " rename to ");
        x.getTo().accept(this);
        return false;
    }
}

