/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.credentials.provider;

import com.aliyun.credentials.exception.CredentialException;
import com.aliyun.credentials.models.CredentialModel;
import com.aliyun.credentials.provider.AlibabaCloudCredentialsProvider;
import com.aliyun.credentials.provider.CLIProfileCredentialsProvider;
import com.aliyun.credentials.provider.EcsRamRoleCredentialProvider;
import com.aliyun.credentials.provider.EnvironmentVariableCredentialsProvider;
import com.aliyun.credentials.provider.OIDCRoleArnCredentialProvider;
import com.aliyun.credentials.provider.ProfileCredentialsProvider;
import com.aliyun.credentials.provider.SystemPropertiesCredentialsProvider;
import com.aliyun.credentials.provider.URLCredentialProvider;
import com.aliyun.credentials.utils.AuthUtils;
import com.aliyun.credentials.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class DefaultCredentialsProvider
implements AlibabaCloudCredentialsProvider {
    private final List<AlibabaCloudCredentialsProvider> defaultProviders = new ArrayList<AlibabaCloudCredentialsProvider>();
    private static final List<AlibabaCloudCredentialsProvider> USER_CONFIGURATION_PROVIDERS = new Vector<AlibabaCloudCredentialsProvider>();
    private volatile AlibabaCloudCredentialsProvider lastUsedCredentialsProvider;
    private final Boolean reuseLastProviderEnabled;

    public DefaultCredentialsProvider() {
        this.reuseLastProviderEnabled = true;
        this.createDefaultChain();
    }

    private DefaultCredentialsProvider(Builder builder) {
        this.reuseLastProviderEnabled = builder.reuseLastProviderEnabled;
        this.createDefaultChain();
    }

    private void createDefaultChain() {
        String uri;
        this.defaultProviders.add(new SystemPropertiesCredentialsProvider());
        this.defaultProviders.add(new EnvironmentVariableCredentialsProvider());
        if (AuthUtils.environmentEnableOIDC()) {
            this.defaultProviders.add(OIDCRoleArnCredentialProvider.builder().roleArn(AuthUtils.getEnvironmentRoleArn()).oidcProviderArn(AuthUtils.getEnvironmentOIDCProviderArn()).oidcTokenFilePath(AuthUtils.getEnvironmentOIDCTokenFilePath()).build());
        }
        this.defaultProviders.add(CLIProfileCredentialsProvider.builder().build());
        this.defaultProviders.add(new ProfileCredentialsProvider());
        String roleName = AuthUtils.getEnvironmentECSMetaData();
        if (null != roleName) {
            this.defaultProviders.add(EcsRamRoleCredentialProvider.builder().roleName(roleName).build());
        }
        if (!StringUtils.isEmpty(uri = AuthUtils.getEnvironmentCredentialsURI())) {
            this.defaultProviders.add(URLCredentialProvider.builder().credentialsURI(uri).build());
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public CredentialModel getCredentials() {
        if (this.reuseLastProviderEnabled.booleanValue() && this.lastUsedCredentialsProvider != null) {
            return this.lastUsedCredentialsProvider.getCredentials();
        }
        ArrayList<String> errorMessages = new ArrayList<String>();
        if (USER_CONFIGURATION_PROVIDERS.size() > 0) {
            for (AlibabaCloudCredentialsProvider provider : USER_CONFIGURATION_PROVIDERS) {
                try {
                    CredentialModel credential = provider.getCredentials();
                    this.lastUsedCredentialsProvider = provider;
                    return credential;
                }
                catch (Exception e) {
                    errorMessages.add(provider.getClass().getName() + ": " + e.getMessage());
                }
            }
        }
        for (AlibabaCloudCredentialsProvider provider : this.defaultProviders) {
            try {
                CredentialModel credential = provider.getCredentials();
                this.lastUsedCredentialsProvider = provider;
                return credential;
            }
            catch (Exception e) {
                errorMessages.add(provider.getClass().getSimpleName() + ": " + e.getMessage());
            }
        }
        throw new CredentialException("Unable to load credentials from any of the providers in the chain: ." + errorMessages);
    }

    @Deprecated
    public static boolean addCredentialsProvider(AlibabaCloudCredentialsProvider provider) {
        return USER_CONFIGURATION_PROVIDERS.add(provider);
    }

    @Deprecated
    public static boolean removeCredentialsProvider(AlibabaCloudCredentialsProvider provider) {
        return USER_CONFIGURATION_PROVIDERS.remove(provider);
    }

    @Deprecated
    public static boolean containsCredentialsProvider(AlibabaCloudCredentialsProvider provider) {
        return USER_CONFIGURATION_PROVIDERS.contains(provider);
    }

    @Deprecated
    public static void clearCredentialsProvider() {
        USER_CONFIGURATION_PROVIDERS.clear();
    }

    public static final class Builder {
        private Boolean reuseLastProviderEnabled = true;

        public Builder reuseLastProviderEnabled(Boolean reuseLastProviderEnabled) {
            this.reuseLastProviderEnabled = reuseLastProviderEnabled;
            return this;
        }

        DefaultCredentialsProvider build() {
            return new DefaultCredentialsProvider(this);
        }
    }
}

