/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.cms;

import com.aliyun.openservices.cms.exception.CMSException;
import com.aliyun.openservices.cms.http.HttpInvoker;
import com.aliyun.openservices.cms.http.HttpMethod;
import com.aliyun.openservices.cms.http.Request;
import com.aliyun.openservices.cms.http.Response;
import com.aliyun.openservices.cms.http.impl.AsyncInvoker;
import com.aliyun.openservices.cms.request.CustomEventUploadRequest;
import com.aliyun.openservices.cms.response.CustomEventUploadResponse;
import com.aliyun.openservices.cms.support.DateUtil;
import com.aliyun.openservices.cms.support.StringSupport;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.validator.routines.InetAddressValidator;

public class CMSClient {
    private final String endPoint;
    private final String accessKeyId;
    private final String accessSecret;
    private final String sourceIp;
    private HttpInvoker client;
    private final String host;

    public CMSClient(String endPoint, String accessKeyId, String accessSecret) {
        this(endPoint, accessKeyId, accessSecret, null);
    }

    public CMSClient(String endPoint, String accessKeyId, String accessSecret, String sourceIp) {
        if (endPoint.endsWith("/")) {
            endPoint = endPoint.substring(0, endPoint.length() - 1);
        }
        if (endPoint.startsWith("http://")) {
            this.host = endPoint.substring(7, endPoint.length());
        } else if (endPoint.startsWith("https://")) {
            this.host = endPoint.substring(8, endPoint.length());
        } else {
            throw new IllegalArgumentException("endpoint must start with 'http' or 'https', only hostname");
        }
        this.endPoint = endPoint;
        this.accessKeyId = accessKeyId;
        this.accessSecret = accessSecret;
        AsyncInvoker invoker = new AsyncInvoker();
        invoker.init();
        this.client = invoker;
        if (StringSupport.isNullOrEmpty(sourceIp, true)) {
            sourceIp = this.localMachineIp();
        }
        this.sourceIp = sourceIp;
    }

    public void setClient(HttpInvoker client) {
        this.client = client;
    }

    public CustomEventUploadResponse putCustomEvent(CustomEventUploadRequest request) throws CMSException {
        Response response = this.invokeHttp(request.httpMethod(), request.uri(), request.queryParam(), request.body());
        CustomEventUploadResponse ret = new CustomEventUploadResponse();
        ret.setRequestId(response.getRequestId());
        ret.setCode(response.getCode());
        ret.setMessage(response.getMsg());
        return ret;
    }

    protected Response invokeHttp(HttpMethod method, String resourceUri, Map<String, String> parameters, byte[] body) throws CMSException {
        Map<String, String> headers = this.headers();
        if (body.length > 0) {
            headers.put("Content-MD5", this.md5(body));
        }
        headers.put("Content-Length", String.valueOf(body.length));
        this.signature(method.toString(), headers, resourceUri, parameters);
        Request request = new Request();
        request.setBody(body);
        request.setHeaders(headers);
        request.setQueryParams(parameters);
        request.setHttpMethod(method);
        request.setUri(this.endPoint + resourceUri);
        Response response = null;
        try {
            response = this.client.doHttpClient(request);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CMSException("", "500", e.getMessage());
        }
        if (response.getHttpStatusCode() != 200 || !"200".equals(response.getCode())) {
            throw new CMSException(response.getRequestId(), response.getCode(), response.getMsg());
        }
        return response;
    }

    private String md5(byte[] bytes) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            return StringSupport.base16(md.digest(bytes));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Not Supported signature method MD5", e);
        }
    }

    private void signature(String verb, Map<String, String> headers, String resourceUri, Map<String, String> urlParams) {
        StringBuilder builder = new StringBuilder();
        builder.append(verb).append("\n");
        builder.append(this.getMapValue(headers, "Content-MD5")).append("\n");
        builder.append(this.getMapValue(headers, "Content-Type")).append("\n");
        builder.append(this.getMapValue(headers, "Date")).append("\n");
        builder.append(this.getCanonicalizedHeaders(headers)).append("\n");
        builder.append(resourceUri);
        if (!urlParams.isEmpty()) {
            builder.append("?");
            builder.append(this.buildUrlParameter(urlParams));
        }
        String signature = this.caluSignature(this.accessSecret, builder.toString());
        headers.put("Authorization", this.accessKeyId + ":" + signature);
    }

    private String getMapValue(Map<String, String> map, String key) {
        if (map.containsKey(key)) {
            return map.get(key);
        }
        return "";
    }

    private String buildUrlParameter(Map<String, String> paras) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>(paras);
        StringBuilder builder = new StringBuilder();
        boolean isFirst = true;
        for (Map.Entry entry : treeMap.entrySet()) {
            if (isFirst) {
                isFirst = false;
            } else {
                builder.append("&");
            }
            builder.append((String)entry.getKey()).append("=").append((String)entry.getValue());
        }
        return builder.toString();
    }

    private String getCanonicalizedHeaders(Map<String, String> headers) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>(headers);
        StringBuilder builder = new StringBuilder();
        boolean isFirst = true;
        for (Map.Entry entry : treeMap.entrySet()) {
            if (!((String)entry.getKey()).startsWith("x-cms-") && !((String)entry.getKey()).startsWith("x-acs-")) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                builder.append("\n");
            }
            builder.append((String)entry.getKey()).append(":").append((String)entry.getValue());
        }
        return builder.toString();
    }

    private String caluSignature(String accesskey, String data) {
        try {
            byte[] keyBytes = accesskey.getBytes("UTF-8");
            byte[] dataBytes = data.getBytes("UTF-8");
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(new SecretKeySpec(keyBytes, "HmacSHA1"));
            String sig = new String(StringSupport.base16(mac.doFinal(dataBytes)));
            return sig;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Not Supported encoding method UTF-8", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Not Supported signature method hmac-sha1", e);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("Failed to calcuate the signature", e);
        }
    }

    private Map<String, String> headers() {
        HashMap<String, String> headParameter = new HashMap<String, String>();
        headParameter.put("User-Agent", "cms-java-sdk-v-1.0");
        headParameter.put("Content-Length", "0");
        headParameter.put("Content-Type", "application/json");
        headParameter.put("Date", DateUtil.formatRfc822Date(new Date()));
        headParameter.put("Host", this.host);
        headParameter.put("x-cms-api-version", "1.0");
        headParameter.put("x-cms-signature", "hmac-sha1");
        headParameter.put("x-cms-ip", this.sourceIp);
        return headParameter;
    }

    private String localMachineIp() {
        InetAddressValidator validator = new InetAddressValidator();
        String candidate = "N/A";
        try {
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                NetworkInterface iface = ifaces.nextElement();
                if (!iface.isUp()) continue;
                Enumeration<InetAddress> addresses = iface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    String ipAddress;
                    InetAddress address = addresses.nextElement();
                    if (address.isLinkLocalAddress() || address.getHostAddress() == null || (ipAddress = address.getHostAddress()).equals("127.0.0.1")) continue;
                    if (validator.isValidInet4Address(ipAddress)) {
                        return ipAddress;
                    }
                    if (!validator.isValid(ipAddress)) continue;
                    candidate = ipAddress;
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return candidate;
    }
}

