/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.cms.builder;

import com.aliyun.openservices.cms.CMSClientInit;
import com.aliyun.openservices.cms.model.Event;
import com.aliyun.openservices.cms.support.PreCondition;
import com.aliyun.openservices.cms.support.StringSupport;
import java.util.Date;
import java.util.UUID;

public abstract class AbstractEventBuilder<T extends Event> {
    protected T event;

    protected void verify() {
        PreCondition.checkIsTrue(StringSupport.isNullOrEmpty(((Event)this.event).getName(), true), "'name' must not be empty");
        PreCondition.checkIsTrue(((Event)this.event).getGroupId() == null && CMSClientInit.groupId == null, "'groupId' must not be empty ");
    }

    protected void setDefaultValue() {
        if (((Event)this.event).getRegionId() == null) {
            ((Event)this.event).setRegionId("N/A");
        }
        if (((Event)this.event).getTrace() == null) {
            ((Event)this.event).setTrace(UUID.randomUUID().toString());
        }
        if (((Event)this.event).getTime() == null) {
            ((Event)this.event).setTime(new Date());
        }
        if (((Event)this.event).getStatus() == null) {
            ((Event)this.event).setStatus("N/A");
        }
        if (((Event)this.event).getGroupId() == null) {
            ((Event)this.event).setGroupId(CMSClientInit.groupId);
        }
    }

    public T build() {
        this.verify();
        this.setDefaultValue();
        return this.event;
    }
}

