/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai;

import com.azure.ai.openai.OpenAIClientBuilder;
import com.azure.ai.openai.implementation.AudioTranscriptionValidator;
import com.azure.ai.openai.implementation.AudioTranslationValidator;
import com.azure.ai.openai.implementation.CompletionsUtils;
import com.azure.ai.openai.implementation.EmbeddingsUtils;
import com.azure.ai.openai.implementation.MultipartFormDataHelper;
import com.azure.ai.openai.implementation.NonAzureOpenAIClientImpl;
import com.azure.ai.openai.implementation.OpenAIClientImpl;
import com.azure.ai.openai.implementation.OpenAIServerSentEvents;
import com.azure.ai.openai.implementation.OpenAIUtils;
import com.azure.ai.openai.implementation.accesshelpers.ChatCompletionsOptionsAccessHelper;
import com.azure.ai.openai.implementation.accesshelpers.CompletionsOptionsAccessHelper;
import com.azure.ai.openai.implementation.accesshelpers.PageableListAccessHelper;
import com.azure.ai.openai.implementation.models.FileListResponse;
import com.azure.ai.openai.implementation.models.OpenAIPageableListOfBatch;
import com.azure.ai.openai.implementation.models.UploadFileRequest;
import com.azure.ai.openai.models.AddUploadPartRequest;
import com.azure.ai.openai.models.AudioTranscription;
import com.azure.ai.openai.models.AudioTranscriptionOptions;
import com.azure.ai.openai.models.AudioTranscriptionTimestampGranularity;
import com.azure.ai.openai.models.AudioTranslation;
import com.azure.ai.openai.models.AudioTranslationOptions;
import com.azure.ai.openai.models.Batch;
import com.azure.ai.openai.models.BatchCreateRequest;
import com.azure.ai.openai.models.ChatCompletionStreamOptions;
import com.azure.ai.openai.models.ChatCompletions;
import com.azure.ai.openai.models.ChatCompletionsOptions;
import com.azure.ai.openai.models.CompleteUploadRequest;
import com.azure.ai.openai.models.Completions;
import com.azure.ai.openai.models.CompletionsOptions;
import com.azure.ai.openai.models.CreateUploadRequest;
import com.azure.ai.openai.models.Embeddings;
import com.azure.ai.openai.models.EmbeddingsOptions;
import com.azure.ai.openai.models.FileDeletionStatus;
import com.azure.ai.openai.models.FileDetails;
import com.azure.ai.openai.models.FilePurpose;
import com.azure.ai.openai.models.ImageGenerationOptions;
import com.azure.ai.openai.models.ImageGenerations;
import com.azure.ai.openai.models.OpenAIFile;
import com.azure.ai.openai.models.PageableList;
import com.azure.ai.openai.models.SpeechGenerationOptions;
import com.azure.ai.openai.models.Upload;
import com.azure.ai.openai.models.UploadPart;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.BinaryData;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.IterableStream;
import com.azure.core.util.logging.ClientLogger;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import reactor.core.publisher.Flux;

@ServiceClient(builder=OpenAIClientBuilder.class)
public final class OpenAIClient {
    private static final ClientLogger LOGGER = new ClientLogger(OpenAIClient.class);
    private final OpenAIClientImpl serviceClient;
    private final NonAzureOpenAIClientImpl openAIServiceClient;

    OpenAIClient(OpenAIClientImpl serviceClient) {
        this.serviceClient = serviceClient;
        this.openAIServiceClient = null;
    }

    OpenAIClient(NonAzureOpenAIClientImpl serviceClient) {
        this.serviceClient = null;
        this.openAIServiceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getEmbeddingsWithResponse(String deploymentOrModelName, BinaryData embeddingsOptions, RequestOptions requestOptions) {
        BinaryData embeddingsOptionsUpdated = EmbeddingsUtils.addEncodingFormat(embeddingsOptions);
        return this.openAIServiceClient != null ? this.openAIServiceClient.getEmbeddingsWithResponse(deploymentOrModelName, embeddingsOptionsUpdated, requestOptions) : this.serviceClient.getEmbeddingsWithResponse(deploymentOrModelName, embeddingsOptionsUpdated, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getCompletionsWithResponse(String deploymentOrModelName, BinaryData completionsOptions, RequestOptions requestOptions) {
        return this.openAIServiceClient != null ? this.openAIServiceClient.getCompletionsWithResponse(deploymentOrModelName, completionsOptions, requestOptions) : this.serviceClient.getCompletionsWithResponse(deploymentOrModelName, completionsOptions, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getChatCompletionsWithResponse(String deploymentOrModelName, BinaryData chatCompletionsOptions, RequestOptions requestOptions) {
        return this.openAIServiceClient != null ? this.openAIServiceClient.getChatCompletionsWithResponse(deploymentOrModelName, chatCompletionsOptions, requestOptions) : this.serviceClient.getChatCompletionsWithResponse(deploymentOrModelName, chatCompletionsOptions, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Embeddings> getEmbeddingsWithResponse(String deploymentOrModelName, EmbeddingsOptions embeddingsOptions, RequestOptions requestOptions) {
        Response<BinaryData> response = this.getEmbeddingsWithResponse(deploymentOrModelName, BinaryData.fromObject((Object)embeddingsOptions), requestOptions);
        return new SimpleResponse(response, (Object)((Embeddings)((BinaryData)response.getValue()).toObject(Embeddings.class)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Completions> getCompletionsWithResponse(String deploymentOrModelName, CompletionsOptions completionsOptions, RequestOptions requestOptions) {
        Response<BinaryData> response = this.getCompletionsWithResponse(deploymentOrModelName, BinaryData.fromObject((Object)completionsOptions), requestOptions);
        return new SimpleResponse(response, (Object)((Completions)((BinaryData)response.getValue()).toObject(Completions.class)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ChatCompletions> getChatCompletionsWithResponse(String deploymentOrModelName, ChatCompletionsOptions chatCompletionsOptions, RequestOptions requestOptions) {
        Response<BinaryData> response = this.getChatCompletionsWithResponse(deploymentOrModelName, BinaryData.fromObject((Object)chatCompletionsOptions), requestOptions);
        return new SimpleResponse(response, (Object)((ChatCompletions)((BinaryData)response.getValue()).toObject(ChatCompletions.class)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Embeddings getEmbeddings(String deploymentOrModelName, EmbeddingsOptions embeddingsOptions) {
        RequestOptions requestOptions = new RequestOptions();
        return (Embeddings)((BinaryData)this.getEmbeddingsWithResponse(deploymentOrModelName, BinaryData.fromObject((Object)embeddingsOptions), requestOptions).getValue()).toObject(Embeddings.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Completions getCompletions(String deploymentOrModelName, CompletionsOptions completionsOptions) {
        RequestOptions requestOptions = new RequestOptions();
        return (Completions)((BinaryData)this.getCompletionsWithResponse(deploymentOrModelName, BinaryData.fromObject((Object)completionsOptions), requestOptions).getValue()).toObject(Completions.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Completions getCompletions(String deploymentOrModelName, String prompt) {
        return this.getCompletions(deploymentOrModelName, CompletionsUtils.defaultCompletionsOptions(prompt));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public IterableStream<Completions> getCompletionsStream(String deploymentOrModelName, CompletionsOptions completionsOptions) {
        CompletionsOptionsAccessHelper.setStream(completionsOptions, true);
        RequestOptions requestOptions = new RequestOptions();
        Flux responseStream = ((BinaryData)this.getCompletionsWithResponse(deploymentOrModelName, BinaryData.fromObject((Object)completionsOptions), requestOptions).getValue()).toFluxByteBuffer();
        OpenAIServerSentEvents<Completions> completionsStream = new OpenAIServerSentEvents<Completions>((Flux<ByteBuffer>)responseStream, Completions.class);
        return new IterableStream(completionsStream.getEvents());
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public IterableStream<Completions> getCompletionsStream(String deploymentOrModelName, CompletionsOptions completionsOptions, ChatCompletionStreamOptions streamOptions) {
        CompletionsOptionsAccessHelper.setStream(completionsOptions, true);
        CompletionsOptionsAccessHelper.setStreamOptions(completionsOptions, streamOptions);
        RequestOptions requestOptions = new RequestOptions();
        Flux responseStream = ((BinaryData)this.getCompletionsWithResponse(deploymentOrModelName, BinaryData.fromObject((Object)completionsOptions), requestOptions).getValue()).toFluxByteBuffer();
        OpenAIServerSentEvents<Completions> completionsStream = new OpenAIServerSentEvents<Completions>((Flux<ByteBuffer>)responseStream, Completions.class);
        return new IterableStream(completionsStream.getEvents());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ChatCompletions getChatCompletions(String deploymentOrModelName, ChatCompletionsOptions chatCompletionsOptions) {
        RequestOptions requestOptions = new RequestOptions();
        return (ChatCompletions)((BinaryData)this.getChatCompletionsWithResponse(deploymentOrModelName, BinaryData.fromObject((Object)chatCompletionsOptions), requestOptions).getValue()).toObject(ChatCompletions.class);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public IterableStream<ChatCompletions> getChatCompletionsStream(String deploymentOrModelName, ChatCompletionsOptions chatCompletionsOptions) {
        ChatCompletionsOptionsAccessHelper.setStream(chatCompletionsOptions, true);
        RequestOptions requestOptions = new RequestOptions();
        Flux responseStream = ((BinaryData)this.getChatCompletionsWithResponse(deploymentOrModelName, BinaryData.fromObject((Object)chatCompletionsOptions), requestOptions).getValue()).toFluxByteBuffer();
        OpenAIServerSentEvents<ChatCompletions> chatCompletionsStream = new OpenAIServerSentEvents<ChatCompletions>((Flux<ByteBuffer>)responseStream, ChatCompletions.class);
        return new IterableStream(chatCompletionsStream.getEvents());
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public IterableStream<ChatCompletions> getChatCompletionsStream(String deploymentOrModelName, ChatCompletionsOptions chatCompletionsOptions, ChatCompletionStreamOptions streamOptions) {
        ChatCompletionsOptionsAccessHelper.setStream(chatCompletionsOptions, true);
        ChatCompletionsOptionsAccessHelper.setStreamOptions(chatCompletionsOptions, streamOptions);
        RequestOptions requestOptions = new RequestOptions();
        Flux responseStream = ((BinaryData)this.getChatCompletionsWithResponse(deploymentOrModelName, BinaryData.fromObject((Object)chatCompletionsOptions), requestOptions).getValue()).toFluxByteBuffer();
        OpenAIServerSentEvents<ChatCompletions> chatCompletionsStream = new OpenAIServerSentEvents<ChatCompletions>((Flux<ByteBuffer>)responseStream, ChatCompletions.class);
        return new IterableStream(chatCompletionsStream.getEvents());
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public Response<IterableStream<ChatCompletions>> getChatCompletionsStreamWithResponse(String deploymentOrModelName, ChatCompletionsOptions chatCompletionsOptions, RequestOptions requestOptions) {
        ChatCompletionsOptionsAccessHelper.setStream(chatCompletionsOptions, true);
        Response<BinaryData> response = this.getChatCompletionsWithResponse(deploymentOrModelName, BinaryData.fromObject((Object)chatCompletionsOptions), requestOptions);
        Flux responseStream = ((BinaryData)response.getValue()).toFluxByteBuffer();
        OpenAIServerSentEvents<ChatCompletions> chatCompletionsStream = new OpenAIServerSentEvents<ChatCompletions>((Flux<ByteBuffer>)responseStream, ChatCompletions.class);
        return new SimpleResponse(response, (Object)new IterableStream(chatCompletionsStream.getEvents()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AudioTranscription getAudioTranscription(String deploymentOrModelName, String fileName, AudioTranscriptionOptions audioTranscriptionOptions) {
        return (AudioTranscription)this.getAudioTranscriptionWithResponse(deploymentOrModelName, fileName, audioTranscriptionOptions, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AudioTranscription> getAudioTranscriptionWithResponse(String deploymentOrModelName, String fileName, AudioTranscriptionOptions audioTranscriptionOptions, RequestOptions requestOptions) {
        AudioTranscriptionValidator.validateAudioResponseFormatForTranscription(audioTranscriptionOptions);
        if (this.openAIServiceClient != null) {
            audioTranscriptionOptions.setModel(deploymentOrModelName);
        }
        if (CoreUtils.isNullOrEmpty((CharSequence)audioTranscriptionOptions.getFilename())) {
            audioTranscriptionOptions.setFilename(fileName);
        }
        RequestOptions multipartRequestOptions = requestOptions == null ? new RequestOptions() : requestOptions;
        FileDetails file = new FileDetails(BinaryData.fromBytes((byte[])audioTranscriptionOptions.getFile()), fileName);
        String temperature = audioTranscriptionOptions.getTemperature() == null ? null : String.valueOf(audioTranscriptionOptions.getTemperature());
        MultipartFormDataHelper multipartRequest = new MultipartFormDataHelper(multipartRequestOptions).serializeFileField("file", file.getContent(), file.getContentType(), file.getFilename()).serializeTextField("response_format", audioTranscriptionOptions.getResponseFormat().toString()).serializeTextField("model", audioTranscriptionOptions.getModel()).serializeTextField("prompt", audioTranscriptionOptions.getPrompt()).serializeTextField("language", audioTranscriptionOptions.getLanguage()).serializeTextField("temperature", temperature);
        List<AudioTranscriptionTimestampGranularity> timestampGranularities = audioTranscriptionOptions.getTimestampGranularities();
        if (!CoreUtils.isNullOrEmpty(timestampGranularities)) {
            for (AudioTranscriptionTimestampGranularity timestampGranularity : timestampGranularities) {
                multipartRequest.serializeTextField("timestamp_granularities[]", timestampGranularity.toString());
            }
        }
        BinaryData uploadFileRequest = multipartRequest.end().getRequestBody();
        Response<BinaryData> response = this.openAIServiceClient != null ? this.openAIServiceClient.getAudioTranscriptionAsPlainTextWithResponse(deploymentOrModelName, uploadFileRequest, multipartRequestOptions) : this.serviceClient.getAudioTranscriptionAsPlainTextWithResponse(deploymentOrModelName, uploadFileRequest, multipartRequestOptions);
        return new SimpleResponse(response, (Object)((AudioTranscription)((BinaryData)response.getValue()).toObject(AudioTranscription.class)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public String getAudioTranscriptionText(String deploymentOrModelName, String fileName, AudioTranscriptionOptions audioTranscriptionOptions) {
        return (String)this.getAudioTranscriptionTextWithResponse(deploymentOrModelName, fileName, audioTranscriptionOptions, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<String> getAudioTranscriptionTextWithResponse(String deploymentOrModelName, String fileName, AudioTranscriptionOptions audioTranscriptionOptions, RequestOptions requestOptions) {
        AudioTranscriptionValidator.validateAudioResponseFormatForTranscriptionText(audioTranscriptionOptions);
        if (this.openAIServiceClient != null) {
            audioTranscriptionOptions.setModel(deploymentOrModelName);
        }
        if (CoreUtils.isNullOrEmpty((CharSequence)audioTranscriptionOptions.getFilename())) {
            audioTranscriptionOptions.setFilename(fileName);
        }
        RequestOptions multipartRequestOptions = requestOptions == null ? new RequestOptions() : requestOptions;
        FileDetails file = new FileDetails(BinaryData.fromBytes((byte[])audioTranscriptionOptions.getFile()), fileName);
        String temperature = audioTranscriptionOptions.getTemperature() == null ? null : String.valueOf(audioTranscriptionOptions.getTemperature());
        BinaryData uploadFileRequest = new MultipartFormDataHelper(multipartRequestOptions).serializeFileField("file", file.getContent(), file.getContentType(), file.getFilename()).serializeTextField("response_format", audioTranscriptionOptions.getResponseFormat().toString()).serializeTextField("model", audioTranscriptionOptions.getModel()).serializeTextField("prompt", audioTranscriptionOptions.getPrompt()).serializeTextField("language", audioTranscriptionOptions.getLanguage()).serializeTextField("temperature", temperature).end().getRequestBody();
        Response<BinaryData> response = this.openAIServiceClient != null ? this.openAIServiceClient.getAudioTranscriptionAsPlainTextWithResponse(deploymentOrModelName, uploadFileRequest, multipartRequestOptions) : this.serviceClient.getAudioTranscriptionAsPlainTextWithResponse(deploymentOrModelName, uploadFileRequest, multipartRequestOptions);
        return new SimpleResponse(response, (Object)((BinaryData)response.getValue()).toString());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AudioTranslation getAudioTranslation(String deploymentOrModelName, String fileName, AudioTranslationOptions audioTranslationOptions) {
        return (AudioTranslation)this.getAudioTranslationWithResponse(deploymentOrModelName, fileName, audioTranslationOptions, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AudioTranslation> getAudioTranslationWithResponse(String deploymentOrModelName, String fileName, AudioTranslationOptions audioTranslationOptions, RequestOptions requestOptions) {
        AudioTranslationValidator.validateAudioResponseFormatForTranslation(audioTranslationOptions);
        if (this.openAIServiceClient != null) {
            audioTranslationOptions.setModel(deploymentOrModelName);
        }
        if (CoreUtils.isNullOrEmpty((CharSequence)audioTranslationOptions.getFilename())) {
            audioTranslationOptions.setFilename(fileName);
        }
        RequestOptions multipartRequestOptions = requestOptions == null ? new RequestOptions() : requestOptions;
        FileDetails file = new FileDetails(BinaryData.fromBytes((byte[])audioTranslationOptions.getFile()), fileName);
        String temperature = audioTranslationOptions.getTemperature() == null ? null : String.valueOf(audioTranslationOptions.getTemperature());
        BinaryData uploadFileRequest = new MultipartFormDataHelper(multipartRequestOptions).serializeFileField("file", file.getContent(), file.getContentType(), file.getFilename()).serializeTextField("response_format", audioTranslationOptions.getResponseFormat().toString()).serializeTextField("model", audioTranslationOptions.getModel()).serializeTextField("prompt", audioTranslationOptions.getPrompt()).serializeTextField("temperature", temperature).end().getRequestBody();
        Response<BinaryData> response = this.openAIServiceClient != null ? this.openAIServiceClient.getAudioTranslationAsPlainTextWithResponse(deploymentOrModelName, uploadFileRequest, multipartRequestOptions) : this.serviceClient.getAudioTranslationAsPlainTextWithResponse(deploymentOrModelName, uploadFileRequest, multipartRequestOptions);
        return new SimpleResponse(response, (Object)((AudioTranslation)((BinaryData)response.getValue()).toObject(AudioTranslation.class)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public String getAudioTranslationText(String deploymentOrModelName, String fileName, AudioTranslationOptions audioTranslationOptions) {
        return (String)this.getAudioTranslationTextWithResponse(deploymentOrModelName, fileName, audioTranslationOptions, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<String> getAudioTranslationTextWithResponse(String deploymentOrModelName, String fileName, AudioTranslationOptions audioTranslationOptions, RequestOptions requestOptions) {
        AudioTranslationValidator.validateAudioResponseFormatForTranslationText(audioTranslationOptions);
        if (this.openAIServiceClient != null) {
            audioTranslationOptions.setModel(deploymentOrModelName);
        }
        if (CoreUtils.isNullOrEmpty((CharSequence)audioTranslationOptions.getFilename())) {
            audioTranslationOptions.setFilename(fileName);
        }
        RequestOptions multipartRequestOptions = requestOptions == null ? new RequestOptions() : requestOptions;
        FileDetails file = new FileDetails(BinaryData.fromBytes((byte[])audioTranslationOptions.getFile()), fileName);
        String temperature = audioTranslationOptions.getTemperature() == null ? null : String.valueOf(audioTranslationOptions.getTemperature());
        BinaryData uploadFileRequest = new MultipartFormDataHelper(multipartRequestOptions).serializeFileField("file", file.getContent(), file.getContentType(), file.getFilename()).serializeTextField("response_format", audioTranslationOptions.getResponseFormat().toString()).serializeTextField("model", audioTranslationOptions.getModel()).serializeTextField("prompt", audioTranslationOptions.getPrompt()).serializeTextField("temperature", temperature).end().getRequestBody();
        Response<BinaryData> response = this.openAIServiceClient != null ? this.openAIServiceClient.getAudioTranslationAsPlainTextWithResponse(deploymentOrModelName, uploadFileRequest, multipartRequestOptions) : this.serviceClient.getAudioTranslationAsPlainTextWithResponse(deploymentOrModelName, uploadFileRequest, multipartRequestOptions);
        return new SimpleResponse(response, (Object)((BinaryData)response.getValue()).toString());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Response<BinaryData> getAudioTranscriptionAsResponseObjectWithResponse(String deploymentOrModelName, BinaryData audioTranscriptionOptions, RequestOptions requestOptions) {
        return this.serviceClient.getAudioTranscriptionAsResponseObjectWithResponse(deploymentOrModelName, audioTranscriptionOptions, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Response<BinaryData> getAudioTranscriptionAsPlainTextWithResponse(String deploymentOrModelName, BinaryData audioTranscriptionOptions, RequestOptions requestOptions) {
        return this.serviceClient.getAudioTranscriptionAsPlainTextWithResponse(deploymentOrModelName, audioTranscriptionOptions, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Response<BinaryData> getAudioTranslationAsResponseObjectWithResponse(String deploymentOrModelName, BinaryData audioTranslationOptions, RequestOptions requestOptions) {
        return this.serviceClient.getAudioTranslationAsResponseObjectWithResponse(deploymentOrModelName, audioTranslationOptions, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Response<BinaryData> getAudioTranslationAsPlainTextWithResponse(String deploymentOrModelName, BinaryData audioTranslationOptions, RequestOptions requestOptions) {
        return this.serviceClient.getAudioTranslationAsPlainTextWithResponse(deploymentOrModelName, audioTranslationOptions, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public String getAudioTranscriptionAsPlainText(String deploymentOrModelName, AudioTranscriptionOptions audioTranscriptionOptions) {
        RequestOptions requestOptions = new RequestOptions();
        return (String)((BinaryData)this.getAudioTranscriptionAsPlainTextWithResponse(deploymentOrModelName, BinaryData.fromObject((Object)audioTranscriptionOptions), requestOptions).getValue()).toObject(String.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public String getAudioTranslationAsPlainText(String deploymentOrModelName, AudioTranslationOptions audioTranslationOptions) {
        RequestOptions requestOptions = new RequestOptions();
        return (String)((BinaryData)this.getAudioTranslationAsPlainTextWithResponse(deploymentOrModelName, BinaryData.fromObject((Object)audioTranslationOptions), requestOptions).getValue()).toObject(String.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Response<BinaryData> getImageGenerationsWithResponse(String deploymentOrModelName, BinaryData imageGenerationOptions, RequestOptions requestOptions) {
        return this.openAIServiceClient != null ? this.openAIServiceClient.getImageGenerationsWithResponse(deploymentOrModelName, imageGenerationOptions, requestOptions) : this.serviceClient.getImageGenerationsWithResponse(deploymentOrModelName, imageGenerationOptions, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ImageGenerations> getImageGenerationsWithResponse(String deploymentOrModelName, ImageGenerationOptions imageGenerationOptions, RequestOptions requestOptions) {
        Response<BinaryData> response = this.getImageGenerationsWithResponse(deploymentOrModelName, BinaryData.fromObject((Object)imageGenerationOptions), requestOptions);
        return new SimpleResponse(response, (Object)((ImageGenerations)((BinaryData)response.getValue()).toObject(ImageGenerations.class)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ImageGenerations getImageGenerations(String deploymentOrModelName, ImageGenerationOptions imageGenerationOptions) {
        RequestOptions requestOptions = new RequestOptions();
        return (ImageGenerations)((BinaryData)this.getImageGenerationsWithResponse(deploymentOrModelName, BinaryData.fromObject((Object)imageGenerationOptions), requestOptions).getValue()).toObject(ImageGenerations.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    AudioTranscription getAudioTranscriptionAsResponseObject(String deploymentOrModelName, AudioTranscriptionOptions audioTranscriptionOptions) {
        return this.getAudioTranscription(deploymentOrModelName, "filename", audioTranscriptionOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    AudioTranslation getAudioTranslationAsResponseObject(String deploymentOrModelName, AudioTranslationOptions audioTranslationOptions) {
        return this.getAudioTranslation(deploymentOrModelName, "filename", audioTranslationOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> generateSpeechFromTextWithResponse(String deploymentOrModelName, BinaryData speechGenerationOptions, RequestOptions requestOptions) {
        BinaryData speechGenerationOptionsWithModelId = NonAzureOpenAIClientImpl.addModelIdJson(speechGenerationOptions, deploymentOrModelName);
        return this.openAIServiceClient != null ? this.openAIServiceClient.generateSpeechFromTextWithResponse(speechGenerationOptionsWithModelId, requestOptions) : this.serviceClient.generateSpeechFromTextWithResponse(deploymentOrModelName, speechGenerationOptionsWithModelId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BinaryData generateSpeechFromText(String deploymentOrModelName, SpeechGenerationOptions speechGenerationOptions) {
        RequestOptions requestOptions = new RequestOptions();
        return (BinaryData)this.generateSpeechFromTextWithResponse(deploymentOrModelName, BinaryData.fromObject((Object)speechGenerationOptions), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<List<OpenAIFile>> listFilesWithResponse(RequestOptions requestOptions) {
        Response<BinaryData> listedFilesWithResponse;
        if (this.openAIServiceClient != null) {
            listedFilesWithResponse = this.openAIServiceClient.listFilesWithResponse(requestOptions);
        } else {
            OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
            listedFilesWithResponse = this.serviceClient.listFilesWithResponse(requestOptions);
        }
        return new SimpleResponse(listedFilesWithResponse, ((FileListResponse)((BinaryData)listedFilesWithResponse.getValue()).toObject(FileListResponse.class)).getData());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Response<OpenAIFile> uploadFileWithResponse(BinaryData uploadFileRequest, RequestOptions requestOptions) {
        Response<BinaryData> uploadedFileWithResponse;
        if (this.openAIServiceClient != null) {
            uploadedFileWithResponse = this.openAIServiceClient.uploadFileWithResponse(uploadFileRequest, requestOptions);
        } else {
            OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
            try {
                uploadedFileWithResponse = this.serviceClient.uploadFileWithResponse(uploadFileRequest, requestOptions);
            }
            catch (HttpResponseException ex) {
                HttpResponse httpResponse = ex.getResponse();
                if (httpResponse.getStatusCode() == 201) {
                    return new ResponseBase(httpResponse.getRequest(), httpResponse.getStatusCode(), httpResponse.getHeaders(), (Object)((OpenAIFile)BinaryData.fromObject((Object)ex.getValue()).toObject(OpenAIFile.class)), null);
                }
                throw LOGGER.logExceptionAsError((RuntimeException)((Object)ex));
            }
        }
        return new SimpleResponse(uploadedFileWithResponse, (Object)((OpenAIFile)((BinaryData)uploadedFileWithResponse.getValue()).toObject(OpenAIFile.class)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<FileDeletionStatus> deleteFileWithResponse(String fileId, RequestOptions requestOptions) {
        Response<BinaryData> deletedFileWithResponse;
        if (this.openAIServiceClient != null) {
            deletedFileWithResponse = this.openAIServiceClient.deleteFileWithResponse(fileId, requestOptions);
        } else {
            OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
            try {
                deletedFileWithResponse = this.serviceClient.deleteFileWithResponse(fileId, requestOptions);
            }
            catch (HttpResponseException ex) {
                HttpResponse httpResponse = ex.getResponse();
                if (httpResponse.getStatusCode() == 204) {
                    return new ResponseBase(httpResponse.getRequest(), httpResponse.getStatusCode(), httpResponse.getHeaders(), (Object)((FileDeletionStatus)BinaryData.fromObject((Object)ex.getValue()).toObject(FileDeletionStatus.class)), null);
                }
                throw LOGGER.logExceptionAsError((RuntimeException)((Object)ex));
            }
        }
        return new SimpleResponse(deletedFileWithResponse, (Object)((FileDeletionStatus)((BinaryData)deletedFileWithResponse.getValue()).toObject(FileDeletionStatus.class)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<OpenAIFile> getFileWithResponse(String fileId, RequestOptions requestOptions) {
        Response<BinaryData> retrievedFileWithResponse;
        if (this.openAIServiceClient != null) {
            retrievedFileWithResponse = this.openAIServiceClient.getFileWithResponse(fileId, requestOptions);
        } else {
            OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
            retrievedFileWithResponse = this.serviceClient.getFileWithResponse(fileId, requestOptions);
        }
        return new SimpleResponse(retrievedFileWithResponse, (Object)((OpenAIFile)((BinaryData)retrievedFileWithResponse.getValue()).toObject(OpenAIFile.class)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<byte[]> getFileContentWithResponse(String fileId, RequestOptions requestOptions) {
        Response<BinaryData> fileContentWithResponse;
        if (this.openAIServiceClient != null) {
            fileContentWithResponse = this.openAIServiceClient.getFileContentWithResponse(fileId, requestOptions);
        } else {
            OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
            fileContentWithResponse = this.serviceClient.getFileContentWithResponse(fileId, requestOptions);
        }
        return new SimpleResponse(fileContentWithResponse, (Object)((BinaryData)fileContentWithResponse.getValue()).toBytes());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PageableList<Batch>> listBatchesWithResponse(RequestOptions requestOptions) {
        Response<BinaryData> listedBatchesWithResponse;
        if (this.openAIServiceClient != null) {
            listedBatchesWithResponse = this.openAIServiceClient.listBatchesWithResponse(requestOptions);
        } else {
            OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
            listedBatchesWithResponse = this.serviceClient.listBatchesWithResponse(requestOptions);
        }
        OpenAIPageableListOfBatch batchList = (OpenAIPageableListOfBatch)((BinaryData)listedBatchesWithResponse.getValue()).toObject(OpenAIPageableListOfBatch.class);
        return new SimpleResponse(listedBatchesWithResponse, PageableListAccessHelper.create(batchList.getData(), batchList.getFirstId(), batchList.getLastId(), batchList.isHasMore()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Batch> createBatchWithResponse(BinaryData createBatchRequest, RequestOptions requestOptions) {
        Response<BinaryData> createdBatchWithResponse;
        if (this.openAIServiceClient != null) {
            createdBatchWithResponse = this.openAIServiceClient.createBatchWithResponse(createBatchRequest, requestOptions);
        } else {
            OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
            try {
                createdBatchWithResponse = this.serviceClient.createBatchWithResponse(createBatchRequest, requestOptions);
            }
            catch (HttpResponseException ex) {
                HttpResponse httpResponse = ex.getResponse();
                if (httpResponse.getStatusCode() == 200) {
                    return new ResponseBase(httpResponse.getRequest(), httpResponse.getStatusCode(), httpResponse.getHeaders(), (Object)((Batch)BinaryData.fromObject((Object)ex.getValue()).toObject(Batch.class)), null);
                }
                throw LOGGER.logExceptionAsError((RuntimeException)((Object)ex));
            }
        }
        return new SimpleResponse(createdBatchWithResponse, (Object)((Batch)((BinaryData)createdBatchWithResponse.getValue()).toObject(Batch.class)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Batch> getBatchWithResponse(String batchId, RequestOptions requestOptions) {
        Response<BinaryData> retrievedBatchWithResponse;
        if (this.openAIServiceClient != null) {
            retrievedBatchWithResponse = this.openAIServiceClient.getBatchWithResponse(batchId, requestOptions);
        } else {
            OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
            retrievedBatchWithResponse = this.serviceClient.getBatchWithResponse(batchId, requestOptions);
        }
        return new SimpleResponse(retrievedBatchWithResponse, (Object)((Batch)((BinaryData)retrievedBatchWithResponse.getValue()).toObject(Batch.class)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Batch> cancelBatchWithResponse(String batchId, RequestOptions requestOptions) {
        Response<BinaryData> cancelledBatchWithResponse;
        if (this.openAIServiceClient != null) {
            cancelledBatchWithResponse = this.openAIServiceClient.cancelBatchWithResponse(batchId, requestOptions);
        } else {
            OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
            cancelledBatchWithResponse = this.serviceClient.cancelBatchWithResponse(batchId, requestOptions);
        }
        return new SimpleResponse(cancelledBatchWithResponse, (Object)((Batch)((BinaryData)cancelledBatchWithResponse.getValue()).toObject(Batch.class)));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public List<OpenAIFile> listFiles(FilePurpose purpose) {
        RequestOptions requestOptions = new RequestOptions();
        if (purpose != null) {
            requestOptions.addQueryParam("purpose", purpose.toString(), false);
        }
        return (List)this.listFilesWithResponse(requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public List<OpenAIFile> listFiles() {
        return this.listFiles(null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private OpenAIFile uploadFile(FileDetails file, FilePurpose purpose, String filename) {
        RequestOptions requestOptions = new RequestOptions();
        UploadFileRequest uploadFileRequestObj = new UploadFileRequest(file, purpose).setFilename(filename);
        BinaryData uploadFileRequest = new MultipartFormDataHelper(requestOptions).serializeFileField("file", uploadFileRequestObj.getFile().getContent(), uploadFileRequestObj.getFile().getContentType(), uploadFileRequestObj.getFile().getFilename()).serializeTextField("purpose", Objects.toString((Object)uploadFileRequestObj.getPurpose())).serializeTextField("filename", uploadFileRequestObj.getFilename()).end().getRequestBody();
        return (OpenAIFile)this.uploadFileWithResponse(uploadFileRequest, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public OpenAIFile uploadFile(FileDetails file, FilePurpose purpose) {
        RequestOptions requestOptions = new RequestOptions();
        UploadFileRequest uploadFileRequestObj = new UploadFileRequest(file, purpose);
        BinaryData uploadFileRequest = new MultipartFormDataHelper(requestOptions).serializeFileField("file", uploadFileRequestObj.getFile().getContent(), uploadFileRequestObj.getFile().getContentType(), uploadFileRequestObj.getFile().getFilename()).serializeTextField("purpose", Objects.toString((Object)uploadFileRequestObj.getPurpose())).serializeTextField("filename", uploadFileRequestObj.getFilename()).end().getRequestBody();
        return (OpenAIFile)this.uploadFileWithResponse(uploadFileRequest, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public FileDeletionStatus deleteFile(String fileId) {
        RequestOptions requestOptions = new RequestOptions();
        return (FileDeletionStatus)this.deleteFileWithResponse(fileId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public OpenAIFile getFile(String fileId) {
        RequestOptions requestOptions = new RequestOptions();
        return (OpenAIFile)this.getFileWithResponse(fileId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public byte[] getFileContent(String fileId) {
        RequestOptions requestOptions = new RequestOptions();
        return (byte[])this.getFileContentWithResponse(fileId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PageableList<Batch> listBatches(String after, Integer limit) {
        RequestOptions requestOptions = new RequestOptions();
        if (after != null) {
            requestOptions.addQueryParam("after", after, false);
        }
        if (limit != null) {
            requestOptions.addQueryParam("limit", String.valueOf(limit), false);
        }
        return (PageableList)this.listBatchesWithResponse(requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PageableList<Batch> listBatches() {
        return this.listBatches(null, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Batch getBatch(String batchId) {
        RequestOptions requestOptions = new RequestOptions();
        return (Batch)this.getBatchWithResponse(batchId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Batch cancelBatch(String batchId) {
        RequestOptions requestOptions = new RequestOptions();
        return (Batch)this.cancelBatchWithResponse(batchId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Batch createBatch(BatchCreateRequest createBatchRequest) {
        RequestOptions requestOptions = new RequestOptions();
        return (Batch)this.createBatchWithResponse(BinaryData.fromObject((Object)createBatchRequest), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Upload> createUploadWithResponse(BinaryData requestBody, RequestOptions requestOptions) {
        Response<BinaryData> createUploadWithResponse;
        if (this.openAIServiceClient != null) {
            createUploadWithResponse = this.openAIServiceClient.createUploadWithResponse(requestBody, requestOptions);
        } else {
            OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
            createUploadWithResponse = this.serviceClient.createUploadWithResponse(requestBody, requestOptions);
        }
        return new SimpleResponse(createUploadWithResponse, (Object)((Upload)((BinaryData)createUploadWithResponse.getValue()).toObject(Upload.class)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Response<UploadPart> addUploadPartWithResponse(String uploadId, BinaryData requestBody, RequestOptions requestOptions) {
        Response<BinaryData> addUploadPartWithResponse;
        if (this.openAIServiceClient != null) {
            addUploadPartWithResponse = this.openAIServiceClient.addUploadPartWithResponse(uploadId, requestBody, requestOptions);
        } else {
            OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
            addUploadPartWithResponse = this.serviceClient.addUploadPartWithResponse(uploadId, requestBody, requestOptions);
        }
        return new SimpleResponse(addUploadPartWithResponse, (Object)((UploadPart)((BinaryData)addUploadPartWithResponse.getValue()).toObject(UploadPart.class)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Upload> completeUploadWithResponse(String uploadId, BinaryData requestBody, RequestOptions requestOptions) {
        Response<BinaryData> completeUploadWithResponse;
        if (this.openAIServiceClient != null) {
            completeUploadWithResponse = this.openAIServiceClient.completeUploadWithResponse(uploadId, requestBody, requestOptions);
        } else {
            OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
            completeUploadWithResponse = this.serviceClient.completeUploadWithResponse(uploadId, requestBody, requestOptions);
        }
        return new SimpleResponse(completeUploadWithResponse, (Object)((Upload)((BinaryData)completeUploadWithResponse.getValue()).toObject(Upload.class)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Upload> cancelUploadWithResponse(String uploadId, RequestOptions requestOptions) {
        Response<BinaryData> cancelUploadWithResponse;
        if (this.openAIServiceClient != null) {
            cancelUploadWithResponse = this.openAIServiceClient.cancelUploadWithResponse(uploadId, requestOptions);
        } else {
            OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
            cancelUploadWithResponse = this.serviceClient.cancelUploadWithResponse(uploadId, requestOptions);
        }
        return new SimpleResponse(cancelUploadWithResponse, (Object)((Upload)((BinaryData)cancelUploadWithResponse.getValue()).toObject(Upload.class)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Upload createUpload(CreateUploadRequest requestBody) {
        RequestOptions requestOptions = new RequestOptions();
        return (Upload)this.createUploadWithResponse(BinaryData.fromObject((Object)requestBody), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public UploadPart addUploadPart(String uploadId, AddUploadPartRequest requestBody) {
        RequestOptions requestOptions = new RequestOptions();
        return (UploadPart)this.addUploadPartWithResponse(uploadId, new MultipartFormDataHelper(requestOptions).serializeFileField("data", requestBody.getData().getContent(), requestBody.getData().getContentType(), requestBody.getData().getFilename()).end().getRequestBody(), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Upload completeUpload(String uploadId, CompleteUploadRequest requestBody) {
        RequestOptions requestOptions = new RequestOptions();
        return (Upload)this.completeUploadWithResponse(uploadId, BinaryData.fromObject((Object)requestBody), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Upload cancelUpload(String uploadId) {
        RequestOptions requestOptions = new RequestOptions();
        return (Upload)this.cancelUploadWithResponse(uploadId, requestOptions).getValue();
    }
}

