/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.ai.openai.models.AzureGroundingEnhancementLineSpan;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class AzureGroundingEnhancementLine
implements JsonSerializable<AzureGroundingEnhancementLine> {
    private final String text;
    private final List<AzureGroundingEnhancementLineSpan> spans;

    private AzureGroundingEnhancementLine(String text, List<AzureGroundingEnhancementLineSpan> spans) {
        this.text = text;
        this.spans = spans;
    }

    public String getText() {
        return this.text;
    }

    public List<AzureGroundingEnhancementLineSpan> getSpans() {
        return this.spans;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("text", this.text);
        jsonWriter.writeArrayField("spans", this.spans, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static AzureGroundingEnhancementLine fromJson(JsonReader jsonReader) throws IOException {
        return (AzureGroundingEnhancementLine)jsonReader.readObject(reader -> {
            String text = null;
            List spans = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("text".equals(fieldName)) {
                    text = reader.getString();
                    continue;
                }
                if ("spans".equals(fieldName)) {
                    spans = reader.readArray(reader1 -> AzureGroundingEnhancementLineSpan.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return new AzureGroundingEnhancementLine(text, spans);
        });
    }
}

