/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc;

import com.facebook.presto.jdbc.PrestoConnection;
import com.facebook.presto.jdbc.PrestoDriverUri;
import com.facebook.presto.jdbc.QueryExecutor;
import com.facebook.presto.jdbc.internal.guava.base.Strings;
import com.facebook.presto.jdbc.internal.guava.base.Throwables;
import java.io.Closeable;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PrestoDriver
implements Driver,
Closeable {
    static final String DRIVER_NAME = "Presto JDBC Driver";
    static final String DRIVER_VERSION;
    static final int DRIVER_VERSION_MAJOR;
    static final int DRIVER_VERSION_MINOR;
    private static final DriverPropertyInfo[] DRIVER_PROPERTY_INFOS;
    private static final String DRIVER_URL_START = "jdbc:presto:";
    private static final String USER_PROPERTY = "user";
    private final QueryExecutor queryExecutor = QueryExecutor.create("Presto JDBC Driver/" + DRIVER_VERSION);

    @Override
    public void close() {
        this.queryExecutor.close();
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        String user = info.getProperty(USER_PROPERTY);
        if (Strings.isNullOrEmpty(user)) {
            throw new SQLException(String.format("Username property (%s) must be set", USER_PROPERTY));
        }
        return new PrestoConnection(new PrestoDriverUri(url), user, this.queryExecutor);
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return url.startsWith(DRIVER_URL_START);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return DRIVER_PROPERTY_INFOS;
    }

    @Override
    public int getMajorVersion() {
        return DRIVER_VERSION_MAJOR;
    }

    @Override
    public int getMinorVersion() {
        return DRIVER_VERSION_MINOR;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    static {
        DRIVER_PROPERTY_INFOS = new DriverPropertyInfo[0];
        String version = Strings.nullToEmpty(PrestoDriver.class.getPackage().getImplementationVersion());
        Matcher matcher = Pattern.compile("^(\\d+)\\.(\\d+)($|[.-])").matcher(version);
        if (!matcher.find()) {
            DRIVER_VERSION = "unknown";
            DRIVER_VERSION_MAJOR = 0;
            DRIVER_VERSION_MINOR = 0;
        } else {
            DRIVER_VERSION = version;
            DRIVER_VERSION_MAJOR = Integer.parseInt(matcher.group(1));
            DRIVER_VERSION_MINOR = Integer.parseInt(matcher.group(2));
        }
        try {
            DriverManager.registerDriver(new PrestoDriver());
        }
        catch (SQLException e) {
            throw Throwables.propagate(e);
        }
    }
}

