/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.airlift.stats;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;

final class ExponentiallyDecayingSample {
    private static final long RESCALE_THRESHOLD = TimeUnit.HOURS.toNanos(1L);
    private final ConcurrentSkipListMap<Double, Long> values;
    private final ReentrantReadWriteLock lock;
    private final double alpha;
    private final int reservoirSize;
    private final AtomicLong count = new AtomicLong(0L);
    private volatile long startTime;
    private final AtomicLong nextScaleTime = new AtomicLong(0L);

    public ExponentiallyDecayingSample(int reservoirSize, double alpha) {
        this.values = new ConcurrentSkipListMap();
        this.lock = new ReentrantReadWriteLock();
        this.alpha = alpha;
        this.reservoirSize = reservoirSize;
        this.clear();
    }

    public void clear() {
        this.values.clear();
        this.count.set(0L);
        this.startTime = ExponentiallyDecayingSample.tick();
        this.nextScaleTime.set(System.nanoTime() + RESCALE_THRESHOLD);
    }

    public int size() {
        return (int)Math.min((long)this.reservoirSize, this.count.get());
    }

    public void update(long value) {
        this.update(value, ExponentiallyDecayingSample.tick());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(long value, long timestamp) {
        this.lockForRegularUsage();
        try {
            double priority = this.weight(timestamp - this.startTime) / Math.random();
            long newCount = this.count.incrementAndGet();
            if (newCount <= (long)this.reservoirSize) {
                this.values.put(priority, value);
            } else {
                Double first = this.values.firstKey();
                if (first < priority && this.values.putIfAbsent(priority, value) == null) {
                    while (this.values.remove(first) == null) {
                        first = this.values.firstKey();
                    }
                }
            }
        }
        finally {
            this.unlockForRegularUsage();
        }
        long now = System.nanoTime();
        long next = this.nextScaleTime.get();
        if (now >= next) {
            this.rescale(now, next);
        }
    }

    public List<Long> values() {
        this.lockForRegularUsage();
        try {
            ArrayList<Long> arrayList = new ArrayList<Long>(this.values.values());
            return arrayList;
        }
        finally {
            this.unlockForRegularUsage();
        }
    }

    private static long tick() {
        return TimeUnit.NANOSECONDS.toSeconds(System.nanoTime());
    }

    private double weight(long t) {
        return Math.exp(this.alpha * (double)t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rescale(long now, long next) {
        if (this.nextScaleTime.compareAndSet(next, now + RESCALE_THRESHOLD)) {
            this.lockForRescale();
            try {
                long oldStartTime = this.startTime;
                this.startTime = ExponentiallyDecayingSample.tick();
                ArrayList keys = new ArrayList(this.values.keySet());
                for (Double key : keys) {
                    Long value = this.values.remove(key);
                    this.values.put(key * Math.exp(-this.alpha * (double)(this.startTime - oldStartTime)), value);
                }
            }
            finally {
                this.unlockForRescale();
            }
        }
    }

    private void unlockForRescale() {
        this.lock.writeLock().unlock();
    }

    private void lockForRescale() {
        this.lock.writeLock().lock();
    }

    private void lockForRegularUsage() {
        this.lock.readLock().lock();
    }

    private void unlockForRegularUsage() {
        this.lock.readLock().unlock();
    }

    public double[] percentiles(double ... percentiles) {
        double[] scores = new double[percentiles.length];
        Arrays.fill(scores, Double.NaN);
        List<Long> values = this.values();
        if (!values.isEmpty()) {
            Collections.sort(values);
            for (int i = 0; i < percentiles.length; ++i) {
                double p = percentiles[i];
                double pos = p * (double)(values.size() + 1);
                if (pos < 1.0) {
                    scores[i] = values.get(0).longValue();
                    continue;
                }
                if (pos >= (double)values.size()) {
                    scores[i] = values.get(values.size() - 1).longValue();
                    continue;
                }
                double lower = values.get((int)pos - 1).longValue();
                double upper = values.get((int)pos).longValue();
                scores[i] = lower + (pos - Math.floor(pos)) * (upper - lower);
            }
        }
        return scores;
    }
}

