/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jetty.alpn.client;

import com.facebook.presto.jdbc.internal.jetty.alpn.ALPN;
import com.facebook.presto.jdbc.internal.jetty.io.ClientConnectionFactory;
import com.facebook.presto.jdbc.internal.jetty.io.EndPoint;
import com.facebook.presto.jdbc.internal.jetty.io.NegotiatingClientConnection;
import com.facebook.presto.jdbc.internal.jetty.util.log.Log;
import com.facebook.presto.jdbc.internal.jetty.util.log.Logger;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLEngine;

public class ALPNClientConnection
extends NegotiatingClientConnection
implements ALPN.ClientProvider {
    private static final Logger LOG = Log.getLogger(ALPNClientConnection.class);
    private final List<String> protocols;

    public ALPNClientConnection(EndPoint endPoint, Executor executor, ClientConnectionFactory connectionFactory, SSLEngine sslEngine, Map<String, Object> context, List<String> protocols) {
        super(endPoint, executor, sslEngine, connectionFactory, context);
        this.protocols = protocols;
        ALPN.put((SSLEngine)sslEngine, (ALPN.Provider)this);
    }

    public void unsupported() {
        ALPN.remove((SSLEngine)this.getSSLEngine());
        this.completed();
    }

    public List<String> protocols() {
        return this.protocols;
    }

    public void selected(String protocol) {
        if (this.protocols.contains(protocol)) {
            ALPN.remove((SSLEngine)this.getSSLEngine());
            this.completed();
        } else {
            LOG.info("Could not negotiate protocol: server [{}] - client {}", protocol, this.protocols);
            this.close();
        }
    }

    @Override
    public void close() {
        ALPN.remove((SSLEngine)this.getSSLEngine());
        super.close();
    }
}

