/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jol.info;

import com.facebook.presto.jdbc.internal.jol.info.GraphPathRecord;
import com.facebook.presto.jdbc.internal.jol.info.GraphVisitor;
import com.facebook.presto.jdbc.internal.jol.info.GraphWalker;
import com.facebook.presto.jdbc.internal.jol.util.Multiset;
import com.facebook.presto.jdbc.internal.jol.util.VMSupport;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.imageio.ImageIO;

public class GraphLayout {
    private static final Comparator<Class<?>> CLASS_COMPARATOR = new Comparator<Class<?>>(){

        @Override
        public int compare(Class<?> o1, Class<?> o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    private final Set<Class<?>> classes = new TreeSet(CLASS_COMPARATOR);
    private final Multiset<Class<?>> classSizes = new Multiset();
    private final Multiset<Class<?>> classCounts = new Multiset();
    private final SortedMap<Long, GraphPathRecord> addresses = new TreeMap<Long, GraphPathRecord>();
    private final String name;
    private final long rootAddress;
    private final int rootHC;
    private long totalCount;
    private long totalSize;

    public static GraphLayout parseInstance(Object root) {
        GraphWalker walker = new GraphWalker(root);
        GraphLayout data = new GraphLayout(root);
        walker.addVisitor(data.visitor());
        walker.walk();
        return data;
    }

    public GraphLayout(Object root) {
        this.rootAddress = VMSupport.addressOf(root);
        this.rootHC = System.identityHashCode(root);
        this.name = root.getClass().getName();
    }

    private GraphVisitor visitor() {
        return new GraphVisitor(){

            @Override
            public void visit(GraphPathRecord gpr) {
                long addr = VMSupport.addressOf(gpr.obj());
                GraphLayout.this.addresses.put(addr, gpr);
                Class<?> klass = gpr.obj().getClass();
                GraphLayout.this.classes.add(klass);
                GraphLayout.this.classCounts.add(klass);
                GraphLayout.this.totalCount++;
                try {
                    int size = VMSupport.sizeOf(gpr.obj());
                    GraphLayout.this.totalSize = GraphLayout.this.totalSize + (long)size;
                    GraphLayout.this.classSizes.add(klass, size);
                }
                catch (Exception e) {
                    GraphLayout.this.classSizes.add(klass, 0);
                }
            }
        };
    }

    public Multiset<Class<?>> getClassSizes() {
        return this.classSizes;
    }

    public Multiset<Class<?>> getClassCounts() {
        return this.classCounts;
    }

    public Set<Class<?>> getClasses() {
        return this.classes;
    }

    public long totalCount() {
        return this.totalCount;
    }

    public long totalSize() {
        return this.totalSize;
    }

    public long startAddress() {
        if (!this.addresses.isEmpty()) {
            return this.addresses.firstKey();
        }
        return 0L;
    }

    public long endAddress() {
        if (!this.addresses.isEmpty()) {
            return this.addresses.lastKey();
        }
        return 0L;
    }

    public SortedSet<Long> addresses() {
        return new TreeSet<Long>(this.addresses.keySet());
    }

    public GraphPathRecord record(long address) {
        return (GraphPathRecord)this.addresses.get(address);
    }

    public String toFootprint() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println(this.name + " instance footprint:");
        pw.printf(" %9s %9s %9s   %s%n", "COUNT", "AVG", "SUM", "DESCRIPTION");
        for (Class<?> key : this.getClasses()) {
            int count = this.getClassCounts().count(key);
            int size = this.getClassSizes().count(key);
            pw.printf(" %9d %9d %9d   %s%n", count, size / count, size, key.getName());
        }
        pw.printf(" %9d %9s %9d   %s%n", this.totalCount(), "", this.totalSize(), "(total)");
        pw.println();
        pw.close();
        return sw.toString();
    }

    public String toPrintable() {
        long addr;
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        long last = 0L;
        int typeLen = 1;
        Iterator iterator = this.addresses().iterator();
        while (iterator.hasNext()) {
            addr = (Long)iterator.next();
            GraphPathRecord r = this.record(addr);
            typeLen = Math.max(typeLen, r.obj().getClass().getName().length());
        }
        pw.println(this.name + " object externals:");
        pw.printf(" %16s %10s %-" + typeLen + "s %-30s %s%n", "ADDRESS", "SIZE", "TYPE", "PATH", "VALUE");
        iterator = this.addresses().iterator();
        while (iterator.hasNext()) {
            addr = (Long)iterator.next();
            Object obj = this.record(addr).obj();
            int size = VMSupport.sizeOf(obj);
            if (addr > last && last != 0L) {
                pw.printf(" %16x %10d %-" + typeLen + "s %-30s %s%n", last, addr - last, "(something else)", "(somewhere else)", "(something else)");
            }
            if (addr < last) {
                pw.printf(" %16x %10d %-" + typeLen + "s %-30s %s%n", last, addr - last, "**** OVERLAP ****", "**** OVERLAP ****", "**** OVERLAP ****");
            }
            pw.printf(" %16x %10d %-" + typeLen + "s %-30s %s%n", addr, size, obj.getClass().getName(), this.record(addr).path(), VMSupport.safeToString(obj));
            last = addr + (long)size;
        }
        pw.println();
        pw.close();
        return sw.toString();
    }

    public void toImage(String fileName) throws IOException {
        int depth;
        if (this.addresses().isEmpty()) {
            return;
        }
        long start = this.startAddress();
        long end = this.endAddress();
        int WIDTH = 1000;
        int HEIGHT = 320;
        int GRAPH_HEIGHT = 100;
        int SCALE_WIDTH = 30;
        int EXT_PAD = 50;
        int PAD = 20;
        BufferedImage image = new BufferedImage(1000, 320, 2);
        Graphics2D g = image.createGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, 1000, 320);
        int minDepth = Integer.MAX_VALUE;
        int maxDepth = Integer.MIN_VALUE;
        Iterator iterator = this.addresses().iterator();
        while (iterator.hasNext()) {
            long addr = (Long)iterator.next();
            GraphPathRecord p = this.record(addr);
            minDepth = Math.min(minDepth, p.depth());
            maxDepth = Math.max(maxDepth, p.depth());
        }
        Multiset<Integer> depths = new Multiset<Integer>();
        Iterator iterator2 = this.addresses().iterator();
        while (iterator2.hasNext()) {
            long addr = (Long)iterator2.next();
            GraphPathRecord r = this.record(addr);
            depths.add(r.depth(), VMSupport.sizeOf(r.obj()));
        }
        int lastX = 0;
        Iterator iterator3 = this.addresses().iterator();
        while (iterator3.hasNext()) {
            long addr = (Long)iterator3.next();
            Object obj = this.record(addr).obj();
            int size = VMSupport.sizeOf(obj);
            int x1 = 80 + (int)(870L * (addr - start) / (end - start));
            int x2 = 80 + (int)(870L * (addr + (long)size - start) / (end - start));
            x1 = Math.max(x1, lastX);
            x2 = Math.max(x2, lastX);
            float relDepth = 1.0f * (float)(this.record(addr).depth() - minDepth) / (float)(maxDepth - minDepth + 1);
            g.setColor(Color.getHSBColor(relDepth, 1.0f, 0.9f));
            g.fillRect(x1, 50, x2 - x1, 100);
        }
        for (depth = minDepth; depth <= maxDepth; ++depth) {
            float relDepth = 1.0f * (float)(depth - minDepth) / (float)(maxDepth - minDepth + 1);
            g.setColor(Color.getHSBColor(relDepth, 1.0f, 0.9f));
            int y1 = 320 * (depth - minDepth) / (maxDepth - minDepth + 1);
            int y2 = 320 * (depth + 1 - minDepth) / (maxDepth - minDepth + 1);
            g.fillRect(0, y1, 30, y2 - y1);
        }
        lastX = 80;
        for (depth = minDepth; depth <= maxDepth; ++depth) {
            int w = (int)((long)(870 * depths.count(depth)) / (end - start));
            float relDepth = 1.0f * (float)(depth - minDepth) / (float)(maxDepth - minDepth + 1);
            g.setColor(Color.getHSBColor(relDepth, 1.0f, 0.9f));
            g.fillRect(lastX, 170, w, 100);
            lastX += w;
        }
        g.setColor(Color.BLACK);
        g.setStroke(new BasicStroke(2.0f));
        g.drawRect(80, 50, 870, 100);
        g.drawRect(80, 170, 870, 100);
        g.setStroke(new BasicStroke(1.0f));
        g.drawLine(80, 290, 950, 290);
        g.drawLine(80, 285, 80, 295);
        g.drawLine(950, 285, 950, 295);
        Font font = new Font("Serif", 0, 18);
        g.setFont(font);
        String labelDense = (end - start) / 1024L + " Kb";
        g.setBackground(Color.WHITE);
        g.setColor(Color.BLACK);
        g.drawString(labelDense, 450, 310);
        g.drawString(String.format("0x%x, %s@%d", this.rootAddress, this.name, this.rootHC), 80, 30);
        AffineTransform orig = g.getTransform();
        g.rotate(-Math.toRadians(90.0), 75.0, 150.0);
        g.drawString("Actual:", 75, 150);
        g.setTransform(orig);
        g.rotate(-Math.toRadians(90.0), 75.0, 270.0);
        g.drawString("Dense:", 75, 270);
        g.setTransform(orig);
        ImageIO.write((RenderedImage)image, "png", new File(fileName));
    }
}

