/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.block;

import com.facebook.presto.jdbc.internal.airlift.slice.SizeOf;
import com.facebook.presto.jdbc.internal.jol.info.ClassLayout;
import com.facebook.presto.jdbc.internal.spi.block.AbstractArrayBlock;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.BlockUtil;
import java.util.Objects;

public class ArrayBlock
extends AbstractArrayBlock {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(ArrayBlock.class).instanceSize();
    private final int arrayOffset;
    private final int positionCount;
    private final boolean[] valueIsNull;
    private final Block values;
    private final int[] offsets;
    private int sizeInBytes;
    private final int retainedSizeInBytes;

    public ArrayBlock(int positionCount, boolean[] valueIsNull, int[] offsets, Block values) {
        this(0, positionCount, valueIsNull, offsets, values);
    }

    ArrayBlock(int arrayOffset, int positionCount, boolean[] valueIsNull, int[] offsets, Block values) {
        if (arrayOffset < 0) {
            throw new IllegalArgumentException("arrayOffset is negative");
        }
        this.arrayOffset = arrayOffset;
        if (positionCount < 0) {
            throw new IllegalArgumentException("positionCount is negative");
        }
        this.positionCount = positionCount;
        Objects.requireNonNull(valueIsNull, "valueIsNull is null");
        if (valueIsNull.length - arrayOffset < positionCount) {
            throw new IllegalArgumentException("isNull length is less than positionCount");
        }
        this.valueIsNull = valueIsNull;
        Objects.requireNonNull(offsets, "offsets is null");
        if (offsets.length - arrayOffset < positionCount + 1) {
            throw new IllegalArgumentException("offsets length is less than positionCount");
        }
        this.offsets = offsets;
        this.values = Objects.requireNonNull(values);
        this.sizeInBytes = -1;
        this.retainedSizeInBytes = BlockUtil.intSaturatedCast((long)(INSTANCE_SIZE + values.getRetainedSizeInBytes()) + SizeOf.sizeOf(offsets) + SizeOf.sizeOf(valueIsNull));
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public int getSizeInBytes() {
        if (this.sizeInBytes < 0) {
            this.calculateSize();
        }
        return this.sizeInBytes;
    }

    private void calculateSize() {
        int valueStart = this.offsets[this.arrayOffset];
        int valueEnd = this.offsets[this.arrayOffset + this.positionCount];
        this.sizeInBytes = BlockUtil.intSaturatedCast((long)this.values.getRegionSizeInBytes(valueStart, valueEnd - valueStart) + 5L * (long)this.positionCount);
    }

    @Override
    public int getRetainedSizeInBytes() {
        return this.retainedSizeInBytes;
    }

    @Override
    protected Block getValues() {
        return this.values;
    }

    @Override
    protected int[] getOffsets() {
        return this.offsets;
    }

    @Override
    protected int getOffsetBase() {
        return this.arrayOffset;
    }

    @Override
    protected boolean[] getValueIsNull() {
        return this.valueIsNull;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ArrayBlock{");
        sb.append("positionCount=").append(this.getPositionCount());
        sb.append('}');
        return sb.toString();
    }
}

