/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.type;

import com.facebook.presto.jdbc.internal.airlift.slice.Slice;
import com.facebook.presto.jdbc.internal.airlift.slice.SliceUtf8;
import com.facebook.presto.jdbc.internal.airlift.slice.Slices;
import com.facebook.presto.jdbc.internal.spi.type.CharType;
import com.facebook.presto.jdbc.internal.spi.type.Type;
import com.facebook.presto.jdbc.internal.spi.type.Varchars;
import java.util.Objects;

public final class Chars {
    private Chars() {
    }

    public static boolean isCharType(Type type) {
        return type instanceof CharType;
    }

    public static Slice padSpaces(Slice slice, Type type) {
        Objects.requireNonNull(type, "type is null");
        if (!Chars.isCharType(type)) {
            throw new IllegalArgumentException("type must be the instance of CharType");
        }
        return Chars.padSpaces(slice, (CharType)CharType.class.cast(type));
    }

    public static Slice padSpaces(Slice slice, CharType charType) {
        Objects.requireNonNull(charType, "charType is null");
        return Chars.padSpaces(slice, charType.getLength());
    }

    public static Slice padSpaces(Slice slice, int length) {
        int textLength = SliceUtf8.countCodePoints(slice);
        if (textLength > length) {
            throw new IllegalArgumentException("pad length is smaller than slice length");
        }
        if (textLength == length) {
            return slice;
        }
        int bufferSize = slice.length() + length - textLength;
        Slice buffer = Slices.allocate(bufferSize);
        buffer.setBytes(0, slice);
        for (int i = slice.length(); i < bufferSize; ++i) {
            buffer.setByte(i, 32);
        }
        return buffer;
    }

    public static Slice trimSpacesAndTruncateToLength(Slice slice, Type type) {
        Objects.requireNonNull(type, "type is null");
        if (!Chars.isCharType(type)) {
            throw new IllegalArgumentException("type must be the instance of CharType");
        }
        return Chars.trimSpacesAndTruncateToLength(slice, (CharType)CharType.class.cast(type));
    }

    public static Slice trimSpacesAndTruncateToLength(Slice slice, CharType charType) {
        Objects.requireNonNull(charType, "charType is null");
        return Chars.trimSpacesAndTruncateToLength(slice, charType.getLength());
    }

    public static Slice trimSpacesAndTruncateToLength(Slice slice, int maxLength) {
        Objects.requireNonNull(slice, "slice is null");
        if (maxLength < 0) {
            throw new IllegalArgumentException("Max length must be greater or equal than zero");
        }
        return Varchars.truncateToLength(Chars.trimSpaces(slice), maxLength);
    }

    public static Slice trimSpaces(Slice slice) {
        Objects.requireNonNull(slice, "slice is null");
        return slice.slice(0, Chars.sliceLengthWithoutTrailingSpaces(slice));
    }

    private static int sliceLengthWithoutTrailingSpaces(Slice slice) {
        for (int i = slice.length(); i > 0; --i) {
            if (slice.getByte(i - 1) == 32) continue;
            return i;
        }
        return 0;
    }

    public static int compareChars(Slice left, Slice right) {
        if (left.length() < right.length()) {
            return Chars.compareCharsShorterToLonger(left, right);
        }
        return -Chars.compareCharsShorterToLonger(right, left);
    }

    private static int compareCharsShorterToLonger(Slice shorter, Slice longer) {
        int result;
        int i;
        for (i = 0; i < shorter.length(); ++i) {
            result = Chars.compareUnsignedBytes(shorter.getByte(i), longer.getByte(i));
            if (result == 0) continue;
            return result;
        }
        for (i = shorter.length(); i < longer.length(); ++i) {
            result = Chars.compareUnsignedBytes((byte)32, longer.getByte(i));
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    private static int compareUnsignedBytes(byte thisByte, byte thatByte) {
        return Chars.unsignedByteToInt(thisByte) - Chars.unsignedByteToInt(thatByte);
    }

    private static int unsignedByteToInt(byte thisByte) {
        return thisByte & 0xFF;
    }
}

