/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.ast;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.BodyOwner;
import com.github.sommeri.less4j.core.ast.GeneralBody;
import com.github.sommeri.less4j.core.ast.Guard;
import com.github.sommeri.less4j.core.ast.ReusableStructure;
import com.github.sommeri.less4j.core.ast.ReusableStructureName;
import com.github.sommeri.less4j.core.ast.Selector;
import com.github.sommeri.less4j.core.ast.annotations.NotAstProperty;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.core.problems.BugHappened;
import com.github.sommeri.less4j.utils.ArraysUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RuleSet
extends ASTCssNode
implements BodyOwner<GeneralBody> {
    private List<Selector> selectors = new ArrayList<Selector>();
    private List<Guard> guards = new ArrayList<Guard>();
    private GeneralBody body;

    public RuleSet(HiddenTokenAwareTree token) {
        super(token);
    }

    public RuleSet(HiddenTokenAwareTree token, GeneralBody body, List<Selector> selectors) {
        super(token);
        this.body = body;
        this.addSelectors(selectors);
        this.configureParentToAllChilds();
    }

    public List<Selector> getSelectors() {
        return this.selectors;
    }

    @Override
    public GeneralBody getBody() {
        return this.body;
    }

    public boolean hasEmptyBody() {
        return this.body == null ? true : this.body.isEmpty();
    }

    @Override
    public void setBody(GeneralBody body) {
        this.body = body;
    }

    public boolean isUsableAsReusableStructure() {
        for (Selector selector : this.selectors) {
            if (!selector.isReusableSelector()) continue;
            return true;
        }
        return false;
    }

    public ReusableStructure convertToReusableStructure() {
        if (!this.isUsableAsReusableStructure()) {
            throw new BugHappened("Caller is supposed to check for this.", (ASTCssNode)this);
        }
        ArrayList<ReusableStructureName> reusableNames = new ArrayList<ReusableStructureName>();
        for (Selector selector : this.selectors) {
            if (!selector.isReusableSelector()) continue;
            ReusableStructureName reusableStructureName = selector.toReusableStructureName();
            reusableNames.add(reusableStructureName);
        }
        ReusableStructure reusable = new ReusableStructure(this.getUnderlyingStructure(), reusableNames, true);
        reusable.setBody(this.getBody().clone());
        reusable.addGuards(ArraysUtils.deeplyClonedList(this.getGuards()));
        reusable.configureParentToAllChilds();
        return reusable;
    }

    public List<String> extractReusableStructureNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (Selector selector : this.selectors) {
            if (!selector.isReusableSelector()) continue;
            ReusableStructureName reusableStructureName = selector.toReusableStructureName();
            result.add(reusableStructureName.asString());
        }
        if (result.isEmpty()) {
            throw new BugHappened("Not convertible to resusable structure - caller was supposed to check for this.", (ASTCssNode)this);
        }
        return result;
    }

    @Override
    @NotAstProperty
    public List<? extends ASTCssNode> getChilds() {
        List<ASTCssNode> result = ArraysUtils.asNonNullList(this.body);
        result.addAll(0, this.guards);
        result.addAll(0, this.selectors);
        return result;
    }

    public void addSelectors(List<Selector> selectors) {
        this.selectors.addAll(selectors);
    }

    public void addSelector(Selector selector) {
        this.selectors.add(selector);
    }

    public void addGuards(List<Guard> guards) {
        this.guards.addAll(guards);
    }

    public void addGuards(Guard guard) {
        this.guards.add(guard);
    }

    public void removeGuards() {
        for (Guard guard : this.guards) {
            guard.setParent(null);
        }
        this.guards.clear();
    }

    public void replaceSelector(Selector oldSelector, Selector newSelector) {
        oldSelector.setParent(null);
        newSelector.setParent(this);
        Collections.replaceAll(this.selectors, oldSelector, newSelector);
    }

    public void replaceSelectors(List<Selector> result) {
        for (Selector oldSelector : this.selectors) {
            oldSelector.setParent(null);
        }
        this.selectors = new ArrayList<Selector>();
        this.selectors.addAll(result);
    }

    @Override
    public RuleSet clone() {
        RuleSet result = (RuleSet)super.clone();
        result.body = this.body == null ? null : this.body.clone();
        result.selectors = ArraysUtils.deeplyClonedList(this.selectors);
        result.guards = ArraysUtils.deeplyClonedList(this.guards);
        result.configureParentToAllChilds();
        return result;
    }

    @Override
    public ASTCssNodeType getType() {
        return ASTCssNodeType.RULE_SET;
    }

    public List<Guard> getGuards() {
        return this.guards;
    }
}

