/*
 * Decompiled with CFR 0.152.
 */
package com.github.emailservice;

import com.github.emailservice.util.FileMediaType;
import com.github.emailservice.util.FileUtil;
import com.github.emailservice.util.HtmlQuery;
import com.github.emailservice.util.ParameterParser;
import com.sun.mail.iap.ProtocolException;
import com.sun.mail.imap.IMAPFolder;
import com.sun.mail.imap.SortTerm;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.mail.AuthenticationFailedException;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimePart;
import javax.mail.internet.NewsAddress;
import javax.mail.internet.ParseException;
import javax.mail.search.AndTerm;
import javax.mail.search.FlagTerm;
import javax.mail.search.ReceivedDateTerm;
import javax.mail.search.SearchTerm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.mail.MailProperties;
import org.springframework.mail.MailException;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;

public class EmailService {
    private static final Logger log = LoggerFactory.getLogger(EmailService.class);
    private static final ContentType TYPE_IMAGE_WILDCARD = new ContentType("image", "*", null);
    private static final ContentType TYPE_TEXT_WILDCARD = new ContentType("text", "*", null);
    private static final ContentType TYPE_TEXT_HTML = new ContentType("text", "html", null);
    private static final ContentType TYPE_APPLICATION_PDF = new ContentType("application", "pdf", null);
    private static final ContentType TYPE_APPLICATION_VND = new ContentType("application", "VND.OPENXMLFORMATS-OFFICEDOCUMENT.WORDPROCESSINGML.DOCUMENT", null);
    private static final ContentType TYPE_APPLICATION_OCTET_STREAM = new ContentType("application", "octet-stream", null);
    private MailProperties mailProperties;
    private JavaMailSender mailSender;

    public EmailService() {
        this(null, null);
    }

    public EmailService(MailProperties mailProperties, JavaMailSender mailSender) {
        this.mailProperties = mailProperties;
        this.mailSender = mailSender;
    }

    public static SearchTerm buildTimeRangeQuery(Date beginTime, Date endTime) {
        ArrayList<ReceivedDateTerm> list = new ArrayList<ReceivedDateTerm>();
        if (beginTime != null) {
            list.add(new ReceivedDateTerm(6, beginTime));
        }
        if (endTime != null) {
            list.add(new ReceivedDateTerm(1, endTime));
        }
        if (list.isEmpty()) {
            return null;
        }
        return new AndTerm((SearchTerm[])list.toArray(new ReceivedDateTerm[0]));
    }

    public static SearchTerm buildUnreadQuery() {
        return new FlagTerm(new Flags(Flags.Flag.SEEN), false);
    }

    private static Content rejectParseEmailContent(Object body, FileMediaType mediaType, ContentType contentType) {
        return new UnkownContent(body);
    }

    private static ContentType parseContentType(String contentType) throws ParseException {
        return new ContentType(contentType);
    }

    private static List<Map<String, String>> parseDisposition(String ... dispositions) {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        if (dispositions != null) {
            for (String disposition : dispositions) {
                ParameterParser parser = new ParameterParser();
                parser.setLowerCaseNames(true);
                list.add(parser.parse(disposition, ';'));
            }
        }
        return list;
    }

    private static Content parseContent(Part part, String sectionId, String messageId) throws MessagingException, IOException {
        Content result;
        FileMediaType mediaType;
        String fileName;
        String transferEncoding = part instanceof MimePart ? ((MimePart)part).getEncoding() : null;
        ContentType contentType = EmailService.parseContentType(part.getContentType());
        List<Map<String, String>> dispositions = EmailService.parseDisposition(part.getHeader("Content-Disposition"));
        if (dispositions.size() > 0) {
            List<Map<String, String>> list = EmailService.parseDisposition(part.getHeader("content-type"));
            for (Map<String, String> map : list) {
                map.forEach((key, value) -> {
                    if (key != null && value != null) {
                        contentType.setParameter(key, value);
                    }
                });
            }
            fileName = dispositions.stream().map(e -> (String)e.get("filename")).filter(Objects::nonNull).collect(Collectors.joining(";"));
        } else {
            fileName = part.getFileName();
        }
        Object body = part.getContent();
        if (body instanceof InputStream) {
            InputStream inputStream = (InputStream)body;
            mediaType = FileMediaType.valueOf(inputStream, false);
            body = mediaType.getInputStream();
        } else {
            mediaType = body instanceof String ? FileMediaType.valueOf(new ByteArrayInputStream(((String)body).getBytes(StandardCharsets.UTF_8))) : FileMediaType.unkown();
        }
        if (body instanceof Multipart) {
            ArrayList<Content> contentList = new ArrayList<Content>();
            Multipart multipart = (Multipart)body;
            for (int i = 0; i < multipart.getCount(); ++i) {
                String nextSectionId = sectionId == null ? Integer.toString(i + 1) : sectionId + "." + (i + 1);
                contentList.add(EmailService.parseContent((Part)multipart.getBodyPart(i), nextSectionId, messageId));
            }
            result = new MultiPartContent(contentList);
        } else if (body instanceof javax.mail.internet.MimeMessage) {
            javax.mail.internet.MimeMessage mimeMessage = (javax.mail.internet.MimeMessage)body;
            String nextSectionId = sectionId == null ? "1" : sectionId + ".1";
            result = EmailService.parseContent((Part)mimeMessage, nextSectionId, messageId);
            result.setFromMessage(true);
        } else {
            result = TYPE_TEXT_HTML.match(contentType) ? new HtmlContent(body, contentType.getParameter("charset")) : (TYPE_TEXT_WILDCARD.match(contentType) ? new TextContent(body, contentType.getParameter("charset")) : (TYPE_IMAGE_WILDCARD.match(contentType) ? new ImageContent(body) : (TYPE_APPLICATION_VND.match(contentType) || mediaType.isMicrosoft() ? new WordContent(body) : (TYPE_APPLICATION_PDF.match(contentType) || mediaType.isPdf() ? new PdfContent(body) : (TYPE_APPLICATION_OCTET_STREAM.match(contentType) ? (mediaType.isImage() ? new ImageContent(body) : (mediaType.isPdf() ? new PdfContent(body) : (mediaType.isMicrosoft() ? new WordContent(body) : EmailService.rejectParseEmailContent(body, mediaType, contentType)))) : EmailService.rejectParseEmailContent(body, mediaType, contentType))))));
        }
        result.setSectionId(sectionId);
        result.setMessageId(messageId);
        result.setEmailPart(part);
        result.setTransferEncoding(transferEncoding);
        result.setDispositions(dispositions);
        result.setHeaders(new Headers(part.getAllHeaders()));
        result.setDescription(part.getDescription());
        result.setFileName(fileName);
        result.setMediaType(mediaType);
        result.setContentType(contentType);
        return result;
    }

    private static List<Folder> flatFolderList(Folder root) throws MessagingException {
        LinkedList<Folder> result = new LinkedList<Folder>();
        LinkedList<Folder> visitFolderList = new LinkedList<Folder>();
        visitFolderList.add(root);
        while (!visitFolderList.isEmpty()) {
            Folder remove = (Folder)visitFolderList.remove(0);
            Folder[] nextList = remove.list();
            if (nextList != null) {
                visitFolderList.addAll(Arrays.asList(nextList));
            }
            result.add(remove);
        }
        return result;
    }

    public MailProperties getMailProperties() {
        return this.mailProperties;
    }

    @Autowired(required=false)
    public void setMailProperties(MailProperties mailProperties) {
        this.mailProperties = mailProperties;
    }

    public JavaMailSender getMailSender() {
        return this.mailSender;
    }

    @Autowired(required=false)
    public void setMailSender(JavaMailSender mailSender) {
        this.mailSender = mailSender;
    }

    private EmailList<EmailMessage> selectEmailList(Folder folder, SearchTerm query, boolean useProtocolSort) throws MessagingException {
        Message[] emails;
        boolean isUnsorted;
        EmailList<EmailMessage> list = new EmailList<EmailMessage>(folder);
        if (useProtocolSort && folder instanceof IMAPFolder) {
            isUnsorted = false;
            emails = query != null ? ((IMAPFolder)folder).getSortedMessages(new SortTerm[]{SortTerm.ARRIVAL}, query) : ((IMAPFolder)folder).getSortedMessages(new SortTerm[]{SortTerm.ARRIVAL});
        } else {
            isUnsorted = true;
            emails = query != null ? folder.search(query) : folder.getMessages();
        }
        for (Message email : emails) {
            list.add(new EmailMessage(email, query));
        }
        if (isUnsorted) {
            list.sort(Comparator.comparing(m -> {
                try {
                    return m.getReceivedDate();
                }
                catch (MessagingException e) {
                    return new Timestamp(System.currentTimeMillis());
                }
            }).reversed());
        }
        for (int i = 0; i < list.size(); ++i) {
            if (i + 1 >= list.size()) continue;
            ((EmailMessage)list.get(i)).next = (EmailMessage)list.get(i + 1);
            ((EmailMessage)list.get(i + 1)).prev = (EmailMessage)list.get(i);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EmailList<EmailMessage> selectEmailList(Account account, SearchTerm query, boolean readOnly) throws AuthenticationFailedException, MessagingException {
        EmailList<EmailMessage> emailList;
        log.info("selectEmailList start account = {} query = {}, readOnly = {}", new Object[]{account, query, readOnly});
        long startTimestamp = System.currentTimeMillis();
        EmailList<EmailMessage> resultList = new EmailList<EmailMessage>();
        try {
            Session session = Session.getInstance((Properties)new Properties());
            Store store = session.getStore(account.getProtocol());
            store.connect(account.getHost(), account.getPort(), account.getUsername(), account.getPassword());
            boolean isSupportProtocolSort = true;
            try {
                Folder[] systemFolders;
                Folder defaultFolder = store.getDefaultFolder();
                for (Folder systemFolder : systemFolders = defaultFolder.list()) {
                    EnumSet<FolderEnum> skipFolders = EnumSet.of(FolderEnum.deleted, FolderEnum.sent, FolderEnum.junk, FolderEnum.drafts);
                    if (skipFolders.stream().anyMatch(e -> e.match(systemFolder))) continue;
                    List<Folder> flatFolderList = EmailService.flatFolderList(systemFolder);
                    for (Folder folder : flatFolderList) {
                        EmailList<EmailMessage> list;
                        if (folder.getType() == 2) continue;
                        folder.open(readOnly ? 1 : 2);
                        try {
                            list = isSupportProtocolSort ? this.selectEmailList(folder, query, true) : this.selectEmailList(folder, query, false);
                        }
                        catch (MessagingException e2) {
                            isSupportProtocolSort = false;
                            if (e2.getNextException() instanceof ProtocolException) {
                                list = this.selectEmailList(folder, query, false);
                            }
                            try {
                                folder.close(false);
                            }
                            catch (MessagingException messagingException) {
                                // empty catch block
                            }
                            throw e2;
                        }
                        resultList.addList(list);
                    }
                }
            }
            catch (Exception e3) {
                store.close();
                resultList.close();
                throw e3;
            }
            resultList.forEach(e -> ((EmailMessage)e).username = account.getUsername());
            emailList = resultList;
        }
        catch (Throwable throwable) {
            log.info("selectEmailList end cost = {}/ms, account = {} query = {}, readOnly = {}, listSize = {}", new Object[]{System.currentTimeMillis() - startTimestamp, account, query, readOnly, resultList.size()});
            throw throwable;
        }
        log.info("selectEmailList end cost = {}/ms, account = {} query = {}, readOnly = {}, listSize = {}", new Object[]{System.currentTimeMillis() - startTimestamp, account, query, readOnly, resultList.size()});
        return emailList;
    }

    public FolderList selectFolderList(Account account) throws AuthenticationFailedException, MessagingException {
        Session session = Session.getInstance((Properties)new Properties());
        Store store = session.getStore(account.getProtocol());
        store.connect(account.getHost(), account.getPort(), account.getUsername(), account.getPassword());
        return new FolderList(store);
    }

    public boolean sendSimpleMail(String to, String subject, String content) {
        SimpleMailMessage message = new SimpleMailMessage();
        message.setTo(to);
        message.setFrom(this.mailProperties.getUsername());
        message.setSubject(subject);
        message.setText(content);
        this.mailSender.send(message);
        return true;
    }

    public boolean sendHtmlMail(String to, String subject, String content) {
        javax.mail.internet.MimeMessage message = this.mailSender.createMimeMessage();
        try {
            MimeMessageHelper helper = new MimeMessageHelper(message, true);
            helper.setTo(to);
            helper.setFrom(this.mailProperties.getUsername());
            helper.setSubject(subject);
            helper.setText(content, true);
            this.mailSender.send(message);
            return true;
        }
        catch (MessagingException e) {
            log.error("\u53d1\u9001html\u90ae\u4ef6\u5931\u8d25\uff1a{}", (Object)e.toString(), (Object)e);
            return false;
        }
    }

    public Sender newSender(String host, String username, String password) {
        String protocol = "smtps";
        String charset = "UTF-8";
        Integer port = 465;
        if (this.mailProperties != null) {
            protocol = this.mailProperties.getProtocol();
            charset = this.mailProperties.getDefaultEncoding().toString();
            port = this.mailProperties.getPort();
        }
        return this.newSender(protocol, charset, port, host, username, password);
    }

    public Sender newSender(String protocol, String charset, Integer port, String host, String username, String password) {
        Sender sender = new Sender();
        sender.setHost(host);
        sender.setDefaultEncoding(charset);
        if (port != null) {
            sender.setPort(port);
        }
        sender.setProtocol(protocol);
        sender.setUsername(username);
        sender.setPassword(password);
        return sender;
    }

    public boolean testConnection(String host, String username, String password) {
        try {
            this.newSender(host, username, password).testConnection();
            return true;
        }
        catch (MessagingException e) {
            return false;
        }
    }

    public static class Headers
    extends LinkedHashMap<String, List<String>> {
        public Headers(Enumeration<Header> enumeration) {
            this(enumeration, null);
        }

        public Headers(Enumeration<Header> enumeration, Headers headers) {
            while (enumeration.hasMoreElements()) {
                Header header = enumeration.nextElement();
                this.computeIfAbsent(header.getName(), e -> new ArrayList()).add(header.getValue());
            }
            if (headers != null) {
                headers.forEach((k, v) -> {
                    if (this.containsKey(k)) {
                        return;
                    }
                    for (String s : v) {
                        this.computeIfAbsent(k, e -> new ArrayList()).add(s);
                    }
                });
            }
        }
    }

    public static class Content
    implements Closeable {
        private Part emailPart;
        private Headers headers;
        private FileMediaType mediaType;
        private ContentType contentType;
        private String description;
        private String fileName;
        private List<Map<String, String>> dispositions;
        private String transferEncoding;
        private boolean fromMessage;
        private String sectionId;
        private String messageId;

        public Part getEmailPart() {
            return this.emailPart;
        }

        public void setEmailPart(Part emailPart) {
            this.emailPart = emailPart;
        }

        public Headers getHeaders() {
            return this.headers;
        }

        public void setHeaders(Headers headers) {
            this.headers = headers;
        }

        public FileMediaType getMediaType() {
            return this.mediaType;
        }

        public void setMediaType(FileMediaType mediaType) {
            this.mediaType = mediaType;
        }

        public ContentType getContentType() {
            return this.contentType;
        }

        public void setContentType(ContentType contentType) {
            this.contentType = contentType;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public List<Map<String, String>> getDispositions() {
            return this.dispositions;
        }

        public void setDispositions(List<Map<String, String>> dispositions) {
            this.dispositions = dispositions;
        }

        public String getTransferEncoding() {
            return this.transferEncoding;
        }

        public void setTransferEncoding(String transferEncoding) {
            this.transferEncoding = transferEncoding;
        }

        public boolean isFromMessage() {
            return this.fromMessage;
        }

        public void setFromMessage(boolean fromMessage) {
            this.fromMessage = fromMessage;
        }

        public String getSectionId() {
            return this.sectionId;
        }

        public void setSectionId(String sectionId) {
            this.sectionId = sectionId;
        }

        public String getMessageId() {
            return this.messageId;
        }

        public void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        public String getId() {
            return this.getMessageId() + "." + this.getSectionId();
        }

        @Override
        public void close() {
        }
    }

    public static class MultiPartContent
    extends Content {
        private List<Content> contentList;

        public MultiPartContent(List<Content> contentList) {
            this.contentList = contentList;
        }

        public List<Content> getContentList() {
            return this.contentList;
        }

        @Override
        public void close() {
            for (Content content : this.contentList) {
                content.close();
            }
            super.close();
        }

        public String toString() {
            return "size=" + this.contentList.size();
        }
    }

    public static class PdfContent
    extends FileContent {
        public PdfContent(Object pdf) {
            super(pdf);
        }

        @Override
        public boolean isPdf() {
            return true;
        }
    }

    public static class WordContent
    extends FileContent {
        public WordContent(Object word) {
            super(word);
        }

        @Override
        public boolean isWord() {
            return true;
        }
    }

    public static class HtmlContent
    extends TextContent {
        private HtmlQuery query;

        public HtmlContent(Object html, String charset) throws IOException {
            super(html, charset);
        }

        public HtmlQuery getQuery() {
            if (this.query == null) {
                this.query = HtmlQuery.valueOf(this.getText());
            }
            return this.query;
        }

        @Override
        public void close() {
            this.query = null;
            super.close();
        }
    }

    public static class ImageContent
    extends FileContent {
        public ImageContent(Object image) {
            super(image);
        }

        @Override
        public boolean isImage() {
            return true;
        }
    }

    public static class TextContent
    extends Content {
        private String text;
        private String charset;

        public TextContent(Object text, String charset) throws IOException {
            this.text = TextContent.textToString(text, charset);
            this.charset = charset;
        }

        private static String textToString(Object o, String charset) throws IOException {
            if (o instanceof String) {
                return (String)o;
            }
            if (o instanceof InputStream) {
                return TextContent.readInput((InputStream)o, charset == null || charset.isEmpty() ? "UTF-8" : charset);
            }
            return o.toString();
        }

        public static String readInput(InputStream in, String encode) throws IOException {
            StringBuilder sb = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, encode));){
                String line;
                while ((line = reader.readLine()) != null) {
                    sb.append(line).append('\n');
                }
                if (sb.length() > 0) {
                    sb.setLength(sb.length() - 1);
                }
                String string = sb.toString();
                return string;
            }
        }

        public String getText() {
            return this.text;
        }

        public String getCharset() {
            return this.charset;
        }

        @Override
        public void close() {
            this.text = null;
            super.close();
        }

        public String toString() {
            return this.text;
        }
    }

    public static class UnkownContent
    extends Content {
        private Object body;

        public UnkownContent(Object body) {
            this.body = body;
        }

        public Object getBody() {
            return this.body;
        }
    }

    public static class FileContent
    extends Content {
        private InputStream stream;

        public FileContent(Object stream) {
            this.stream = FileContent.toStream(stream);
        }

        private static InputStream toStream(Object o) {
            if (o instanceof InputStream) {
                return (InputStream)o;
            }
            if (o instanceof byte[]) {
                return new ByteArrayInputStream((byte[])o);
            }
            throw new IllegalStateException("toStream=" + o);
        }

        public InputStream getStream() {
            return this.stream;
        }

        public File getCacheFile() {
            String id = this.getId();
            InputStream stream = this.stream;
            String ext = this.getExt();
            String cacheId = "EmailBody_" + id + "." + ext;
            try {
                return FileUtil.cacheTempFile(cacheId, () -> stream, false);
            }
            catch (IOException e) {
                return null;
            }
        }

        public String getExt() {
            return FileUtil.getFileExtension(this.getFileName());
        }

        public InputStream getCacheStream() {
            try {
                File file = this.getCacheFile();
                return new FileInputStream(file);
            }
            catch (IOException e) {
                return this.stream;
            }
        }

        public boolean isPdf() {
            return false;
        }

        public boolean isImage() {
            return false;
        }

        public boolean isWord() {
            return false;
        }

        @Override
        public void close() {
            InputStream stream = this.stream;
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            super.close();
        }

        public String toString() {
            return this.stream.toString();
        }
    }

    public static class Address {
        private final String username;
        private final String email;

        public Address(javax.mail.Address address) {
            if (address instanceof InternetAddress) {
                this.username = ((InternetAddress)address).getPersonal();
                this.email = ((InternetAddress)address).getAddress();
            } else if (address instanceof NewsAddress) {
                this.username = ((NewsAddress)address).getNewsgroup();
                this.email = null;
            } else {
                this.username = null;
                this.email = null;
            }
        }

        public String getUsername() {
            return this.username;
        }

        public String getEmail() {
            return this.email;
        }

        public String toString() {
            return this.email;
        }
    }

    public static class EmailMessage
    implements Closeable {
        private final Message email;
        private final SearchTerm query;
        private final String folderName;
        private String username;
        private String messageId;
        private String subject;
        private Address sender;
        private Address[] forms;
        private Date receivedDate;
        private Headers headers;
        private Content content;
        private ContentType contentType;
        private EmailMessage next;
        private EmailMessage prev;
        private boolean parseFormFlag = false;
        private Map<String, Object> attributeMap;
        private Boolean seenFlag;

        public EmailMessage(Message email, SearchTerm query) {
            this.folderName = Optional.ofNullable(email).map(Message::getFolder).map(Folder::getFullName).orElse(null);
            this.email = email;
            this.query = query;
        }

        public Message getEmail() {
            return this.email;
        }

        public SearchTerm getQuery() {
            return this.query;
        }

        public String getFolderName() {
            return this.folderName;
        }

        public String getUsername() {
            return this.username;
        }

        public EmailMessage getNext() {
            return this.next;
        }

        public EmailMessage getPrev() {
            return this.prev;
        }

        public boolean isParseFormFlag() {
            return this.parseFormFlag;
        }

        public Map<String, Object> getAttributeMap() {
            return this.attributeMap;
        }

        public Boolean getSeenFlag() {
            return this.seenFlag;
        }

        public boolean isSeen() throws MessagingException {
            if (this.seenFlag == null) {
                this.seenFlag = this.email.getFlags().contains(Flags.Flag.SEEN);
            }
            return this.seenFlag;
        }

        public <T> T getAttribute(String key) {
            if (this.attributeMap == null) {
                return null;
            }
            return (T)this.attributeMap.get(key);
        }

        public <T> T setAttribute(String key, T value) {
            if (this.attributeMap == null) {
                this.attributeMap = new LinkedHashMap<String, Object>();
            }
            return (T)this.attributeMap.put(key, value);
        }

        public <T> T removeAttribute(String key) {
            if (this.attributeMap == null) {
                return null;
            }
            return (T)this.attributeMap.remove(key);
        }

        public String getMessageId() throws MessagingException {
            if (this.messageId == null) {
                String[] messageIds = this.email.getHeader("Message-ID");
                if (messageIds != null && messageIds.length > 0) {
                    for (String id : messageIds) {
                        if (id.length() <= 0) continue;
                        this.messageId = id;
                        break;
                    }
                } else {
                    this.messageId = "";
                }
            }
            return this.messageId;
        }

        public Headers getHeaders() throws MessagingException {
            if (this.headers == null) {
                this.headers = new Headers(this.email.getAllHeaders());
            }
            return this.headers;
        }

        public Address getSender() throws MessagingException {
            this.getForms();
            return this.sender;
        }

        public Address[] getForms() throws MessagingException {
            if (!this.parseFormFlag) {
                javax.mail.Address[] mfroms = this.email.getFrom();
                if (mfroms != null) {
                    this.forms = new Address[mfroms.length];
                    this.sender = mfroms.length > 0 ? new Address(mfroms[0]) : null;
                    for (int i = 0; i < mfroms.length; ++i) {
                        this.forms[i] = new Address(mfroms[i]);
                    }
                } else {
                    this.forms = null;
                    this.sender = null;
                }
                this.parseFormFlag = true;
            }
            return this.forms;
        }

        public Date getReceivedDate() throws MessagingException {
            if (this.receivedDate == null) {
                this.receivedDate = new Timestamp(this.email.getReceivedDate().getTime());
            }
            return this.receivedDate;
        }

        public Content getContent() throws IOException, MessagingException {
            if (this.content == null) {
                String messageId = this.getMessageId();
                this.content = EmailService.parseContent((Part)this.email, null, messageId);
            }
            return this.content;
        }

        public ContentType getContentType() throws MessagingException {
            if (this.contentType == null) {
                this.contentType = EmailService.parseContentType(this.email.getContentType());
            }
            return this.contentType;
        }

        public String getSubject() throws MessagingException {
            if (this.subject == null) {
                this.subject = this.email.getSubject();
            }
            return this.subject;
        }

        public String getSenderEmail() throws MessagingException {
            Address sender = this.getSender();
            return sender != null ? sender.getEmail() : null;
        }

        public <CONTENT extends Content> CONTENT getContent(Class<CONTENT> type, int index) throws IOException, MessagingException {
            List<CONTENT> list = this.getContentList(type);
            return (CONTENT)(index >= 0 && index < list.size() ? (Content)list.get(index) : null);
        }

        public List<Content> getContentList() throws IOException, MessagingException {
            return this.getContentList(Content.class);
        }

        public <CONTENT extends Content> List<CONTENT> getContentList(Class<CONTENT> type) throws IOException, MessagingException {
            ArrayList<Content> resultList = new ArrayList<Content>();
            LinkedList<Content> tempList = new LinkedList<Content>();
            tempList.add(this.getContent());
            while (!tempList.isEmpty()) {
                Content remove = (Content)tempList.remove(0);
                if (type.isAssignableFrom(remove.getClass())) {
                    resultList.add(remove);
                }
                if (!(remove instanceof MultiPartContent)) continue;
                tempList.addAll(((MultiPartContent)remove).getContentList());
            }
            return resultList;
        }

        public String toString() {
            try {
                return this.folderName + ": " + this.getSubject() + " / " + this.getMessageId() + " / " + this.getReceivedDate();
            }
            catch (Exception e) {
                return e.toString();
            }
        }

        @Override
        public void close() {
            Content content = this.content;
            if (content != null) {
                content.close();
            }
        }
    }

    public static class Account {
        private final String protocol = "imap";
        private String username = "";
        private String password = "";
        private String host = "";
        private int port = -1;

        public String getProtocol() {
            return "imap";
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public String toString() {
            return "Account{username='" + this.username + '\'' + ", passwordLength='" + Objects.toString(this.password, "").length() + '\'' + ", host='" + this.host + '\'' + ", protocol='" + "imap" + '\'' + ", port=" + this.port + '}';
        }
    }

    public static class EmailList<T extends EmailMessage>
    extends ArrayList<T>
    implements Closeable {
        private final Set<Folder> folderList = Collections.newSetFromMap(new IdentityHashMap());
        private final AtomicBoolean closeFlag = new AtomicBoolean(false);

        public EmailList() {
        }

        public EmailList(Folder folder) {
            this.folderList.add(folder);
        }

        public EmailList(List<EmailList<T>> list) {
            list.forEach(this::addList);
        }

        public Set<Folder> getFolderList() {
            return this.folderList;
        }

        public void addList(EmailList<T> emailList) {
            this.folderList.addAll(emailList.folderList);
            this.addAll(emailList);
        }

        @Override
        public void close() {
            if (this.closeFlag.compareAndSet(false, true)) {
                for (EmailMessage m : this) {
                    m.close();
                }
                for (Folder folder : this.folderList) {
                    if (folder == null) continue;
                    try {
                        if (folder.isOpen()) {
                            folder.close(false);
                        }
                    }
                    catch (MessagingException e) {
                        log.warn("EmailList folder close error = {}", (Object)e.toString(), (Object)e);
                    }
                    try {
                        folder.getStore().close();
                    }
                    catch (MessagingException e) {
                        log.warn("EmailList store close error = {}", (Object)e.toString(), (Object)e);
                    }
                }
            }
        }
    }

    public static class Sender
    extends JavaMailSenderImpl {
        private final List<MimeMessage> messageList = new ArrayList<MimeMessage>();

        public MimeMessage newMessage() throws MessagingException {
            MimeMessage message = new MimeMessage(this);
            message.setFrom(this.getUsername());
            this.messageList.add(message);
            return message;
        }

        public void send(MimeMessage message) throws MailException {
            if (this.messageList.remove((Object)message)) {
                this.send(message.getMimeMessage());
            }
        }

        public int sendAll() {
            int i = 0;
            Iterator<MimeMessage> iterator = this.messageList.iterator();
            while (iterator.hasNext()) {
                this.send(iterator.next().getMimeMessage());
                iterator.remove();
                ++i;
            }
            return i;
        }
    }

    public static class MimeMessage
    extends MimeMessageHelper {
        private final Sender sender;

        private MimeMessage(Sender sender) throws MessagingException {
            super(sender.createMimeMessage(), true, "UTF-8");
            this.sender = sender;
        }

        public void send() throws MailException {
            this.sender.send(this);
        }
    }

    public static class FolderList
    extends ArrayList<Folder>
    implements Closeable {
        private final Store store;

        public FolderList() {
            this.store = null;
        }

        public FolderList(Store store) throws MessagingException {
            Folder defaultFolder;
            Folder[] folders;
            this.store = store;
            if (store != null && (folders = (defaultFolder = store.getDefaultFolder()).list()) != null) {
                this.addAll(Arrays.asList(folders));
            }
        }

        @Override
        public void close() {
            if (this.store == null) {
                return;
            }
            try {
                this.store.close();
            }
            catch (MessagingException e) {
                log.warn("FolderList store close error = {}", (Object)e.toString(), (Object)e);
            }
        }
    }

    public static interface Closeable
    extends AutoCloseable {
        @Override
        public void close();
    }

    public static enum FolderEnum {
        inbox("\u6536\u4ef6"),
        sent("\u53d1\u9001"),
        junk("\u5783\u573e"),
        deleted("\u5220\u9664"),
        drafts("\u8349\u7a3f"),
        other("\u5176\u4ed6"){

            @Override
            public boolean match(Folder folder) {
                if (super.match(folder)) {
                    return true;
                }
                return !deleted.match(folder) && !sent.match(folder) && !inbox.match(folder) && !junk.match(folder) && !drafts.match(folder);
            }
        };

        private final String cnName;

        private FolderEnum(String cnName) {
            this.cnName = cnName;
        }

        public boolean match(Folder folder) {
            String name = folder.getName();
            if (name == null) {
                return false;
            }
            String lowerCase = name.toLowerCase();
            return lowerCase.contains(this.name()) || lowerCase.contains(this.cnName);
        }
    }
}

