/*
 * Decompiled with CFR 0.152.
 */
package com.github.emailservice.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public final class MimeUtility {
    private static final String US_ASCII_CHARSET = "US-ASCII";
    private static final String BASE64_ENCODING_MARKER = "B";
    private static final String QUOTEDPRINTABLE_ENCODING_MARKER = "Q";
    private static final String ENCODED_TOKEN_MARKER = "=?";
    private static final String ENCODED_TOKEN_FINISHER = "?=";
    private static final String LINEAR_WHITESPACE = " \t\r\n";
    private static final Map<String, String> MIME2JAVA = new HashMap<String, String>();
    private static final int UPPER_NIBBLE_SHIFT = 4;

    private MimeUtility() {
    }

    public static String decodeText(String text) throws UnsupportedEncodingException {
        if (!text.contains(ENCODED_TOKEN_MARKER)) {
            return text;
        }
        int offset = 0;
        int endOffset = text.length();
        int startWhiteSpace = -1;
        int endWhiteSpace = -1;
        StringBuilder decodedText = new StringBuilder(text.length());
        boolean previousTokenEncoded = false;
        block2: while (offset < endOffset) {
            char ch = text.charAt(offset);
            if (LINEAR_WHITESPACE.indexOf(ch) != -1) {
                startWhiteSpace = offset;
                while (offset < endOffset) {
                    ch = text.charAt(offset);
                    if (LINEAR_WHITESPACE.indexOf(ch) != -1) {
                        ++offset;
                        continue;
                    }
                    endWhiteSpace = offset;
                    continue block2;
                }
                continue;
            }
            int wordStart = offset;
            while (offset < endOffset && LINEAR_WHITESPACE.indexOf(ch = text.charAt(offset)) == -1) {
                ++offset;
            }
            String word = text.substring(wordStart, offset);
            if (word.startsWith(ENCODED_TOKEN_MARKER)) {
                try {
                    String decodedWord = MimeUtility.decodeWord(word);
                    if (!previousTokenEncoded && startWhiteSpace != -1) {
                        decodedText.append(text.substring(startWhiteSpace, endWhiteSpace));
                        startWhiteSpace = -1;
                    }
                    previousTokenEncoded = true;
                    decodedText.append(decodedWord);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (startWhiteSpace != -1) {
                decodedText.append(text, startWhiteSpace, endWhiteSpace);
                startWhiteSpace = -1;
            }
            previousTokenEncoded = false;
            decodedText.append(word);
        }
        return decodedText.toString();
    }

    private static String decodeWord(String word) throws IllegalArgumentException, UnsupportedEncodingException {
        if (!word.startsWith(ENCODED_TOKEN_MARKER)) {
            throw new IllegalArgumentException("Invalid RFC 2047 encoded-word: " + word);
        }
        int charsetPos = word.indexOf(63, 2);
        if (charsetPos == -1) {
            throw new IllegalArgumentException("Missing charset in RFC 2047 encoded-word: " + word);
        }
        String charset = word.substring(2, charsetPos).toLowerCase(Locale.ENGLISH);
        int encodingPos = word.indexOf(63, charsetPos + 1);
        if (encodingPos == -1) {
            throw new IllegalArgumentException("Missing encoding in RFC 2047 encoded-word: " + word);
        }
        String encoding = word.substring(charsetPos + 1, encodingPos);
        int encodedTextPos = word.indexOf(ENCODED_TOKEN_FINISHER, encodingPos + 1);
        if (encodedTextPos == -1) {
            throw new IllegalArgumentException("Missing encoded text in RFC 2047 encoded-word: " + word);
        }
        String encodedText = word.substring(encodingPos + 1, encodedTextPos);
        if (encodedText.length() == 0) {
            return "";
        }
        try {
            byte[] decodedData;
            ByteArrayOutputStream out = new ByteArrayOutputStream(encodedText.length());
            if (encoding.equals(BASE64_ENCODING_MARKER)) {
                decodedData = Base64.getDecoder().decode(encodedText.getBytes(Charset.forName("utf-8")));
            } else if (encoding.equals(QUOTEDPRINTABLE_ENCODING_MARKER)) {
                byte[] encodedData = encodedText.getBytes(US_ASCII_CHARSET);
                MimeUtility.decode(encodedData, out);
                decodedData = out.toByteArray();
            } else {
                throw new UnsupportedEncodingException("Unknown RFC 2047 encoding: " + encoding);
            }
            return new String(decodedData, MimeUtility.javaCharset(charset));
        }
        catch (IOException e) {
            throw new UnsupportedEncodingException("Invalid RFC 2047 encoding");
        }
    }

    private static String javaCharset(String charset) {
        if (charset == null) {
            return null;
        }
        String mappedCharset = MIME2JAVA.get(charset.toLowerCase(Locale.ENGLISH));
        if (mappedCharset == null) {
            return charset;
        }
        return mappedCharset;
    }

    public static int decode(byte[] data, OutputStream out) throws IOException {
        int off = 0;
        int length = data.length;
        int endOffset = off + length;
        int bytesWritten = 0;
        while (off < endOffset) {
            byte ch;
            if ((ch = data[off++]) == 95) {
                out.write(32);
                continue;
            }
            if (ch == 61) {
                if (off + 1 >= endOffset) {
                    throw new IOException("Invalid quoted printable encoding; truncated escape sequence");
                }
                byte b1 = data[off++];
                byte b2 = data[off++];
                if (b1 == 13) {
                    if (b2 == 10) continue;
                    throw new IOException("Invalid quoted printable encoding; CR must be followed by LF");
                }
                int c1 = MimeUtility.hexToBinary(b1);
                int c2 = MimeUtility.hexToBinary(b2);
                out.write(c1 << 4 | c2);
                ++bytesWritten;
                continue;
            }
            out.write(ch);
            ++bytesWritten;
        }
        return bytesWritten;
    }

    private static int hexToBinary(byte b) throws IOException {
        int i = Character.digit((char)b, 16);
        if (i == -1) {
            throw new IOException("Invalid quoted printable encoding: not a valid hex digit: " + b);
        }
        return i;
    }

    static {
        MIME2JAVA.put("ja_jp.iso2022-7", "ISO2022JP");
        MIME2JAVA.put("ja_jp.eucjp", "EUCJIS");
        MIME2JAVA.put("x-us-ascii", "ISO-8859-1");
    }
}

