package com.github.netty.protocol.servlet.util;

/**
 * @author wangzihao
 */
public class HttpHeaderConstants {

    public static final CharSequence PATH = "Path";

    public static final CharSequence MAX_AGE_1 = "Max-Age";

    public static final CharSequence DOMAIN = "Domain";

    public static final CharSequence SECURE = "Secure";

    public static final CharSequence HTTPONLY = "HttpOnly";

    public static final CharSequence COMMENT = "Comment";

    public static final CharSequence COMMENTURL = "CommentURL";

    public static final CharSequence DISCARD = "Discard";

    public static final CharSequence PORT = "Port";

    public static final CharSequence VERSION = "Version";

    /**
     * {@code "Accept"}
     */
    public static final CharSequence ACCEPT = "Accept";
    /**
     * {@code "Accept-Charset"}
     */
    public static final CharSequence ACCEPT_CHARSET = "Accept-Charset";
    /**
     * {@code "Accept-Encoding"}
     */
    public static final CharSequence ACCEPT_ENCODING = "Accept-Encoding";
    /**
     * {@code "Accept-Language"}
     */
    public static final CharSequence ACCEPT_LANGUAGE = "Accept-Language";
    /**
     * {@code "Accept-Ranges"}
     */
    public static final CharSequence ACCEPT_RANGES = "Accept-Ranges";
    /**
     * {@code "Accept-Patch"}
     */
    public static final CharSequence ACCEPT_PATCH = "Accept-Patch";
    /**
     * {@code "Access-Control-Allow-Credentials"}
     */
    public static final CharSequence ACCESS_CONTROL_ALLOW_CREDENTIALS = "Access-Control-Allow-Credentials";
    /**
     * {@code "Access-Control-Allow-Headers"}
     */
    public static final CharSequence ACCESS_CONTROL_ALLOW_HEADERS = "Access-Control-Allow-Headers";
    /**
     * {@code "Access-Control-Allow-Methods"}
     */
    public static final CharSequence ACCESS_CONTROL_ALLOW_METHODS = "Access-Control-Allow-Methods";
    /**
     * {@code "Access-Control-Allow-Origin"}
     */
    public static final CharSequence ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
    /**
     * {@code "Access-Control-Expose-Headers"}
     */
    public static final CharSequence ACCESS_CONTROL_EXPOSE_HEADERS = "Access-Control-Expose-Headers";
    /**
     * {@code "Access-Control-Max-Age"}
     */
    public static final CharSequence ACCESS_CONTROL_MAX_AGE = "Access-Control-Max-Age";
    /**
     * {@code "Access-Control-Request-Headers"}
     */
    public static final CharSequence ACCESS_CONTROL_REQUEST_HEADERS = "Access-Control-Request-Headers";
    /**
     * {@code "Access-Control-Request-Method"}
     */
    public static final CharSequence ACCESS_CONTROL_REQUEST_METHOD = "Access-Control-Request-Method";
    /**
     * {@code "Age"}
     */
    public static final CharSequence AGE = "Age";
    /**
     * {@code "Allow"}
     */
    public static final CharSequence ALLOW = "Allow";
    /**
     * {@code "Authorization"}
     */
    public static final CharSequence AUTHORIZATION = "Authorization";
    /**
     * {@code "Cache-Control"}
     */
    public static final CharSequence CACHE_CONTROL = "Cache-Control";
    /**
     * {@code "Connection"}
     */
    public static final CharSequence CONNECTION = "Connection";
    /**
     * {@code "Content-Base"}
     */
    public static final CharSequence CONTENT_BASE = "Content-Base";
    /**
     * {@code "Content-Encoding"}
     */
    public static final CharSequence CONTENT_ENCODING = "Content-Encoding";
    /**
     * {@code "Content-Language"}
     */
    public static final CharSequence CONTENT_LANGUAGE = "Content-Language";
    /**
     * {@code "Content-Length"}
     */
    public static final CharSequence CONTENT_LENGTH = "Content-Length";
    /**
     * {@code "Content-Location"}
     */
    public static final CharSequence CONTENT_LOCATION = "Content-Location";
    /**
     * {@code "Content-Transfer-Encoding"}
     */
    public static final CharSequence CONTENT_TRANSFER_ENCODING = "Content-Transfer-Encoding";
    /**
     * {@code "Content-MD5"}
     */
    public static final CharSequence CONTENT_MD5 = "Content-MD5";
    /**
     * {@code "Content-Range"}
     */
    public static final CharSequence CONTENT_RANGE = "Content-Range";
    /**
     * {@code "Content-Type"}
     */
    public static final CharSequence CONTENT_TYPE = "Content-Type";
    /**
     * {@code "Cookie"}
     */
    public static final CharSequence COOKIE = "Cookie";
    /**
     * {@code "Date"}
     */
    public static final CharSequence DATE = "Date";
    /**
     * {@code "ETag"}
     */
    public static final CharSequence ETAG = "ETag";
    /**
     * {@code "Expect"}
     */
    public static final CharSequence EXPECT = "Expect";
    /**
     * {@code "Expires"}
     */
    public static final CharSequence EXPIRES = "Expires";
    /**
     * {@code "From"}
     */
    public static final CharSequence FROM = "From";
    /**
     * {@code "Host"}
     */
    public static final CharSequence HOST = "Host";
    /**
     * {@code "If-Match"}
     */
    public static final CharSequence IF_MATCH = "If-Match";
    /**
     * {@code "If-Modified-Since"}
     */
    public static final CharSequence IF_MODIFIED_SINCE = "If-Modified-Since";
    /**
     * {@code "If-None-Match"}
     */
    public static final CharSequence IF_NONE_MATCH = "If-None-Match";
    /**
     * {@code "If-Range"}
     */
    public static final CharSequence IF_RANGE = "If-Range";
    /**
     * {@code "If-Unmodified-Since"}
     */
    public static final CharSequence IF_UNMODIFIED_SINCE = "If-Unmodified-Since";
    /**
     * {@code "Last-Modified"}
     */
    public static final CharSequence LAST_MODIFIED = "Last-Modified";
    /**
     * {@code "Location"}
     */
    public static final CharSequence LOCATION = "Location";
    /**
     * {@code "Max-Forwards"}
     */
    public static final CharSequence MAX_FORWARDS = "Max-Forwards";
    /**
     * {@code "Origin"}
     */
    public static final CharSequence ORIGIN = "Origin";
    /**
     * {@code "Pragma"}
     */
    public static final CharSequence PRAGMA = "Pragma";
    /**
     * {@code "Proxy-Authenticate"}
     */
    public static final CharSequence PROXY_AUTHENTICATE = "Proxy-Authenticate";
    /**
     * {@code "Proxy-Authorization"}
     */
    public static final CharSequence PROXY_AUTHORIZATION = "Proxy-Authorization";
    /**
     * {@code "Range"}
     */
    public static final CharSequence RANGE = "Range";
    /**
     * {@code "Referer"}
     */
    public static final CharSequence REFERER = "Referer";
    /**
     * {@code "Retry-After"}
     */
    public static final CharSequence RETRY_AFTER = "Retry-After";
    /**
     * {@code "Sec-WebSocket-Key1"}
     */
    public static final CharSequence SEC_WEBSOCKET_KEY1 = "Sec-WebSocket-Key1";
    /**
     * {@code "Sec-WebSocket-Key2"}
     */
    public static final CharSequence SEC_WEBSOCKET_KEY2 = "Sec-WebSocket-Key2";
    /**
     * {@code "Sec-WebSocket-Location"}
     */
    public static final CharSequence SEC_WEBSOCKET_LOCATION = "Sec-WebSocket-Location";
    /**
     * {@code "Sec-WebSocket-Origin"}
     */
    public static final CharSequence SEC_WEBSOCKET_ORIGIN = "Sec-WebSocket-Origin";
    /**
     * {@code "Sec-WebSocket-Protocol"}
     */
    public static final CharSequence SEC_WEBSOCKET_PROTOCOL = "Sec-WebSocket-Protocol";
    /**
     * {@code "Sec-WebSocket-Version"}
     */
    public static final CharSequence SEC_WEBSOCKET_VERSION = "Sec-WebSocket-Version";
    /**
     * {@code "Sec-WebSocket-Key"}
     */
    public static final CharSequence SEC_WEBSOCKET_KEY = "Sec-WebSocket-Key";
    /**
     * {@code "Sec-WebSocket-Accept"}
     */
    public static final CharSequence SEC_WEBSOCKET_ACCEPT = "Sec-WebSocket-Accept";
    /**
     * {@code "Server"}
     */
    public static final CharSequence SERVER = "Server";
    /**
     * {@code "Set-Cookie"}
     */
    public static final CharSequence SET_COOKIE = "Set-Cookie";
    /**
     * {@code "Set-Cookie2"}
     */
    public static final CharSequence SET_COOKIE2 = "Set-Cookie2";
    /**
     * {@code "TE"}
     */
    public static final CharSequence TE = "TE";
    /**
     * {@code "Trailer"}
     */
    public static final CharSequence TRAILER = "Trailer";
    /**
     * {@code "Transfer-Encoding"}
     */
    public static final CharSequence TRANSFER_ENCODING = "Transfer-Encoding";
    /**
     * {@code "Upgrade"}
     */
    public static final CharSequence UPGRADE = "Upgrade";
    /**
     * {@code "User-Agent"}
     */
    public static final CharSequence USER_AGENT = "User-Agent";
    /**
     * {@code "Vary"}
     */
    public static final CharSequence VARY = "Vary";
    /**
     * {@code "Via"}
     */
    public static final CharSequence VIA = "Via";
    /**
     * {@code "Warning"}
     */
    public static final CharSequence WARNING = "Warning";
    /**
     * {@code "WebSocket-Location"}
     */
    public static final CharSequence WEBSOCKET_LOCATION = "WebSocket-Location";
    /**
     * {@code "WebSocket-Origin"}
     */
    public static final CharSequence WEBSOCKET_ORIGIN = "WebSocket-Origin";
    /**
     * {@code "WebSocket-Protocol"}
     */
    public static final CharSequence WEBSOCKET_PROTOCOL = "WebSocket-Protocol";
    /**
     * {@code "WWW-Authenticate"}
     */
    public static final CharSequence WWW_AUTHENTICATE = "WWW-Authenticate";





    /**
     * {@code "application/x-www-form-urlencoded"}
     */
    public static final CharSequence APPLICATION_X_WWW_FORM_URLENCODED =
            "application/x-www-form-urlencoded";
    /**
     * {@code "base64"}
     */
    public static final CharSequence BASE64 = "base64";
    /**
     * {@code "binary"}
     */
    public static final CharSequence BINARY = "binary";
    /**
     * {@code "boundary"}
     */
    public static final CharSequence BOUNDARY = "boundary";
    /**
     * {@code "bytes"}
     */
    public static final CharSequence BYTES = "bytes";
    /**
     * {@code "charset"}
     */
    public static final CharSequence CHARSET = "charset";
    /**
     * {@code "chunked"}
     */
    public static final CharSequence CHUNKED = "chunked";
    /**
     * {@code "close"}
     */
    public static final CharSequence CLOSE = "close";
    /**
     * {@code "compress"}
     */
    public static final CharSequence COMPRESS = "compress";
    /**
     * {@code "100-continue"}
     */
    public static final CharSequence CONTINUE =  "100-continue";
    /**
     * {@code "deflate"}
     */
    public static final CharSequence DEFLATE = "deflate";
    /**
     * {@code "gzip"}
     */
    public static final CharSequence GZIP = "gzip";
    /**
     * {@code "identity"}
     */
    public static final CharSequence IDENTITY = "identity";
    /**
     * {@code "keep-alive"}
     */
    public static final CharSequence KEEP_ALIVE = "keep-alive";
    /**
     * {@code "max-age"}
     */
    public static final CharSequence MAX_AGE_0 = "max-age";
    /**
     * {@code "max-stale"}
     */
    public static final CharSequence MAX_STALE = "max-stale";
    /**
     * {@code "min-fresh"}
     */
    public static final CharSequence MIN_FRESH = "min-fresh";
    /**
     * {@code "multipart/form-data"}
     */
    public static final CharSequence MULTIPART_FORM_DATA = "multipart/form-data";
    /**
     * {@code "must-revalidate"}
     */
    public static final CharSequence MUST_REVALIDATE = "must-revalidate";
    /**
     * {@code "no-cache"}
     */
    public static final CharSequence NO_CACHE = "no-cache";
    /**
     * {@code "no-store"}
     */
    public static final CharSequence NO_STORE = "no-store";
    /**
     * {@code "no-transform"}
     */
    public static final CharSequence NO_TRANSFORM = "no-transform";
    /**
     * {@code "none"}
     */
    public static final CharSequence NONE = "none";
    /**
     * {@code "only-if-cached"}
     */
    public static final CharSequence ONLY_IF_CACHED = "only-if-cached";
    /**
     * {@code "private"}
     */
    public static final CharSequence PRIVATE = "private";
    /**
     * {@code "proxy-revalidate"}
     */
    public static final CharSequence PROXY_REVALIDATE = "proxy-revalidate";
    /**
     * {@code "public"}
     */
    public static final CharSequence PUBLIC = "public";
    /**
     * {@code "quoted-printable"}
     */
    public static final CharSequence QUOTED_PRINTABLE = "quoted-printable";
    /**
     * {@code "s-maxage"}
     */
    public static final CharSequence S_MAXAGE = "s-maxage";
    /**
     * {@code "trailers"}
     */
    public static final CharSequence TRAILERS = "trailers";
    /**
     * {@code "WebSocket"}
     */
    public static final CharSequence WEBSOCKET = "websocket";
    /**
     * {@code "Sec-WebSocket-Extensions"}
     */
    public static final CharSequence SEC_WEBSOCKET_EXTENSIONS = "Sec-WebSocket-Extensions";
    /**
     * {@code "X-Forwarded-Port"}
     */
    public static final CharSequence X_FORWARDED_PORT = "X-Forwarded-Port";
    /**
     * {@code "X-Forwarded-Proto"}
     */
    public static final CharSequence X_FORWARDED_PROTO = "X-Forwarded-Proto";
    /**
     * {@code "X-Forwarded-Prefix"}
     */
    public static final CharSequence X_FORWARDED_PREFIX = "X-Forwarded-Prefix";
    /**
     * {@code "X-Forwarded-Ssl"}
     */
    public static final CharSequence X_FORWARDED_SSL = "X-Forwarded-Ssl";
    /**
     * {@code "X-Forwarded-Host"}
     */
    public static final CharSequence X_FORWARDED_HOST = "X-Forwarded-Host";

    public static final CharSequence CONTENT_DISPOSITION = "Content-Disposition";
    public static final CharSequence NAME = "name";
    public static final CharSequence FILENAME = "filename";
    public static final CharSequence FORM_DATA = "form-data";

}
