/*
 * Decompiled with CFR 0.152.
 */
package com.github.sseserver;

import com.github.sseserver.AccessToken;
import com.github.sseserver.AccessUser;
import com.github.sseserver.LocalConnectionService;
import com.github.sseserver.SseEmitter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

public class LocalConnectionServiceImpl
implements LocalConnectionService,
BeanNameAware {
    private static final Logger log = LoggerFactory.getLogger(LocalConnectionServiceImpl.class);
    protected final Map<String, Set<Long>> accessToken2ConnectionIdMap = new ConcurrentHashMap<String, Set<Long>>();
    protected final Map<String, Set<Long>> channel2ConnectionIdMap = new ConcurrentHashMap<String, Set<Long>>();
    protected final Map<String, Set<Long>> customerId2ConnectionIdMap = new ConcurrentHashMap<String, Set<Long>>();
    protected final Map<String, Set<String>> userId2AccessTokenMap = new ConcurrentHashMap<String, Set<String>>();
    protected final Map<Long, SseEmitter> connectionMap = new ConcurrentHashMap<Long, SseEmitter>();
    protected final List<Consumer<SseEmitter>> connectListeners = new ArrayList<Consumer<SseEmitter>>();
    protected final List<Consumer<SseEmitter>> disconnectListeners = new ArrayList<Consumer<SseEmitter>>();
    protected final Map<String, List<Predicate<SseEmitter>>> connectListenerMap = new ConcurrentHashMap<String, List<Predicate<SseEmitter>>>();
    protected final Map<String, List<Predicate<SseEmitter>>> disconnectListenerMap = new ConcurrentHashMap<String, List<Predicate<SseEmitter>>>();
    private String beanName = this.getClass().getSimpleName();

    @Override
    public <ACCESS_USER extends AccessUser & AccessToken> SseEmitter<ACCESS_USER> connect(ACCESS_USER accessUser, Long keepaliveTime) {
        if (keepaliveTime == null) {
            keepaliveTime = 0L;
        }
        SseEmitter<ACCESS_USER> result = new SseEmitter<ACCESS_USER>(keepaliveTime, accessUser);
        result.onCompletion(this.completionCallBack(result));
        result.onError(this.errorCallBack(result));
        result.onTimeout(this.timeoutCallBack(result));
        result.addDisConnectListener(e -> {
            Collection channelList;
            Collection customerList;
            Collection userList;
            long id = e.getId();
            String accessToken = this.wrapStringKey(e.getAccessToken());
            String userId = this.wrapStringKey(Objects.toString(e.getUserId(), null));
            String channel = this.wrapStringKey(e.getChannel());
            String customerId = this.wrapStringKey(Objects.toString(e.getCustomerId(), null));
            log.debug("sse {} connection disconnect : {}", (Object)this.beanName, (Object)e);
            this.notifyListener((SseEmitter)((Object)e), this.disconnectListeners, this.disconnectListenerMap);
            this.connectionMap.remove(id);
            Collection tokenEmitterList = this.accessToken2ConnectionIdMap.get(accessToken);
            if (tokenEmitterList != null) {
                tokenEmitterList.remove(id);
                if (tokenEmitterList.isEmpty()) {
                    this.accessToken2ConnectionIdMap.remove(accessToken);
                }
            }
            if ((userList = (Collection)this.userId2AccessTokenMap.get(userId)) != null) {
                userList.remove(accessToken);
                if (userList.isEmpty()) {
                    this.userId2AccessTokenMap.remove(userId);
                }
            }
            if ((customerList = (Collection)this.customerId2ConnectionIdMap.get(customerId)) != null) {
                customerList.remove(id);
                if (customerList.isEmpty()) {
                    this.customerId2ConnectionIdMap.remove(userId);
                }
            }
            if ((channelList = (Collection)this.channel2ConnectionIdMap.get(channel)) != null) {
                channelList.remove(id);
                if (channelList.isEmpty()) {
                    this.channel2ConnectionIdMap.remove(channel);
                }
            }
        });
        result.addConnectListener(e -> {
            log.debug("sse {} connection create : {}", (Object)this.beanName, (Object)e);
            this.notifyListener((SseEmitter)((Object)e), this.connectListeners, this.connectListenerMap);
        });
        long id = result.getId();
        String accessToken = this.wrapStringKey(result.getAccessToken());
        String userId = this.wrapStringKey(Objects.toString(result.getUserId(), null));
        String channel = this.wrapStringKey(result.getChannel());
        String customerId = this.wrapStringKey(Objects.toString(result.getCustomerId(), null));
        this.connectionMap.put(id, result);
        this.channel2ConnectionIdMap.computeIfAbsent(channel, o -> Collections.newSetFromMap(new ConcurrentHashMap(3))).add(id);
        this.accessToken2ConnectionIdMap.computeIfAbsent(accessToken, o -> Collections.newSetFromMap(new ConcurrentHashMap(3))).add(id);
        this.customerId2ConnectionIdMap.computeIfAbsent(customerId, o -> Collections.newSetFromMap(new ConcurrentHashMap(3))).add(id);
        this.userId2AccessTokenMap.computeIfAbsent(userId, o -> Collections.newSetFromMap(new ConcurrentHashMap(3))).add(accessToken);
        try {
            int reconnectTime = 5000;
            result.send(SseEmitter.event().reconnectTime((long)reconnectTime).name("connect-finish").data((Object)("{\"connectionId\":" + id + ",\"serverTime\":" + System.currentTimeMillis() + ",\"reconnectTime\":" + reconnectTime + ",\"name\":\"" + this.beanName + "\"}")));
            return result;
        }
        catch (IOException e2) {
            log.error("sse {} send {} IOException:{}", new Object[]{this.beanName, result, e2.toString(), e2});
            return null;
        }
    }

    public SseEmitter disconnectByConnectionId(Long connectionId) {
        SseEmitter sseEmitter = this.getConnectionById(connectionId);
        if (sseEmitter != null && sseEmitter.disconnect()) {
            return sseEmitter;
        }
        return null;
    }

    public List<SseEmitter> disconnectByAccessToken(String accessToken) {
        Collection sseEmitters = this.getConnectionByAccessToken(accessToken);
        ArrayList<SseEmitter> result = new ArrayList<SseEmitter>();
        if (sseEmitters != null) {
            for (SseEmitter next : sseEmitters) {
                if (!next.disconnect()) continue;
                result.add(next);
            }
        }
        return result;
    }

    public List<SseEmitter> disconnectByUserId(Object userId) {
        Collection sseEmitters = this.getConnectionByUserId(userId);
        ArrayList<SseEmitter> result = new ArrayList<SseEmitter>();
        if (sseEmitters != null) {
            for (SseEmitter next : sseEmitters) {
                if (!next.disconnect()) continue;
                result.add(next);
            }
        }
        return result;
    }

    public Collection<SseEmitter> getConnectionAll() {
        return new ArrayList<SseEmitter>(this.connectionMap.values());
    }

    public SseEmitter getConnectionById(Long connectionId) {
        if (connectionId == null) {
            return null;
        }
        return this.connectionMap.get(connectionId);
    }

    public List<SseEmitter> getConnectionByChannel(String channel) {
        Collection idList = this.channel2ConnectionIdMap.get(this.wrapStringKey(channel));
        if (idList == null || idList.isEmpty()) {
            return Collections.emptyList();
        }
        return idList.stream().map(this::getConnectionById).filter(Objects::nonNull).distinct().collect(Collectors.toList());
    }

    public List<SseEmitter> getConnectionByAccessToken(String accessToken) {
        Collection idList = this.accessToken2ConnectionIdMap.get(this.wrapStringKey(accessToken));
        if (idList == null || idList.isEmpty()) {
            return Collections.emptyList();
        }
        return idList.stream().map(this::getConnectionById).filter(Objects::nonNull).distinct().collect(Collectors.toList());
    }

    public List<SseEmitter> getConnectionByCustomerId(Object customerId) {
        Collection idList = this.customerId2ConnectionIdMap.get(this.wrapStringKey(Objects.toString(customerId, null)));
        if (idList == null || idList.isEmpty()) {
            return Collections.emptyList();
        }
        return idList.stream().map(this::getConnectionById).distinct().collect(Collectors.toList());
    }

    public List<SseEmitter> getConnectionByUserId(Object userId) {
        Collection accessTokenList = this.userId2AccessTokenMap.get(this.wrapStringKey(Objects.toString(userId, null)));
        if (accessTokenList == null || accessTokenList.isEmpty()) {
            return Collections.emptyList();
        }
        return accessTokenList.stream().map(string -> this.getConnectionByAccessToken((String)string)).flatMap(Collection::stream).distinct().collect(Collectors.toList());
    }

    @Override
    public <ACCESS_USER extends AccessUser & AccessToken> void addConnectListener(String accessToken, String channel, Consumer<SseEmitter<ACCESS_USER>> consumer) {
        Collection sseEmitters = this.getConnectionByAccessToken(accessToken);
        if (sseEmitters != null) {
            for (SseEmitter emitter : sseEmitters) {
                if (!emitter.isConnect() || !Objects.equals(channel, emitter.getChannel())) continue;
                consumer.accept(emitter);
            }
        }
        this.connectListenerMap.computeIfAbsent(accessToken, e -> new ArrayList()).add(e -> {
            if (Objects.equals(channel, e.getChannel())) {
                consumer.accept((SseEmitter)((Object)e));
                return true;
            }
            return false;
        });
    }

    @Override
    public <ACCESS_USER extends AccessUser & AccessToken> void addConnectListener(String accessToken, Consumer<SseEmitter<ACCESS_USER>> consumer) {
        Collection sseEmitters = this.getConnectionByAccessToken(accessToken);
        if (sseEmitters != null) {
            for (SseEmitter emitter : sseEmitters) {
                if (!emitter.isConnect()) continue;
                consumer.accept(emitter);
            }
        }
        this.connectListenerMap.computeIfAbsent(accessToken, e -> new ArrayList()).add(e -> {
            consumer.accept((SseEmitter)((Object)e));
            return true;
        });
    }

    @Override
    public <ACCESS_USER extends AccessUser & AccessToken> void addConnectListener(Consumer<SseEmitter<ACCESS_USER>> consumer) {
        this.connectListeners.add(consumer);
    }

    @Override
    public <ACCESS_USER extends AccessUser & AccessToken> void addDisConnectListener(Consumer<SseEmitter<ACCESS_USER>> consumer) {
        this.disconnectListeners.add(consumer);
    }

    @Override
    public <ACCESS_USER extends AccessUser & AccessToken> void addDisConnectListener(String accessToken, Consumer<SseEmitter<ACCESS_USER>> consumer) {
        this.disconnectListenerMap.computeIfAbsent(accessToken, e -> new ArrayList()).add(e -> {
            consumer.accept((SseEmitter)((Object)e));
            return true;
        });
    }

    @Override
    public int send(Collection<SseEmitter> sseEmitterList, SseEmitter.SseEventBuilder message) {
        int count = 0;
        for (SseEmitter emitter : sseEmitterList) {
            if (!this.send(emitter, message)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int sendAll(SseEmitter.SseEventBuilder message) {
        return this.send(this.getConnectionAll(), message);
    }

    @Override
    public int sendByConnectionId(Collection<Long> connectionIds, SseEmitter.SseEventBuilder message) {
        int count = 0;
        for (Long connectionId : connectionIds) {
            if (!this.send(this.getConnectionById(connectionId), message)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int sendByChannel(Collection<String> channels, SseEmitter.SseEventBuilder message) {
        int count = 0;
        for (String channel : channels) {
            count += this.send(this.getConnectionByChannel(channel), message);
        }
        return count;
    }

    @Override
    public int sendByAccessToken(Collection<String> accessTokens, SseEmitter.SseEventBuilder message) {
        int count = 0;
        for (String accessToken : accessTokens) {
            count += this.send(this.getConnectionByAccessToken(accessToken), message);
        }
        return count;
    }

    @Override
    public int sendByUserId(Collection<?> userIds, SseEmitter.SseEventBuilder message) {
        int count = 0;
        for (Object userId : userIds) {
            count += this.send(this.getConnectionByUserId(userId), message);
        }
        return count;
    }

    @Override
    public int sendByUserId(Object userId, SseEmitter.SseEventBuilder message) {
        return this.send(this.getConnectionByUserId(userId), message);
    }

    @Override
    public int sendByCustomerId(Collection<?> customerIds, SseEmitter.SseEventBuilder message) {
        int count = 0;
        for (Object customerId : customerIds) {
            count += this.send(this.getConnectionByCustomerId(customerId), message);
        }
        return count;
    }

    @Override
    public int sendByCustomerId(Object customerId, SseEmitter.SseEventBuilder message) {
        return this.send(this.getConnectionByCustomerId(customerId), message);
    }

    @Override
    public List<Long> getConnectionIds() {
        return new ArrayList<Long>(this.connectionMap.keySet());
    }

    @Override
    public List<String> getAccessTokens() {
        return new ArrayList<String>(this.accessToken2ConnectionIdMap.keySet());
    }

    @Override
    public List<String> getUserIds() {
        return new ArrayList<String>(this.userId2AccessTokenMap.keySet());
    }

    @Override
    public List<String> getCustomerIds() {
        return new ArrayList<String>(this.customerId2ConnectionIdMap.keySet());
    }

    @Override
    public List<String> getChannels() {
        return new ArrayList<String>(this.channel2ConnectionIdMap.keySet());
    }

    @Override
    public int getAccessTokenCount() {
        return this.accessToken2ConnectionIdMap.size();
    }

    @Override
    public int getUserCount() {
        return this.userId2AccessTokenMap.size();
    }

    @Override
    public int getConnectionCount() {
        return this.connectionMap.size();
    }

    protected Runnable completionCallBack(SseEmitter sseEmitter) {
        return () -> {
            log.debug("sse {} completion \u7ed3\u675f\u8fde\u63a5\uff1a{}", (Object)this.beanName, (Object)sseEmitter);
            sseEmitter.disconnect();
        };
    }

    protected Runnable timeoutCallBack(SseEmitter sseEmitter) {
        return () -> {
            log.debug("sse {} timeout \u8d85\u8fc7\u6700\u5927\u8fde\u63a5\u65f6\u95f4\uff1a{}", (Object)this.beanName, (Object)sseEmitter);
            sseEmitter.disconnect();
        };
    }

    protected Consumer<Throwable> errorCallBack(SseEmitter sseEmitter) {
        return throwable -> {
            log.debug("sse {} {} error \u53d1\u751f\u9519\u8bef\uff1a{}, {}", new Object[]{this.beanName, sseEmitter, throwable.toString(), throwable});
            sseEmitter.disconnect();
        };
    }

    protected boolean isSkipException(IOException e) {
        String exceptionMessage = e.getMessage();
        return exceptionMessage != null && exceptionMessage.contains("Broken pipe");
    }

    protected String wrapStringKey(String key) {
        return key == null ? "" : key;
    }

    protected <ACCESS_USER extends AccessUser & AccessToken> void notifyListener(SseEmitter<ACCESS_USER> emitter, List<Consumer<SseEmitter>> listeners, Map<String, List<Predicate<SseEmitter>>> listenerMap) {
        for (Consumer<SseEmitter> listener : listeners) {
            listener.accept(emitter);
        }
        List<Predicate<SseEmitter>> consumerList = listenerMap.get(emitter.getAccessToken());
        if (consumerList != null) {
            for (Predicate<SseEmitter> listener : new ArrayList<Predicate<SseEmitter>>(consumerList)) {
                if (!listener.test(emitter)) continue;
                consumerList.remove(listener);
            }
        }
    }

    protected <ACCESS_USER extends AccessUser & AccessToken> boolean send(SseEmitter<ACCESS_USER> sseEmitter, SseEmitter.SseEventBuilder message) {
        block3: {
            if (sseEmitter != null && !sseEmitter.isDisconnect()) {
                try {
                    sseEmitter.send(message);
                    return true;
                }
                catch (IOException e) {
                    if (this.isSkipException(e)) break block3;
                    log.warn("sse {} send {} io exception = {}", new Object[]{this.beanName, sseEmitter, e.toString(), e});
                    sseEmitter.disconnect();
                }
            }
        }
        return false;
    }

    @Override
    public String getBeanName() {
        return this.beanName;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }
}

