/*
 * Decompiled with CFR 0.152.
 */
package com.github.sseserver;

import com.github.sseserver.AccessToken;
import com.github.sseserver.AccessUser;
import com.github.sseserver.CustomerAccessUser;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyEmitter;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

public class SseEmitter<ACCESS_USER extends AccessUser & AccessToken>
extends org.springframework.web.servlet.mvc.method.annotation.SseEmitter {
    private static final Logger log = LoggerFactory.getLogger(SseEmitter.class);
    private static final AtomicLong ID_INCR = new AtomicLong();
    private static final MediaType TEXT_PLAIN = new MediaType("text", "plain", StandardCharsets.UTF_8);
    private final long id = SseEmitter.newId();
    private final ACCESS_USER accessUser;
    private final AtomicBoolean disconnect = new AtomicBoolean();
    private final List<Consumer<SseEmitter<ACCESS_USER>>> connectListeners = new ArrayList<Consumer<SseEmitter<ACCESS_USER>>>();
    private final List<Consumer<SseEmitter<ACCESS_USER>>> disconnectListeners = new ArrayList<Consumer<SseEmitter<ACCESS_USER>>>();
    private final Map<String, Object> attributeMap = new LinkedHashMap<String, Object>();
    private final long createTime = System.currentTimeMillis();
    private boolean connect = false;
    private int count;
    private String channel;

    public SseEmitter(Long timeout) {
        this(timeout, null);
    }

    public SseEmitter(Long timeout, ACCESS_USER accessUser) {
        super(timeout);
        this.accessUser = accessUser;
    }

    private static long newId() {
        long id = ID_INCR.getAndIncrement();
        if (id == Long.MAX_VALUE) {
            id = 0L;
            ID_INCR.set(1L);
        }
        return id;
    }

    public static SseEmitter.SseEventBuilder event() {
        return new SseEventBuilderImpl();
    }

    public int getCount() {
        return this.count;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public long getId() {
        return this.id;
    }

    public Object getUserId() {
        return this.accessUser == null ? null : this.accessUser.getId();
    }

    public String getAccessToken() {
        return this.accessUser != null ? ((AccessToken)this.accessUser).getAccessToken() : null;
    }

    public Object getCustomerId() {
        return this.accessUser != null && this.accessUser instanceof CustomerAccessUser ? ((CustomerAccessUser)this.accessUser).getCustomerId() : null;
    }

    public ACCESS_USER getAccessUser() {
        return this.accessUser;
    }

    public Map<String, Object> getAttributeMap() {
        return this.attributeMap;
    }

    public <T> T getAttribute(String key) {
        return (T)this.attributeMap.get(key);
    }

    public <T> T setAttribute(String key, Object value) {
        return (T)this.attributeMap.put(key, value);
    }

    public <T> T removeAttribute(String key) {
        return (T)this.attributeMap.remove(key);
    }

    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public boolean isConnect() {
        return this.connect;
    }

    public void addConnectListener(Consumer<SseEmitter<ACCESS_USER>> consumer) {
        if (this.connect) {
            try {
                consumer.accept(this);
            }
            catch (Exception e) {
                log.warn("addConnectListener connectListener error = {} {}", new Object[]{e.toString(), consumer, e});
            }
        } else {
            this.connectListeners.add(consumer);
        }
    }

    public void addDisConnectListener(Consumer<SseEmitter<ACCESS_USER>> consumer) {
        if (this.isDisconnect()) {
            try {
                consumer.accept(this);
            }
            catch (Exception e) {
                log.warn("addDisConnectListener connectListener error = {} {}", new Object[]{e.toString(), consumer, e});
            }
        } else {
            this.disconnectListeners.add(consumer);
        }
    }

    protected void extendResponse(ServerHttpResponse outputMessage) {
        super.extendResponse(outputMessage);
        this.connect = true;
        for (Consumer<SseEmitter<ACCESS_USER>> connectListener : new ArrayList<Consumer<SseEmitter<ACCESS_USER>>>(this.connectListeners)) {
            try {
                connectListener.accept(this);
            }
            catch (Exception e) {
                log.warn("connectListener error = {} {}", new Object[]{e.toString(), connectListener, e});
            }
        }
        this.connectListeners.clear();
    }

    public void send(SseEmitter.SseEventBuilder builder) throws IOException {
        if (builder instanceof SseEventBuilderImpl) {
            String id = ((SseEventBuilderImpl)builder).id;
            String name = ((SseEventBuilderImpl)builder).name;
            log.debug("sse connection send {} : {}, id = {}, name = {}", new Object[]{++this.count, this, id, name});
        } else {
            log.debug("sse connection send {} : {}", (Object)(++this.count), (Object)this);
        }
        super.send(builder);
    }

    public boolean isDisconnect() {
        return this.disconnect.get();
    }

    public boolean disconnect() {
        if (this.disconnect.compareAndSet(false, true)) {
            for (Consumer<SseEmitter<ACCESS_USER>> disconnectListener : new ArrayList<Consumer<SseEmitter<ACCESS_USER>>>(this.disconnectListeners)) {
                try {
                    disconnectListener.accept(this);
                }
                catch (Exception e) {
                    log.warn("disconnectListener error = {} {}", new Object[]{e.toString(), disconnectListener, e});
                }
            }
            this.disconnectListeners.clear();
            try {
                this.complete();
            }
            catch (Exception e) {
                log.warn("sse connection disconnect exception : {}. {}", (Object)e.toString(), (Object)this);
            }
            return true;
        }
        return false;
    }

    public String toString() {
        if (this.accessUser == null) {
            return this.id + "#";
        }
        return this.id + "#" + this.accessUser;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SseEmitter) {
            return ((SseEmitter)((Object)obj)).id == this.id;
        }
        return false;
    }

    public int hashCode() {
        return Long.hashCode(this.id);
    }

    private static class SseEventBuilderImpl
    implements SseEmitter.SseEventBuilder {
        private final Set<ResponseBodyEmitter.DataWithMediaType> dataToSend = new LinkedHashSet<ResponseBodyEmitter.DataWithMediaType>(4);
        private String id;
        private String name;
        private StringBuilder sb;

        private SseEventBuilderImpl() {
        }

        public SseEmitter.SseEventBuilder id(String id) {
            this.id = id;
            this.append("id:").append(id).append("\n");
            return this;
        }

        public SseEmitter.SseEventBuilder name(String name) {
            this.name = name;
            this.append("event:").append(name).append("\n");
            return this;
        }

        public SseEmitter.SseEventBuilder reconnectTime(long reconnectTimeMillis) {
            this.append("retry:").append(String.valueOf(reconnectTimeMillis)).append("\n");
            return this;
        }

        public SseEmitter.SseEventBuilder comment(String comment) {
            this.append(":").append(comment).append("\n");
            return this;
        }

        public SseEmitter.SseEventBuilder data(Object object) {
            return this.data(object, null);
        }

        public SseEmitter.SseEventBuilder data(Object object, MediaType mediaType) {
            this.append("data:");
            this.saveAppendedText();
            this.dataToSend.add(new ResponseBodyEmitter.DataWithMediaType(object, mediaType));
            this.append("\n");
            return this;
        }

        SseEventBuilderImpl append(String text) {
            if (this.sb == null) {
                this.sb = new StringBuilder();
            }
            this.sb.append(text);
            return this;
        }

        public Set<ResponseBodyEmitter.DataWithMediaType> build() {
            if ((this.sb == null || this.sb.length() == 0) && this.dataToSend.isEmpty()) {
                return Collections.emptySet();
            }
            this.append("\n");
            this.saveAppendedText();
            return this.dataToSend;
        }

        private void saveAppendedText() {
            if (this.sb != null) {
                this.dataToSend.add(new ResponseBodyEmitter.DataWithMediaType((Object)this.sb.toString(), TEXT_PLAIN));
                this.sb = null;
            }
        }
    }
}

