/*
 * Decompiled with CFR 0.152.
 */
package com.github.sseserver;

import com.github.sseserver.AccessToken;
import com.github.sseserver.AccessUser;
import com.github.sseserver.LocalConnectionService;
import com.github.sseserver.SseEmitter;
import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

public class SseWebController<ACCESS_USER extends AccessUser & AccessToken> {
    private LocalConnectionService localConnectionService;

    public void setLocalConnectionService(LocalConnectionService localConnectionService) {
        this.localConnectionService = localConnectionService;
    }

    @Autowired(required=false)
    public void setLocalConnectionServiceMap(Map<String, LocalConnectionService> localConnectionServiceMap) {
        if (this.localConnectionService == null && localConnectionServiceMap != null && localConnectionServiceMap.size() > 0) {
            this.localConnectionService = localConnectionServiceMap.values().iterator().next();
        }
    }

    protected ACCESS_USER getAccessUser() {
        return null;
    }

    protected Object wrapOkResponse(Object result) {
        return new ResponseWrap<Object>(result);
    }

    protected void onConnect(SseEmitter<ACCESS_USER> conncet) {
    }

    protected void onDisconnect(List<SseEmitter<ACCESS_USER>> disconnectList, ACCESS_USER accessUser, String accessToken, Long connectionId) {
    }

    protected ResponseEntity buildIfConnectVerifyErrorResponse(ACCESS_USER accessUser, Map query, Map body, Long keepaliveTime, HttpServletRequest request) {
        return null;
    }

    @RequestMapping(value={"/connect"})
    public Object connect(@RequestParam Map query, @RequestBody(required=false) Map body, Long keepaliveTime, HttpServletRequest request) {
        ACCESS_USER accessUser;
        ResponseEntity responseEntity;
        LinkedHashMap message = new LinkedHashMap(query);
        if (body != null) {
            message.putAll(body);
        }
        if ((responseEntity = this.buildIfConnectVerifyErrorResponse(accessUser = this.getAccessUser(), query, body, keepaliveTime, request)) != null) {
            return responseEntity;
        }
        SseEmitter<ACCESS_USER> emitter = this.localConnectionService.connect(accessUser, keepaliveTime);
        emitter.getAttributeMap().putAll(message);
        String channel = Objects.toString(message.get("channel"), null);
        emitter.setChannel(this.isBlank(channel) ? null : channel);
        Enumeration headerNames = request.getHeaderNames();
        LinkedHashMap<String, String> headerMap = new LinkedHashMap<String, String>();
        while (headerNames.hasMoreElements()) {
            String name = (String)headerNames.nextElement();
            headerMap.put(name, request.getHeader(name));
        }
        emitter.setAttribute("httpHeaders", headerMap);
        emitter.setAttribute("httpCookies", request.getCookies());
        emitter.setAttribute("httpParameters", new LinkedHashMap(request.getParameterMap()));
        this.onConnect(emitter);
        return emitter;
    }

    @RequestMapping(value={"/send"})
    public ResponseEntity send(@RequestParam Map query, @RequestBody(required=false) Map body) {
        LinkedHashMap message = new LinkedHashMap(query);
        if (body != null) {
            message.putAll(body);
        }
        int count = this.localConnectionService.sendAll(this.buildEvent(message));
        return ResponseEntity.ok((Object)this.wrapOkResponse(Collections.singletonMap("count", count)));
    }

    @RequestMapping(value={"/send/{userId}"})
    public ResponseEntity sendOne(@RequestParam Map query, @RequestBody(required=false) Map body, @PathVariable Object userId) {
        LinkedHashMap message = new LinkedHashMap(query);
        if (body != null) {
            message.putAll(body);
        }
        int count = this.localConnectionService.sendByUserId(userId, this.buildEvent(message));
        return ResponseEntity.ok((Object)this.wrapOkResponse(Collections.singletonMap("count", count)));
    }

    @RequestMapping(value={"/disconnect/{connectionId}"})
    public ResponseEntity disconnect(@PathVariable Long connectionId) {
        ACCESS_USER accessUser = this.getAccessUser();
        String accessToken = ((AccessToken)accessUser).getAccessToken();
        SseEmitter disconnect = this.localConnectionService.disconnectByConnectionId(connectionId);
        if (disconnect != null) {
            this.onDisconnect(Collections.singletonList(disconnect), accessUser, accessToken, connectionId);
        }
        return ResponseEntity.ok((Object)this.wrapOkResponse(Collections.singletonMap("count", disconnect != null ? 1 : 0)));
    }

    @RequestMapping(value={"/disconnect"})
    public ResponseEntity disconnect0(Long connectionId) {
        ACCESS_USER accessUser = this.getAccessUser();
        String accessToken = ((AccessToken)accessUser).getAccessToken();
        if (connectionId != null) {
            SseEmitter disconnect = this.localConnectionService.disconnectByConnectionId(connectionId);
            if (disconnect != null) {
                this.onDisconnect(Collections.singletonList(disconnect), accessUser, accessToken, connectionId);
            }
            return ResponseEntity.ok((Object)this.wrapOkResponse(Collections.singletonMap("count", disconnect != null ? 1 : 0)));
        }
        List count = this.localConnectionService.disconnectByAccessToken(accessToken);
        if (count.size() > 0) {
            this.onDisconnect(count, accessUser, accessToken, null);
        }
        return ResponseEntity.ok((Object)this.wrapOkResponse(Collections.singletonMap("count", count.size())));
    }

    private SseEmitter.SseEventBuilder buildEvent(Map rawMessage) {
        Object reconnectTime;
        Object comment;
        Object name;
        LinkedHashMap message = new LinkedHashMap(rawMessage);
        SseEmitter.SseEventBuilder event = SseEmitter.event();
        Object id = message.remove("id");
        if (id != null) {
            event.id(id.toString());
        }
        if ((name = message.remove("name")) != null) {
            event.name(name.toString());
        }
        if ((comment = message.remove("comment")) != null) {
            event.comment(comment.toString());
        }
        if ((reconnectTime = message.remove("reconnectTime")) != null) {
            event.reconnectTime(Long.parseLong(reconnectTime.toString()));
        }
        if (!message.isEmpty()) {
            event.data(message);
        }
        return event;
    }

    public boolean isBlank(CharSequence str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static class ResponseWrap<T>
    implements Serializable {
        private boolean success = true;
        private int code = 200;
        private T data;
        private String message;
        private String errorMessage;

        public ResponseWrap() {
        }

        public ResponseWrap(T data) {
            this.data = data;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public void setSuccess(boolean success) {
            this.success = success;
        }

        public int getCode() {
            return this.code;
        }

        public void setCode(int code) {
            this.code = code;
        }

        public T getData() {
            return this.data;
        }

        public void setData(T data) {
            this.data = data;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }
    }
}

